/*****************************************************************************
 * Copyright (c) 2014-2021 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "SpriteBase.h"

class DataSerialiser;
struct CoordsXYZ;

struct MoneyEffect : MiscEntity
{
    static constexpr auto cEntityType = EntityType::MoneyEffect;
    uint16_t MoveDelay;
    uint8_t NumMovements;
    uint8_t Vertical;
    money32 Value;
    int16_t OffsetX;
    uint16_t Wiggle;

    static void CreateAt(money32 value, const CoordsXYZ& effectPos, bool vertical);
    static void Create(money32 value, const CoordsXYZ& loc);
    void Update();
    std::pair<rct_string_id, money32> GetStringId() const;
    void Serialise(DataSerialiser& stream);
};
