#pragma region Copyright (c) 2014-2017 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#include <openrct2/common.h>
#include <openrct2/ride/Ride.h>

const_utf8string RideNames[RIDE_TYPE_COUNT] = {
    "SpiralRollerCoaster",
    "StandUpRollerCoaster",
    "SuspendedSwingingCoaster",
    "InvertedRollerCoaster",
    "JuniorRollerCoaster",
    "MiniatureRailway",
    "Monorail",
    "MiniSuspendedCoaster",
    "BoatHire",
    "WoodenWildMouse",
    "Steeplechase",
    "CarRide",
    "LaunchedFreefall",
    "BobsleighCoaster",
    "ObservationTower",
    "LoopingRollerCoaster",
    "DinghySlide",
    "MineTrainCoaster",
    "Chairlift",
    "CorkscrewRollerCoaster",
    "Maze",
    "SpiralSlide",
    "GoKarts",
    "LogFlume",
    "RiverRapids",
    "Dodgems",
    "PirateShip",
    "SwingingInverterShip",
    "FoodStall",
    "1D",
    "DrinkStall",
    "1F",
    "Shop",
    "MerryGoRound",
    "22",
    "InformationKiosk",
    "Toilets",
    "FerrisWheel",
    "MotionSimulator",
    "3DCinema",
    "TopSpin",
    "SpaceRings",
    "ReverseFreefallCoaster",
    "Lift",
    "VerticalDropRollerCoaster",
    "CashMachine",
    "Twist",
    "HauntedHouse",
    "FirstAid",
    "CircusShow",
    "GhostTrain",
    "TwisterRollerCoaster",
    "WoodenRollerCoaster",
    "SideFrictionRollerCoaster",
    "WildMouse",
    "MultiDimensionRollerCoaster",
    "MultiDimensionRollerCoasterAlt",
    "FlyingRollerCoaster",
    "FlyingRollerCoasterAlt",
    "VirginiaReel",
    "SplashBoats",
    "MiniHelicopters",
    "LayDownRollerCoaster",
    "SuspendedMonorail",
    "LayDownRollerCoasterAlt",
    "ReverserRollerCoaster",
    "HeartlineTwisterCoaster",
    "MiniGolf",
    "GigaCoaster",
    "RoToDrop",
    "FlyingSaucers",
    "CrookedHouse",
    "MonorailCycles",
    "CompactInvertedCoaster",
    "WaterCoaster",
    "AirPoweredVerticalCoaster",
    "InvertedHairpinCoaster",
    "MagicCarpet",
    "SubmarineRide",
    "RiverRafts",
    "50",
    "Enterprise",
    "52",
    "53",
    "54",
    "55",
    "InvertedImpulseCoaster",
    "MiniRollerCoaster",
    "MineRide",
    "59",
    "LimLaunchedRollerCoaster",
};

const_utf8string TrackNames[256] = {
    "Flat",
    "EndStation",
    "BeginStation",
    "MiddleStation",
    "25DegUp",
    "60DegUp",
    "FlatTo25DegUp",
    "25DegUpTo60DegUp",
    "60DegUpTo25DegUp",
    "25DegUpToFlat",
    "25DegDown",
    "60DegDown",
    "FlatTo25DegDown",
    "25DegDownTo60DegDown",
    "60DegDownTo25DegDown",
    "25DegDownToFlat",
    "LeftQuarterTurn5Tiles",
    "RightQuarterTurn5Tiles",
    "FlatToLeftBank",
    "FlatToRightBank",
    "LeftBankToFlat",
    "RightBankToFlat",
    "BankedLeftQuarterTurn5Tiles",
    "BankedRightQuarterTurn5Tiles",
    "LeftBankTo25DegUp",
    "RightBankTo25DegUp",
    "25DegUpToLeftBank",
    "25DegUpToRightBank",
    "LeftBankTo25DegDown",
    "RightBankTo25DegDown",
    "25DegDownToLeftBank",
    "25DegDownToRightBank",
    "LeftBank",
    "RightBank",
    "LeftQuarterTurn5Tiles25DegUp",
    "RightQuarterTurn5Tiles25DegUp",
    "LeftQuarterTurn5Tiles25DegDown",
    "RightQuarterTurn5Tiles25DegDown",
    "SBendLeft",
    "SBendRight",
    "LeftVerticalLoop",
    "RightVerticalLoop",
    "LeftQuarterTurn3Tiles",
    "RightQuarterTurn3Tiles",
    "LeftQuarterTurn3TilesBank",
    "RightQuarterTurn3TilesBank",
    "LeftQuarterTurn3Tiles25DegUp",
    "RightQuarterTurn3Tiles25DegUp",
    "LeftQuarterTurn3Tiles25DegDown",
    "RightQuarterTurn3Tiles25DegDown",
    "LeftQuarterTurn1Tile",
    "RightQuarterTurn1Tile",
    "LeftTwistDownToUp",
    "RightTwistDownToUp",
    "LeftTwistUpToDown",
    "RightTwistUpToDown",
    "HalfLoopUp",
    "HalfLoopDown",
    "LeftCorkscrewUp",
    "RightCorkscrewUp",
    "LeftCorkscrewDown",
    "RightCorkscrewDown",
    "FlatTo60DegUp",
    "60DegUpToFlat",
    "FlatTo60DegDown",
    "60DegDownToFlat",
    "TowerBase",
    "TowerSection",
    "FlatCovered",
    "25DegUpCovered",
    "60DegUpCovered",
    "FlatTo25DegUpCovered",
    "25DegUpTo60DegUpCovered",
    "60DegUpTo25DegUpCovered",
    "25DegUpToFlatCovered",
    "25DegDownCovered",
    "60DegDownCovered",
    "FlatTo25DegDownCovered",
    "25DegDownTo60DegDownCovered",
    "60DegDownTo25DegDownCovered",
    "25DegDownToFlatCovered",
    "LeftQuarterTurn5TilesCovered",
    "RightQuarterTurn5TilesCovered",
    "SBendLeftCovered",
    "SBendRightCovered",
    "LeftQuarterTurn3TilesCovered",
    "RightQuarterTurn3TilesCovered",
    "LeftHalfBankedHelixUpSmall",
    "RightHalfBankedHelixUpSmall",
    "LeftHalfBankedHelixDownSmall",
    "RightHalfBankedHelixDownSmall",
    "LeftHalfBankedHelixUpLarge",
    "RightHalfBankedHelixUpLarge",
    "LeftHalfBankedHelixDownLarge",
    "RightHalfBankedHelixDownLarge",
    "LeftQuarterTurn1Tile60DegUp",
    "RightQuarterTurn1Tile60DegUp",
    "LeftQuarterTurn1Tile60DegDown",
    "RightQuarterTurn1Tile60DegDown",
    "Brakes",
    "RotationControlToggle",
    "Inverted90DegUpToFlatQuarterLoop_Maze",
    "LeftQuarterBankedHelixLargeUp",
    "RightQuarterBankedHelixLargeUp",
    "LeftQuarterBankedHelixLargeDown",
    "RightQuarterBankedHelixLargeDown",
    "LeftQuarterHelixLargeUp",
    "RightQuarterHelixLargeUp",
    "LeftQuarterHelixLargeDown",
    "RightQuarterHelixLargeDown",
    "25DegUpLeftBanked",
    "25DegUpRightBanked",
    "Waterfall",
    "Rapids",
    "OnRidePhoto",
    "25DegDownLeftBanked",
    "25DegDownRightBanked",
    "WaterSplash",
    "FlatTo60DegUpLongBase",
    "60DegUpToFlatLongBase",
    "Whirlpool",
    "FlatTo60DegDownLongBase",
    "60DegUpToFlatLongBase122",
    "CableLiftHill",
    "ReverseWhoaBellySlope",
    "ReverseWhoaBellyVertical",
    "90DegUp",
    "90DegDown",
    "60DegUpTo90DegUp",
    "90DegDownTo60DegDown",
    "90DegUpTo60DegUp",
    "60DegDownTo90DegDown",
    "BrakeForDrop",
    "LeftEighthToDiag",
    "RightEighthToDiag",
    "LeftEighthToOrthogonal",
    "RightEighthToOrthogonal",
    "LeftEighthBankToDiag",
    "RightEighthBankToDiag",
    "LeftEighthBankToOrthogonal",
    "RightEighthBankToOrthogonal",
    "DiagFlat",
    "Diag25DegUp",
    "Diag60DegUp",
    "DiagFlatTo25DegUp",
    "Diag25DegUpTo60DegUp",
    "Diag60DegUpTo25DegUp",
    "Diag25DegUpToFlat",
    "Diag25DegDown",
    "Diag60DegDown",
    "DiagFlatTo25DegDown",
    "Diag25DegDownTo60DegDown",
    "Diag60DegDownTo25DegDown",
    "Diag25DegDownToFlat",
    "DiagFlatTo60DegUp",
    "Diag60DegUpToFlat",
    "DiagFlatTo60DegDown",
    "Diag60DegDownToFlat",
    "DiagFlatToLeftBank",
    "DiagFlatToRightBank",
    "DiagLeftBankToFlat",
    "DiagRightBankToFlat",
    "DiagLeftBankTo25DegUp",
    "DiagRightBankTo25DegUp",
    "Diag25DegUpToLeftBank",
    "Diag25DegUpToRightBank",
    "DiagLeftBankTo25DegDown",
    "DiagRightBankTo25DegDown",
    "Diag25DegDownToLeftBank",
    "Diag25DegDownToRightBank",
    "DiagLeftBank",
    "DiagRightBank",
    "LogFlumeReverser",
    "SpinningTunnel",
    "LeftBarrelRollUpToDown",
    "RightBarrelRollUpToDown",
    "LeftBarrelRollDownToUp",
    "RightBarrelRollDownToUp",
    "LeftBankToLeftQuarterTurn3Tiles25DegUp",
    "RightBankToRightQuarterTurn3Tiles25DegUp",
    "LeftQuarterTurn3Tiles25DegDownToLeftBank",
    "RightQuarterTurn3Tiles25DegDownToRightBank",
    "PoweredLift",
    "LeftLargeHalfLoopUp",
    "RightLargeHalfLoopUp",
    "RightLargeHalfLoopDown",
    "LeftLargeHalfLoopDown",
    "LeftFlyerTwistUp",
    "RightFlyerTwistUp",
    "LeftFlyerTwistDown",
    "RightFlyerTwistDown",
    "FlyerHalfLoopUp",
    "FlyerHalfLoopDown",
    "LeftFlyerCorkscrewUp",
    "RightFlyerCorkscrewUp",
    "LeftFlyerCorkscrewDown",
    "RightFlyerCorkscrewDown",
    "HeartlineTransferUp",
    "HeartlineTransferDown",
    "LeftHeartlineRoll",
    "RightHeartlineRoll",
    "MiniGolfHoleA",
    "MiniGolfHoleB",
    "MiniGolfHoleC",
    "MiniGolfHoleD",
    "MiniGolfHoleE",
    "MultidimInvertedFlatTo90DegQuarterLoopDown",
    "90DegToInvertedFlatQuarterLoopUp",
    "InvertedFlatTo90DegQuarterLoopDown",
    "LeftCurvedLiftHill",
    "RightCurvedLiftHill",
    "LeftReverser",
    "RightReverser",
    "AirThrustTopCap",
    "AirThrustVerticalDown",
    "AirThrustVerticalDownToLevel",
    "BlockBrakes",
    "LeftBankedQuarterTurn3Tile25DegUp",
    "RightBankedQuarterTurn3Tile25DegUp",
    "LeftBankedQuarterTurn3Tile25DegDown",
    "RightBankedQuarterTurn3Tile25DegDown",
    "LeftBankedQuarterTurn5Tile25DegUp",
    "RightBankedQuarterTurn5Tile25DegUp",
    "LeftBankedQuarterTurn5Tile25DegDown",
    "RightBankedQuarterTurn5Tile25DegDown",
    "25DegUpToLeftBanked25DegUp",
    "25DegUpToRightBanked25DegUp",
    "LeftBanked25DegUpTo25DegUp",
    "RightBanked25DegUpTo25DegUp",
    "25DegDownToLeftBanked25DegDown",
    "25DegDownToRightBanked25DegDown",
    "LeftBanked25DegDownTo25DegDown",
    "RightBanked25DegDownTo25DegDown",
    "LeftBankedFlatToLeftBanked25DegUp",
    "RightBankedFlatToRightBanked25DegUp",
    "LeftBanked25DegUpToLeftBankedFlat",
    "RightBanked25DegUpToRightBankedFlat",
    "LeftBankedFlatToLeftBanked25DegDown",
    "RightBankedFlatToRightBanked25DegDown",
    "LeftBanked25DegDownToLeftBankedFlat",
    "RightBanked25DegDownToRightBankedFlat",
    "FlatToLeftBanked25DegUp",
    "FlatToRightBanked25DegUp",
    "LeftBanked25DegUpToFlat",
    "RightBanked25DegUpToFlat",
    "FlatToLeftBanked25DegDown",
    "FlatToRightBanked25DegDown",
    "LeftBanked25DegDownToFlat",
    "RightBanked25DegDownToFlat",
    "LeftQuarterTurn1Tile90DegUp",
    "RightQuarterTurn1Tile90DegUp",
    "LeftQuarterTurn1Tile90DegDown",
    "RightQuarterTurn1Tile90DegDown",
    "Multidim90DegUpToInvertedFlatQuarterLoop",
    "MultidimFlatTo90DegDownQuarterLoop",
    "Elem255",
};

const_utf8string FlatTrackNames[256] = {
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "1x4_A",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "2x2",
    "4x4",
    "",
    "",
    "",
    "",
    "1x5",
    "",
    "1x1_A",
    "1x4_B",
    "",
    "1x1_B",
    "1x4_C",
    "3x3",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
};

const_utf8string TrackElemNames[] = {
    "TRACK_ELEM_FLAT",
    "TRACK_ELEM_END_STATION",
    "TRACK_ELEM_BEGIN_STATION",
    "TRACK_ELEM_MIDDLE_STATION",
    "TRACK_ELEM_25_DEG_UP",
    "TRACK_ELEM_60_DEG_UP",
    "TRACK_ELEM_FLAT_TO_25_DEG_UP",
    "TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP",
    "TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP",
    "TRACK_ELEM_25_DEG_UP_TO_FLAT",
    "TRACK_ELEM_25_DEG_DOWN",
    "TRACK_ELEM_60_DEG_DOWN",
    "TRACK_ELEM_FLAT_TO_25_DEG_DOWN",
    "TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN",
    "TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN",
    "TRACK_ELEM_25_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES",
    "TRACK_ELEM_FLAT_TO_LEFT_BANK",
    "TRACK_ELEM_FLAT_TO_RIGHT_BANK",
    "TRACK_ELEM_LEFT_BANK_TO_FLAT",
    "TRACK_ELEM_RIGHT_BANK_TO_FLAT",
    "TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES",
    "TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES",
    "TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP",
    "TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK",
    "TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK",
    "TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN",
    "TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK",
    "TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK",
    "TRACK_ELEM_LEFT_BANK",
    "TRACK_ELEM_RIGHT_BANK",
    "TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN",
    "TRACK_ELEM_S_BEND_LEFT",
    "TRACK_ELEM_S_BEND_RIGHT",
    "TRACK_ELEM_LEFT_VERTICAL_LOOP",
    "TRACK_ELEM_RIGHT_VERTICAL_LOOP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE",
    "TRACK_ELEM_LEFT_TWIST_DOWN_TO_UP",
    "TRACK_ELEM_RIGHT_TWIST_DOWN_TO_UP",
    "TRACK_ELEM_LEFT_TWIST_UP_TO_DOWN",
    "TRACK_ELEM_RIGHT_TWIST_UP_TO_DOWN",
    "TRACK_ELEM_HALF_LOOP_UP",
    "TRACK_ELEM_HALF_LOOP_DOWN",
    "TRACK_ELEM_LEFT_CORKSCREW_UP",
    "TRACK_ELEM_RIGHT_CORKSCREW_UP",
    "TRACK_ELEM_LEFT_CORKSCREW_DOWN",
    "TRACK_ELEM_RIGHT_CORKSCREW_DOWN",
    "TRACK_ELEM_FLAT_TO_60_DEG_UP",
    "TRACK_ELEM_60_DEG_UP_TO_FLAT",
    "TRACK_ELEM_FLAT_TO_60_DEG_DOWN",
    "TRACK_ELEM_60_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_TOWER_BASE",
    "TRACK_ELEM_TOWER_SECTION",
    "TRACK_ELEM_FLAT_COVERED",
    "TRACK_ELEM_25_DEG_UP_COVERED",
    "TRACK_ELEM_60_DEG_UP_COVERED",
    "TRACK_ELEM_FLAT_TO_25_DEG_UP_COVERED",
    "TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP_COVERED",
    "TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP_COVERED",
    "TRACK_ELEM_25_DEG_UP_TO_FLAT_COVERED",
    "TRACK_ELEM_25_DEG_DOWN_COVERED",
    "TRACK_ELEM_60_DEG_DOWN_COVERED",
    "TRACK_ELEM_FLAT_TO_25_DEG_DOWN_COVERED",
    "TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN_COVERED",
    "TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN_COVERED",
    "TRACK_ELEM_25_DEG_DOWN_TO_FLAT_COVERED",
    "TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_COVERED",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_COVERED",
    "TRACK_ELEM_S_BEND_LEFT_COVERED",
    "TRACK_ELEM_S_BEND_RIGHT_COVERED",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_COVERED",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_COVERED",
    "TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL",
    "TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL",
    "TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL",
    "TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL",
    "TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE",
    "TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE",
    "TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE",
    "TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE",
    "TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN",
    "TRACK_ELEM_BRAKES",
    "TRACK_ELEM_ROTATION_CONTROL_TOGGLE",
    "TRACK_ELEM_INVERTED_90_DEG_UP_TO_FLAT_QUARTER_LOOP",
    "TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_UP",
    "TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_UP",
    "TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_DOWN",
    "TRACK_ELEM_LEFT_QUARTER_HELIX_LARGE_UP",
    "TRACK_ELEM_RIGHT_QUARTER_HELIX_LARGE_UP",
    "TRACK_ELEM_LEFT_QUARTER_HELIX_LARGE_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_HELIX_LARGE_DOWN",
    "TRACK_ELEM_25_DEG_UP_LEFT_BANKED",
    "TRACK_ELEM_25_DEG_UP_RIGHT_BANKED",
    "TRACK_ELEM_WATERFALL",
    "TRACK_ELEM_RAPIDS",
    "TRACK_ELEM_ON_RIDE_PHOTO",
    "TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED",
    "TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED",
    "TRACK_ELEM_WATER_SPLASH",
    "TRACK_ELEM_FLAT_TO_60_DEG_UP_LONG_BASE",
    "TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE",
    "TRACK_ELEM_WHIRLPOOL",
    "TRACK_ELEM_FLAT_TO_60_DEG_DOWN_LONG_BASE",
    "TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE_122",
    "TRACK_ELEM_CABLE_LIFT_HILL",
    "TRACK_ELEM_REVERSE_FREEFALL_SLOPE",
    "TRACK_ELEM_REVERSE_FREEFALL_VERTICAL",
    "TRACK_ELEM_90_DEG_UP",
    "TRACK_ELEM_90_DEG_DOWN",
    "TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP",
    "TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN",
    "TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP",
    "TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN",
    "TRACK_ELEM_BRAKE_FOR_DROP",
    "TRACK_ELEM_LEFT_EIGHTH_TO_DIAG",
    "TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG",
    "TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL",
    "TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL",
    "TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG",
    "TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG",
    "TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL",
    "TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL",
    "TRACK_ELEM_DIAG_FLAT",
    "TRACK_ELEM_DIAG_25_DEG_UP",
    "TRACK_ELEM_DIAG_60_DEG_UP",
    "TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP",
    "TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP",
    "TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP",
    "TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT",
    "TRACK_ELEM_DIAG_25_DEG_DOWN",
    "TRACK_ELEM_DIAG_60_DEG_DOWN",
    "TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN",
    "TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN",
    "TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN",
    "TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_DIAG_FLAT_TO_60_DEG_UP",
    "TRACK_ELEM_DIAG_60_DEG_UP_TO_FLAT",
    "TRACK_ELEM_DIAG_FLAT_TO_60_DEG_DOWN",
    "TRACK_ELEM_DIAG_60_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK",
    "TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK",
    "TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT",
    "TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT",
    "TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP",
    "TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP",
    "TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK",
    "TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK",
    "TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN",
    "TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN",
    "TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK",
    "TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK",
    "TRACK_ELEM_DIAG_LEFT_BANK",
    "TRACK_ELEM_DIAG_RIGHT_BANK",
    "TRACK_ELEM_LOG_FLUME_REVERSER",
    "TRACK_ELEM_SPINNING_TUNNEL",
    "TRACK_ELEM_LEFT_BARREL_ROLL_UP_TO_DOWN",
    "TRACK_ELEM_RIGHT_BARREL_ROLL_UP_TO_DOWN",
    "TRACK_ELEM_LEFT_BARREL_ROLL_DOWN_TO_UP",
    "TRACK_ELEM_RIGHT_BARREL_ROLL_DOWN_TO_UP",
    "TRACK_ELEM_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_LEFT_BANK",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_RIGHT_BANK",
    "TRACK_ELEM_POWERED_LIFT",
    "TRACK_ELEM_LEFT_LARGE_HALF_LOOP_UP",
    "TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_UP",
    "TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_DOWN",
    "TRACK_ELEM_LEFT_LARGE_HALF_LOOP_DOWN",
    "TRACK_ELEM_LEFT_FLYER_TWIST_UP",
    "TRACK_ELEM_RIGHT_FLYER_TWIST_UP",
    "TRACK_ELEM_LEFT_FLYER_TWIST_DOWN",
    "TRACK_ELEM_RIGHT_FLYER_TWIST_DOWN",
    "TRACK_ELEM_FLYER_HALF_LOOP_UP",
    "TRACK_ELEM_FLYER_HALF_LOOP_DOWN",
    "TRACK_ELEM_LEFT_FLYER_CORKSCREW_UP",
    "TRACK_ELEM_RIGHT_FLYER_CORKSCREW_UP",
    "TRACK_ELEM_LEFT_FLYER_CORKSCREW_DOWN",
    "TRACK_ELEM_RIGHT_FLYER_CORKSCREW_DOWN",
    "TRACK_ELEM_HEARTLINE_TRANSFER_UP",
    "TRACK_ELEM_HEARTLINE_TRANSFER_DOWN",
    "TRACK_ELEM_LEFT_HEARTLINE_ROLL",
    "TRACK_ELEM_RIGHT_HEARTLINE_ROLL",
    "TRACK_ELEM_MINI_GOLF_HOLE_A",
    "TRACK_ELEM_MINI_GOLF_HOLE_B",
    "TRACK_ELEM_MINI_GOLF_HOLE_C",
    "TRACK_ELEM_MINI_GOLF_HOLE_D",
    "TRACK_ELEM_MINI_GOLF_HOLE_E",
    "TRACK_ELEM_MULTIDIM_INVERTED_FLAT_TO_90_DEG_QUARTER_LOOP_DOWN",
    "TRACK_ELEM_90_DEG_TO_INVERTED_FLAT_QUARTER_LOOP_UP",
    "TRACK_ELEM_INVERTED_FLAT_TO_90_DEG_QUARTER_LOOP_DOWN",
    "TRACK_ELEM_LEFT_CURVED_LIFT_HILL",
    "TRACK_ELEM_RIGHT_CURVED_LIFT_HILL",
    "TRACK_ELEM_LEFT_REVERSER",
    "TRACK_ELEM_RIGHT_REVERSER",
    "TRACK_ELEM_AIR_THRUST_TOP_CAP",
    "TRACK_ELEM_AIR_THRUST_VERTICAL_DOWN",
    "TRACK_ELEM_AIR_THRUST_VERTICAL_DOWN_TO_LEVEL",
    "TRACK_ELEM_BLOCK_BRAKES",
    "TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP",
    "TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP",
    "TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN",
    "TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP",
    "TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP",
    "TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP",
    "TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT",
    "TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT",
    "TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP",
    "TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT",
    "TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN",
    "TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT",
    "TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_UP",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_UP",
    "TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_DOWN",
    "TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_DOWN",
    "TRACK_ELEM_MULTIDIM_90_DEG_UP_TO_INVERTED_FLAT_QUARTER_LOOP",
    "TRACK_ELEM_MULTIDIM_FLAT_TO_90_DEG_DOWN_QUARTER_LOOP",
    "TRACK_ELEM_255",
};

const_utf8string RideCodeNames[RIDE_TYPE_COUNT] = {
    "spiral_rc",
    "stand_up_rc",
    "suspended_swinging_rc",
    "inverted_rc",
    "junior_rc",
    "miniature_railway",
    "monorail",
    "mini_suspended_rc",
    "boat_hire",
    "wooden_wild_mouse",
    "steeplechase",
    "car_ride",
    "launched_freefall",
    "bobsleigh_rc",
    "observation_tower",
    "looping_rc",
    "dinghy_slide",
    "mine_train_rc",
    "chairlift",
    "corkscrew_rc",
    "maze",
    "spiralslide",
    "go_karts",
    "log_flume",
    "river_rapids",
    "dodgems",
    "pirate_ship",
    "swinging_inverter_ship",
    "food_stall",
    "1D",
    "drink_stall",
    "1F",
    "shop",
    "merry_go_round",
    "22",
    "information_kiosk",
    "toilets",
    "ferris_wheel",
    "motion_simulator",
    "3d_cinema",
    "top_spin",
    "space_rings",
    "reverse_freefall_rc",
    "lift",
    "vertical_drop_rc",
    "cash_machine",
    "twist",
    "haunted_house",
    "first_aid",
    "circus_show",
    "ghost_train",
    "twister_rc",
    "wooden_rc",
    "side_friction_rc",
    "wild_mouse",
    "multi_dimension_rc",
    "multi_dimension_rc_alt",
    "flying_rc",
    "flying_rc_alt",
    "virginia_reel",
    "splash_boats",
    "mini_helicopters",
    "lay_down_rc",
    "suspended_monorail",
    "lay_down_rc_alt",
    "reverser_rc",
    "heartline_twister_rc",
    "mini_golf",
    "giga_rc",
    "roto_drop",
    "flying_saucers",
    "crooked_house",
    "monorail_cycles",
    "compact_inverted_rc",
    "water_rc",
    "air_powered_vertical_rc",
    "inverted_hairpin_rc",
    "magic_carpet",
    "submarine_ride",
    "river_rafts",
    "50",
    "enterprise",
    "52",
    "53",
    "54",
    "55",
    "inverted_impulse_rc",
    "mini_rc",
    "mine_ride",
    "59",
    "lim_launched_rc",
};

const_utf8string TrackCodeNames[256] = {
    "flat",
    "end_station",
    "begin_station",
    "middle_station",
    "25_deg_up",
    "60_deg_up",
    "flat_to_25_deg_up",
    "25_deg_up_to_60_deg_up",
    "60_deg_up_to_25_deg_up",
    "25_deg_up_to_flat",
    "25_deg_down",
    "60_deg_down",
    "flat_to_25_deg_down",
    "25_deg_down_to_60_deg_down",
    "60_deg_down_to_25_deg_down",
    "25_deg_down_to_flat",
    "left_quarter_turn_5",
    "right_quarter_turn_5",
    "flat_to_left_bank",
    "flat_to_right_bank",
    "left_bank_to_flat",
    "right_bank_to_flat",
    "banked_left_quarter_turn_5",
    "banked_right_quarter_turn_5",
    "left_bank_to_25_deg_up",
    "right_bank_to_25_deg_up",
    "25_deg_up_to_left_bank",
    "25_deg_up_to_right_bank",
    "left_bank_to_25_deg_down",
    "right_bank_to_25_deg_down",
    "25_deg_down_to_left_bank",
    "25_deg_down_to_right_bank",
    "left_bank",
    "right_bank",
    "left_quarter_turn_5_25_deg_up",
    "right_quarter_turn_5_25_deg_up",
    "left_quarter_turn_5_25_deg_down",
    "right_quarter_turn_5_25_deg_down",
    "s_bend_left",
    "s_bend_right",
    "left_vertical_loop",
    "right_vertical_loop",
    "left_quarter_turn_3",
    "right_quarter_turn_3",
    "left_quarter_turn_3_bank",
    "right_quarter_turn_3_bank",
    "left_quarter_turn_3_25_deg_up",
    "right_quarter_turn_3_25_deg_up",
    "left_quarter_turn_3_25_deg_down",
    "right_quarter_turn_3_25_deg_down",
    "left_quarter_turn_1",
    "right_quarter_turn_1",
    "left_twist_down_to_up",
    "right_twist_down_to_up",
    "left_twist_up_to_down",
    "right_twist_up_to_down",
    "half_loop_up",
    "half_loop_down",
    "left_corkscrew_up",
    "right_corkscrew_up",
    "left_corkscrew_down",
    "right_corkscrew_down",
    "flat_to_60_deg_up",
    "60_deg_up_to_flat",
    "flat_to_60_deg_down",
    "60_deg_down_to_flat",
    "tower_base",
    "tower_section",
    "flat_covered",
    "25_deg_up_covered",
    "60_deg_up_covered",
    "flat_to_25_deg_up_covered",
    "25_deg_up_to_60_deg_up_covered",
    "60_deg_up_to_25_deg_up_covered",
    "25_deg_up_to_flat_covered",
    "25_deg_down_covered",
    "60_deg_down_covered",
    "flat_to_25_deg_down_covered",
    "25_deg_down_to_60_deg_down_covered",
    "60_deg_down_to_25_deg_down_covered",
    "25_deg_down_to_flat_covered",
    "left_quarter_turn_5_covered",
    "right_quarter_turn_5_covered",
    "s_bend_left_covered",
    "s_bend_right_covered",
    "left_quarter_turn_3_covered",
    "right_quarter_turn_3_covered",
    "left_half_banked_helix_up_small",
    "right_half_banked_helix_up_small",
    "left_half_banked_helix_down_small",
    "right_half_banked_helix_down_small",
    "left_half_banked_helix_up_large",
    "right_half_banked_helix_up_large",
    "left_half_banked_helix_down_large",
    "right_half_banked_helix_down_large",
    "left_quarter_turn_1_60_deg_up",
    "right_quarter_turn_1_60_deg_up",
    "left_quarter_turn_1_60_deg_down",
    "right_quarter_turn_1_60_deg_down",
    "brakes",
    "rotation_control_toggle",
    "inverted_90_deg_up_to_flat_quarter_loop_maze",
    "left_quarter_banked_helix_large_up",
    "right_quarter_banked_helix_large_up",
    "left_quarter_banked_helix_large_down",
    "right_quarter_banked_helix_large_down",
    "left_quarter_helix_large_up",
    "right_quarter_helix_large_up",
    "left_quarter_helix_large_down",
    "right_quarter_helix_large_down",
    "25_deg_up_left_banked",
    "25_deg_up_right_banked",
    "waterfall",
    "rapids",
    "on_ride_photo",
    "25_deg_down_left_banked",
    "25_deg_down_right_banked",
    "water_splash",
    "flat_to_60_deg_up_long_base",
    "60_deg_up_to_flat_long_base",
    "whirlpool",
    "flat_to_60_deg_down_long_base",
    "60_deg_up_to_flat_long_base122",
    "cable_lift_hill",
    "reverse_freefall_slope",
    "reverse_freefall_vertical",
    "90_deg_up",
    "90_deg_down",
    "60_deg_up_to_90_deg_up",
    "90_deg_down_to_60_deg_down",
    "90_deg_up_to_60_deg_up",
    "60_deg_down_to_90_deg_down",
    "brake_for_drop",
    "left_eighth_to_diag",
    "right_eighth_to_diag",
    "left_eighth_to_orthogonal",
    "right_eighth_to_orthogonal",
    "left_eighth_bank_to_diag",
    "right_eighth_bank_to_diag",
    "left_eighth_bank_to_orthogonal",
    "right_eighth_bank_to_orthogonal",
    "diag_flat",
    "diag_25_deg_up",
    "diag_60_deg_up",
    "diag_flat_to_25_deg_up",
    "diag_25_deg_up_to_60_deg_up",
    "diag_60_deg_up_to_25_deg_up",
    "diag_25_deg_up_to_flat",
    "diag_25_deg_down",
    "diag_60_deg_down",
    "diag_flat_to_25_deg_down",
    "diag_25_deg_down_to_60_deg_down",
    "diag_60_deg_down_to_25_deg_down",
    "diag_25_deg_down_to_flat",
    "diag_flat_to_60_deg_up",
    "diag_60_deg_up_to_flat",
    "diag_flat_to_60_deg_down",
    "diag_60_deg_down_to_flat",
    "diag_flat_to_left_bank",
    "diag_flat_to_right_bank",
    "diag_left_bank_to_flat",
    "diag_right_bank_to_flat",
    "diag_left_bank_to_25_deg_up",
    "diag_right_bank_to_25_deg_up",
    "diag_25_deg_up_to_left_bank",
    "diag_25_deg_up_to_right_bank",
    "diag_left_bank_to_25_deg_down",
    "diag_right_bank_to_25_deg_down",
    "diag_25_deg_down_to_left_bank",
    "diag_25_deg_down_to_right_bank",
    "diag_left_bank",
    "diag_right_bank",
    "log_flume_reverser",
    "spinning_tunnel",
    "left_barrel_roll_up_to_down",
    "right_barrel_roll_up_to_down",
    "left_barrel_roll_down_to_up",
    "right_barrel_roll_down_to_up",
    "left_bank_to_left_quarter_turn_3_25_deg_up",
    "right_bank_to_right_quarter_turn_3_25_deg_up",
    "left_quarter_turn_3_25_deg_down_to_left_bank",
    "right_quarter_turn_3_25_deg_down_to_right_bank",
    "powered_lift",
    "left_large_half_loop_up",
    "right_large_half_loop_up",
    "right_large_half_loop_down",
    "left_large_half_loop_down",
    "left_flyer_twist_up",
    "right_flyer_twist_up",
    "left_flyer_twist_down",
    "right_flyer_twist_down",
    "flyer_half_loop_up",
    "flyer_half_loop_down",
    "left_flyer_corkscrew_up",
    "right_flyer_corkscrew_up",
    "left_flyer_corkscrew_down",
    "right_flyer_corkscrew_down",
    "heartline_transfer_up",
    "heartline_transfer_down",
    "left_heartline_roll",
    "right_heartline_roll",
    "mini_golf_hole_a",
    "mini_golf_hole_b",
    "mini_golf_hole_c",
    "mini_golf_hole_d",
    "mini_golf_hole_e",
    "multidim_inverted_flat_to_90_deg_quarter_loop_down",
    "90_deg_to_inverted_flat_quarter_loop_up",
    "inverted_flat_to_90_deg_quarter_loop_down",
    "left_curved_lift_hill",
    "right_curved_lift_hill",
    "left_reverser",
    "right_reverser",
    "air_thrust_top_cap",
    "air_thrust_vertical_down",
    "air_thrust_vertical_down_to_level",
    "block_brakes",
    "left_banked_quarter_turn_3_25_deg_up",
    "right_banked_quarter_turn_3_25_deg_up",
    "left_banked_quarter_turn_3_25_deg_down",
    "right_banked_quarter_turn_3_25_deg_down",
    "left_banked_quarter_turn_5_25_deg_up",
    "right_banked_quarter_turn_5_25_deg_up",
    "left_banked_quarter_turn_5_25_deg_down",
    "right_banked_quarter_turn_5_25_deg_down",
    "25_deg_up_to_left_banked_25_deg_up",
    "25_deg_up_to_right_banked_25_deg_up",
    "left_banked_25_deg_up_to_25_deg_up",
    "right_banked_25_deg_up_to_25_deg_up",
    "25_deg_down_to_left_banked_25_deg_down",
    "25_deg_down_to_right_banked_25_deg_down",
    "left_banked_25_deg_down_to_25_deg_down",
    "right_banked_25_deg_down_to_25_deg_down",
    "left_banked_flat_to_left_banked_25_deg_up",
    "right_banked_flat_to_right_banked_25_deg_up",
    "left_banked_25_deg_up_to_left_banked_flat",
    "right_banked_25_deg_up_to_right_banked_flat",
    "left_banked_flat_to_left_banked_25_deg_down",
    "right_banked_flat_to_right_banked_25_deg_down",
    "left_banked_25_deg_down_to_left_banked_flat",
    "right_banked_25_deg_down_to_right_banked_flat",
    "flat_to_left_banked_25_deg_up",
    "flat_to_right_banked_25_deg_up",
    "left_banked_25_deg_up_to_flat",
    "right_banked_25_deg_up_to_flat",
    "flat_to_left_banked_25_deg_down",
    "flat_to_right_banked_25_deg_down",
    "left_banked_25_deg_down_to_flat",
    "right_banked_25_deg_down_to_flat",
    "left_quarter_turn_1_90_deg_up",
    "right_quarter_turn_1_90_deg_up",
    "left_quarter_turn_1_90_deg_down",
    "right_quarter_turn_1_90_deg_down",
    "multidim_90_deg_up_to_inverted_flat_quarter_loop",
    "multidim_flat_to_90_deg_down_quarter_loop",
    "elem_255"
};
