#pragma region Copyright (c) 2014-2017 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#include "../../core/Math.hpp"
#include "../../drawing/Drawing.h"
#include "../../interface/Viewport.h"
#include "../../interface/Window.h"
#include "../../localisation/Localisation.h"
#include "../../paint/Paint.h"
#include "../../paint/Supports.h"
#include "../../sprites.h"
#include "../../world/Map.h"
#include "../../world/Sprite.h"
#include "../RideData.h"
#include "../TrackData.h"
#include "../TrackPaint.h"
#include "JuniorRollerCoaster.h"

enum
{
    SPR_JUNIOR_RC_FLAT_SW_NE                                                = 27807,
    SPR_JUNIOR_RC_FLAT_NW_SE                                                = 27808,
    SPR_JUNIOR_RC_25_DEG_SW_NE                                              = 27809,
    SPR_JUNIOR_RC_60_DEG_SW_NE                                              = 27810,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_SW_NE                                   = 27811,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_SW_NE                                 = 27812,
    SPR_JUNIOR_RC_25_DEG_NE_SW                                              = 27813,
    SPR_JUNIOR_RC_60_DEG_NE_SW                                              = 27814,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_NE_SW                                   = 27815,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NE_SW_PART_0_2                        = 27816,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_NE_SW                                   = 27817,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NE_SW_PART_0_2                        = 27818,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_SW_NE                                   = 27819,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_SW_NE                                 = 27820,
    SPR_JUNIOR_RC_25_DEG_NW_SE                                              = 27821,
    SPR_JUNIOR_RC_60_DEG_NW_SE                                              = 27822,
    SPR_JUNIOR_RC_25_DEG_SE_NW                                              = 27823,
    SPR_JUNIOR_RC_60_DEG_SE_NW                                              = 27824,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_NW_SE                                   = 27825,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NW_SE_PART_0_2                        = 27826,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_SE_NW                                   = 27827,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_SE_NW                                 = 27828,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_SE_NW                                   = 27829,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_SE_NW                                 = 27830,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_NW_SE                                   = 27831,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NW_SE_PART_0_2                        = 27832,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_0                    = 27833,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_1                    = 27834,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_2                    = 27835,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_3                    = 27836,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_4                    = 27837,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_0                    = 27838,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_1                    = 27839,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_2                    = 27840,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_3                    = 27841,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_4                    = 27842,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_0                    = 27843,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_1                    = 27844,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_2                    = 27845,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_3                    = 27846,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_4                    = 27847,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_0                    = 27848,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_1                    = 27849,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_2                    = 27850,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_3                    = 27851,
    SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_4                    = 27852,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NE_SW                                 = 27853,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NE_SW                                 = 27854,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NW_SE                                 = 27855,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NW_SE                                 = 27856,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_0         = 27857,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_1         = 27858,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_2         = 27859,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_3         = 27860,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_4         = 27861,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_0         = 27862,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_1         = 27863,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_2         = 27864,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_3         = 27865,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_4         = 27866,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_0         = 27867,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_1         = 27868,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_2         = 27869,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_3         = 27870,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_4         = 27871,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_0         = 27872,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_1         = 27873,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_2         = 27874,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_3         = 27875,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_4         = 27876,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_0          = 27877,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_1          = 27878,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_2          = 27879,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_3          = 27880,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_4          = 27881,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_0          = 27882,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_1          = 27883,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_2          = 27884,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_3          = 27885,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_4          = 27886,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_0          = 27887,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_1          = 27888,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_2          = 27889,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_3          = 27890,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_4          = 27891,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_0          = 27892,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_1          = 27893,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_2          = 27894,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_3          = 27895,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_4          = 27896,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_0                                 = 27897,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_1                                 = 27898,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_2                                 = 27899,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_3                                 = 27900,
    SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_0                                  = 27901,
    SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_1                                  = 27902,
    SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_2                                  = 27903,
    SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_3                                  = 27904,
    SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_0                                  = 27905,
    SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_1                                  = 27906,
    SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_2                                  = 27907,
    SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_3                                  = 27908,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_0                                 = 27909,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_1                                 = 27910,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_2                                 = 27911,
    SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_3                                 = 27912,
    SPR_JUNIOR_RC_FLAT_CHAIN_SW_NE                                          = 27913,
    SPR_JUNIOR_RC_FLAT_CHAIN_NW_SE                                          = 27914,
    SPR_JUNIOR_RC_25_DEG_CHAIN_SW_NE                                        = 27915,
    SPR_JUNIOR_RC_60_DEG_CHAIN_SW_NE                                        = 27916,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_SW_NE                             = 27917,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_SW_NE                           = 27918,
    SPR_JUNIOR_RC_25_DEG_CHAIN_NE_SW                                        = 27919,
    SPR_JUNIOR_RC_60_DEG_CHAIN_NE_SW                                        = 27920,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_NE_SW                             = 27921,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NE_SW_PART_0_2                  = 27922,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_NE_SW                             = 27923,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NE_SW_PART_0_2                  = 27924,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_SW_NE                             = 27925,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_SW_NE                           = 27926,
    SPR_JUNIOR_RC_25_DEG_CHAIN_NW_SE                                        = 27927,
    SPR_JUNIOR_RC_60_DEG_CHAIN_NW_SE                                        = 27928,
    SPR_JUNIOR_RC_25_DEG_CHAIN_SE_NW                                        = 27929,
    SPR_JUNIOR_RC_60_DEG_CHAIN_SE_NW                                        = 27930,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_NW_SE                             = 27931,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NW_SE_PART_0_2                  = 27932,
    SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_SE_NW                             = 27933,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_SE_NW                           = 27934,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_SE_NW                             = 27935,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_SE_NW                           = 27936,
    SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_NW_SE                             = 27937,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NW_SE_PART_0_2                  = 27938,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NE_SW                           = 27939,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NE_SW                           = 27940,
    SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NW_SE                           = 27941,
    SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NW_SE                           = 27942,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0   = 27943,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1   = 27944,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_2   = 27945,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_3   = 27946,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_4   = 27947,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0   = 27948,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1   = 27949,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_2   = 27950,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_3   = 27951,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_4   = 27952,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0   = 27953,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1   = 27954,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_2   = 27955,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_3   = 27956,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_4   = 27957,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0   = 27958,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1   = 27959,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_2   = 27960,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_3   = 27961,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_4   = 27962,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0    = 27963,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1    = 27964,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_2    = 27965,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_3    = 27966,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_4    = 27967,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0    = 27968,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1    = 27969,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_2    = 27970,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_3    = 27971,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_4    = 27972,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0    = 27973,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1    = 27974,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_2    = 27975,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_3    = 27976,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_4    = 27977,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0    = 27978,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1    = 27979,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_2    = 27980,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_3    = 27981,
    SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_4    = 27982,
    SPR_WATER_RC_FLAT_CHAIN_SW_NE                                           = 27983,
    SPR_WATER_RC_FLAT_CHAIN_NW_SE                                           = 27984,
    SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_SW_NE                              = 27985,
    SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_NW_SE                              = 27986,
    SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_NE_SW                              = 27987,
    SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_SE_NW                              = 27988,
    SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_SW_NE                              = 27989,
    SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_NW_SE                              = 27990,
    SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_NE_SW                              = 27991,
    SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_SE_NW                              = 27992,
    SPR_WATER_RC_25_DEG_CHAIN_SW_NE                                         = 27993,
    SPR_WATER_RC_25_DEG_CHAIN_NW_SE                                         = 27994,
    SPR_WATER_RC_25_DEG_CHAIN_NE_SW                                         = 27995,
    SPR_WATER_RC_25_DEG_CHAIN_SE_NW                                         = 27996,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SW_NE                                   = 27997,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NW_SE                                   = 27998,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NE_SW                                   = 27999,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SE_NW                                   = 28000,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SW_NE                                  = 28001,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NW_SE                                  = 28002,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NE_SW                                  = 28003,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SE_NW                                  = 28004,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SW_NE_FRONT                             = 28005,
    SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NW_SE_FRONT                             = 28006,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NE_SW_FRONT                            = 28007,
    SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SE_NW_FRONT                            = 28008,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SW_NE                              = 28009,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NW_SE                              = 28010,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NE_SW                              = 28011,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SE_NW                              = 28012,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SW_NE_FRONT                        = 28013,
    SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NW_SE_FRONT                        = 28014,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SW_NE                             = 28015,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NW_SE                             = 28016,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NE_SW                             = 28017,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SE_NW                             = 28018,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NE_SW_FRONT                       = 28019,
    SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SE_NW_FRONT                       = 28020,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SW_NE                              = 28021,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NW_SE                              = 28022,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NE_SW                              = 28023,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SE_NW                              = 28024,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SW_NE_FRONT                        = 28025,
    SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NW_SE_FRONT                        = 28026,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SW_NE                             = 28027,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NW_SE                             = 28028,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NE_SW                             = 28029,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SE_NW                             = 28030,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NE_SW_FRONT                       = 28031,
    SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SE_NW_FRONT                       = 28032,
    SPR_JUNIOR_RC_LEFT_BANK_SW_NE                                           = 28033,
    SPR_JUNIOR_RC_LEFT_BANK_NW_SE                                           = 28034,
    SPR_JUNIOR_RC_LEFT_BANK_NE_SW                                           = 28035,
    SPR_JUNIOR_RC_LEFT_BANK_SE_NW                                           = 28036,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_0                  = 28037,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_1                  = 28038,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_2                  = 28039,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_3                  = 28040,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_4                  = 28041,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_0                  = 28042,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_1                  = 28043,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_2                  = 28044,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_3                  = 28045,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_4                  = 28046,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_0                  = 28047,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_1                  = 28048,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_2                  = 28049,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_3                  = 28050,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_4                  = 28051,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_0                  = 28052,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_1                  = 28053,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_2                  = 28054,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_3                  = 28055,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_4                  = 28056,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_4_2                = 28057,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_0_2                = 28058,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_0                         = 28059,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_1                         = 28060,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_2                         = 28061,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_0                         = 28062,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_1                         = 28063,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_2                         = 28064,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_0                         = 28065,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_1                         = 28066,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_2                         = 28067,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_0                         = 28068,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_1                         = 28069,
    SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_2                         = 28070,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_0                  = 28071,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_1                  = 28072,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_2                  = 28073,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_0                  = 28074,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_1                  = 28075,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_2                  = 28076,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_0                  = 28077,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_1                  = 28078,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_2                  = 28079,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_0                  = 28080,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_1                  = 28081,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_2                  = 28082,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_2_2                = 28083,
    SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_0_2                = 28084,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SW_SE_PART_0         = 28085,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SW_SE_PART_1         = 28086,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NW_SW_PART_0         = 28087,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NW_SW_PART_1         = 28088,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NE_NW_PART_0         = 28089,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NE_NW_PART_1         = 28090,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SE_NE_PART_0         = 28091,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SE_NE_PART_1         = 28092,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SW_SE_PART_0       = 28093,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SW_SE_PART_1       = 28094,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NW_SW_PART_0       = 28095,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NW_SW_PART_1       = 28096,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NE_NW_PART_0       = 28097,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NE_NW_PART_1       = 28098,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SE_NE_PART_0       = 28099,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SE_NE_PART_1       = 28100,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0   = 28101,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1   = 28102,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0   = 28103,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1   = 28104,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0   = 28105,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1   = 28106,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0   = 28107,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1   = 28108,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SW_SE_PART_0 = 28109,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SW_SE_PART_1 = 28110,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NW_SW_PART_0 = 28111,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NW_SW_PART_1 = 28112,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NE_NW_PART_0 = 28113,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NE_NW_PART_1 = 28114,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SE_NE_PART_0 = 28115,
    SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SE_NE_PART_1 = 28116,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_0             = 28117,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_1             = 28118,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_2             = 28119,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_0             = 28120,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_1             = 28121,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_2             = 28122,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_0             = 28123,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_1             = 28124,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_2             = 28125,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_0             = 28126,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_1             = 28127,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_2             = 28128,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_2_2           = 28129,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_0_2           = 28130,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_0           = 28131,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_1           = 28132,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_2           = 28133,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_0           = 28134,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_1           = 28135,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_2           = 28136,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_0           = 28137,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_1           = 28138,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_2           = 28139,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_0           = 28140,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_1           = 28141,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_2           = 28142,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_2_2         = 28143,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_0_2         = 28144,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_0             = 28145,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_1             = 28146,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_2             = 28147,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_3             = 28148,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_4             = 28149,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_0             = 28150,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_1             = 28151,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_2             = 28152,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_3             = 28153,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_4             = 28154,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_0             = 28155,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_1             = 28156,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_2             = 28157,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_3             = 28158,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_4             = 28159,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_0             = 28160,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_1             = 28161,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_2             = 28162,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_3             = 28163,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_4             = 28164,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_4_2           = 28165,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_0_2           = 28166,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_0           = 28167,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_1           = 28168,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_2           = 28169,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_3           = 28170,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_4           = 28171,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_0           = 28172,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_1           = 28173,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_2           = 28174,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_3           = 28175,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_4           = 28176,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_0           = 28177,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_1           = 28178,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_2           = 28179,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_3           = 28180,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_4           = 28181,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_0           = 28182,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_1           = 28183,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_2           = 28184,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_3           = 28185,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_4           = 28186,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_4_2         = 28187,
    SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_0_2         = 28188,
    SPR_JUNIOR_RC_STATION_SW_NE                                             = 28189,
    SPR_JUNIOR_RC_STATION_NW_SE                                             = 28190,
    SPR_JUNIOR_RC_FLAT_SW_NE_BRAKED                                         = 28191,
    SPR_JUNIOR_RC_FLAT_NW_SE_BRAKED                                         = 28192,
    SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE                                          = 28193,
    SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE                                          = 28194,
    SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE_BRAKED                                   = 28195,
    SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE_BRAKED                                   = 28196,
    SPR_JUNIOR_RC_DIAG_FLAT_W_E                                             = 28197,
    SPR_JUNIOR_RC_DIAG_FLAT_N_S                                             = 28198,
    SPR_JUNIOR_RC_DIAG_FLAT_E_W                                             = 28199,
    SPR_JUNIOR_RC_DIAG_FLAT_S_N                                             = 28200,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_W_E                                = 28201,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_N_S                                = 28202,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_E_W                                = 28203,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_S_N                                = 28204,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_W_E                                = 28205,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_N_S                                = 28206,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_E_W                                = 28207,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_S_N                                = 28208,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_W_E                                        = 28209,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_N_S                                        = 28210,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_E_W                                        = 28211,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_S_N                                        = 28212,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_W_E                           = 28213,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_N_S                           = 28214,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_E_W                           = 28215,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_S_N                           = 28216,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_W_E                           = 28217,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_N_S                           = 28218,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_E_W                           = 28219,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_S_N                           = 28220,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_W_E                                        = 28221,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_N_S                                        = 28222,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_E_W                                        = 28223,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_S_N                                        = 28224,

    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_W_E = 28225,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_N_S = 28226,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_E_W = 28227,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_S_N = 28228,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_W_E = 28229,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_N_S = 28230,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_E_W = 28231,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_S_N = 28232,

    SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_W_E                   = 28233,
    SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_N_S                   = 28234,
    SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_E_W                   = 28235,
    SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_S_N                   = 28236,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E      = 28237,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S      = 28238,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W      = 28239,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N      = 28240,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E      = 28241,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S      = 28242,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W      = 28243,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N      = 28244,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_W_E              = 28245,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_N_S              = 28246,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_E_W              = 28247,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_S_N              = 28248,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_W_E = 28249,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_N_S = 28250,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_E_W = 28251,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_S_N = 28252,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_W_E = 28253,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_N_S = 28254,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_E_W = 28255,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_S_N = 28256,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_W_E              = 28257,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_N_S              = 28258,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_E_W              = 28259,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_S_N              = 28260,

    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_W_E = 28261,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_N_S = 28262,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_E_W = 28263,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_S_N = 28264,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_W_E = 28265,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_N_S = 28266,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_E_W = 28267,
    SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_S_N = 28268,

    SPR_WATER_RC_DIAG_FLAT_CHAIN_W_E                        = 28269,
    SPR_WATER_RC_DIAG_FLAT_CHAIN_N_S                        = 28270,
    SPR_WATER_RC_DIAG_FLAT_CHAIN_E_W                        = 28271,
    SPR_WATER_RC_DIAG_FLAT_CHAIN_S_N                        = 28272,
    SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E           = 28273,
    SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S           = 28274,
    SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W           = 28275,
    SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N           = 28276,
    SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E           = 28277,
    SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S           = 28278,
    SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W           = 28279,
    SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N           = 28280,
    SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_W_E                   = 28281,
    SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_N_S                   = 28282,
    SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_E_W                   = 28283,
    SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_S_N                   = 28284,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_0                 = 28285,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_1                 = 28286,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_2                 = 28287,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_3                 = 28288,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_0                 = 28289,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_1                 = 28290,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_2                 = 28291,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_3                 = 28292,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_0                 = 28293,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_1                 = 28294,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_2                 = 28295,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_3                 = 28296,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_0                 = 28297,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_1                 = 28298,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_2                 = 28299,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_3                 = 28300,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_0                 = 28301,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_1                 = 28302,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_2                 = 28303,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_3                 = 28304,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_0                 = 28305,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_1                 = 28306,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_2                 = 28307,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_3                 = 28308,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_0                 = 28309,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_1                 = 28310,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_2                 = 28311,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_3                 = 28312,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_0                 = 28313,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_1                 = 28314,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_2                 = 28315,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_3                 = 28316,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_0            = 28317,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_1            = 28318,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_2            = 28319,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_3            = 28320,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_0            = 28321,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_1            = 28322,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_2            = 28323,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_3            = 28324,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_0            = 28325,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_1            = 28326,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_2            = 28327,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_3            = 28328,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_0            = 28329,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_1            = 28330,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_2            = 28331,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_3            = 28332,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_0            = 28333,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_1            = 28334,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_2            = 28335,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_3            = 28336,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_0            = 28337,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_1            = 28338,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_2            = 28339,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_3            = 28340,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_0            = 28341,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_1            = 28342,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_2            = 28343,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_3            = 28344,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_0            = 28345,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_1            = 28346,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_2            = 28347,
    SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_3            = 28348,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_W_E                        = 28349,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_N_S                        = 28350,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_E_W                        = 28351,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_S_N                        = 28352,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E                = 28353,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_N_S                = 28354,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_E_W                = 28355,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_S_N                = 28356,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E_PART_0_2       = 28357,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_W_E               = 28358,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_N_S               = 28359,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W               = 28360,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_S_N               = 28361,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W_PART_0_2      = 28362,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E           = 28363,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_N_S           = 28364,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_E_W           = 28365,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_S_N           = 28366,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E_PART_0_2  = 28367,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_W_E          = 28368,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_N_S          = 28369,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W          = 28370,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_S_N          = 28371,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W_PART_0_2 = 28372,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E           = 28373,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_N_S           = 28374,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_E_W           = 28375,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_S_N           = 28376,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E_PART_0_2  = 28377,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_W_E          = 28378,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_N_S          = 28379,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W          = 28380,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_S_N          = 28381,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W_PART_0_2 = 28382,

    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SW_NE          = SPR_G2_BEGIN + 34,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE          = SPR_G2_BEGIN + 35,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW          = SPR_G2_BEGIN + 36,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SE_NW          = SPR_G2_BEGIN + 37,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE_PART_0_2 = SPR_G2_BEGIN + 38,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW_PART_0_2 = SPR_G2_BEGIN + 39,

    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SW_NE          = SPR_G2_BEGIN + 46,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE          = SPR_G2_BEGIN + 47,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW          = SPR_G2_BEGIN + 48,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SE_NW          = SPR_G2_BEGIN + 49,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE_PART_0_2 = SPR_G2_BEGIN + 50,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW_PART_0_2 = SPR_G2_BEGIN + 51,

    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SW_NE          = SPR_G2_BEGIN + 40,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE          = SPR_G2_BEGIN + 41,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW          = SPR_G2_BEGIN + 42,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SE_NW          = SPR_G2_BEGIN + 43,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE_PART_0_2 = SPR_G2_BEGIN + 44,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW_PART_0_2 = SPR_G2_BEGIN + 45,

    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SW_NE          = SPR_G2_BEGIN + 52,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE          = SPR_G2_BEGIN + 53,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW          = SPR_G2_BEGIN + 54,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SE_NW          = SPR_G2_BEGIN + 55,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE_PART_0_2 = SPR_G2_BEGIN + 56,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW_PART_0_2 = SPR_G2_BEGIN + 57,

    SPR_JUNIOR_RC_BOOSTER_NW_SE = SPR_G2_BEGIN + 85,
    SPR_JUNIOR_RC_BOOSTER_NE_SW = SPR_G2_BEGIN + 86,
};

static constexpr const uint32 junior_rc_track_pieces_flat[3][4] = {
    { SPR_JUNIOR_RC_FLAT_SW_NE, SPR_JUNIOR_RC_FLAT_NW_SE, SPR_JUNIOR_RC_FLAT_SW_NE, SPR_JUNIOR_RC_FLAT_NW_SE },
    { SPR_JUNIOR_RC_FLAT_CHAIN_SW_NE, SPR_JUNIOR_RC_FLAT_CHAIN_NW_SE, SPR_JUNIOR_RC_FLAT_CHAIN_SW_NE,
      SPR_JUNIOR_RC_FLAT_CHAIN_NW_SE },
    {
        SPR_WATER_RC_FLAT_CHAIN_SW_NE,
        SPR_WATER_RC_FLAT_CHAIN_NW_SE,
        SPR_WATER_RC_FLAT_CHAIN_SW_NE,
        SPR_WATER_RC_FLAT_CHAIN_NW_SE,
    },
};

static constexpr const uint32 junior_rc_track_pieces_block_brake[2][4] = {
    { SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE, SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE, SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE,
      SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE },
    { SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE_BRAKED, SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE_BRAKED, SPR_JUNIOR_RC_FLAT_BLOCK_SW_NE_BRAKED,
      SPR_JUNIOR_RC_FLAT_BLOCK_NW_SE_BRAKED },
};

static constexpr const uint32 junior_rc_track_pieces_station[2][4] = {
    { SPR_JUNIOR_RC_STATION_SW_NE, SPR_JUNIOR_RC_STATION_NW_SE, SPR_JUNIOR_RC_STATION_SW_NE, SPR_JUNIOR_RC_STATION_NW_SE },
    { SPR_JUNIOR_RC_FLAT_SW_NE_BRAKED, SPR_JUNIOR_RC_FLAT_NW_SE_BRAKED, SPR_JUNIOR_RC_FLAT_SW_NE_BRAKED,
      SPR_JUNIOR_RC_FLAT_NW_SE_BRAKED },
};

static constexpr const uint32 junior_rc_track_pieces_25_deg_up[3][4] = {
    { SPR_JUNIOR_RC_25_DEG_SW_NE, SPR_JUNIOR_RC_25_DEG_NW_SE, SPR_JUNIOR_RC_25_DEG_NE_SW, SPR_JUNIOR_RC_25_DEG_SE_NW },
    { SPR_JUNIOR_RC_25_DEG_CHAIN_SW_NE, SPR_JUNIOR_RC_25_DEG_CHAIN_NW_SE, SPR_JUNIOR_RC_25_DEG_CHAIN_NE_SW,
      SPR_JUNIOR_RC_25_DEG_CHAIN_SE_NW },
    {
        SPR_WATER_RC_25_DEG_CHAIN_SW_NE,
        SPR_WATER_RC_25_DEG_CHAIN_NW_SE,
        SPR_WATER_RC_25_DEG_CHAIN_NE_SW,
        SPR_WATER_RC_25_DEG_CHAIN_SE_NW,
    },
};

static constexpr const uint32 junior_rc_track_pieces_flat_to_25_deg_up[3][4] = {
    { SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_SW_NE, SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_NW_SE, SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_NE_SW,
      SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_SE_NW },
    { SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_SW_NE, SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_NW_SE,
      SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_NE_SW, SPR_JUNIOR_RC_FLAT_TO_25_DEG_UP_CHAIN_SE_NW },
    {
        SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_SW_NE,
        SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_NW_SE,
        SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_NE_SW,
        SPR_WATER_RC_FLAT_TO_25_DEG_UP_CHAIN_SE_NW,
    },
};

static constexpr const uint32 junior_rc_track_pieces_25_deg_up_to_flat[3][4] = {
    { SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_SW_NE, SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_NW_SE, SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_NE_SW,
      SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_SE_NW },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_SW_NE, SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_NW_SE,
      SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_NE_SW, SPR_JUNIOR_RC_25_DEG_UP_TO_FLAT_CHAIN_SE_NW },
    {
        SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_SW_NE,
        SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_NW_SE,
        SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_NE_SW,
        SPR_WATER_RC_25_DEG_UP_TO_FLAT_CHAIN_SE_NW,
    },
};

static constexpr const uint32 junior_rc_track_pieces_flat_to_left_bank[4][2] = {
    { SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SW_NE, SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SW_NE_FRONT },
    { SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NW_SE, SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NW_SE_FRONT },
    { SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_NE_SW, 0 },
    { SPR_JUNIOR_RC_FLAT_TO_LEFT_BANK_SE_NW, 0 }
};

static constexpr const uint32 junior_rc_track_pieces_flat_to_right_bank[4][2] = {
    { SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SW_NE, 0 },
    { SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NW_SE, 0 },
    { SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NE_SW, SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_NE_SW_FRONT },
    { SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SE_NW, SPR_JUNIOR_RC_FLAT_TO_RIGHT_BANK_SE_NW_FRONT }
};

static constexpr const uint32 junior_rc_track_pieces_flat_quarter_turn_5_tiles[4][5] = {
    {
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_0,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_1,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_2,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_3,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SW_SE_PART_4,
    },
    {
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_0,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_1,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_2,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_3,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NW_SW_PART_4,
    },
    {
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_0,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_1,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_2,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_3,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_NE_NW_PART_4,
    },
    {
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_0,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_1,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_2,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_3,
        SPR_JUNIOR_RC_FLAT_QUARTER_TURN_5_TILES_SE_NE_PART_4,
    }
};

static constexpr const uint32 junior_rc_track_pieces_banked_quarter_turn_5_tiles[4][5] = {
    {
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_0,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_1,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_2,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_3,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SW_SE_PART_4,
    },
    {
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_0,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_1,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_2,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_3,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_4,
    },
    {
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_0,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_1,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_2,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_3,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NE_NW_PART_4,
    },
    {
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_0,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_1,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_2,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_3,
        SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_4,
    }
};

static constexpr const uint32 junior_rc_track_pieces_left_banked_to_25_deg_up[4][2] = {
    { SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SW_NE, SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SW_NE_FRONT },
    { SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NW_SE, SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NW_SE_FRONT },
    { SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_NE_SW, 0 },
    { SPR_JUNIOR_RC_LEFT_BANK_TO_25_DEG_UP_SE_NW, 0 }
};

static constexpr const uint32 junior_rc_track_pieces_right_banked_to_25_deg_up[4][2] = {
    { SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SW_NE, 0 },
    { SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NW_SE, 0 },
    { SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NE_SW, SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_NE_SW_FRONT },
    { SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SE_NW, SPR_JUNIOR_RC_RIGHT_BANK_TO_25_DEG_UP_SE_NW_FRONT }
};

static constexpr const uint32 junior_rc_track_pieces_25_deg_up_to_left_bank[4][2] = {
    { SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SW_NE, SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SW_NE_FRONT },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NW_SE, SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NW_SE_FRONT },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_NE_SW, 0 },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_LEFT_BANK_SE_NW, 0 }
};

static constexpr const uint32 junior_rc_track_pieces_25_deg_up_to_right_bank[4][2] = {
    { SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SW_NE, 0 },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NW_SE, 0 },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NE_SW, SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_NE_SW_FRONT },
    { SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SE_NW, SPR_JUNIOR_RC_25_DEG_UP_TO_RIGHT_BANK_SE_NW_FRONT }
};

static constexpr const uint32 junior_rc_track_pieces_left_bank[4] = { SPR_JUNIOR_RC_LEFT_BANK_SW_NE, SPR_JUNIOR_RC_LEFT_BANK_NW_SE,
                                                            SPR_JUNIOR_RC_LEFT_BANK_NE_SW, SPR_JUNIOR_RC_LEFT_BANK_SE_NW };

static constexpr const uint32 junior_rc_track_pieces_left_quarter_turn_5_tiles_25_deg_up[2][4][5] = {
    { {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_4,
      } },
    { {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_4,
      },
      {
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_2,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_3,
          SPR_JUNIOR_RC_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_4,
      } }
};

// clang-format off
static constexpr const LocationXY16 junior_rc_left_quarter_turn_5_tiles_25_deg_up_offsets[4][5] = { {
                                                                                   { 0, 6 },
                                                                                   { 0, 0 },
                                                                                   { 0, 16 },
                                                                                   { 16, 0 },
                                                                                   { 6, 0 },
                                                                               },
                                                                               {
                                                                                   { 6, 0 },
                                                                                   { 0, 0 },
                                                                                   { 16, 16 },
                                                                                   { 0, 0 },
                                                                                   { 0, 6 },
                                                                               },
                                                                               {
                                                                                   { 0, 6 },
                                                                                   { 0, 16 },
                                                                                   { 16, 0 },
                                                                                   { 0, 0 },
                                                                                   { 6, 0 },
                                                                               },
                                                                               {
                                                                                   { 6, 0 },
                                                                                   { 16, 0 },
                                                                                   { 0, 0 },
                                                                                   { 0, 16 },
                                                                                   { 0, 6 },
                                                                               } };

static constexpr const uint32 junior_rc_track_pieces_right_quarter_turn_5_tiles_25_deg_up[2][4][5] = {
    { {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SW_SE_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NW_SW_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_NE_NW_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_SE_NE_PART_4,
      } },
    { {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SW_SE_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NW_SW_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_NE_NW_PART_4,
      },
      {
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_2,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_3,
          SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP_CHAIN_SE_NE_PART_4,
      } }
};

static constexpr const uint32 junior_rc_track_pieces_s_bend_left[2][4] = { {
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_0,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_1,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_2,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SW_NE_PART_3,
                                                                 },
                                                                 {
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_3,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_2,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_1,
                                                                     SPR_JUNIOR_RC_S_BEND_LEFT_SE_NW_PART_0,
                                                                 } };

static constexpr const uint32 junior_rc_track_pieces_s_bend_right[2][4] = { {
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_0,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_1,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_2,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SW_NE_PART_3,
                                                                  },
                                                                  {
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_3,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_2,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_1,
                                                                      SPR_JUNIOR_RC_S_BEND_RIGHT_SE_NW_PART_0,
                                                                  } };

static constexpr const uint32 junior_rc_track_pieces_flat_quarter_turn_3_tiles[4][3] = {
    { SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_0, SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_1,
      SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SW_SE_PART_2 },
    { SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_0, SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_1,
      SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NW_SW_PART_2 },
    { SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_0, SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_1,
      SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_NE_NW_PART_2 },
    { SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_0, SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_1,
      SPR_JUNIOR_RC_QUARTER_TURN_3_TILES_SE_NE_PART_2 }
};

static constexpr const uint32 junior_rc_track_pieces_banked_quarter_turn_3_tiles[4][3] = {
    { SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_0, SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_1,
      SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SW_SE_PART_2 },
    { SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_0, SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_1,
      SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_2 },
    { SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_0, SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_1,
      SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NE_NW_PART_2 },
    { SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_0, SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_1,
      SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_2 }
};

static constexpr const uint32 junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_up[2][4][2] = {
    { { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SW_SE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SW_SE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NW_SW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NE_NW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_SE_NE_PART_1 } },
    { { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SW_SE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SW_SE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NW_SW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NE_NW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP_CHAIN_SE_NE_PART_1 } }
};

static constexpr const uint32 junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_down[2][4][2] = {
    { { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SW_SE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SW_SE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NW_SW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NE_NW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_SE_NE_PART_1 } },
    { { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SW_SE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SW_SE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NW_SW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NE_NW_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_CHAIN_SE_NE_PART_1 } }
};

static constexpr const uint32 junior_rc_track_pieces_right_half_banked_helix_up_small_quarter_tiles[4][3][2] = {
    {
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_0 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_1 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SW_SE_PART_2 },
    },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_2,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NW_SW_PART_2_2 } },
    { { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_1 },
      { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_NE_NW_PART_2 } },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_0_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_SE_NE_PART_2 } }
};

static constexpr const uint32 junior_rc_track_pieces_right_half_banked_helix_down_small_quarter_tiles[4][3][2] = {
    {
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_0 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_1 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SW_SE_PART_2 },
    },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_2,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NW_SW_PART_2_2 } },
    { { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_1 },
      { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_NE_NW_PART_2 } },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_0_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL_SE_NE_PART_2 } }
};

static constexpr const uint32 junior_rc_track_pieces_right_half_banked_helix_up_large_quarter_tiles[4][5][2] = {
    {
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_0 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_1 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_2 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_3 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SW_SE_PART_4 },
    },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_3 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_4,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NW_SW_PART_4_2 } },
    { { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_3 },
      { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_NE_NW_PART_4 } },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_0_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_3 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_UP_LARGE_SE_NE_PART_4 } }
};

static constexpr const uint32 junior_rc_track_pieces_right_half_banked_helix_down_large_quarter_tiles[4][5][2] = {
    {
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_0 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_1 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_2 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_3 },
        { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SW_SE_PART_4 },
    },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_3 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_4,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NW_SW_PART_4_2 } },
    { { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_0 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_3 },
      { 0, SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_NE_NW_PART_4 } },
    { { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_0,
        SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_0_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_1 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_2 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_3 },
      { SPR_JUNIOR_RC_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE_SE_NE_PART_4 } }
};

static constexpr const uint32 junior_rc_track_pieces_brake[4] = { SPR_JUNIOR_RC_FLAT_SW_NE_BRAKED, SPR_JUNIOR_RC_FLAT_NW_SE_BRAKED,
                                                        SPR_JUNIOR_RC_FLAT_SW_NE_BRAKED, SPR_JUNIOR_RC_FLAT_NW_SE_BRAKED };

static constexpr const uint32 junior_rc_track_pieces_left_eight_to_diag[4][4] = {
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_N_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_E_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_S_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_W_PART_3,
    },
};

static constexpr const uint32 junior_rc_track_pieces_right_eight_to_diag[4][4] = {
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SW_E_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NW_S_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_NE_W_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_SE_N_PART_3,
    },
};

static constexpr const uint32 junior_rc_track_pieces_left_eight_to_diag_bank[4][4] = {
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_N_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_E_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_S_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_W_PART_3,
    },
};

static constexpr const uint32 junior_rc_track_pieces_right_eight_to_diag_bank[4][4] = {
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SW_E_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NW_S_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_NE_W_PART_3,
    },
    {
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_0,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_1,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_2,
        SPR_JUNIOR_RC_EIGHT_TO_DIAG_BANK_SE_N_PART_3,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat[3][4] = {
    { SPR_JUNIOR_RC_DIAG_FLAT_W_E, SPR_JUNIOR_RC_DIAG_FLAT_N_S, SPR_JUNIOR_RC_DIAG_FLAT_E_W, SPR_JUNIOR_RC_DIAG_FLAT_S_N },
    { SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_N_S, SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_E_W,
      SPR_JUNIOR_RC_DIAG_FLAT_CHAIN_S_N },
    { SPR_WATER_RC_DIAG_FLAT_CHAIN_W_E, SPR_WATER_RC_DIAG_FLAT_CHAIN_N_S, SPR_WATER_RC_DIAG_FLAT_CHAIN_E_W,
      SPR_WATER_RC_DIAG_FLAT_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_up[3][4] = {
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_N_S, SPR_JUNIOR_RC_DIAG_25_DEG_UP_E_W,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_N_S, SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_E_W,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_S_N },
    { SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_W_E, SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_N_S, SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_E_W,
      SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_25_deg_up[3][4] = {
    { SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_N_S,
      SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_E_W, SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N },
    { SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E, SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S,
      SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W, SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_60_deg_up[2][4] = {
    { SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_N_S,
      SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_E_W, SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_up_to_flat[3][4] = {
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_N_S,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_E_W, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_S_N },
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N },
    { SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E, SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S,
      SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W, SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_up_to_flat[2][4] = {
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_N_S,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_E_W, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_S_N },
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_down[3][4] = {
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_CHAIN_N_S,
    },
    {
        SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_E_W,
        SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_S_N,
        SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_W_E,
        SPR_WATER_RC_DIAG_25_DEG_UP_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_25_deg_down[3][4] = {
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S,
    },
    {
        SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_E_W,
        SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_S_N,
        SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_W_E,
        SPR_WATER_RC_DIAG_25_DEG_UP_TO_FLAT_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_60_deg_down[2][4] = {
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_FLAT_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_down_to_flat[3][4] = {
    {
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S,
    },
    {
        SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_E_W,
        SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_S_N,
        SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_W_E,
        SPR_WATER_RC_DIAG_FLAT_TO_25_DEG_UP_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_down_to_flat[2][4] = {
    {
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_FLAT_TO_60_DEG_UP_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_left_bank[4] = {
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_N_S,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_flat_to_right_bank[4] = {
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_N_S,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_right_bank_to_flat[4] = {
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_S_N,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_left_bank_to_flat[4] = {
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_S_N,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_left_bank_to_25_deg_up[4] = {
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_N_S,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_E_W,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_right_bank_to_25_deg_up[4] = {
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_W_E,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_N_S,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_up_to_left_bank[4] = {
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_N_S,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_up_to_right_bank[4] = {
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_N_S,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_right_bank_to_25_deg_down[4] = {
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_S_N,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_left_bank_to_25_deg_down[4] = {
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_S_N,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_down_to_right_bank[4] = {
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_E_W,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_S_N,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_down_to_left_bank[4] = {
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_S_N,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_W_E,
    SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_diag_left_bank[4] = {
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_N_S,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_S_N,
};

static constexpr const uint32 junior_rc_track_pieces_diag_right_bank[4] = {
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_E_W,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_S_N,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_W_E,
    SPR_JUNIOR_RC_DIAG_LEFT_BANK_N_S,
};

static constexpr const uint32 junior_rc_track_pieces_flat_to_60_deg_up[2][4][2] = {
    {
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SW_NE, 0 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE, SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW, SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SE_NW, 0 },
    },
    {
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SW_NE, 0 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE, SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW, SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SE_NW, 0 },
    },
};

static constexpr const uint32 junior_rc_track_pieces_60_deg_up_to_flat[2][4][2] = {
    {
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SW_NE, 0 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE, SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW, SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SE_NW, 0 },
    },
    {
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SW_NE, 0 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE, SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW, SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SE_NW, 0 },
    },
};

static constexpr const uint32 junior_rc_track_pieces_60_deg_up[2][4] = {
    { SPR_JUNIOR_RC_60_DEG_SW_NE, SPR_JUNIOR_RC_60_DEG_NW_SE, SPR_JUNIOR_RC_60_DEG_NE_SW, SPR_JUNIOR_RC_60_DEG_SE_NW },
    { SPR_JUNIOR_RC_60_DEG_CHAIN_SW_NE, SPR_JUNIOR_RC_60_DEG_CHAIN_NW_SE, SPR_JUNIOR_RC_60_DEG_CHAIN_NE_SW,
      SPR_JUNIOR_RC_60_DEG_CHAIN_SE_NW },
};

static constexpr const uint32 junior_rc_track_pieces_25_deg_up_to_60_deg_up[2][4][2] = {
    {
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_SW_NE, 0 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NW_SE, SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NE_SW, SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_SE_NW, 0 },
    },
    {
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_SW_NE, 0 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NW_SE, SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NE_SW, SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_25_DEG_TO_60_DEG_UP_CHAIN_SE_NW, 0 },
    },
};

static constexpr const uint32 junior_rc_track_pieces_60_deg_up_to_25_deg_up[2][4][2] = {
    {
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_SW_NE, 0 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NW_SE, SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NE_SW, SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_SE_NW, 0 },
    },
    {
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_SW_NE, 0 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NW_SE, SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NW_SE_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NE_SW, SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_NE_SW_PART_0_2 },
        { SPR_JUNIOR_RC_60_DEG_TO_25_DEG_UP_CHAIN_SE_NW, 0 },
    }
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_up[2][4] = {
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_N_S, SPR_JUNIOR_RC_DIAG_60_DEG_UP_E_W,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_N_S, SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_E_W,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_down[2][4] = {
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_up_to_60_deg_up[2][4] = {
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_N_S,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_E_W, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_up_to_25_deg_up[2][4] = {
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_N_S,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_E_W, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_S_N },
    { SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_W_E, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_N_S,
      SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_E_W, SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_S_N },
};

static constexpr const uint32 junior_rc_track_pieces_diag_25_deg_down_to_60_deg_down[2][4] = {
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_60_DEG_UP_TO_25_DEG_UP_CHAIN_N_S,
    },
};

static constexpr const uint32 junior_rc_track_pieces_diag_60_deg_down_to_25_deg_down[2][4] = {
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_N_S,
    },
    {
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_E_W,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_S_N,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_W_E,
        SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_60_DEG_UP_CHAIN_N_S,
    },
};
// clang-format on

void junior_rc_paint_track_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 imageId = junior_rc_track_pieces_flat[chainType][direction] | session->TrackColours[SCHEME_TRACK];
    sub_98196C_rotated(session, direction, imageId, 0, 6, 32, 20, 1, height);
    paint_util_push_tunnel_rotated(session, direction, height, TUNNEL_0);

    if (track_paint_util_should_paint_supports(session->MapPosition))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

void junior_rc_paint_station(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    uint8                    rideType)
{
    uint32 imageId;

    bool isBraked = (bool)(tileElement->flags & TILE_ELEMENT_FLAG_BLOCK_BRAKE_CLOSED);

    if (direction == 0 || direction == 2)
    {
        // height -= 2 (height - 2)
        imageId = SPR_STATION_BASE_B_SW_NE | session->TrackColours[SCHEME_MISC];
        sub_98197C(session, imageId, 0, 0, 32, 28, 1, height - 2, 0, 2, height);

        // height += 2 (height)
        if (track_element_get_type(tileElement) == TRACK_ELEM_END_STATION && rideType == RIDE_TYPE_JUNIOR_ROLLER_COASTER)
        {
            imageId = junior_rc_track_pieces_block_brake[isBraked][direction] | session->TrackColours[SCHEME_TRACK];
        }
        else
        {
            imageId = junior_rc_track_pieces_station[false][direction] | session->TrackColours[SCHEME_TRACK];
        }
        sub_98199C(session, imageId, 0, 6, 32, 20, 1, height, 0, 0, height);

        metal_a_supports_paint_setup(session, METAL_SUPPORTS_BOXED, 5, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        metal_a_supports_paint_setup(session, METAL_SUPPORTS_BOXED, 8, 0, height, session->TrackColours[SCHEME_SUPPORTS]);

        paint_util_push_tunnel_left(session, height, TUNNEL_6);
    }
    else if (direction == 1 || direction == 3)
    {
        // height -= 2 (height - 2)
        imageId = SPR_STATION_BASE_B_NW_SE | session->TrackColours[SCHEME_MISC];
        sub_98197C(session, imageId, 0, 0, 28, 32, 1, height - 2, 2, 0, height);

        // height += 2 (height)
        if (track_element_get_type(tileElement) == TRACK_ELEM_END_STATION && rideType == RIDE_TYPE_JUNIOR_ROLLER_COASTER)
        {
            imageId = junior_rc_track_pieces_block_brake[isBraked][direction] | session->TrackColours[SCHEME_TRACK];
        }
        else
        {
            imageId = junior_rc_track_pieces_station[false][direction] | session->TrackColours[SCHEME_TRACK];
        }
        sub_98199C(session, imageId, 6, 0, 20, 32, 1, height, 0, 0, height);

        metal_a_supports_paint_setup(session, METAL_SUPPORTS_BOXED, 6, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        metal_a_supports_paint_setup(session, METAL_SUPPORTS_BOXED, 7, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        paint_util_push_tunnel_right(session, height, TUNNEL_6);
    }

    track_paint_util_draw_station(session, rideIndex, trackSequence, direction, height, tileElement);

    paint_util_set_segment_support_height(session, SEGMENTS_ALL, 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

void junior_rc_paint_track_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 imageId = junior_rc_track_pieces_25_deg_up[chainType][direction] | session->TrackColours[SCHEME_TRACK];
    sub_98196C_rotated(session, direction, imageId, 0, 6, 32, 20, 1, height);

    sint8 tunnel_height[4] = { -8, 8, 8, -8 };
    uint8 tunnel_type[4]   = { TUNNEL_1, TUNNEL_2, TUNNEL_2, TUNNEL_1 };
    paint_util_push_tunnel_rotated(session, direction, height + tunnel_height[direction], tunnel_type[direction]);

    if (track_paint_util_should_paint_supports(session->MapPosition))
    {
        sint32 supportType = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, supportType, 4, 8, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_flat_to_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 imageId = junior_rc_track_pieces_flat_to_25_deg_up[chainType][direction] | session->TrackColours[SCHEME_TRACK];

    sub_98196C_rotated(session, direction, imageId, 0, 6, 32, 20, 1, height);
    if (direction == 0 || direction == 3)
    {
        paint_util_push_tunnel_rotated(session, direction, height, TUNNEL_0);
    }
    else
    {
        paint_util_push_tunnel_rotated(session, direction, height, TUNNEL_2);
    }

    if (track_paint_util_should_paint_supports(session->MapPosition))
    {
        sint32 supportType = (direction & 1) ? 2 : 1;
        uint16 ax          = (direction == 0) ? 5 : 3;
        metal_a_supports_paint_setup(session, supportType, 4, ax, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

void junior_rc_paint_track_25_deg_up_to_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 imageId = junior_rc_track_pieces_25_deg_up_to_flat[chainType][direction] | session->TrackColours[SCHEME_TRACK];
    sub_98196C_rotated(session, direction, imageId, 0, 6, 32, 20, 1, height);

    uint8  tunnelType;
    sint16 tunnelHeight;
    if (direction == 1 || direction == 2)
    {
        tunnelType   = TUNNEL_12;
        tunnelHeight = height + 8;
    }
    else
    {
        tunnelType   = TUNNEL_0;
        tunnelHeight = height - 8;
    }

    if (direction & 1)
    {
        paint_util_push_tunnel_right(session, tunnelHeight, tunnelType);
    }
    else
    {
        paint_util_push_tunnel_left(session, tunnelHeight, tunnelType);
    }

    if (track_paint_util_should_paint_supports(session->MapPosition))
    {
        sint32 supportType = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, supportType, 4, 6, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 40, 0x20);
}

static constexpr const sint8 junior_rc_track_right_quarter_turn_5_tiles_support_height_offset[][7] = {
    { 0, 0, 0, 0, 0, 0, -1 },
    { -1, 0, 0, 0, 0, 0, 0 },
    { 0 },
    { 0, 0, 0, 0, 0, 0, 0 },
};

static void junior_rc_right_quarter_turn_5_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_right_quarter_turn_5_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_flat_quarter_turn_5_tiles, defaultRightQuarterTurn5TilesOffsets,
        defaultRightQuarterTurn5TilesBoundLengths, defaultRightQuarterTurn5TilesBoundOffsets, session->CurrentRotation);

    sint32 supportHeight = height + junior_rc_track_right_quarter_turn_5_tiles_support_height_offset[direction][trackSequence];
    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0,
                                     supportHeight, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 6:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 0,
                                     supportHeight, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC, direction), 0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_BC | SEGMENT_C0 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_B4 | SEGMENT_C8 | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8, direction), 0xFFFF, 0);
        break;
    }

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

static constexpr const uint8 junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[] = { 6, 4, 5, 3, 1, 2, 0 };

/* rct2: 0x0051917A */
static void junior_rc_left_quarter_turn_5_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_quarter_turn_5_tiles_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                     tileElement);
}

/**
 * rct2: 0x008AAFC0, 0x00521593, 0x005216A1, 0x005217AF, 0x00521884
 */
static void junior_rc_flat_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_flat_to_left_bank[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);

        paint_util_push_tunnel_right(session, height, 0);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);

        paint_util_push_tunnel_left(session, height, 0);
    }

    if (junior_rc_track_pieces_flat_to_left_bank[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_flat_to_left_bank[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 26, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 26, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/**
 * rct2: 0x008AAFD0, 0x00521959, 0x00521A2E, 0x00521B03, 0x00521C11
 */
static void junior_rc_flat_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_flat_to_right_bank[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);

        paint_util_push_tunnel_right(session, height, 0);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);

        paint_util_push_tunnel_left(session, height, 0);
    }

    if (junior_rc_track_pieces_flat_to_right_bank[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_flat_to_right_bank[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 26, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 26, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

static void junior_rc_left_bank_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_flat_to_right_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

static void junior_rc_right_bank_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_flat_to_left_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

static constexpr const LocationXY16 junior_rc_banked_right_quarter_turn_5_tiles_bound_lengths[4][5] = { {
                                                                                       { 32, 20 },
                                                                                       { 32, 16 },
                                                                                       { 16, 16 },
                                                                                       { 16, 32 },
                                                                                       { 20, 32 },
                                                                                   },
                                                                                   {
                                                                                       { 20, 32 },
                                                                                       { 16, 32 },
                                                                                       { 16, 16 },
                                                                                       { 32, 16 },
                                                                                       { 32, 20 },
                                                                                   },
                                                                                   {
                                                                                       { 32, 1 },
                                                                                       { 32, 16 },
                                                                                       { 16, 16 },
                                                                                       { 16, 32 },
                                                                                       { 1, 32 },
                                                                                   },
                                                                                   {
                                                                                       { 20, 32 },
                                                                                       { 16, 32 },
                                                                                       { 16, 16 },
                                                                                       { 32, 16 },
                                                                                       { 32, 20 },
                                                                                   } };

static constexpr const LocationXYZ16 junior_rc_banked_right_quarter_turn_5_tiles_bound_offsets[4][5] = { {
                                                                                        { 0, 6 },
                                                                                        { 0, 16 },
                                                                                        { 0, 0 },
                                                                                        { 16, 0 },
                                                                                        { 6, 0 },
                                                                                    },
                                                                                    {
                                                                                        { 6, 0 },
                                                                                        { 16, 0 },
                                                                                        { 0, 16 },
                                                                                        { 0, 0 },
                                                                                        { 0, 6 },
                                                                                    },
                                                                                    {
                                                                                        { 0, 27 },
                                                                                        { 0, 0, 27 },
                                                                                        { 16, 16, 27 },
                                                                                        { 0, 0, 27 },
                                                                                        { 27, 0 },
                                                                                    },
                                                                                    {
                                                                                        { 6, 0 },
                                                                                        { 0, 0 },
                                                                                        { 16, 0 },
                                                                                        { 0, 16 },
                                                                                        { 0, 6 },
                                                                                    } };

/* rct2: 0x008AB010, 0x0052304C */
static void junior_rc_banked_right_quarter_turn_5_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint8 thickness = 1;
    if (direction == 2 && (trackSequence == 0 || trackSequence == 6))
    {
        thickness = 26;
    }
    track_paint_util_right_quarter_turn_5_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_banked_quarter_turn_5_tiles, nullptr, junior_rc_banked_right_quarter_turn_5_tiles_bound_lengths,
        junior_rc_banked_right_quarter_turn_5_tiles_bound_offsets, session->CurrentRotation);

    if (direction == 1 && trackSequence == 6)
    {
        uint32 imageId = SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_NW_SW_PART_4_2 | session->TrackColours[SCHEME_TRACK];
        sub_98197C(session, imageId, 0, 0, 32, 1, 26, height, 0, 27, height);
    }
    else if (direction == 3 && trackSequence == 0)
    {
        uint32 imageId = SPR_JUNIOR_RC_BANKED_QUARTER_TURN_5_TILES_SE_NE_PART_0_2 | session->TrackColours[SCHEME_TRACK];
        sub_98197C(session, imageId, 0, 0, 1, 32, 26, height, 27, 0, height);
    }

    sint32 supportHeight = height;
    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0,
                                     supportHeight, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 6:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 0,
                                     supportHeight, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC, direction), 0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_BC | SEGMENT_C0 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_B4 | SEGMENT_C8 | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8, direction), 0xFFFF, 0);
        break;
    }

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/* rct2: 0x008AB000 */
static void junior_rc_banked_left_quarter_turn_5_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence];
    junior_rc_banked_right_quarter_turn_5_tiles_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                            tileElement);
}

/**
 * rct2: 0x008AB020, 0x00522073, 0x00522182, 0x00522291, 0x00522367
 */
static void junior_rc_left_bank_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_left_banked_to_25_deg_up[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);
    }

    if (junior_rc_track_pieces_left_banked_to_25_deg_up[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_left_banked_to_25_deg_up[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 34, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 34, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 3, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

/**
 * rct2: 0x008AB030, 0x0052243D, 0x00522513, 0x005225E9, 0x005226F8
 */
static void junior_rc_right_bank_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_right_banked_to_25_deg_up[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);
    }

    if (junior_rc_track_pieces_right_banked_to_25_deg_up[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_right_banked_to_25_deg_up[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 34, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 34, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 3, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

/**
 * rct2: 0x008AB040, 0x00522807, 0x0052291A, 0x00522A2D, 0x00522B07
 */
static void junior_rc_25_deg_up_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    uint8  tunnelType;
    sint16 tunnelHeight;
    if (direction == 1 || direction == 2)
    {
        tunnelType   = TUNNEL_12;
        tunnelHeight = height + 8;
    }
    else
    {
        tunnelType   = TUNNEL_0;
        tunnelHeight = height - 8;
    }

    image_id = junior_rc_track_pieces_25_deg_up_to_left_bank[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);

        paint_util_push_tunnel_right(session, tunnelHeight, tunnelType);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);

        paint_util_push_tunnel_left(session, tunnelHeight, tunnelType);
    }

    if (junior_rc_track_pieces_25_deg_up_to_left_bank[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_25_deg_up_to_left_bank[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 34, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 34, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 6, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 40, 0x20);
}

/**
 * rct2: 0x008AB050, 0x00522BE1, 0x00522CBB, 0x00522D95, 0x00522EA8
 */
static void junior_rc_25_deg_up_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    uint8  tunnelType;
    sint16 tunnelHeight;
    if (direction == 1 || direction == 2)
    {
        tunnelType   = TUNNEL_12;
        tunnelHeight = height + 8;
    }
    else
    {
        tunnelType   = TUNNEL_0;
        tunnelHeight = height - 8;
    }

    image_id = junior_rc_track_pieces_25_deg_up_to_right_bank[direction][0] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98197C(session, image_id, 0, 0, 20, 32, 1, height, 6, 0, height);

        paint_util_push_tunnel_right(session, tunnelHeight, tunnelType);
    }
    else
    {
        sub_98197C(session, image_id, 0, 0, 32, 20, 1, height, 0, 6, height);

        paint_util_push_tunnel_left(session, tunnelHeight, tunnelType);
    }

    if (junior_rc_track_pieces_25_deg_up_to_right_bank[direction][1] != 0)
    {
        image_id = junior_rc_track_pieces_25_deg_up_to_right_bank[direction][1] | session->TrackColours[SCHEME_TRACK];

        if (direction & 1)
        {
            sub_98197C(session, image_id, 0, 0, 1, 32, 34, height, 27, 0, height);
        }
        else
        {
            sub_98197C(session, image_id, 0, 0, 32, 1, 34, height, 0, 27, height);
        }
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 6, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 40, 0x20);
}

/**
 * rct2: 0x008AB060
 */
static void junior_rc_left_bank_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_25_deg_up_to_right_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

/**
 * rct2: 0x008AB070
 */
static void junior_rc_right_bank_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_25_deg_up_to_left_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

/**
 * rct2: 0x008AB080
 */
static void junior_rc_25_deg_down_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_right_bank_to_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

/**
 * rct2: 0x008AB090
 */
static void junior_rc_25_deg_down_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_left_bank_to_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

static constexpr const LocationXYZ16 junior_rc_left_bank_bound_lengths[4] = {
    { 32, 1, 26 },
    { 1, 32, 26 },
    { 32, 20, 1 },
    { 20, 32, 1 },
};

static constexpr const LocationXY16 junior_rc_left_bank_bound_offsets[4] = {
    { 0, 27 },
    { 27, 0 },
    { 0, 6 },
    { 6, 0 },
};

/**
 * rct2: 0x008AB0A0, 0x00521D1F, 0x00521DF4, 0x00521EC9, 0x00521F9E
 */
static void junior_rc_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_left_bank[direction] | session->TrackColours[SCHEME_TRACK];
    sub_98197C(
        session, image_id, 0, 0, junior_rc_left_bank_bound_lengths[direction].x, junior_rc_left_bank_bound_lengths[direction].y,
        (sint8)junior_rc_left_bank_bound_lengths[direction].z, height, junior_rc_left_bank_bound_offsets[direction].x,
        junior_rc_left_bank_bound_offsets[direction].y, height);

    if (direction & 1)
    {
        paint_util_push_tunnel_right(session, height, 0);
    }
    else
    {
        paint_util_push_tunnel_left(session, height, 0);
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/**
 * rct2: 0x008AB0B0
 */
static void junior_rc_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_left_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

void junior_rc_paint_track_left_quarter_turn_5_tiles_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_right_quarter_turn_5_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_left_quarter_turn_5_tiles_25_deg_up[chainType],
        junior_rc_left_quarter_turn_5_tiles_25_deg_up_offsets, defaultRightQuarterTurn5TilesBoundLengths, nullptr,
        session->CurrentRotation);

    uint8 supportSpecial[4] = { 8, 8, 8, 3 };
    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4,
                                     (direction == 0 || direction == 3) ? 10 : 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 6:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4,
                                     supportSpecial[direction], height, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
    }
    if (direction == 2 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_2);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
    }
    if (direction == 3 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_2);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B4, direction), 0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_B4 | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_BC | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_C0, direction), 0xFFFF, 0);
        break;
    }
    if (trackSequence == 3)
    {
        paint_util_set_general_support_height(session, height + 64, 0x20);
    }
    else
    {
        paint_util_set_general_support_height(session, height + 72, 0x20);
    }
}

void junior_rc_paint_track_right_quarter_turn_5_tiles_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_right_quarter_turn_5_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_quarter_turn_5_tiles_25_deg_up[chainType], defaultRightQuarterTurn5TilesOffsets,
        defaultRightQuarterTurn5TilesBoundLengths, nullptr, session->CurrentRotation);

    uint8 supportSpecial[4] = { 11, 8, 8, 7 };
    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4,
                                     supportSpecial[direction], height, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 6:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
    }
    if (direction == 0 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_2);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
    }
    if (direction == 1 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_2);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC, direction), 0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_BC | SEGMENT_C0 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_B4 | SEGMENT_C8 | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8, direction), 0xFFFF, 0);
        break;
    }
    if (trackSequence == 3)
    {
        paint_util_set_general_support_height(session, height + 64, 0x20);
    }
    else
    {
        paint_util_set_general_support_height(session, height + 72, 0x20);
    }
}

/* rct2: 0x008AAE10, 0x00519D88, 0x00519DAC, 0x00519DD0, 0x00519DF4 */
static void junior_rc_left_quarter_turn_5_tiles_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_left_quarter_turn_5_tiles_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                              isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS
                                                                        : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x008AAE20, 0x00519E18, 0x0051A148, 0x0051A452, 0x0051A738 */
static void junior_rc_right_quarter_turn_5_tiles_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_right_quarter_turn_5_tiles_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                               isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS
                                                                         : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x008AAE30, 0x0051AA42, 0x0051AA68, 0x0051AA8C, 0x0051AAB0 */
static void junior_rc_left_quarter_turn_5_tiles_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_right_quarter_turn_5_tiles_25_deg_up_paint_setup(
        session, rideIndex, junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence], (direction + 1) & 3, height,
        tileElement);
}

/* rct2: 0x008AAE40, 0x0051AAD4, 0x0051AE04, 0x0051B10E, 0x0051B3F4 */
static void junior_rc_right_quarter_turn_5_tiles_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_left_quarter_turn_5_tiles_25_deg_up_paint_setup(
        session, rideIndex, junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence], (direction - 1) & 3, height,
        tileElement);
}

/* rct2: 0x008AAE50, 0x0051B6FE, 0x0051B946, 0x0051BB8E, 0x0051BBA8 */
static void junior_rc_s_bend_left_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (direction == 2 || direction == 3)
    {
        trackSequence = 3 - trackSequence;
    }

    const LocationXY16 offsetList[] = {
        { 0, 6 },
        { 0, 0 },
        { 0, 6 },
        { 0, 6 },
    };

    const LocationXY16 boundsList[] = {
        { 32, 20 },
        { 32, 26 },
        { 32, 26 },
        { 32, 20 },
    };

    uint32   imageId = junior_rc_track_pieces_s_bend_left[(direction & 1)][trackSequence] | session->TrackColours[SCHEME_TRACK];
    LocationXY16 offset  = offsetList[trackSequence];
    LocationXY16 bounds  = boundsList[trackSequence];
    if (direction == 0 || direction == 2)
    {
        sub_98196C(session, imageId, (sint8)offset.x, (sint8)offset.y, bounds.x, bounds.y, 1, height);
    }
    else
    {
        sub_98196C(session, imageId, (sint8)offset.y, (sint8)offset.x, bounds.y, bounds.x, 1, height);
    }

    if (direction == 0 || direction == 2)
    {
        if (trackSequence == 0)
        {
            paint_util_push_tunnel_left(session, height, TUNNEL_0);
        }

        switch (trackSequence)
        {
        case 0:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 1:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 5, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 3:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        }
    }
    else
    {
        if (trackSequence == 3)
        {
            paint_util_push_tunnel_right(session, height, TUNNEL_0);
        }

        switch (trackSequence)
        {
        case 0:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 4, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 1:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 6, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 3:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 4, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        }
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B4;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, (direction & 1)), 0xFFFF, 0);

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/* rct2: 0x008AAE60, 0x0051BBC0, 0x0051BE06, 0x0051C04E, 0x0051C068 */
static void junior_rc_s_bend_right_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (direction == 2 || direction == 3)
    {
        trackSequence = 3 - trackSequence;
    }

    const LocationXY16 offsetList[] = {
        { 0, 6 },
        { 0, 6 },
        { 0, 0 },
        { 0, 6 },
    };

    const LocationXY16 boundsList[] = {
        { 32, 20 },
        { 32, 26 },
        { 32, 26 },
        { 32, 20 },
    };

    uint32   imageId = junior_rc_track_pieces_s_bend_right[direction & 1][trackSequence] | session->TrackColours[SCHEME_TRACK];
    LocationXY16 offset  = offsetList[trackSequence];
    LocationXY16 bounds  = boundsList[trackSequence];
    if (direction == 0 || direction == 2)
    {
        sub_98196C(session, imageId, (sint8)offset.x, (sint8)offset.y, bounds.x, bounds.y, 1, height);
    }
    else
    {
        sub_98196C(session, imageId, (sint8)offset.y, (sint8)offset.x, bounds.y, bounds.x, 1, height);
    }

    if (direction == 0 || direction == 2)
    {
        if (trackSequence == 0)
        {
            paint_util_push_tunnel_left(session, height, TUNNEL_0);
        }

        switch (trackSequence)
        {
        case 0:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 1:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 8, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 3:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
            break;
        }
    }
    else
    {
        if (trackSequence == 3)
        {
            paint_util_push_tunnel_right(session, height, TUNNEL_0);
        }

        switch (trackSequence)
        {
        case 0:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 4, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 1:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 7, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        case 3:
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 4, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
            break;
        }
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, (direction & 1)), 0xFFFF, 0);

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AAEB0, 0x0051C0E0, 0x0051C2C1, 0x0051C47F, 0x0051C61D */
static void junior_rc_right_quarter_turn_3_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_right_quarter_turn_3_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_flat_quarter_turn_3_tiles, defaultRightQuarterTurn3TilesOffsets,
        defaultRightQuarterTurn3TilesBoundLengths, nullptr, session->CurrentRotation);
    track_paint_util_right_quarter_turn_3_tiles_tunnel(session, height, direction, trackSequence, TUNNEL_0);

    uint8 supportType[2][4] = { { 1, 0, 0, 2 }, { 2, 0, 0, 1 } };
    switch (trackSequence)
    {
    case 0:
    case 3:
        metal_a_supports_paint_setup(session, supportType[(direction & 1)][trackSequence], 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_C0;
        break;
    case 3:
        blockedSegments = SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AAEA0 */
static void junior_rc_left_quarter_turn_3_tiles_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    junior_rc_right_quarter_turn_3_tiles_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                     tileElement);
}

static constexpr const LocationXY16 junior_rc_right_quarter_turn_3_tiles_bank_bound_lengths[4][3] = { {
                                                                                     { 32, 20 },
                                                                                     { 16, 16 },
                                                                                     { 20, 32 },
                                                                                 },
                                                                                 {
                                                                                     { 20, 32 },
                                                                                     { 16, 16 },
                                                                                     { 32, 20 },
                                                                                 },
                                                                                 {
                                                                                     { 32, 1 },
                                                                                     { 16, 16 },
                                                                                     { 1, 32 },
                                                                                 },
                                                                                 {
                                                                                     { 20, 32 },
                                                                                     { 16, 16 },
                                                                                     { 32, 20 },
                                                                                 } };

static constexpr const LocationXYZ16 junior_rc_right_quarter_turn_3_tiles_bank_offsets[4][3] = { {
                                                                                { 0, 6 },
                                                                                { 16, 16 },
                                                                                { 6, 0 },
                                                                            },
                                                                            {
                                                                                { 6, 0 },
                                                                                { 16, 0 },
                                                                                { 0, 6 },
                                                                            },
                                                                            {
                                                                                { 0, 27 },
                                                                                { 0, 0, 27 },
                                                                                { 27, 0 },
                                                                            },
                                                                            {
                                                                                { 6, 0 },
                                                                                { 0, 16 },
                                                                                { 0, 6 },
                                                                            } };

/** rct2: 0x008AA0D0, 0x00523EA0, 0x005240CC, 0x0052430F, 0x00524500*/
static void junior_rc_right_quarter_turn_3_tiles_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint8 thickness[4][4] = { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 26, 1, 1, 26 }, { 1, 1, 1, 1 } };

    track_paint_util_right_quarter_turn_3_tiles_paint(
        session, thickness[direction][trackSequence], height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_banked_quarter_turn_3_tiles, nullptr, junior_rc_right_quarter_turn_3_tiles_bank_bound_lengths,
        junior_rc_right_quarter_turn_3_tiles_bank_offsets, session->CurrentRotation);
    track_paint_util_right_quarter_turn_3_tiles_tunnel(session, height, direction, trackSequence, TUNNEL_0);

    if (direction == 1 && trackSequence == 3)
    {
        uint32 imageId = SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_NW_SW_PART_2_2 | session->TrackColours[SCHEME_TRACK];
        sub_98197C(session, imageId, 0, 0, 32, 1, 26, height, 0, 27, height);
    }
    else if (direction == 3 && trackSequence == 0)
    {
        uint32 imageId = SPR_JUNIOR_RC_BANKED_QUARTER_TURN_3_TILES_SE_NE_PART_0_2 | session->TrackColours[SCHEME_TRACK];
        sub_98197C(session, imageId, 0, 0, 1, 32, 26, height, 27, 0, height);
    }

    uint8 supportType[2][4] = { { 1, 0, 0, 2 }, { 2, 0, 0, 1 } };
    switch (trackSequence)
    {
    case 0:
    case 3:
        metal_a_supports_paint_setup(session, supportType[(direction & 1)][trackSequence], 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_C0;
        break;
    case 3:
        blockedSegments = SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

void junior_rc_paint_track_right_quarter_turn_3_tiles_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32   imageId      = 0;
    LocationXY16 offset       = { 0 };
    LocationXY16 boundsLength = { 0 };
    LocationXY16 boundsOffset = { 0 };

    switch (trackSequence)
    {
    case 0:
        imageId = junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_up[chainType][direction][0] |
                  session->TrackColours[SCHEME_TRACK];
        offset       = defaultRightQuarterTurn3TilesOffsets[direction][0];
        boundsLength = defaultRightQuarterTurn3TilesBoundLengths[direction][0];
        boundsOffset = offset;
        break;
    case 3:
        imageId = junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_up[chainType][direction][1] |
                  session->TrackColours[SCHEME_TRACK];
        offset       = defaultRightQuarterTurn3TilesOffsets[direction][2];
        boundsLength = defaultRightQuarterTurn3TilesBoundLengths[direction][2];
        boundsOffset = offset;
        break;
    }
    if (imageId != 0)
        sub_98197C(
            session, imageId, (sint8)offset.x, (sint8)offset.y, boundsLength.x, boundsLength.y, 1, height, boundsOffset.x,
            boundsOffset.y, height);

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
    }

    if (direction == 0 && trackSequence == 3)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_2);
    }

    if (direction == 1 && trackSequence == 3)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_2);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
    }

    uint8 supportType[2][4] = { { 1, 0, 0, 2 }, { 2, 0, 0, 1 } };
    switch (trackSequence)
    {
    case 0:
    case 3:
        metal_a_supports_paint_setup(session, supportType[(direction & 1)][trackSequence], 4, 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC;
        break;
    case 3:
        blockedSegments = SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);

    if (trackSequence == 0 || trackSequence == 3)
        paint_util_set_general_support_height(session, height + 72, 0x20);
    else
        paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_right_quarter_turn_3_tiles_25_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32   imageId      = 0;
    LocationXY16 offset       = { 0 };
    LocationXY16 boundsLength = { 0 };
    LocationXY16 boundsOffset = { 0 };

    switch (trackSequence)
    {
    case 0:
        imageId = junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_down[chainType][direction][0] |
                  session->TrackColours[SCHEME_TRACK];
        offset       = defaultRightQuarterTurn3TilesOffsets[direction][0];
        boundsLength = defaultRightQuarterTurn3TilesBoundLengths[direction][0];
        boundsOffset = offset;
        break;
    case 3:
        imageId = junior_rc_track_pieces_right_quarter_turn_3_tiles_25_deg_down[chainType][direction][1] |
                  session->TrackColours[SCHEME_TRACK];
        offset       = defaultRightQuarterTurn3TilesOffsets[direction][2];
        boundsLength = defaultRightQuarterTurn3TilesBoundLengths[direction][2];
        boundsOffset = offset;
        break;
    }
    if (imageId != 0)
        sub_98197C(
            session, imageId, (sint8)offset.x, (sint8)offset.y, boundsLength.x, boundsLength.y, 1, height, boundsOffset.x,
            boundsOffset.y, height);

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_2);
    }

    if (direction == 0 && trackSequence == 3)
    {
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
    }

    if (direction == 1 && trackSequence == 3)
    {
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_2);
    }

    uint8 supportType[2][4] = { { 1, 0, 0, 2 }, { 2, 0, 0, 1 } };
    switch (trackSequence)
    {
    case 0:
    case 3:
        metal_a_supports_paint_setup(session, supportType[(direction & 1)][trackSequence], 4, 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC;
        break;
    case 3:
        blockedSegments = SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);

    if (trackSequence == 0 || trackSequence == 3)
        paint_util_set_general_support_height(session, height + 72, 0x20);
    else
        paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AA0C0 */
static void junior_rc_left_quarter_turn_3_tiles_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    junior_rc_right_quarter_turn_3_tiles_bank_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                          tileElement);
}

/** rct2: 0x008AAED0, 0x0051C83C, 0x0051C9EC, 0x0051CB76, 0x0051CCDC*/
static void junior_rc_right_quarter_turn_3_tiles_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_right_quarter_turn_3_tiles_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                               isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS
                                                                         : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAEF0, 0x0051CEC8, 0x0051D078, 0x0051D202, 0x0051D368*/
static void junior_rc_right_quarter_turn_3_tiles_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_right_quarter_turn_3_tiles_25_deg_down(
        session, rideIndex, trackSequence, direction, height, tileElement,
        isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static constexpr const uint8 junior_rc_left_quarter_turn_3_tiles_to_right_turn_map[] = { 3, 1, 2, 0 };

/** rct2: 0x008AAEC0 */
static void junior_rc_left_quarter_turn_3_tiles_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = junior_rc_left_quarter_turn_3_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_quarter_turn_3_tiles_25_deg_down_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                                 tileElement);
}

/** rct2: 0x008AAEE0 */
static void junior_rc_left_quarter_turn_3_tiles_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    trackSequence = junior_rc_left_quarter_turn_3_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_quarter_turn_3_tiles_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                               tileElement);
}

/** rct2: 0x008AB0F0, 0x0052B3A4, 0x0052B5F8, 0x0052B863, 0x0052BA78 */
static void junior_rc_right_half_banked_helix_up_small_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const sint8 thickness[2] = { 1, 26 };

    if (trackSequence > 3)
    {
        trackSequence -= 4;
        direction++;
        direction &= 3;
    }
    track_paint_util_right_helix_up_small_quarter_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_half_banked_helix_up_small_quarter_tiles, nullptr,
        defaultRightHelixUpSmallQuarterBoundLengths, defaultRightHelixUpSmallQuarterBoundOffsets, session->CurrentRotation);

    if (trackSequence == 0)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 2, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }
    else if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 6, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 3)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 3)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC | SEGMENT_D4;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_C0 | SEGMENT_D4;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB110, 0x0052BD80, 0x0052BFD4, 0x0052C23B, 0x0052C450 */
static void junior_rc_right_half_banked_helix_down_small_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const sint8 thickness[2] = { 1, 26 };

    if (trackSequence > 3)
    {
        trackSequence -= 4;
        direction++;
        direction &= 3;
    }
    track_paint_util_right_helix_up_small_quarter_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_half_banked_helix_down_small_quarter_tiles, nullptr,
        defaultRightHelixUpSmallQuarterBoundLengths, defaultRightHelixUpSmallQuarterBoundOffsets, session->CurrentRotation);

    if (trackSequence == 0)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 6, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }
    else if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 2, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 3)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 3)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC | SEGMENT_D4;
        break;
    case 2:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_C0 | SEGMENT_D4;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8;
        break;
    }
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB0E0 */
static void junior_rc_left_half_banked_helix_up_small_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (trackSequence > 3)
    {
        trackSequence -= 4;
        direction--;
        direction &= 3;
    }
    trackSequence = junior_rc_left_quarter_turn_3_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_half_banked_helix_down_small_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                             tileElement);
}

/** rct2: 0x008AB100 */
static void junior_rc_left_half_banked_helix_down_small_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (trackSequence > 3)
    {
        trackSequence -= 4;
        direction--;
        direction &= 3;
    }
    trackSequence = junior_rc_left_quarter_turn_3_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_half_banked_helix_up_small_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                           tileElement);
}

/** rct2: 0x008AB130, 0x0052C7BC, 0x0052CB6B, 0x0052CF32, 0x0052D2B3 */
static void junior_rc_right_half_banked_helix_up_large_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const sint8 thickness[2] = { 1, 26 };

    if (trackSequence > 6)
    {
        trackSequence -= 7;
        direction++;
        direction &= 3;
    }
    track_paint_util_right_helix_up_large_quarter_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_half_banked_helix_up_large_quarter_tiles, nullptr,
        defaultRightHelixUpLargeQuarterBoundLengths, defaultRightHelixUpLargeQuarterBoundOffsets, session->CurrentRotation);

    if (trackSequence == 0)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 1, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }
    else if (trackSequence == 6)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 7, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC, direction),
            0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_BC | SEGMENT_C0 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_B4 | SEGMENT_C8 | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8, direction),
            0xFFFF, 0);
        break;
    }

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB150, 0x0052D778, 0x0052DB27, 0x0052DEEA, 0x0052E26B */
static void junior_rc_right_half_banked_helix_down_large_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const sint8 thickness[2] = { 1, 26 };

    if (trackSequence > 6)
    {
        trackSequence -= 7;
        direction++;
        direction &= 3;
    }
    track_paint_util_right_helix_up_large_quarter_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_half_banked_helix_down_large_quarter_tiles, nullptr,
        defaultRightHelixUpLargeQuarterBoundLengths, defaultRightHelixUpLargeQuarterBoundOffsets, session->CurrentRotation);

    if (trackSequence == 0)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 7, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }
    else if (trackSequence == 6)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK : METAL_SUPPORTS_FORK_ALT, 4, 1, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height + 8, TUNNEL_0);
    }

    if (direction == 0 && trackSequence == 6)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    if (direction == 1 && trackSequence == 6)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height + 8, TUNNEL_0);
    }

    switch (trackSequence)
    {
    case 0:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_BC, direction),
            0xFFFF, 0);
        break;
    case 2:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_C4 | SEGMENT_D4 | SEGMENT_BC | SEGMENT_C0 | SEGMENT_CC, direction),
            0xFFFF, 0);
        break;
    case 3:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_B4 | SEGMENT_C8 | SEGMENT_CC | SEGMENT_C4, direction), 0xFFFF, 0);
        break;
    case 5:
        paint_util_set_segment_support_height(
            session,
            paint_util_rotate_segments(SEGMENT_D4 | SEGMENT_C4 | SEGMENT_D0 | SEGMENT_B8 | SEGMENT_C0 | SEGMENT_C8, direction),
            0xFFFF, 0);
        break;
    case 6:
        paint_util_set_segment_support_height(
            session, paint_util_rotate_segments(SEGMENT_D0 | SEGMENT_D4 | SEGMENT_C4 | SEGMENT_C8 | SEGMENT_B8, direction),
            0xFFFF, 0);
        break;
    }

    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB120 */
static void junior_rc_left_half_banked_helix_up_large_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (trackSequence > 6)
    {
        trackSequence -= 7;
        direction--;
        direction &= 3;
    }
    trackSequence = junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_half_banked_helix_down_large_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                             tileElement);
}

/** rct2: 0x008AB140 */
static void junior_rc_left_half_banked_helix_down_large_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    if (trackSequence > 6)
    {
        trackSequence -= 7;
        direction--;
        direction &= 3;
    }
    trackSequence = junior_rc_left_quarter_turn_5_tiles_to_right_turn_map[trackSequence];
    junior_rc_right_half_banked_helix_up_large_paint_setup(session, rideIndex, trackSequence, (direction + 1) % 4, height,
                                                           tileElement);
}

/**
 * rct2: 0x008AAF00, 0x0051851C, 0x005185D8
 */
static void junior_rc_brake_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    image_id = junior_rc_track_pieces_brake[direction] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98196C(session, image_id, 6, 0, 20, 32, 1, height);

        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }
    else
    {
        sub_98196C(session, image_id, 0, 6, 32, 20, 1, height);

        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/**
 * rct2: 0x008AB280, 0x00518694, 0x00518759
 */
static void junior_rc_block_brake_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id;

    bool isBraked = (bool)(tileElement->flags & TILE_ELEMENT_FLAG_BLOCK_BRAKE_CLOSED);

    image_id = junior_rc_track_pieces_block_brake[isBraked][direction] | session->TrackColours[SCHEME_TRACK];
    if (direction & 1)
    {
        sub_98196C(session, image_id, 6, 0, 20, 32, 1, height);

        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }
    else
    {
        sub_98196C(session, image_id, 0, 6, 32, 20, 1, height);

        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        sint32 edi = (direction & 1) ? 2 : 1;
        metal_a_supports_paint_setup(session, edi, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AAF80 */
static void junior_rc_left_eighth_to_diag_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_eighth_to_diag_tiles_paint(
        session, defaultEighthToDiagThickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_left_eight_to_diag, nullptr, defaultLeftEighthToDiagBoundLengths,
        defaultLeftEighthToDiagBoundOffsets, session->CurrentRotation);

    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 4:
        if (direction == 0)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 3, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 1)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 1, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 2)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 0, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 3)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 2, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 2:
        blockedSegments = SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_B8 | SEGMENT_C8;
        break;
    case 4:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C8 | SEGMENT_C0 | SEGMENT_D4;
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AAF90 */
static void junior_rc_right_eighth_to_diag_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_eighth_to_diag_tiles_paint(
        session, defaultEighthToDiagThickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_right_eight_to_diag, nullptr, defaultRightEighthToDiagBoundLengths,
        defaultRightEighthToDiagBoundOffsets, session->CurrentRotation);

    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 4:
        if (direction == 0)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 1, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 1)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 0, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 2)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 2, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 3)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 3, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 2:
        blockedSegments = SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_C0 | SEGMENT_D4;
        break;
    case 4:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_D4;
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AAFA0 */
static void junior_rc_left_eighth_to_orthogonal_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const uint8 map[] = { 4, 2, 3, 1, 0 };
    trackSequence     = map[trackSequence];
    junior_rc_right_eighth_to_diag_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

/** rct2: 0x008AAFB0 */
static void junior_rc_right_eighth_to_orthogonal_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const uint8 map[] = { 4, 2, 3, 1, 0 };
    trackSequence     = map[trackSequence];
    junior_rc_left_eighth_to_diag_paint_setup(session, rideIndex, trackSequence, (direction + 3) % 4, height, tileElement);
}

static constexpr const LocationXY16 junior_rc_left_eighth_to_diag_bank_bound_lengths[4][4] = {
    {
        { 32, 1 },
        { 32, 16 },
        { 16, 16 },
        { 16, 16 },
    },
    {
        { 1, 32 },
        { 16, 34 },
        { 16, 16 },
        { 18, 16 },
    },
    {
        { 32, 20 },
        { 32, 16 },
        { 16, 16 },
        { 16, 16 },
    },
    {
        { 20, 32 },
        { 16, 32 },
        { 16, 16 },
        { 16, 16 },
    },
};

static constexpr const LocationXYZ16 junior_rc_left_eighth_to_diag_bank_bound_offsets[4][4] = {
    {
        { 0, 27 },
        { 0, 0 },
        { 0, 16 },
        { 16, 16 },
    },
    {
        { 27, 0 },
        { 0, 0, 27 },
        { 16, 16, 27 },
        { 16, 0, 27 },
    },
    {
        { 0, 6 },
        { 0, 16 },
        { 16, 0 },
        { 0, 0 },
    },
    {
        { 6, 0 },
        { 16, 0 },
        { 0, 0 },
        { 0, 16 },
    },
};

static constexpr const sint8 junior_rc_left_eighth_to_diag_bank_thickness[4][4] = {
    {
        26,
        1,
        1,
        1,
    },
    {
        26,
        0,
        0,
        0,
    },
    {
        1,
        1,
        1,
        1,
    },
    {
        1,
        1,
        1,
        1,
    },
};

/** rct2: 0x008AB160 */
static void junior_rc_left_eighth_to_diag_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_eighth_to_diag_tiles_paint(
        session, junior_rc_left_eighth_to_diag_bank_thickness, height, direction, trackSequence,
        session->TrackColours[SCHEME_TRACK], junior_rc_track_pieces_left_eight_to_diag_bank, nullptr,
        junior_rc_left_eighth_to_diag_bank_bound_lengths, junior_rc_left_eighth_to_diag_bank_bound_offsets,
        session->CurrentRotation);

    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 4:
        if (direction == 0)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 3, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 1)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 1, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 2)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 0, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 3)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 2, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 2:
        blockedSegments = SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_B8 | SEGMENT_C8;
        break;
    case 4:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C8 | SEGMENT_C0 | SEGMENT_D4;
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

static constexpr const LocationXY16 junior_rc_right_eighth_to_diag_bank_bound_lengths[4][4] = {
    {
        { 32, 20 },
        { 16, 16 },
        { 16, 16 },
        { 16, 16 },
    },
    {
        { 20, 32 },
        { 16, 32 },
        { 16, 16 },
        { 16, 16 },
    },
    {
        { 32, 1 },
        { 34, 16 },
        { 28, 28 },
        { 16, 18 },
    },
    {
        { 1, 32 },
        { 16, 32 },
        { 16, 16 },
        { 16, 16 },
    },
};

static constexpr const LocationXYZ16 junior_rc_right_eighth_to_diag_bank_bound_offsets[4][4] = {
    {
        { 0, 6 },
        { 0, 0 },
        { 0, 0 },
        { 16, 0 },
    },
    {
        { 6, 0 },
        { 16, 0 },
        { 0, 16 },
        { 0, 0 },
    },
    {
        { 0, 27 },
        { 0, 0, 27 },
        { 4, 4, 27 },
        { 0, 16, 27 },
    },
    {
        { 27, 0 },
        { 0, 0 },
        { 16, 0 },
        { 16, 16 },
    },
};

static constexpr const sint8 junior_rc_right_eighth_to_diag_bank_thickness[4][4] = {
    {
        1,
        1,
        1,
        1,
    },
    {
        1,
        1,
        1,
        1,
    },
    {
        26,
        0,
        0,
        0,
    },
    {
        26,
        1,
        1,
        1,
    },
};

/** rct2: 0x008AB170 */
static void junior_rc_right_eighth_to_diag_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_eighth_to_diag_tiles_paint(
        session, junior_rc_right_eighth_to_diag_bank_thickness, height, direction, trackSequence,
        session->TrackColours[SCHEME_TRACK], junior_rc_track_pieces_right_eight_to_diag_bank, nullptr,
        junior_rc_right_eighth_to_diag_bank_bound_lengths, junior_rc_right_eighth_to_diag_bank_bound_offsets,
        session->CurrentRotation);

    switch (trackSequence)
    {
    case 0:
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
        break;
    case 4:
        if (direction == 0)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 1, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 1)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 0, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 2)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK, 2, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
        if (direction == 3)
            metal_a_supports_paint_setup(session, METAL_SUPPORTS_FORK_ALT, 3, 0, height,
                                         session->TrackColours[SCHEME_SUPPORTS]);
        break;
    }

    if (direction == 0 && trackSequence == 0)
    {
        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }
    if (direction == 3 && trackSequence == 0)
    {
        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }

    sint32 blockedSegments = 0;
    switch (trackSequence)
    {
    case 0:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC;
        break;
    case 1:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_C0 | SEGMENT_D4 | SEGMENT_BC;
        break;
    case 2:
        blockedSegments = SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_B4;
        break;
    case 3:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_C0 | SEGMENT_D4;
        break;
    case 4:
        blockedSegments = SEGMENT_D0 | SEGMENT_C4 | SEGMENT_CC | SEGMENT_B8 | SEGMENT_C8 | SEGMENT_D4;
        break;
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB180 */
static void junior_rc_left_eighth_to_orthogonal_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const uint8 map[] = { 4, 2, 3, 1, 0 };
    trackSequence     = map[trackSequence];
    junior_rc_right_eighth_to_diag_bank_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

/** rct2: 0x008AB190 */
static void junior_rc_right_eighth_to_orthogonal_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    const uint8 map[] = { 4, 2, 3, 1, 0 };
    trackSequence     = map[trackSequence];
    junior_rc_left_eighth_to_diag_bank_paint_setup(session, rideIndex, trackSequence, (direction + 3) % 4, height, tileElement);
}

static constexpr const sint32 junior_rc_diag_blocked_segments[] = { SEGMENT_C4 | SEGMENT_CC | SEGMENT_D4 | SEGMENT_BC,
                                                          SEGMENT_C4 | SEGMENT_CC | SEGMENT_C8 | SEGMENT_B4,
                                                          SEGMENT_D0 | SEGMENT_C4 | SEGMENT_C0 | SEGMENT_D4,
                                                          SEGMENT_D0 | SEGMENT_C4 | SEGMENT_B8 | SEGMENT_C8 };

static constexpr const uint8 junior_rc_diag_support_segment[] = { 1, 0, 2, 3 };

void junior_rc_paint_track_diag_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

void junior_rc_paint_track_diag_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_diag_flat_to_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_25_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

void junior_rc_paint_track_diag_flat_to_60_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    // There is no specific chain for the Water Coaster, use the Junior RC chain instead
    chainType = Math::Min(JUNIOR_RC_CHAIN_FRICTION_WHEELS, chainType);

    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_60_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height + 6,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 64, 0x20);
}

void junior_rc_paint_track_diag_25_deg_up_to_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_up_to_flat[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_diag_60_deg_up_to_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    // There is no specific chain for the Water Coaster, use the Junior RC chain instead
    chainType = Math::Min(JUNIOR_RC_CHAIN_FRICTION_WHEELS, chainType);

    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_60_deg_up_to_flat[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4,
                                     height + 13, session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 64, 0x20);
}

void junior_rc_paint_track_diag_25_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{

    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_diag_flat_to_25_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_25_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

void junior_rc_paint_track_diag_flat_to_60_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    // There is no specific chain for the Water Coaster, use the Junior RC chain instead
    chainType = Math::Min(JUNIOR_RC_CHAIN_FRICTION_WHEELS, chainType);

    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_60_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height + 7,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

void junior_rc_paint_track_diag_25_deg_down_to_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_down_to_flat[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

void junior_rc_paint_track_diag_60_deg_down_to_flat(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    // There is no specific chain for the Water Coaster, use the Junior RC chain instead
    chainType = Math::Min(JUNIOR_RC_CHAIN_FRICTION_WHEELS, chainType);

    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_60_deg_down_to_flat[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AAF10 */
static void junior_rc_diag_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                    isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF40 */
static void junior_rc_diag_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                         isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF20 */
static void junior_rc_diag_flat_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_flat_to_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_flat_to_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_flat_to_60_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF30 */
static void junior_rc_diag_25_deg_up_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_up_to_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_60_deg_up_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_up_to_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF70 */
static void junior_rc_diag_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                           isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF50 */
static void junior_rc_diag_flat_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_flat_to_25_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                                   isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_flat_to_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_flat_to_60_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                                   isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AAF60 */
static void junior_rc_diag_25_deg_down_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_down_to_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                                   isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_60_deg_down_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_down_to_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                                   isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/** rct2: 0x008AB1C0 */
static void junior_rc_diag_flat_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_left_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 27);
    }
    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB1D0 */
static void junior_rc_diag_flat_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_flat_to_right_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 27);
    }
    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB1E0 */
static void junior_rc_diag_left_bank_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_left_bank_to_flat, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_FLAT_TO_RIGHT_BANK_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 27);
    }
    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB1F0 */
static void junior_rc_diag_right_bank_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_right_bank_to_flat, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_FLAT_TO_LEFT_BANK_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 27);
    }
    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB220 */
static void junior_rc_diag_left_bank_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_left_bank_to_25_deg_up, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

/** rct2: 0x008AB230 */
static void junior_rc_diag_right_bank_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_right_bank_to_25_deg_up, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

/** rct2: 0x008AB200 */
static void junior_rc_diag_25_deg_up_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_up_to_left_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AB210 */
static void junior_rc_diag_25_deg_up_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_up_to_right_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AB200 */
static void junior_rc_diag_left_bank_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_left_bank_to_25_deg_down, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_RIGHT_BANK_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AB210 */
static void junior_rc_diag_right_bank_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_right_bank_to_25_deg_down, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_25_DEG_UP_TO_LEFT_BANK_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 4, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 56, 0x20);
}

/** rct2: 0x008AB220 */
static void junior_rc_diag_25_deg_down_to_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_down_to_left_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 0 && trackSequence == 1)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_E_W_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

/** rct2: 0x008AB230 */
static void junior_rc_diag_25_deg_down_to_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_down_to_right_bank, defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (direction == 2 && trackSequence == 2)
    {
        uint32 imageId = SPR_JUNIOR_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_W_E_PART_0_2 | session->TrackColours[SCHEME_TRACK];

        sub_98197C(session, imageId, -16, -16, 32, 32, 0, height, -16, -16, height + 35);
    }
    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 48, 0x20);
}

static constexpr const LocationXYZ16 junior_rc_diag_left_bank_bound_offsets[4] = {
    { -16, -16, 27 },
    { -16, -16 },
    { -16, -16 },
    { -16, -16 },
};

static constexpr const LocationXYZ16 junior_rc_diag_right_bank_bound_offsets[4] = {
    { -16, -16 },
    { -16, -16 },
    { -16, -16, 27 },
    { -16, -16 },
};

/** rct2: 0x008AB1A0 */
static void junior_rc_diag_left_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint8 thickness = direction == 0 ? 0 : 1;
    track_paint_util_diag_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_left_bank, defaultDiagTileOffsets, defaultDiagBoundLengths,
        junior_rc_diag_left_bank_bound_offsets, session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/** rct2: 0x008AB1B0 */
static void junior_rc_diag_right_bank_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint8 thickness = direction == 2 ? 0 : 1;
    track_paint_util_diag_tiles_paint(
        session, thickness, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_right_bank, defaultDiagTileOffsets, defaultDiagBoundLengths,
        junior_rc_diag_right_bank_bound_offsets, session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK,
                                     junior_rc_diag_support_segment[direction], 0, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

static constexpr const LocationXY16 junior_rc_60_deg_up_bound_offsets[4] = {
    { 0, 6 },
    { 10, 29 },
    { 29, 10 },
    { 6, 0 },
};

static constexpr const LocationXY16 junior_rc_60_deg_up_tile_offsets[4] = {
    { 0, 6 },
    { 6, 0 },
    { 0, 6 },
    { 6, 0 },
};

static constexpr const sint8 junior_rc_60_deg_up_bound_thickness[4] = { 1, 75, 75, 1 };

static constexpr const LocationXY16 junior_rc_60_deg_up_bound_lengths[4] = {
    { 32, 20 },
    { 10, 1 },
    { 1, 10 },
    { 20, 32 },
};

void junior_rc_paint_track_60_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 image_id = session->TrackColours[SCHEME_TRACK];

    image_id |= junior_rc_track_pieces_60_deg_up[chainType][direction];

    sub_98197C(
        session, image_id, (sint8)junior_rc_60_deg_up_tile_offsets[direction].x,
        (sint8)junior_rc_60_deg_up_tile_offsets[direction].y, junior_rc_60_deg_up_bound_lengths[direction].x,
        junior_rc_60_deg_up_bound_lengths[direction].y, junior_rc_60_deg_up_bound_thickness[direction], height,
        junior_rc_60_deg_up_bound_offsets[direction].x, junior_rc_60_deg_up_bound_offsets[direction].y, height);

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height + 56, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height + 56, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
        break;
    }

    const LocationXY16 pos = session->MapPosition;

    sint8 support[4] = { 35, 29, 25, 32 };
    if (track_paint_util_should_paint_supports(pos))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4,
                                     support[direction], height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 104, 0x20);
}

static void junior_rc_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_60_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                    isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_60_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

static constexpr const LocationXY16 junior_rc_25_deg_up_to_60_deg_up_bound_lengths[4][2] = {
    { { 32, 20 }, { 0 } },
    { { 10, 32 }, { 2, 32 } },
    { { 32, 10 }, { 32, 2 } },
    { { 20, 32 }, { 0 } },
};

static constexpr const sint8 junior_rc_25_deg_up_to_60_deg_up_bound_thickness[4] = { 1, 43, 43, 1 };

static constexpr const LocationXY16 junior_rc_25_deg_up_to_60_deg_up_bound_offsets[4][2] = {
    { { 0, 6 }, { 0 } },
    { { 10, 0 }, { 4, 0 } },
    { { 0, 10 }, { 0, 4 } },
    { { 6, 0 }, { 0 } },
};

void junior_rc_paint_track_25_deg_up_to_60_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 image_id = session->TrackColours[SCHEME_TRACK];

    image_id |= junior_rc_track_pieces_25_deg_up_to_60_deg_up[chainType][direction][0];

    sub_98197C(
        session, image_id, (sint8)junior_rc_60_deg_up_tile_offsets[direction].x,
        (sint8)junior_rc_60_deg_up_tile_offsets[direction].y, junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][0].x,
        junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][0].y,
        junior_rc_25_deg_up_to_60_deg_up_bound_thickness[direction], height,
        junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][0].x,
        junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][0].y, height);

    if (junior_rc_track_pieces_25_deg_up_to_60_deg_up[chainType][direction][1] != 0)
    {
        image_id = session->TrackColours[SCHEME_TRACK];

        image_id |= junior_rc_track_pieces_25_deg_up_to_60_deg_up[chainType][direction][1];

        sub_98197C(
            session, image_id, (sint8)junior_rc_60_deg_up_tile_offsets[direction].x,
            (sint8)junior_rc_60_deg_up_tile_offsets[direction].y,
            junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][1].x,
            junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][1].y,
            junior_rc_25_deg_up_to_60_deg_up_bound_thickness[direction], height,
            junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][1].x,
            junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][1].y, height);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height + 24, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height + 24, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
        break;
    }

    const LocationXY16 pos = session->MapPosition;

    sint8 support[4] = { 12, 12, 12, 14 };
    if (track_paint_util_should_paint_supports(pos))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4,
                                     support[direction], height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

static void junior_rc_25_deg_up_to_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_25_deg_up_to_60_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_60_deg_down_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_25_deg_up_to_60_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

void junior_rc_paint_track_60_deg_up_to_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    uint32 image_id = session->TrackColours[SCHEME_TRACK];

    image_id |= junior_rc_track_pieces_60_deg_up_to_25_deg_up[chainType][direction][0];

    sub_98197C(
        session, image_id, (sint8)junior_rc_60_deg_up_tile_offsets[direction].x,
        (sint8)junior_rc_60_deg_up_tile_offsets[direction].y, junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][0].x,
        junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][0].y,
        junior_rc_25_deg_up_to_60_deg_up_bound_thickness[direction], height,
        junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][0].x,
        junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][0].y, height);

    if (junior_rc_track_pieces_60_deg_up_to_25_deg_up[chainType][direction][1] != 0)
    {
        image_id = session->TrackColours[SCHEME_TRACK];

        image_id |= junior_rc_track_pieces_60_deg_up_to_25_deg_up[chainType][direction][1];

        sub_98197C(
            session, image_id, (sint8)junior_rc_60_deg_up_tile_offsets[direction].x,
            (sint8)junior_rc_60_deg_up_tile_offsets[direction].y,
            junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][1].x,
            junior_rc_25_deg_up_to_60_deg_up_bound_lengths[direction][1].y,
            junior_rc_25_deg_up_to_60_deg_up_bound_thickness[direction], height,
            junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][1].x,
            junior_rc_25_deg_up_to_60_deg_up_bound_offsets[direction][1].y, height);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height - 8, TUNNEL_1);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height + 24, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height + 24, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height - 8, TUNNEL_1);
        break;
    }

    const LocationXY16 pos = session->MapPosition;

    if (track_paint_util_should_paint_supports(pos))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 20, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

static void junior_rc_60_deg_up_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_60_deg_up_to_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                 isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_25_deg_down_to_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_60_deg_up_to_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) % 4, height, tileElement);
}

void junior_rc_paint_track_diag_60_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_60_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 36, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 104, 0x20);
}

void junior_rc_paint_track_diag_60_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_60_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 28, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 104, 0x20);
}

void junior_rc_paint_track_diag_25_deg_up_to_60_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_25_deg_up_to_60_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths, nullptr,
        session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 16, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

void junior_rc_paint_track_diag_60_deg_up_to_25_deg_up(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    if (direction == 1 && trackSequence == 3)
    {
        sub_98197C(
            session,
            junior_rc_track_pieces_diag_60_deg_up_to_25_deg_up[chainType][direction] | session->TrackColours[SCHEME_TRACK], -16,
            -16, 16, 16, 1, height, 0, 0, height);
    }
    else
    {
        track_paint_util_diag_tiles_paint(
            session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
            junior_rc_track_pieces_diag_60_deg_up_to_25_deg_up[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths,
            nullptr, session->CurrentRotation);
    }

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 21, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

void junior_rc_paint_track_diag_25_deg_down_to_60_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    if (direction == 3 && trackSequence == 0)
    {
        sub_98197C(
            session,
            junior_rc_track_pieces_diag_25_deg_down_to_60_deg_down[chainType][direction] | session->TrackColours[SCHEME_TRACK],
            -16, -16, 16, 16, 1, height, 0, 0, height);
    }
    else
    {
        track_paint_util_diag_tiles_paint(
            session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
            junior_rc_track_pieces_diag_25_deg_down_to_60_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths,
            nullptr, session->CurrentRotation);
    }

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 17, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

void junior_rc_paint_track_diag_60_deg_down_to_25_deg_down(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    uint16                   height,
    const rct_tile_element * tileElement,
    JUNIOR_RC_CHAINTYPE      chainType)
{
    track_paint_util_diag_tiles_paint(
        session, 1, height, direction, trackSequence, session->TrackColours[SCHEME_TRACK],
        junior_rc_track_pieces_diag_60_deg_down_to_25_deg_down[chainType], defaultDiagTileOffsets, defaultDiagBoundLengths,
        nullptr, session->CurrentRotation);

    if (trackSequence == 3)
    {
        metal_b_supports_paint_setup(session, (direction & 1) ? 2 : 1, junior_rc_diag_support_segment[direction], 8, height,
                                     session->TrackColours[SCHEME_SUPPORTS]);
    }

    sint32 blockedSegments = junior_rc_diag_blocked_segments[trackSequence];
    paint_util_set_segment_support_height(session, paint_util_rotate_segments(blockedSegments, direction), 0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

static void junior_rc_diag_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                         isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                           isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_25_deg_up_to_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_up_to_60_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                      isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_60_deg_up_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_up_to_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                                      isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_25_deg_down_to_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_25_deg_down_to_60_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                                          isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static void junior_rc_diag_60_deg_down_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_diag_60_deg_down_to_25_deg_down(session, rideIndex, trackSequence, direction, height, tileElement,
                                                          isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

static constexpr const LocationXY16 junior_rc_flat_to_60_deg_up_bound_lengths[4][2] = {
    { { 32, 24 }, { 0 } },
    { { 10, 1 }, { 2, 32 } },
    { { 1, 10 }, { 32, 2 } },
    { { 24, 32 }, { 0 } },
};

static constexpr const sint8 junior_rc_flat_to_60_deg_up_bound_thickness[4] = { 1, 43, 43, 1 };

static constexpr const LocationXY16 junior_rc_flat_to_60_deg_up_bound_offsets[4][2] = {
    { { 0, 4 }, { 0 } },
    { { 10, 0 }, { 4, 0 } },
    { { 0, 10 }, { 0, 4 } },
    { { 4, 0 }, { 0 } },
};

static constexpr const LocationXY16 junior_rc_flat_to_60_deg_up_tile_offsets[4][2] = {
    { { 12, -10 }, { 0 } }, { { 22, 9 }, { 12, -11 } }, { { 30, 7 }, { 5, 0 } }, { { 12, -12 }, { 0 } }
};

static constexpr const LocationXY16 junior_rc_60_deg_up_to_flat_tile_offsets[4][2] = {
    { { 13, -9 }, { 0 } }, { { 32, 9 }, { -7, -11 } }, { { 22, 18 }, { 2, -19 } }, { { 13, -9 }, { 0 } }
};

static void junior_rc_flat_to_60_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    uint32 image_id = session->TrackColours[SCHEME_TRACK];

    bool isChained = tileElement->type & (1 << 7);

    image_id |= junior_rc_track_pieces_flat_to_60_deg_up[isChained][direction][0];

    sub_98197C(
        session, image_id, (sint8)junior_rc_flat_to_60_deg_up_tile_offsets[direction][0].x,
        (sint8)junior_rc_flat_to_60_deg_up_tile_offsets[direction][0].y,
        junior_rc_flat_to_60_deg_up_bound_lengths[direction][0].x, junior_rc_flat_to_60_deg_up_bound_lengths[direction][0].y,
        junior_rc_flat_to_60_deg_up_bound_thickness[direction], height + 24,
        junior_rc_flat_to_60_deg_up_bound_offsets[direction][0].x, junior_rc_flat_to_60_deg_up_bound_offsets[direction][0].y,
        height);

    if (junior_rc_track_pieces_flat_to_60_deg_up[isChained][direction][1] != 0)
    {
        image_id = session->TrackColours[SCHEME_TRACK];

        image_id |= junior_rc_track_pieces_flat_to_60_deg_up[isChained][direction][1];

        sub_98197C(
            session, image_id, (sint8)junior_rc_flat_to_60_deg_up_tile_offsets[direction][1].x,
            (sint8)junior_rc_flat_to_60_deg_up_tile_offsets[direction][1].y,
            junior_rc_flat_to_60_deg_up_bound_lengths[direction][1].x,
            junior_rc_flat_to_60_deg_up_bound_lengths[direction][1].y, junior_rc_flat_to_60_deg_up_bound_thickness[direction],
            height, junior_rc_flat_to_60_deg_up_bound_offsets[direction][1].x,
            junior_rc_flat_to_60_deg_up_bound_offsets[direction][1].y, height);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height, TUNNEL_1);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height + 24, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height + 24, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height, TUNNEL_1);
        break;
    }

    const LocationXY16 pos = session->MapPosition;

    sint8 support[4] = { 12, 12, 12, 14 };
    if (track_paint_util_should_paint_supports(pos))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4,
                                     support[direction], height - 7, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

static void junior_rc_60_deg_down_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_flat_to_60_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) & 3, height, tileElement);
}

static void junior_rc_60_deg_up_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{

    uint32 image_id = session->TrackColours[SCHEME_TRACK];

    bool isChained = tileElement->type & (1 << 7);

    image_id |= junior_rc_track_pieces_60_deg_up_to_flat[isChained][direction][0];

    sub_98197C(
        session, image_id, (sint8)junior_rc_60_deg_up_to_flat_tile_offsets[direction][0].x,
        (sint8)junior_rc_60_deg_up_to_flat_tile_offsets[direction][0].y,
        junior_rc_flat_to_60_deg_up_bound_lengths[direction][0].x, junior_rc_flat_to_60_deg_up_bound_lengths[direction][0].y,
        junior_rc_flat_to_60_deg_up_bound_thickness[direction], height + 24,
        junior_rc_flat_to_60_deg_up_bound_offsets[direction][0].x, junior_rc_flat_to_60_deg_up_bound_offsets[direction][0].y,
        height);

    if (junior_rc_track_pieces_60_deg_up_to_flat[isChained][direction][1] != 0)
    {
        image_id = session->TrackColours[SCHEME_TRACK];

        image_id |= junior_rc_track_pieces_60_deg_up_to_flat[isChained][direction][1];

        sub_98197C(
            session, image_id, (sint8)junior_rc_60_deg_up_to_flat_tile_offsets[direction][1].x,
            (sint8)junior_rc_60_deg_up_to_flat_tile_offsets[direction][1].y,
            junior_rc_flat_to_60_deg_up_bound_lengths[direction][1].x,
            junior_rc_flat_to_60_deg_up_bound_lengths[direction][1].y, junior_rc_flat_to_60_deg_up_bound_thickness[direction],
            height, junior_rc_flat_to_60_deg_up_bound_offsets[direction][1].x,
            junior_rc_flat_to_60_deg_up_bound_offsets[direction][1].y, height);
    }

    switch (direction)
    {
    case 0:
        paint_util_push_tunnel_left(session, height, TUNNEL_1);
        break;
    case 1:
        paint_util_push_tunnel_right(session, height + 24, TUNNEL_2);
        break;
    case 2:
        paint_util_push_tunnel_left(session, height + 24, TUNNEL_2);
        break;
    case 3:
        paint_util_push_tunnel_right(session, height, TUNNEL_1);
        break;
    }

    const LocationXY16 pos = session->MapPosition;

    if (track_paint_util_should_paint_supports(pos))
    {
        metal_a_supports_paint_setup(session, (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK, 4, 20,
                                     height - 5, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 72, 0x20);
}

static void junior_rc_flat_to_60_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_60_deg_up_to_flat_paint_setup(session, rideIndex, trackSequence, (direction + 2) & 3, height, tileElement);
}

/* rct2: 0x00518394 */
static void junior_rc_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                               isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x00515629, 0x00514D22, 0x005151B9 */
static void paint_junior_rc_station_track(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    junior_rc_paint_station(session, rideIndex, trackSequence, direction, height, tileElement, RIDE_TYPE_JUNIOR_ROLLER_COASTER);
}

/* rct2: 0x0051881E */
static void junior_rc_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                    isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x00518B42 */
static void junior_rc_flat_to_25_deg_up_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_flat_to_25_deg_up(session, rideIndex, trackSequence, direction, height, tileElement,
                                            isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x00518E56 */
static void junior_rc_25_deg_up_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    bool isChained = track_element_is_lift_hill(tileElement);
    junior_rc_paint_track_25_deg_up_to_flat(session, rideIndex, trackSequence, direction, height, tileElement,
                                            isChained ? JUNIOR_RC_CHAIN_FRICTION_WHEELS : JUNIOR_RC_CHAIN_NONE);
}

/* rct2: 0x005189B0 */
static void junior_rc_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{

    junior_rc_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) & 3, height, tileElement);
}

/* rct2: 0x00518FE8 */
static void junior_rc_flat_to_25_deg_down_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{

    junior_rc_25_deg_up_to_flat_paint_setup(session, rideIndex, trackSequence, (direction + 2) & 3, height, tileElement);
}

/* rct2: 0x00518CCC */
static void junior_rc_25_deg_down_to_flat_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{

    junior_rc_flat_to_25_deg_up_paint_setup(session, rideIndex, trackSequence, (direction + 2) & 3, height, tileElement);
}

static void junior_rc_booster_paint_setup(
    paint_session *          session,
    uint8                    rideIndex,
    uint8                    trackSequence,
    uint8                    direction,
    sint32                   height,
    const rct_tile_element * tileElement)
{
    sint32 XoffsetNESW = 12;
    sint32 YoffsetNESW = -10;
    sint32 XoffsetNWSE = 10;
    sint32 YoffsetNWSE = -10;

    if (direction & 1)
    {
        sub_98196C(
            session, SPR_JUNIOR_RC_BOOSTER_NE_SW | session->TrackColours[SCHEME_TRACK], XoffsetNESW, YoffsetNESW, 20, 32, 1,
            height);

        paint_util_push_tunnel_right(session, height, TUNNEL_0);
    }
    else
    {
        sub_98196C(
            session, SPR_JUNIOR_RC_BOOSTER_NW_SE | session->TrackColours[SCHEME_TRACK], XoffsetNWSE, YoffsetNWSE, 32, 20, 1,
            height);

        paint_util_push_tunnel_left(session, height, TUNNEL_0);
    }

    const LocationXY16 pos = session->MapPosition;
    if (track_paint_util_should_paint_supports(pos))
    {
        uint8 supportType = (direction & 1) ? METAL_SUPPORTS_FORK_ALT : METAL_SUPPORTS_FORK;
        metal_a_supports_paint_setup(session, supportType, 4, 0, height, session->TrackColours[SCHEME_SUPPORTS]);
    }

    paint_util_set_segment_support_height(session, paint_util_rotate_segments(SEGMENT_C4 | SEGMENT_D0 | SEGMENT_CC, direction),
                                          0xFFFF, 0);
    paint_util_set_general_support_height(session, height + 32, 0x20);
}

/* 0x008AAA0C */
TRACK_PAINT_FUNCTION get_track_paint_function_junior_rc(sint32 trackType, sint32 direction)
{
    switch (trackType)
    {
    case TRACK_ELEM_FLAT:
        return junior_rc_flat_paint_setup;
    case TRACK_ELEM_END_STATION:
        return paint_junior_rc_station_track;
    case TRACK_ELEM_BEGIN_STATION:
        return paint_junior_rc_station_track;
    case TRACK_ELEM_MIDDLE_STATION:
        return paint_junior_rc_station_track;
    case TRACK_ELEM_25_DEG_UP:
        return junior_rc_25_deg_up_paint_setup;
    case TRACK_ELEM_60_DEG_UP:
        return junior_rc_60_deg_up_paint_setup;
    case TRACK_ELEM_FLAT_TO_25_DEG_UP:
        return junior_rc_flat_to_25_deg_up_paint_setup;
    case TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP:
        return junior_rc_25_deg_up_to_60_deg_up_paint_setup;
    case TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP:
        return junior_rc_60_deg_up_to_25_deg_up_paint_setup;
    case TRACK_ELEM_25_DEG_UP_TO_FLAT:
        return junior_rc_25_deg_up_to_flat_paint_setup;
    case TRACK_ELEM_25_DEG_DOWN:
        return junior_rc_25_deg_down_paint_setup;
    case TRACK_ELEM_60_DEG_DOWN:
        return junior_rc_60_deg_down_paint_setup;
    case TRACK_ELEM_FLAT_TO_25_DEG_DOWN:
        return junior_rc_flat_to_25_deg_down_paint_setup;
    case TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN:
        return junior_rc_25_deg_down_to_60_deg_down_paint_setup;
    case TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN:
        return junior_rc_60_deg_down_to_25_deg_down_paint_setup;
    case TRACK_ELEM_25_DEG_DOWN_TO_FLAT:
        return junior_rc_25_deg_down_to_flat_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES:
        return junior_rc_left_quarter_turn_5_tiles_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES:
        return junior_rc_right_quarter_turn_5_tiles_paint_setup;
    case TRACK_ELEM_FLAT_TO_LEFT_BANK:
        return junior_rc_flat_to_left_bank_paint_setup;
    case TRACK_ELEM_FLAT_TO_RIGHT_BANK:
        return junior_rc_flat_to_right_bank_paint_setup;
    case TRACK_ELEM_LEFT_BANK_TO_FLAT:
        return junior_rc_left_bank_to_flat_paint_setup;
    case TRACK_ELEM_RIGHT_BANK_TO_FLAT:
        return junior_rc_right_bank_to_flat_paint_setup;
    case TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES:
        return junior_rc_banked_left_quarter_turn_5_tiles_paint_setup;
    case TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES:
        return junior_rc_banked_right_quarter_turn_5_tiles_paint_setup;
    case TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP:
        return junior_rc_left_bank_to_25_deg_up_paint_setup;
    case TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP:
        return junior_rc_right_bank_to_25_deg_up_paint_setup;
    case TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK:
        return junior_rc_25_deg_up_to_left_bank_paint_setup;
    case TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK:
        return junior_rc_25_deg_up_to_right_bank_paint_setup;
    case TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN:
        return junior_rc_left_bank_to_25_deg_down_paint_setup;
    case TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN:
        return junior_rc_right_bank_to_25_deg_down_paint_setup;
    case TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK:
        return junior_rc_25_deg_down_to_left_bank_paint_setup;
    case TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK:
        return junior_rc_25_deg_down_to_right_bank_paint_setup;
    case TRACK_ELEM_LEFT_BANK:
        return junior_rc_left_bank_paint_setup;
    case TRACK_ELEM_RIGHT_BANK:
        return junior_rc_right_bank_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP:
        return junior_rc_left_quarter_turn_5_tiles_25_deg_up_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP:
        return junior_rc_right_quarter_turn_5_tiles_25_deg_up_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN:
        return junior_rc_left_quarter_turn_5_tiles_25_deg_down_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN:
        return junior_rc_right_quarter_turn_5_tiles_25_deg_down_paint_setup;
    case TRACK_ELEM_S_BEND_LEFT:
        return junior_rc_s_bend_left_paint_setup;
    case TRACK_ELEM_S_BEND_RIGHT:
        return junior_rc_s_bend_right_paint_setup;

    case TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES:
        return junior_rc_left_quarter_turn_3_tiles_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES:
        return junior_rc_right_quarter_turn_3_tiles_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK:
        return junior_rc_left_quarter_turn_3_tiles_bank_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK:
        return junior_rc_right_quarter_turn_3_tiles_bank_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP:
        return junior_rc_left_quarter_turn_3_tiles_25_deg_up_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP:
        return junior_rc_right_quarter_turn_3_tiles_25_deg_up_paint_setup;
    case TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN:
        return junior_rc_left_quarter_turn_3_tiles_25_deg_down_paint_setup;
    case TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN:
        return junior_rc_right_quarter_turn_3_tiles_25_deg_down_paint_setup;

    case TRACK_ELEM_FLAT_TO_60_DEG_UP:
        return junior_rc_flat_to_60_deg_up_paint_setup;
    case TRACK_ELEM_60_DEG_UP_TO_FLAT:
        return junior_rc_60_deg_up_to_flat_paint_setup;
    case TRACK_ELEM_FLAT_TO_60_DEG_DOWN:
        return junior_rc_flat_to_60_deg_down_paint_setup;
    case TRACK_ELEM_60_DEG_DOWN_TO_FLAT:
        return junior_rc_60_deg_down_to_flat_paint_setup;

    case TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL:
        return junior_rc_left_half_banked_helix_up_small_paint_setup;
    case TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL:
        return junior_rc_right_half_banked_helix_up_small_paint_setup;
    case TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL:
        return junior_rc_left_half_banked_helix_down_small_paint_setup;
    case TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL:
        return junior_rc_right_half_banked_helix_down_small_paint_setup;
    case TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE:
        return junior_rc_left_half_banked_helix_up_large_paint_setup;
    case TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE:
        return junior_rc_right_half_banked_helix_up_large_paint_setup;
    case TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE:
        return junior_rc_left_half_banked_helix_down_large_paint_setup;
    case TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE:
        return junior_rc_right_half_banked_helix_down_large_paint_setup;

    case TRACK_ELEM_BRAKES:
        return junior_rc_brake_paint_setup;

    case TRACK_ELEM_LEFT_EIGHTH_TO_DIAG:
        return junior_rc_left_eighth_to_diag_paint_setup;
    case TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG:
        return junior_rc_right_eighth_to_diag_paint_setup;
    case TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL:
        return junior_rc_left_eighth_to_orthogonal_paint_setup;
    case TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL:
        return junior_rc_right_eighth_to_orthogonal_paint_setup;
    case TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG:
        return junior_rc_left_eighth_to_diag_bank_paint_setup;
    case TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG:
        return junior_rc_right_eighth_to_diag_bank_paint_setup;
    case TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL:
        return junior_rc_left_eighth_to_orthogonal_bank_paint_setup;
    case TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL:
        return junior_rc_right_eighth_to_orthogonal_bank_paint_setup;
    case TRACK_ELEM_DIAG_FLAT:
        return junior_rc_diag_flat_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_UP:
        return junior_rc_diag_25_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_60_DEG_UP:
        return junior_rc_diag_60_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP:
        return junior_rc_diag_flat_to_25_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP:
        return junior_rc_diag_25_deg_up_to_60_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP:
        return junior_rc_diag_60_deg_up_to_25_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT:
        return junior_rc_diag_25_deg_up_to_flat_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_DOWN:
        return junior_rc_diag_25_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_60_DEG_DOWN:
        return junior_rc_diag_60_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN:
        return junior_rc_diag_flat_to_25_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN:
        return junior_rc_diag_25_deg_down_to_60_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN:
        return junior_rc_diag_60_deg_down_to_25_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT:
        return junior_rc_diag_25_deg_down_to_flat_paint_setup;

    case TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK:
        return junior_rc_diag_flat_to_left_bank_paint_setup;
    case TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK:
        return junior_rc_diag_flat_to_right_bank_paint_setup;
    case TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT:
        return junior_rc_diag_left_bank_to_flat_paint_setup;
    case TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT:
        return junior_rc_diag_right_bank_to_flat_paint_setup;
    case TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP:
        return junior_rc_diag_left_bank_to_25_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP:
        return junior_rc_diag_right_bank_to_25_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK:
        return junior_rc_diag_25_deg_up_to_left_bank_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK:
        return junior_rc_diag_25_deg_up_to_right_bank_paint_setup;
    case TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN:
        return junior_rc_diag_left_bank_to_25_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN:
        return junior_rc_diag_right_bank_to_25_deg_down_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK:
        return junior_rc_diag_25_deg_down_to_left_bank_paint_setup;
    case TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK:
        return junior_rc_diag_25_deg_down_to_right_bank_paint_setup;
    case TRACK_ELEM_DIAG_LEFT_BANK:
        return junior_rc_diag_left_bank_paint_setup;
    case TRACK_ELEM_DIAG_RIGHT_BANK:
        return junior_rc_diag_right_bank_paint_setup;

    case TRACK_ELEM_BLOCK_BRAKES:
        return junior_rc_block_brake_paint_setup;

    case TRACK_ELEM_BOOSTER:
        return junior_rc_booster_paint_setup;

    case TRACK_ELEM_DIAG_60_DEG_DOWN_TO_FLAT:
        return junior_rc_diag_60_deg_down_to_flat_paint_setup;
    case TRACK_ELEM_DIAG_60_DEG_UP_TO_FLAT:
        return junior_rc_diag_60_deg_up_to_flat_paint_setup;
    case TRACK_ELEM_DIAG_FLAT_TO_60_DEG_UP:
        return junior_rc_diag_flat_to_60_deg_up_paint_setup;
    case TRACK_ELEM_DIAG_FLAT_TO_60_DEG_DOWN:
        return junior_rc_diag_flat_to_60_deg_down_paint_setup;
    }
    return nullptr;
}
