#pragma region Copyright (c) 2014-2017 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#ifndef _PAINT_SURFACE_H
#define _PAINT_SURFACE_H

#include "../../common.h"
#include "../../sprites.h"

enum
{
    SPR_TERRAIN_GRASS = 1915,
    SPR_TERRAIN_GRASS_GRID = 1934,
    SPR_TERRAIN_GRASS_UNDERGROUND = 1953,
    SPR_TERRAIN_SAND = 1972,
    SPR_TERRAIN_SAND_GRID = 1991,
    SPR_TERRAIN_SAND_UNDERGROUND = 2010,
    SPR_TERRAIN_SAND_RED = 2029,
    SPR_TERRAIN_SAND_RED_GRID = 2048,
    SPR_TERRAIN_SAND_RED_UNDERGROUND = 2067,
    SPR_TERRAIN_SAND_YELLOW = 2086,
    SPR_TERRAIN_SAND_YELLOW_GRID = 2105,
    SPR_TERRAIN_SAND_YELLOW_UNDERGROUND = 2124,
    SPR_TERRAIN_ICE = 2143,
    SPR_TERRAIN_ICE_GRID = 2162,
    SPR_TERRAIN_ICE_UNDERGROUND = 2181,
    SPR_TERRAIN_GRASS_CLUMPS = 2200,
    SPR_TERRAIN_GRASS_CLUMPS_GRID = 2219,
    SPR_TERRAIN_GRASS_CLUMPS_UNDERGROUND = 2238,
    SPR_TERRAIN_GRID = 2257,
    SPR_TERRAIN_GRID_GRID = 2276,
    SPR_TERRAIN_GRID_UNDERGROUND = 2295,
    SPR_TERRAIN_MARTIAN = 2314,
    SPR_TERRAIN_MARTIAN_GRID = 2333,
    SPR_TERRAIN_MARTIAN_UNDERGROUND = 2352,
    SPR_TERRAIN_CHECKERBOARD = 2371,
    SPR_TERRAIN_CHECKERBOARD_GRID = 2390,
    SPR_TERRAIN_CHECKERBOARD_UNDERGROUND = 2409,
    SPR_TERRAIN_CHECKERBOARD_INVERTED = 2428,
    SPR_TERRAIN_CHECKERBOARD_INVERTED_GRID = 2447,
    SPR_TERRAIN_CHECKERBOARD_INVERTED_UNDERGROUND = 2466,
    SPR_TERRAIN_DIRT = 2485,
    SPR_TERRAIN_DIRT_GRID = 2504,
    SPR_TERRAIN_DIRT_UNDERGROUND = 2523,
    SPR_TERRAIN_ROCK = 2542,
    SPR_TERRAIN_ROCK_GRID = 2561,
    SPR_TERRAIN_ROCK_UNDERGROUND = 2580,
    SPR_TERRAIN_SELECTION_PATROL_AREA = 2599,
    SPR_TERRAIN_TRACK_DESIGNER = 2623,
    SPR_TERRAIN_GRASS_MOWED = 2663,
    SPR_TERRAIN_GRASS_MOWED_GRID = 2682,
    SPR_TERRAIN_GRASS_MOWED_90 = 2701,
    SPR_TERRAIN_GRASS_MOWED_90_GRID = 2720,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_1 = 2739,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_1_GRID = 2758,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_2 = 2777,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_2_GRID = 2796,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_3 = 2815,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_3_GRID = 2834,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_4 = 2853,
    SPR_TERRAIN_GRASS_LENGTH_4_VARIANT_4_GRID = 2872,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_1 = 2891,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_1_GRID = 2910,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_2 = 2929,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_2_GRID = 2948,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_3 = 2967,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_3_GRID = 2986,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_4 = 3005,
    SPR_TERRAIN_GRASS_LENGTH_6_VARIANT_4_GRID = 3024,
    SPR_TERRAIN_SELECTION_CORNER = 3043,
    SPR_TERRAIN_SELECTION_EDGE = 3062,
    SPR_TERRAIN_SELECTION_QUARTER = 3081,
    SPR_WATER_MASK = 5048,
    SPR_WATER_OVERLAY = 5053,
    SPR_HEIGHT_MARKER_BASE = 5769,

    SPR_TERRAIN_BOUNDARY_FENCES_1 = 22872,
    SPR_TERRAIN_BOUNDARY_FENCES_2 = 22873,
    SPR_TERRAIN_BOUNDARY_FENCES_3 = 22874,
    SPR_TERRAIN_BOUNDARY_FENCES_4 = 22875,
    SPR_TERRAIN_BOUNDARY_FENCES_5 = 22876,
    SPR_TERRAIN_BOUNDARY_FENCES_6 = 22877,

    SPR_TERRAIN_EDGE_MASK_TOP_RIGHT = 28883,
    SPR_TERRAIN_EDGE_MASK_BOTTOM_RIGHT = 28902,
    SPR_TERRAIN_EDGE_MASK_BOTTOM_LEFT = 28921,
    SPR_TERRAIN_EDGE_MASK_TOP_LEFT = 28940,
    SPR_TERRAIN_PATTERN_GRASS = 28959,
    SPR_TERRAIN_PATTERN_SAND = 28965,
    SPR_TERRAIN_PATTERN_SAND_RED = 28971,
    SPR_TERRAIN_PATTERN_DIRT = 28977,
    SPR_TERRAIN_PATTERN_SAND_YELLOW = 28983,
    SPR_TERRAIN_PATTERN_ROCK = 28989,
    SPR_TERRAIN_PATTERN_MARTIAN = 28995,
    SPR_TERRAIN_PATTERN_GRASS_CLUMPS = 29001,
    SPR_TERRAIN_PATTERN_ICE = 29007,

    SPR_CSG_TERRAIN_GRASS = SPR_CSG_BEGIN + 41862,
    SPR_CSG_TERRAIN_GRASS_GRID = SPR_CSG_TERRAIN_GRASS + 19,
    SPR_CSG_TERRAIN_GRASS_UNDERGROUND = SPR_CSG_TERRAIN_GRASS + 38,
    SPR_CSG_TERRAIN_SAND = SPR_CSG_BEGIN + 41919,
    SPR_CSG_TERRAIN_ICE = SPR_CSG_BEGIN + 41976,
    SPR_CSG_TERRAIN_GRASS_CLUMPS = SPR_CSG_BEGIN + 42033,
    SPR_CSG_TERRAIN_ROOF_TILES_RED = SPR_CSG_BEGIN + 42090,
    SPR_CSG_TERRAIN_ROOF_TILES_GREY = SPR_CSG_BEGIN + 42147,
    SPR_CSG_TERRAIN_GRID = SPR_CSG_BEGIN + 42204,
    SPR_CSG_TERRAIN_WOOD = SPR_CSG_BEGIN + 42261,
    SPR_CSG_TERRAIN_WOOD_INVERTED = SPR_CSG_BEGIN + 42318,
    SPR_CSG_TERRAIN_RUST = SPR_CSG_BEGIN + 42375,
    SPR_CSG_TERRAIN_RUST_INVERTED = SPR_CSG_BEGIN + 42432,
    SPR_CSG_TERRAIN_MARTIAN = SPR_CSG_BEGIN + 42489,
    SPR_CSG_TERRAIN_CHECKERBOARD = SPR_CSG_BEGIN + 42546,
    SPR_CSG_TERRAIN_CHECKERBOARD_INVERTED = SPR_CSG_BEGIN + 42603,
    SPR_CSG_TERRAIN_DIRT = SPR_CSG_BEGIN + 42660,
    SPR_CSG_TERRAIN_ROCK = SPR_CSG_BEGIN + 42717,
};

#endif //_PAINT_SURFACE_H
