/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.cpu;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ThreadInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(ThreadInfoProvider.class.getName());
    private static String AGENT_PATH = "modules/ext/stagent.jar";
    private final String status;
    private ProxyTruffleMBean tbean;

    public ThreadInfoProvider(Application app, String mode, boolean trackFlags) {
        this.status = this.initialize(app, mode, trackFlags);
    }

    public String getStatus() {
        return this.status;
    }

    private String initialize(Application application, String mode, boolean trackFlags) {
        if (application.getState() != 1) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable");
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel == null) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_init_jmx");
        }
        if (jmxModel.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_create_jmx");
        }
        try {
            this.tbean = new ProxyTruffleMBean(jmxModel.getMBeanServerConnection());
            if (!this.checkAndLoadJMX(application)) {
                return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
            }
            if (!this.tbean.isStackTracesEnabled()) {
                return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_stacktraces");
            }
            this.tbean.setTrackFlags(trackFlags);
            this.tbean.setMode(mode);
            this.tbean.dumpAllThreads();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws SecurityException for " + application, e);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws Throwable for " + application, t);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        return null;
    }

    Map<String, Object>[] dumpAllThreads() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.tbean.dumpAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAndLoadJMX(Application app) throws MalformedObjectNameException, IOException, InterruptedException {
        Application application = app;
        synchronized (application) {
            if (this.tbean.isRegistered()) {
                return true;
            }
            if (this.loadAgent(app)) {
                for (int i = 0; i < 10; ++i) {
                    if (this.tbean.isRegistered()) {
                        return true;
                    }
                    Thread.sleep(300L);
                }
            }
            return this.tbean.isRegistered();
        }
    }

    boolean loadAgent(Application app) {
        String pid = String.valueOf(app.getPid());
        String agentPath = this.getAgentPath();
        LOGGER.warning("Agent " + agentPath);
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            LOGGER.warning(vm.toString());
            ThreadInfoProvider.loadAgentIntoTargetJVM(vm, agentPath, null);
            vm.detach();
            LOGGER.warning("Agent loaded");
            return true;
        }
        catch (AttachNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentLoadException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentInitializationException ex) {
            LOGGER.log(Level.INFO, "loadAgent()", ex);
        }
        return false;
    }

    void setOptions(String mode, boolean trackFlags) {
        try {
            this.tbean.setMode(mode);
            this.tbean.setTrackFlags(trackFlags);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "threadBean.setMode(), setTrackFlags()", ex);
        }
    }

    private static void loadAgentIntoTargetJVM(VirtualMachine virtualMachine, String jar, String options) throws IOException, AgentLoadException, AgentInitializationException {
        try {
            virtualMachine.loadAgent(jar, options);
        }
        catch (AgentLoadException ex) {
            if ("0".equals(ex.getMessage())) {
                return;
            }
            throw ex;
        }
        catch (IOException ex) {
            if ("readInt".equals(ex.getStackTrace()[0].getMethodName())) {
                return;
            }
            throw ex;
        }
    }

    private String getAgentPath() {
        InstalledFileLocator loc = InstalledFileLocator.getDefault();
        File jar = loc.locate(AGENT_PATH, "org.graalvm.visualvm.sampler.truffle", false);
        return jar.getAbsolutePath();
    }

    private class ProxyTruffleMBean {
        private static final String TRUFFLE_OBJECT_NAME = "com.truffle:type=Threading";
        private final ObjectName truffleObjectName;
        private final MBeanServerConnection conn;

        ProxyTruffleMBean(MBeanServerConnection c) throws MalformedObjectNameException {
            this.conn = c;
            this.truffleObjectName = new ObjectName(TRUFFLE_OBJECT_NAME);
        }

        Map<String, Object>[] dumpAllThreads() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return (Map[])this.conn.invoke(this.truffleObjectName, "dumpAllThreads", null, null);
        }

        boolean isStackTracesEnabled() throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, AttributeNotFoundException {
            return (Boolean)this.conn.getAttribute(this.truffleObjectName, "StackTracesEnabled");
        }

        void setTrackFlags(boolean trackFlags) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.conn.setAttribute(this.truffleObjectName, new Attribute("TrackFlags", trackFlags));
        }

        void setMode(String mode) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException, InvalidAttributeValueException {
            this.conn.setAttribute(this.truffleObjectName, new Attribute("Mode", mode));
        }

        boolean isRegistered() throws IOException {
            return this.conn.isRegistered(this.truffleObjectName);
        }
    }
}

