/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

final class TruffleJDKServices {
    TruffleJDKServices() {
    }

    static void exportTo(ClassLoader loader, String moduleName) {
    }

    static void exportTo(Class<?> client) {
    }

    static <S> void addUses(Class<S> service) {
    }

    static <Service> List<Iterable<Service>> getTruffleRuntimeLoaders(Class<Service> serviceClass) {
        Iterable<Service> jvmciProviders = TruffleJDKServices.getJVMCIProviders(serviceClass);
        if (Boolean.getBoolean("truffle.TrustAllTruffleRuntimeProviders")) {
            ServiceLoader<Service> standardProviders = ServiceLoader.load(serviceClass);
            return Arrays.asList(jvmciProviders, standardProviders);
        }
        return Collections.singletonList(jvmciProviders);
    }

    private static <Service> Iterable<Service> getJVMCIProviders(Class<Service> serviceClass) {
        Class<?> jvmciServicesClass;
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        for (ClassLoader cl = TruffleJDKServices.class.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != scl) continue;
            return null;
        }
        try {
            jvmciServicesClass = Class.forName("jdk.vm.ci.services.Services");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return TruffleJDKServices.reflectiveServiceLoaderLoad(jvmciServicesClass, serviceClass);
    }

    private static <Service> Iterable<Service> reflectiveServiceLoaderLoad(Class<?> servicesClass, Class<Service> serviceClass) {
        try {
            Method m = servicesClass.getDeclaredMethod("load", Class.class);
            return (Iterable)m.invoke(null, serviceClass);
        }
        catch (Throwable e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    static Object getUnnamedModule(ClassLoader classLoader) {
        return null;
    }

    static boolean verifyModuleVisibility(Object currentModule, Class<?> memberClass) {
        assert (currentModule == null);
        return true;
    }

    static boolean isNonTruffleClass(Class<?> clazz) {
        return clazz.getClassLoader() != null;
    }
}

