/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.coverage.RootCoverage;
import com.oracle.truffle.tools.coverage.SectionCoverage;
import com.oracle.truffle.tools.coverage.SourceCoverage;
import com.oracle.truffle.tools.coverage.impl.LineCoverage;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;

final class CoverageCLI {
    private final PrintStream out;
    private final String format;
    private final String summaryHeader;
    private final int summaryHeaderLen;
    private final SourceCoverage[] coverage;
    private final boolean strictLines;

    CoverageCLI(PrintStream out, SourceCoverage[] coverage, boolean strictLines) {
        this.out = out;
        this.coverage = coverage;
        this.strictLines = strictLines;
        this.sortCoverage();
        this.format = CoverageCLI.getHistogramLineFormat(coverage);
        this.summaryHeader = String.format(this.format, "Path", "Statements", "Lines", "Roots");
        this.summaryHeaderLen = this.summaryHeader.length();
    }

    private static String getName(Source source) {
        if (source.getPath() == null) {
            return source.getName();
        }
        return source.getPath();
    }

    private static String getHistogramLineFormat(SourceCoverage[] coverage) {
        int maxNameLength = 10;
        for (SourceCoverage source : coverage) {
            String name = CoverageCLI.getName(source.getSource());
            maxNameLength = Math.max(maxNameLength, name.length());
        }
        return " %-" + maxNameLength + "s |  %10s |  %7s |  %7s ";
    }

    private static String percentFormat(double val) {
        return String.format("%.2f%%", val);
    }

    private static String statementCoverage(SourceCoverage coverage) {
        int loaded = 0;
        int covered = 0;
        for (RootCoverage root : coverage.getRoots()) {
            SectionCoverage[] sectionCoverage = root.getSectionCoverage();
            loaded += sectionCoverage.length;
            covered = (int)((long)covered + CoverageCLI.getCoveredCount(sectionCoverage));
        }
        return CoverageCLI.percentFormat(100.0 * (double)covered / (double)loaded);
    }

    private static long getCoveredCount(SectionCoverage[] sectionCoverage) {
        return Arrays.stream(sectionCoverage).filter(SectionCoverage::isCovered).count();
    }

    private static String rootCoverage(SourceCoverage coverage) {
        int covered = 0;
        for (RootCoverage root : coverage.getRoots()) {
            if (!root.isCovered()) continue;
            ++covered;
        }
        return CoverageCLI.percentFormat(100.0 * (double)covered / (double)coverage.getRoots().length);
    }

    private static String lineCoverage(LineCoverage lineCoverage) {
        double coverage = lineCoverage.getCoverage();
        if (Double.isNaN(coverage)) {
            return "";
        }
        return CoverageCLI.percentFormat(100.0 * coverage);
    }

    void printLinesOutput() {
        this.printLine();
        this.printLinesLegend();
        for (SourceCoverage sourceCoverage : this.coverage) {
            Source source = sourceCoverage.getSource();
            String name = CoverageCLI.getName(source);
            this.printLine();
            this.printSummaryHeader();
            LineCoverage lineCoverage = new LineCoverage(sourceCoverage, this.strictLines);
            this.out.println(String.format(this.format, name, CoverageCLI.statementCoverage(sourceCoverage), CoverageCLI.lineCoverage(lineCoverage), CoverageCLI.rootCoverage(sourceCoverage)));
            this.out.println();
            if (source.hasCharacters() || source.hasBytes()) {
                this.printLinesOfSource(source, lineCoverage);
                continue;
            }
            this.out.println("NO CONTENT AVAILABLE");
        }
        this.printLine();
    }

    private void printLinesOfSource(Source source, LineCoverage lineCoverage) {
        for (int i = 1; i <= source.getLineCount(); ++i) {
            char covered = lineCoverage.getStatementCoverageCharacter(i);
            this.out.println(String.format("%s %s", Character.valueOf(covered), source.getCharacters(i)));
        }
    }

    private void printLinesLegend() {
        this.out.println("Code coverage per line of code and what percent of each element was covered during execution (per source)");
        this.out.println("  + indicates the line is covered during execution");
        this.out.println("  - indicates the line is not covered during execution");
        if (this.strictLines) {
            this.out.println("  p indicates the line is part of a statement that was incidentally covered during execution");
            this.out.println("    e.g. a not-taken branch of a covered if statement");
        }
    }

    void printHistogramOutput() {
        this.printLine();
        this.out.println("Code coverage histogram.");
        this.out.println("  Shows what percent of each element was covered during execution");
        this.printLine();
        this.printSummaryHeader();
        this.printLine();
        for (SourceCoverage sourceCoverage : this.coverage) {
            String name = CoverageCLI.getName(sourceCoverage.getSource());
            String line = String.format(this.format, name, CoverageCLI.statementCoverage(sourceCoverage), CoverageCLI.lineCoverage(new LineCoverage(sourceCoverage, this.strictLines)), CoverageCLI.rootCoverage(sourceCoverage));
            this.out.println(line);
        }
        this.printLine();
    }

    private void sortCoverage() {
        Arrays.sort(this.coverage, new Comparator<SourceCoverage>(){

            @Override
            public int compare(SourceCoverage o1, SourceCoverage o2) {
                return CoverageCLI.getName(o1.getSource()).compareTo(CoverageCLI.getName(o2.getSource()));
            }
        });
    }

    private void printSummaryHeader() {
        this.out.println(this.summaryHeader);
    }

    private void printLine() {
        this.out.println(String.format("%" + this.summaryHeaderLen + "s", "").replace(' ', '-'));
    }
}

