/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.tool.Assemble;
import jdk.jfr.internal.tool.Disassemble;
import jdk.jfr.internal.tool.Help;
import jdk.jfr.internal.tool.Metadata;
import jdk.jfr.internal.tool.Print;
import jdk.jfr.internal.tool.Summary;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;
import jdk.jfr.internal.tool.Version;

abstract class Command {
    public static final String title = "Tool for working with Flight Recorder files (.jfr)";
    private static final Command HELP = new Help();
    private static final List<Command> COMMANDS = Command.createCommands();

    Command() {
    }

    private static List<Command> createCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(new Print());
        arrayList.add(new Metadata());
        arrayList.add(new Summary());
        arrayList.add(new Assemble());
        arrayList.add(new Disassemble());
        arrayList.add(new Version());
        arrayList.add(HELP);
        return Collections.unmodifiableList(arrayList);
    }

    static void displayHelp() {
        System.out.println(title);
        System.out.println();
        Command.displayAvailableCommands(System.out);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract void execute(Deque<String> var1) throws UserSyntaxException, UserDataException;

    protected String getTitle() {
        return this.getDescription();
    }

    static void displayAvailableCommands(PrintStream printStream) {
        boolean bl = true;
        for (Command command : COMMANDS) {
            if (!bl) {
                System.out.println();
            }
            Command.displayCommand(printStream, command);
            printStream.println("     " + command.getDescription());
            bl = false;
        }
    }

    protected static void displayCommand(PrintStream printStream, Command command) {
        boolean bl = true;
        String string = Command.buildAlias(command);
        String string2 = " jfr " + command.getName();
        for (String string3 : command.getOptionSyntax()) {
            if (bl) {
                if (string3.length() != 0) {
                    printStream.println(string2 + " " + string3 + string);
                } else {
                    printStream.println(string2 + string);
                }
            } else {
                for (int i = 0; i < string2.length(); ++i) {
                    printStream.print(" ");
                }
                printStream.println(" " + string3);
            }
            bl = false;
        }
    }

    private static String buildAlias(Command command) {
        List<String> list = command.getAliases();
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() == 1) {
            stringBuilder.append(" (alias ");
            stringBuilder.append(list.get(0));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        stringBuilder.append(" (aliases ");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static List<Command> getCommands() {
        return COMMANDS;
    }

    public static Command valueOf(String string) {
        for (Command command : COMMANDS) {
            if (!command.getName().equals(string)) continue;
            return command;
        }
        return null;
    }

    public List<String> getOptionSyntax() {
        return Collections.singletonList("");
    }

    public void displayOptionUsage(PrintStream printStream) {
    }

    protected boolean acceptOption(Deque<String> deque, String string) throws UserSyntaxException {
        if (string.equals(deque.peek())) {
            if (deque.size() < 2) {
                throw new UserSyntaxException("missing value for " + deque.peek());
            }
            deque.remove();
            return true;
        }
        return false;
    }

    protected void warnForWildcardExpansion(String string, String string2) throws UserDataException {
        try {
            Path path;
            if (!string2.contains(File.pathSeparator) && !Files.exists(path = Paths.get(".", string2), new LinkOption[0])) {
                return;
            }
            throw new UserDataException("wildcards should be quoted, for example " + string + " \"Foo*\"");
        }
        catch (InvalidPathException invalidPathException) {
            return;
        }
    }

    protected boolean acceptFilterOption(Deque<String> deque, String string) throws UserSyntaxException {
        if (!this.acceptOption(deque, string)) {
            return false;
        }
        if (deque.isEmpty()) {
            throw new UserSyntaxException("missing filter after " + string);
        }
        String string2 = deque.peek();
        if (string2.startsWith("--")) {
            throw new UserSyntaxException("missing filter after " + string);
        }
        return true;
    }

    protected final void ensureMaxArgumentCount(Deque<String> deque, int n) throws UserSyntaxException {
        if (deque.size() > n) {
            throw new UserSyntaxException("too many arguments");
        }
    }

    protected final void ensureMinArgumentCount(Deque<String> deque, int n) throws UserSyntaxException {
        if (deque.size() < n) {
            throw new UserSyntaxException("too few arguments");
        }
    }

    protected final Path getDirectory(String string) throws UserDataException {
        try {
            Path path = Paths.get(string, new String[0]).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                throw new UserDataException("directory does not exist, " + string);
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new UserDataException("path must be directory, " + string);
            }
            return path;
        }
        catch (InvalidPathException invalidPathException) {
            throw new UserDataException("invalid path '" + string + "'");
        }
    }

    protected final Path getJFRInputFile(Deque<String> deque) throws UserSyntaxException, UserDataException {
        if (deque.isEmpty()) {
            throw new UserSyntaxException("missing file");
        }
        String string = deque.removeLast();
        if (string.startsWith("--")) {
            throw new UserSyntaxException("missing file");
        }
        try {
            Path path = Paths.get(string, new String[0]).toAbsolutePath();
            this.ensureAccess(path);
            this.ensureJFRFile(path);
            return path;
        }
        catch (IOError iOError) {
            throw new UserDataException("i/o error reading file '" + string + "', " + iOError.getMessage());
        }
        catch (InvalidPathException invalidPathException) {
            throw new UserDataException("invalid path '" + string + "'");
        }
    }

    private void ensureAccess(Path path) throws UserDataException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "r");){
            if (randomAccessFile.length() == 0L) {
                throw new UserDataException("file is empty '" + path + "'");
            }
            randomAccessFile.read();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UserDataException("could not find file '" + path + "'");
        }
        catch (IOException iOException) {
            throw new UserDataException("i/o error reading file '" + path + "', " + iOException.getMessage());
        }
    }

    protected final void couldNotReadError(Path path, IOException iOException) throws UserDataException {
        throw new UserDataException("could not read recording at " + path.toAbsolutePath() + ". " + iOException.getMessage());
    }

    protected final Path ensureFileDoesNotExist(Path path) throws UserDataException {
        if (Files.exists(path, new LinkOption[0])) {
            throw new UserDataException("file '" + path + "' already exists");
        }
        return path;
    }

    protected final void ensureJFRFile(Path path) throws UserDataException {
        if (!path.toString().endsWith(".jfr")) {
            throw new UserDataException("filename must end with '.jfr'");
        }
    }

    protected void displayUsage(PrintStream printStream) {
        Command.displayCommand(printStream, this);
        printStream.println();
        this.displayOptionUsage(printStream);
    }

    protected final void println() {
        System.out.println();
    }

    protected final void print(String string) {
        System.out.print(string);
    }

    protected final void println(String string) {
        System.out.println(string);
    }

    protected final boolean matches(String string) {
        for (String string2 : this.getNames()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getAliases() {
        return Collections.emptyList();
    }

    public List<String> getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getName());
        arrayList.addAll(this.getAliases());
        return arrayList;
    }
}

