/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.javaext;

import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.javaext.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TerminalJavaNodes;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

public class TruffleReferencesProvider
extends HeapViewerNode.Provider {
    public String getName() {
        return Bundle.TruffleReferencesProvider_Name();
    }

    public boolean supportsView(Heap heap, String viewID) {
        return viewID.equals("truffle_objects_javaext");
    }

    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        if (parent instanceof InstanceNode && !(parent instanceof DynamicObjectFieldNode)) {
            InstanceNode node = (InstanceNode)parent;
            if (InstanceNode.Mode.OUTGOING_REFERENCE.equals((Object)node.getMode())) {
                return false;
            }
            Instance instance = node.getInstance();
            return DynamicObject.isDynamicObject(instance);
        }
        return false;
    }

    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        return TruffleReferencesProvider.getNodes(this.getReferences(parent, heap), parent, heap, viewID, dataTypes, sortOrders, progress);
    }

    static HeapViewerNode[] getNodes(final List<FieldValue> references, HeapViewerNode parent, final Heap heap, String viewID, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        if (references == null) {
            return null;
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(references.size(), UIThresholds.MAX_INSTANCE_REFERENCES){

            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            protected HeapViewerNode createNode(Integer index) {
                return TruffleReferencesProvider.createNode((FieldValue)references.get(index), heap);
            }

            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator iterator = 1.integerIterator((int)index, (int)references.size());
                return new ProgressIterator(iterator, index, false, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.TruffleReferencesProvider_MoreNodes(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.TruffleReferencesProvider_SamplesContainer(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.TTruffleReferencesProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    private static HeapViewerNode createNode(FieldValue field, Heap heap) {
        Instance instance = field.getDefiningInstance();
        if (DynamicObject.isDynamicObject(instance)) {
            DynamicObject dobject = new DynamicObject(instance);
            return new DynamicObjectReferenceNode<DynamicObject>(dobject, dobject.getType(heap), field);
        }
        return TerminalJavaNodes.incomingReference((Value)field);
    }

    protected List<FieldValue> getReferences(HeapViewerNode parent, Heap heap) {
        Instance instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)parent, (DataType)DataType.INSTANCE, (Heap)heap);
        if (DynamicObject.isDynamicObject(instance)) {
            DynamicObject dobject = new DynamicObject(instance);
            return dobject.getReferences();
        }
        return null;
    }
}

