/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.CompilationContext;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.BufferUtil;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntimeInstance;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleDebugContextImpl;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilationTask;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerListener;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.LibGraalObjectHandles;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.FromLibGraalCalls;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class TruffleToLibGraalEntryPoints {
    TruffleToLibGraalEntryPoints() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.InitializeRuntime)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_initializeRuntime")
    public static long initializeRuntime(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JObject truffleRuntime, long classLoaderDelegateId) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.InitializeRuntime, env);){
            long truffleRuntimeHandle;
            ResolvedJavaType classLoaderDelegate = (ResolvedJavaType)LibGraal.unhand(ResolvedJavaType.class, (long)classLoaderDelegateId);
            HSTruffleCompilerRuntime hsTruffleRuntime = new HSTruffleCompilerRuntime(env, truffleRuntime, classLoaderDelegate, HotSpotGraalOptionValues.defaultOptions());
            TruffleCompilerRuntimeInstance.initialize((TruffleCompilerRuntime)hsTruffleRuntime);
            long l = truffleRuntimeHandle = LibGraalObjectHandles.create((Object)hsTruffleRuntime);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.NewCompiler)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_newCompiler")
    public static long newCompiler(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long truffleRuntimeHandle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.NewCompiler, env);){
            HSTruffleCompilerRuntime hsTruffleRuntime = LibGraalObjectHandles.resolve(truffleRuntimeHandle, HSTruffleCompilerRuntime.class);
            long l = LibGraalObjectHandles.create(HotSpotTruffleCompilerImpl.create((TruffleCompilerRuntime)hsTruffleRuntime));
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.InitializeCompiler)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_initializeCompiler")
    public static void initializeCompiler(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilerHandle, JNI.JByteArray hsOptions, JNI.JObject hsCompilable, boolean firstInitialization) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.InitializeCompiler, env);){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(compilerHandle, HotSpotTruffleCompilerImpl.class);
            Map<String, Object> options = TruffleToLibGraalEntryPoints.decodeOptions(env, hsOptions);
            HSCompilableTruffleAST compilable = new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)s, hsCompilable);
            compiler.initialize(options, (CompilableTruffleAST)compilable, firstInitialization);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetCompilerConfigurationFactoryName)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getCompilerConfigurationFactoryName")
    public static JNI.JString getCompilerConfigurationFactoryName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long truffleRuntimeHandle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetCompilerConfigurationFactoryName, env);
        try (JNILibGraalScope s = scope;){
            HSTruffleCompilerRuntime hsTruffleRuntime = LibGraalObjectHandles.resolve(truffleRuntimeHandle, HSTruffleCompilerRuntime.class);
            assert (TruffleCompilerRuntime.getRuntime() == hsTruffleRuntime);
            OptionValues options = TruffleCompilerOptions.getOptions();
            CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory((String)((String)HotSpotTruffleCompilerImpl.Options.TruffleCompilerConfiguration.getValue(options)), (OptionValues)options);
            String name = compilerConfigurationFactory.getName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.OpenCompilation)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_openCompilation")
    public static long openCompilation(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JObject hsCompilable) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.OpenCompilation, env);
        try (JNILibGraalScope s = scope;){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            HSCompilableTruffleAST compilable = new HSCompilableTruffleAST(env, hsCompilable);
            TruffleCompilation compilation = compiler.openCompilation((CompilableTruffleAST)compilable);
            assert (compilation instanceof TruffleCompilationIdentifier);
            long l = LibGraalObjectHandles.create(compilation);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetCompilerConfigurationName)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getCompilerConfigurationName")
    public static JNI.JString getCompilerConfigurationName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateId, long handle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetCompilerConfigurationName, env);
        try (JNILibGraalScope s = scope;){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            String name = compiler.getCompilerConfigurationName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.DoCompile)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_doCompile")
    public static void doCompile(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilerHandle, long debugContextHandle, long compilationHandle, JNI.JByteArray hsOptions, JNI.JObject hsInlining, JNI.JObject hsTask, JNI.JObject hsListener) {
        try (JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.DoCompile, env);){
            TruffleCompilationIdentifier compilation = LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class);
            try (CompilationContext hotSpotObjectConstantScope = HotSpotGraalServices.openLocalCompilationContext((Object)compilation);){
                HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(compilerHandle, HotSpotTruffleCompilerImpl.class);
                TruffleDebugContext debugContext = LibGraalObjectHandles.resolve(debugContextHandle, TruffleDebugContext.class);
                Map<String, Object> options = TruffleToLibGraalEntryPoints.decodeOptions(env, hsOptions);
                HSTruffleInliningPlan inlining = new HSTruffleInliningPlan((JNILibGraalScope<TruffleToLibGraal.Id>)scope, hsInlining);
                HSTruffleCompilationTask task = hsTask.isNull() ? null : new HSTruffleCompilationTask((JNILibGraalScope<TruffleToLibGraal.Id>)scope, hsTask);
                HSTruffleCompilerListener listener = hsListener.isNull() ? null : new HSTruffleCompilerListener((JNILibGraalScope<TruffleToLibGraal.Id>)scope, hsListener);
                compiler.doCompile(debugContext, (TruffleCompilation)compilation, options, (TruffleInliningPlan)inlining, (TruffleCompilationTask)task, (TruffleCompilerListener)listener);
            }
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.CloseCompilation)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_closeCompilation")
    public static void closeCompilation(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        try (JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.CloseCompilation, env);){
            TruffleCompilation compilation = LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilation.class);
            HSCompilableTruffleAST compilable = (HSCompilableTruffleAST)compilation.getCompilable();
            compilable.release(env);
            HSObject.cleanHandles((JNI.JNIEnv)env);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.Shutdown)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_shutdown")
    public static void shutdown(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.Shutdown, env);){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            compiler.shutdown();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.InstallTruffleCallBoundaryMethods)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_installTruffleCallBoundaryMethods")
    public static void installTruffleCallBoundaryMethods(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JObject hsCompilable) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.InstallTruffleCallBoundaryMethods, env);){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            HSCompilableTruffleAST compilable = new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)s, hsCompilable);
            compiler.installTruffleCallBoundaryMethods((CompilableTruffleAST)compilable);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.PendingTransferToInterpreterOffset)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_pendingTransferToInterpreterOffset")
    public static int pendingTransferToInterpreterOffset(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JObject hsCompilable) {
        try (JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.PendingTransferToInterpreterOffset, env);){
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            HSCompilableTruffleAST compilable = new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)scope, hsCompilable);
            int n = compiler.pendingTransferToInterpreterOffset((CompilableTruffleAST)compilable);
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetGraphDumpDirectory)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getGraphDumpDirectory")
    public static JNI.JString getGraphDumpDirectory(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetGraphDumpDirectory, env);
        try (JNILibGraalScope s = scope;){
            Path path = DebugOptions.getDumpDirectory((OptionValues)HotSpotGraalOptionValues.defaultOptions());
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)path.toString()));
        }
        catch (IOException ioe) {
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetInitialOptions)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getInitialOptions")
    public static JNI.JByteArray getInitialOptions(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long truffleRuntimeHandle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetInitialOptions, env);
        try (JNILibGraalScope s = scope;){
            HSTruffleCompilerRuntime hsTruffleRuntime = LibGraalObjectHandles.resolve(truffleRuntimeHandle, HSTruffleCompilerRuntime.class);
            Map<String, Object> allOptions = hsTruffleRuntime.getOptions();
            HashMap<String, Object> options = new HashMap<String, Object>();
            for (Map.Entry<String, Object> option : allOptions.entrySet()) {
                String key = option.getKey();
                Object value = option.getValue();
                if (!OptionsEncoder.isValueSupported((Object)value)) continue;
                options.put(key, value);
            }
            byte[] serializedOptions = OptionsEncoder.encode(options);
            JNI.JByteArray hsSerializedOptions = JNIUtil.NewByteArray((JNI.JNIEnv)env, (int)serializedOptions.length);
            CCharPointer cdata = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            for (int i = 0; i < serializedOptions.length; ++i) {
                cdata.write(i, serializedOptions[i]);
            }
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (CCharPointer)cdata, (int)0);
            scope.setObjectResult((JNI.JObject)hsSerializedOptions);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> decodeOptions(JNI.JNIEnv env, JNI.JByteArray hsOptions) {
        Map options;
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)hsOptions);
        CCharPointer optionsCPointer = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsOptions, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            byte[] optionsBuffer = new byte[len];
            CTypeConversion.asByteBuffer((PointerBase)optionsCPointer, (int)len).get(optionsBuffer);
            options = OptionsEncoder.decode((byte[])optionsBuffer);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsOptions, (CCharPointer)optionsCPointer, (int)2);
        }
        return options;
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetSuppliedString)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getSuppliedString")
    public static JNI.JString getString(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetSuppliedString, env);
        try (JNILibGraalScope s = scope;){
            Supplier orig = LibGraalObjectHandles.resolve(handle, Supplier.class);
            if (orig != null) {
                String stackTrace = (String)orig.get();
                scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)stackTrace));
            } else {
                scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetNodeCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getNodeCount")
    public static int getNodeCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetNodeCount, env);){
            TruffleCompilerListener.GraphInfo orig = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.GraphInfo.class);
            int n = orig.getNodeCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetNodeTypes)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getNodeTypes")
    public static JNI.JObjectArray getNodeTypes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, boolean simpleNames) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetNodeTypes, env);
        try (JNILibGraalScope s = scope;){
            TruffleCompilerListener.GraphInfo orig = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.GraphInfo.class);
            String[] nodeTypes = orig.getNodeTypes(simpleNames);
            JNI.JClass componentType = FromLibGraalCalls.getJNIClass((JNI.JNIEnv)env, String.class);
            JNI.JObjectArray res = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)nodeTypes.length, (JNI.JClass)componentType, (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
            for (int i = 0; i < nodeTypes.length; ++i) {
                JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)res, (int)i, (JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)nodeTypes[i]));
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JObjectArray)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetTargetCodeSize)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getTargetCodeSize")
    public static int getTargetCodeSize(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetTargetCodeSize, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getTargetCodeSize();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetTotalFrameSize)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getTotalFrameSize")
    public static int getTotalFrameSize(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetTotalFrameSize, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getTotalFrameSize();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetExceptionHandlersCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getExceptionHandlersCount")
    public static int getExceptionHandlersCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetExceptionHandlersCount, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getExceptionHandlersCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetInfopointsCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getInfopointsCount")
    public static int getInfopointsCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetInfopointsCount, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getInfopointsCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetInfopoints)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getInfopoints")
    public static JNI.JObjectArray getInfopoints(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetInfopoints, env);
        try (JNILibGraalScope s = scope;){
            String[] infoPoints = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getInfopoints();
            JNI.JClass componentType = FromLibGraalCalls.getJNIClass((JNI.JNIEnv)env, String.class);
            JNI.JObjectArray res = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)infoPoints.length, (JNI.JClass)componentType, (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
            for (int i = 0; i < infoPoints.length; ++i) {
                JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)res, (int)i, (JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)infoPoints[i]));
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JObjectArray)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetMarksCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getMarksCount")
    public static int getMarksCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetMarksCount, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getMarksCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetDataPatchesCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getDataPatchesCount")
    public static int getDataPatchesCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetDataPatchesCount, env);){
            int n = LibGraalObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getDataPatchesCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.OpenDebugContext)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_openDebugContext")
    public static long openDebugContext(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilerHandle, long compilationHandle, JNI.JByteArray hsOptions) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.OpenDebugContext, env);){
            long handle;
            HotSpotTruffleCompilerImpl compiler = LibGraalObjectHandles.resolve(compilerHandle, HotSpotTruffleCompilerImpl.class);
            TruffleCompilation compilation = LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilation.class);
            Map<String, Object> options = TruffleToLibGraalEntryPoints.decodeOptions(env, hsOptions);
            TruffleDebugContext debugContext = compiler.openDebugContext(options, compilation);
            long l = handle = LibGraalObjectHandles.create(debugContext);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.OpenDebugContextScope)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_openDebugContextScope")
    public static long openDebugContextScope(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JString hsName, long compilationHandle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.OpenDebugContextScope, env);){
            long scopeHandle;
            AutoCloseable scope;
            TruffleDebugContext debugContext = LibGraalObjectHandles.resolve(handle, TruffleDebugContext.class);
            String name = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)hsName);
            if (compilationHandle == 0L) {
                scope = debugContext.scope(name);
            } else {
                TruffleCompilationIdentifier compilation222 = LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class);
                scope = debugContext.scope(name, (Object)new TruffleDebugJavaMethod(compilation222.getCompilable()));
            }
            if (scope == null) {
                long compilation222 = 0L;
                return compilation222;
            }
            long l = scopeHandle = LibGraalObjectHandles.create(scope);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.CloseDebugContext)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_closeDebugContext")
    public static void closeDebugContext(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.CloseDebugContext, env);){
            TruffleDebugContext debugContext = LibGraalObjectHandles.resolve(handle, TruffleDebugContext.class);
            debugContext.close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.CloseDebugContextScope)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_closeDebugContextScope")
    public static void closeDebugContextScope(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.CloseDebugContextScope, env);){
            AutoCloseable scope = (AutoCloseable)LibGraalObjectHandles.resolve(handle, DebugContext.Scope.class);
            scope.close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.IsBasicDumpEnabled)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_isBasicDumpEnabled")
    public static boolean isBasicDumpEnabled(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.IsBasicDumpEnabled, env);){
            TruffleDebugContext debugContext = LibGraalObjectHandles.resolve(handle, TruffleDebugContext.class);
            boolean bl = debugContext.isDumpEnabled();
            return bl;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return false;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetTruffleCompilationTruffleAST)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getTruffleCompilationTruffleAST")
    public static JNI.JObject getTruffleCompilationTruffleAST(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetTruffleCompilationTruffleAST, env);
        try (JNILibGraalScope s = scope;){
            HSCompilableTruffleAST compilable = (HSCompilableTruffleAST)LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilation.class).getCompilable();
            scope.setObjectResult(compilable.getHandle());
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return scope.getObjectResult();
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetTruffleCompilationId)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getTruffleCompilationId")
    public static JNI.JString getTruffleCompilationId(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetTruffleCompilationId, env);
        try (JNILibGraalScope s = scope;){
            String compilationId = LibGraalObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class).toString(CompilationIdentifier.Verbosity.ID);
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)compilationId));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetDumpChannel)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getDumpChannel")
    public static long getDumpChannel(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long debugContextHandle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetDumpChannel, env);){
            TruffleDebugContextImpl debugContext = LibGraalObjectHandles.resolve(debugContextHandle, TruffleDebugContextImpl.class);
            GraphOutput graphOutput = debugContext.buildOutput(GraphOutput.newBuilder((GraphStructure)VoidGraphStructure.INSTANCE));
            long l = LibGraalObjectHandles.create(graphOutput);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return 0L;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetVersionProperties)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getVersionProperties")
    public static JNI.JByteArray getVersionProperties(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetVersionProperties, env);
        try (JNILibGraalScope s = scope;){
            HashMap versionProperties = new HashMap();
            for (Map.Entry e : DebugContext.addVersionProperties(null).entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                assert (key instanceof String);
                assert (value instanceof String);
                versionProperties.put((String)key, value);
            }
            byte[] serializedProperties = OptionsEncoder.encode(versionProperties);
            JNI.JByteArray hsSerializedOptions = JNIUtil.NewByteArray((JNI.JNIEnv)env, (int)serializedProperties.length);
            CCharPointer cdata = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            CTypeConversion.asByteBuffer((PointerBase)cdata, (int)serializedProperties.length).put(serializedProperties);
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (CCharPointer)cdata, (int)0);
            scope.setObjectResult((JNI.JObject)hsSerializedOptions);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.IsDumpChannelOpen)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_isDumpChannelOpen")
    public static boolean isDumpChannelOpen(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.IsDumpChannelOpen, env);){
            boolean bl = LibGraalObjectHandles.resolve(channelHandle, WritableByteChannel.class).isOpen();
            return bl;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.DumpChannelWrite)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_dumpChannelWrite")
    public static int dumpChannelWrite(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle, JNI.JObject hsSource, int capacity, int position, int limit) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.DumpChannelWrite, env);){
            WritableByteChannel channel = LibGraalObjectHandles.resolve(channelHandle, WritableByteChannel.class);
            VoidPointer baseAddr = JNIUtil.GetDirectBufferAddress((JNI.JNIEnv)env, (JNI.JObject)hsSource);
            ByteBuffer source = CTypeConversion.asByteBuffer((PointerBase)baseAddr, (int)capacity);
            Buffer baseBuffer = BufferUtil.asBaseBuffer((Buffer)source);
            baseBuffer.position(position);
            baseBuffer.limit(limit);
            int n = channel.write(source);
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            return -1;
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.DumpChannelClose)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_dumpChannelClose")
    public static void dumpChannelClose(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.IsDumpChannelOpen, env);){
            LibGraalObjectHandles.resolve(channelHandle, WritableByteChannel.class).close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.TtyWriteByte)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_ttyWriteByte")
    public static void ttyWriteByte(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, int b) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.TtyWriteByte, env);){
            TTY.out.write(b);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TruffleToLibGraal(value=TruffleToLibGraal.Id.TtyWriteBytes)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_ttyWriteBytes")
    public static void ttyWriteBytes(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JByteArray array, int off, int len) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.TtyWriteBytes, env);){
            int arrayLen = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)array);
            CCharPointer arrayPointer = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)array, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            try {
                byte[] buf = new byte[arrayLen];
                CTypeConversion.asByteBuffer((PointerBase)arrayPointer, (int)arrayLen).get(buf);
                TTY.out.write(buf, off, len);
            }
            finally {
                JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)array, (CCharPointer)arrayPointer, (int)2);
            }
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
        }
    }

    @TruffleToLibGraal(value=TruffleToLibGraal.Id.GetExecutionID)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_TruffleToLibGraalCalls_getExecutionID")
    public static JNI.JString getExecutionID(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        JNILibGraalScope scope = new JNILibGraalScope((Enum)TruffleToLibGraal.Id.GetExecutionID, env);
        try (JNILibGraalScope s = scope;){
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)GraalServices.getExecutionID()));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot((JNI.JNIEnv)env, (Throwable)t);
            scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
        }
        return (JNI.JString)scope.getObjectResult();
    }

    static {
        try {
            Class<?> callsClass = Class.forName("org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls");
            JNIUtil.checkToLibGraalCalls(TruffleToLibGraalEntryPoints.class, callsClass, TruffleToLibGraal.class);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }
}

