/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.io.Closeable;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerListenerGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.LibGraalObjectHandles;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSTruffleCompilerListener
extends HSObject
implements TruffleCompilerListener {
    HSTruffleCompilerListener(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnSuccess)
    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject hsInliningPlan = ((HSTruffleInliningPlan)inliningPlan).getHandle();
        JNI.JNIEnv env = JNILibGraalScope.env();
        try (LibGraalObjectHandleScope graphInfoScope = LibGraalObjectHandleScope.forObject(graphInfo);
             LibGraalObjectHandleScope compilationResultInfoScope = LibGraalObjectHandleScope.forObject(compilationResultInfo);){
            HSTruffleCompilerListenerGen.callOnSuccess(env, this.getHandle(), hsCompilable, hsInliningPlan, graphInfoScope.getHandle(), compilationResultInfoScope.getHandle());
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnTruffleTierFinished)
    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject hsInliningPlan = ((HSTruffleInliningPlan)inliningPlan).getHandle();
        JNI.JNIEnv env = JNILibGraalScope.env();
        try (LibGraalObjectHandleScope graphInfoScope = LibGraalObjectHandleScope.forObject(graph);){
            HSTruffleCompilerListenerGen.callOnTruffleTierFinished(env, this.getHandle(), hsCompilable, hsInliningPlan, graphInfoScope.getHandle());
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnGraalTierFinished)
    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JNIEnv env = JNILibGraalScope.env();
        try (LibGraalObjectHandleScope graphInfoScope = LibGraalObjectHandleScope.forObject(graph);){
            HSTruffleCompilerListenerGen.callOnGraalTierFinished(env, this.getHandle(), hsCompilable, graphInfoScope.getHandle());
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnFailure)
    public void onFailure(CompilableTruffleAST compilable, String serializedException, boolean bailout, boolean permanentBailout) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JString hsReason = JNIUtil.createHSString((JNI.JNIEnv)env, (String)serializedException);
        HSTruffleCompilerListenerGen.callOnFailure(env, this.getHandle(), hsCompilable, (JNI.JObject)hsReason, bailout, permanentBailout);
    }

    private static final class LibGraalObjectHandleScope
    implements Closeable {
        private long handle;

        private LibGraalObjectHandleScope(long handle) {
            this.handle = handle;
        }

        @Override
        public void close() {
            LibGraalObjectHandles.remove(this.handle);
            this.handle = 0L;
        }

        long getHandle() {
            if (this.handle == 0L) {
                throw new IllegalStateException("Reading handle from a closed scope.");
            }
            return this.handle;
        }

        static LibGraalObjectHandleScope forObject(Object object) {
            return new LibGraalObjectHandleScope(LibGraalObjectHandles.create(object));
        }
    }
}

