/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.home.HomeFinder;

public class LLVMToolchain {
    public static String runLLVMCommand(String command, Path directory, String ... args) throws RunFailureException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(LLVMToolchain.getLLVMBinDir().resolve(command).toString());
        Collections.addAll(cmd, args);
        return LLVMToolchain.runCommand(directory, cmd);
    }

    public static String runLLVMCommand(String command, Path directory, List<String> args) throws RunFailureException {
        ArrayList<String> cmd = new ArrayList<String>(args);
        cmd.add(0, LLVMToolchain.getLLVMBinDir().resolve(command).toString());
        return LLVMToolchain.runCommand(directory, cmd);
    }

    public static String runCommand(Path directory, List<String> cmd) throws RunFailureException {
        String output;
        int status;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            if (directory != null) {
                pb.directory(directory.toFile());
            }
            Process p = pb.start();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)os);
            status = p.waitFor();
            output = ((Object)os).toString().trim();
        }
        catch (IOException | InterruptedException e) {
            status = -1;
            output = e.getMessage();
        }
        if (status != 0) {
            throw new RunFailureException(status, output);
        }
        return output;
    }

    private static Path getLLVMBinDir() {
        String property = System.getProperty("llvm.bin.dir");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        Path runtimeDir = HomeFinder.getInstance().getHomeFolder();
        if (runtimeDir == null) {
            throw new IllegalStateException("Could not find GraalVM home");
        }
        if (System.getProperty("java.specification.version").startsWith("1.")) {
            runtimeDir = runtimeDir.resolve("jre");
        }
        return runtimeDir.resolve("lib").resolve("llvm").resolve("bin");
    }

    public static final class RunFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int status;
        private String output;

        private RunFailureException(int status, String output) {
            this.status = status;
            this.output = output;
        }

        public int getStatus() {
            return this.status;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

