/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.llvm.util.LLVMTargetSpecific;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
class LLVMAArch64TargetSpecificFeature
implements Feature {
    private static final int AARCH64_FP_IDX = 29;
    private static final int AARCH64_SP_IDX = 31;

    LLVMAArch64TargetSpecificFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.useLLVMBackend();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(LLVMTargetSpecific.class, (Object)new LLVMTargetSpecific(){

            @Override
            public String getRegisterInlineAsm(String register) {
                return "MOV $0, " + this.getLLVMRegisterName(register);
            }

            @Override
            public String getJumpInlineAsm() {
                return "BR $0";
            }

            @Override
            public String getLLVMArchName() {
                return "aarch64";
            }

            @Override
            public int getCallFrameSeparation() {
                return 0;
            }

            @Override
            public int getFramePointerOffset() {
                return -2 * FrameAccess.wordSize();
            }

            @Override
            public int getStackPointerDwarfRegNum() {
                return 31;
            }

            @Override
            public int getFramePointerDwarfRegNum() {
                return 29;
            }

            @Override
            public List<String> getLLCAdditionalOptions() {
                return Collections.singletonList("--frame-pointer=all");
            }

            @Override
            public String getLLVMRegisterName(String register) {
                return register.replace("r", "x");
            }
        });
    }
}

