/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.replacements;

import com.oracle.svm.core.graal.llvm.replacements.LLVMBinaryIntrinsicNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMUnaryIntrinsicNode;
import java.lang.reflect.Type;
import java.util.Arrays;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.AtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.BitCountNode;
import org.graalvm.compiler.replacements.nodes.FusedMultiplyAddNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import sun.misc.Unsafe;

public class LLVMGraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    public void register(GraphBuilderConfiguration.Plugins plugins, final Replacements replacements, Architecture arch, final boolean explicitUnsafeNullChecks, boolean registerMathPlugins, boolean emitJDK9StringSubstitutions, boolean useFMAIntrinsics) {
        final InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                LLVMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int, replacements);
                LLVMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long, replacements);
                StandardGraphBuilderPlugins.registerPlatformSpecificUnsafePlugins((InvocationPlugins)invocationPlugins, (Replacements)replacements, (boolean)explicitUnsafeNullChecks, (JavaKind[])new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object, JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Char, JavaKind.Float, JavaKind.Double});
                LLVMGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, replacements, explicitUnsafeNullChecks);
                LLVMGraphBuilderPlugins.registerMathPlugins(invocationPlugins, replacements);
            }
        });
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, JavaKind kind, Replacements replacements) {
        Class declaringClass = kind.toBoxedJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)declaringClass, replacements);
        LLVMGraphBuilderPlugins.registerUnaryLLVMIntrinsic(r, "numberOfLeadingZeros", LLVMIntrinsicNode.LLVMIntrinsicOperation.CTLZ, JavaKind.Int, kind.toJavaClass());
        LLVMGraphBuilderPlugins.registerUnaryLLVMIntrinsic(r, "numberOfTrailingZeros", LLVMIntrinsicNode.LLVMIntrinsicOperation.CTTZ, JavaKind.Int, kind.toJavaClass());
        r.register1("bitCount", (Type)kind.toJavaClass(), new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new BitCountNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Math.class, replacements);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
        LLVMGraphBuilderPlugins.registerBinaryMath(r, "pow", BinaryMathIntrinsicNode.BinaryOperation.POW);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
        LLVMGraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
        LLVMGraphBuilderPlugins.registerUnaryLLVMIntrinsic(r, "ceil", LLVMIntrinsicNode.LLVMIntrinsicOperation.CEIL, JavaKind.Double, Double.TYPE);
        LLVMGraphBuilderPlugins.registerUnaryLLVMIntrinsic(r, "floor", LLVMIntrinsicNode.LLVMIntrinsicOperation.FLOOR, JavaKind.Double, Double.TYPE);
        for (JavaKind kind : Arrays.asList(JavaKind.Float, JavaKind.Double)) {
            LLVMGraphBuilderPlugins.registerBinaryLLVMIntrinsic(r, "copySign", LLVMIntrinsicNode.LLVMIntrinsicOperation.COPYSIGN, kind, kind.toJavaClass(), kind.toJavaClass());
        }
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            LLVMGraphBuilderPlugins.registerFMA(r);
        }
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register1(name, Double.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(UnaryMathIntrinsicNode.create((ValueNode)value, (UnaryMathIntrinsicNode.UnaryOperation)operation)));
                return true;
            }
        });
    }

    private static void registerBinaryMath(InvocationPlugins.Registration r, String name, final BinaryMathIntrinsicNode.BinaryOperation operation) {
        r.register2(name, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, b.append(BinaryMathIntrinsicNode.create((ValueNode)x, (ValueNode)y, (BinaryMathIntrinsicNode.BinaryOperation)operation)));
                return true;
            }
        });
    }

    private static void registerFMA(InvocationPlugins.Registration r) {
        r.register3("fma", Double.TYPE, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Double, b.append((ValueNode)new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
        r.register3("fma", Float.TYPE, Float.TYPE, Float.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Float, b.append((ValueNode)new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, Replacements replacements, boolean explicitUnsafeNullChecks) {
        LLVMGraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, Unsafe.class), explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object}, true);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            LLVMGraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements), explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Object}, JavaVersionUtil.JAVA_SPEC <= 11);
        }
    }

    private static void registerUnsafePlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks, JavaKind[] unsafeJavaKinds, boolean java11OrEarlier) {
        Class javaClass;
        for (final JavaKind kind : unsafeJavaKinds) {
            javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            String kindName = kind == JavaKind.Object && !java11OrEarlier ? "Reference" : kind.name();
            r.register4("getAndSet" + kindName, InvocationPlugin.Receiver.class, Object.class, Long.TYPE, (Type)javaClass, (InvocationPlugin)new StandardGraphBuilderPlugins.UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndWriteNode(obj, offset, value, kind, loc));
                    return true;
                }
            });
            if (kind == JavaKind.Boolean || !kind.isNumericInteger()) continue;
            r.register4("getAndAdd" + kindName, InvocationPlugin.Receiver.class, Object.class, Long.TYPE, (Type)javaClass, (InvocationPlugin)new StandardGraphBuilderPlugins.UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode delta) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndAddNode((AddressNode)b.add((ValueNode)new OffsetAddressNode(obj, offset)), delta, kind, loc));
                    return true;
                }
            });
        }
        for (final JavaKind kind : new JavaKind[]{JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long}) {
            javaClass = kind.toJavaClass();
            r.registerOptional3("get" + kind.name() + "Unaligned", InvocationPlugin.Receiver.class, Object.class, Long.TYPE, (InvocationPlugin)new StandardGraphBuilderPlugins.UnsafeGetPlugin(kind, explicitUnsafeNullChecks));
            r.registerOptional4("put" + kind.name() + "Unaligned", InvocationPlugin.Receiver.class, Object.class, Long.TYPE, (Type)javaClass, (InvocationPlugin)new StandardGraphBuilderPlugins.UnsafePutPlugin(kind, explicitUnsafeNullChecks));
        }
    }

    private static void registerUnaryLLVMIntrinsic(InvocationPlugins.Registration registration, String name, final LLVMIntrinsicNode.LLVMIntrinsicOperation op, final JavaKind returnKind, Type argType) {
        registration.register1(name, argType, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                ConstantNode folded = LLVMUnaryIntrinsicNode.tryFold(op, arg);
                b.addPush(returnKind, (ValueNode)(folded != null ? folded : LLVMUnaryIntrinsicNode.factory(op, returnKind, arg)));
                return true;
            }
        });
    }

    private static void registerBinaryLLVMIntrinsic(InvocationPlugins.Registration registration, String name, final LLVMIntrinsicNode.LLVMIntrinsicOperation op, final JavaKind returnKind, Type argType1, Type argType2) {
        registration.register2(name, argType1, argType2, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                ConstantNode folded = LLVMBinaryIntrinsicNode.tryFold(op, arg1, arg2);
                b.addPush(returnKind, (ValueNode)(folded != null ? folded : LLVMBinaryIntrinsicNode.factory(op, returnKind, arg1, arg2)));
                return true;
            }
        });
    }
}

