/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.lowering;

import com.oracle.svm.core.graal.meta.SubstrateBasicLoweringProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;

public class SubstrateLLVMLoweringProvider
extends SubstrateBasicLoweringProvider {
    public SubstrateLLVMLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
    }

    public void lower(Node n, LoweringTool tool) {
        NodeLoweringProvider lowering = (NodeLoweringProvider)this.getLowerings().get(n.getClass());
        if (lowering != null) {
            lowering.lower(n, tool);
        } else if (!(n instanceof RemNode) && !(n instanceof FloatConvertNode)) {
            if (n instanceof CodeSynchronizationNode) {
                CodeSynchronizationNode syncNode = (CodeSynchronizationNode)n;
                syncNode.graph().removeFixed((FixedWithNextNode)syncNode);
            } else {
                super.lower(n, tool);
            }
        }
    }

    public Integer smallestCompareWidth() {
        return 32;
    }

    public boolean supportsBulkZeroing() {
        return false;
    }

    public boolean targetingLLVM() {
        return true;
    }
}

