/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.llvm.LLVMGenerator;
import com.oracle.svm.core.graal.llvm.NodeLLVMBuilder;
import com.oracle.svm.core.graal.llvm.lowering.LLVMAddressLowering;
import com.oracle.svm.core.graal.llvm.util.LLVMOptions;
import com.oracle.svm.core.util.VMError;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.util.Providers;

public class SubstrateLLVMBackend
extends SubstrateBackend {
    private static final TimerKey EmitLLVM = DebugContext.timer((CharSequence)"EmitLLVM").doc("Time spent generating LLVM from HIR.");
    private static final TimerKey BackEnd = DebugContext.timer((CharSequence)"BackEnd").doc("Time spent in EmitLLVM and Populate.");

    public SubstrateLLVMBackend(Providers providers) {
        super(providers);
    }

    public Phase newAddressLoweringPhase(CodeCacheProvider codeCache) {
        return new AddressLoweringPhase((AddressLoweringPhase.AddressLowering)new LLVMAddressLowering());
    }

    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        result.setMethods(method, Collections.emptySet());
        LLVMGenerator generator = new LLVMGenerator(this.getProviders(), result, method, 0);
        generator.createJNITrampoline(threadArg, threadIsolateOffset, methodIdArg, methodObjEntryPointOffset);
        byte[] bitcode = generator.getBitcode();
        result.setTargetCode(bitcode, bitcode.length);
        return result;
    }

    protected CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        throw VMError.unimplemented();
    }

    public void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, CompilationResult result, CompilationResultBuilderFactory factory, RegisterConfig config, LIRSuites lirSuites) {
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"BackEnd", (Object)graph.getLastSchedule());
             DebugCloseable a = BackEnd.start(debug);){
            this.emitLLVM(graph, result);
            SubstrateLLVMBackend.dumpDebugInfo(result, graph);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        finally {
            graph.checkCancellation();
        }
    }

    private void emitLLVM(StructuredGraph graph, CompilationResult result) {
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope ds = debug.scope((Object)"EmitLLVM");
             DebugCloseable a = EmitLLVM.start(debug);){
            assert (!graph.hasValueProxies());
            ResolvedJavaMethod method = graph.method();
            LLVMGenerator generator = new LLVMGenerator(this.getProviders(), result, method, (Integer)LLVMOptions.IncludeLLVMDebugInfo.getValue());
            NodeLLVMBuilder nodeBuilder = this.newNodeLLVMBuilder(graph, generator);
            SubstrateLLVMBackend.generate(nodeBuilder, graph);
            byte[] bitcode = generator.getBitcode();
            result.setTargetCode(bitcode, bitcode.length);
            try (DebugContext.Scope s = debug.scope((Object)"LIRStages", (Object)nodeBuilder, null, null);){
                debug.dump(1, (Object)graph.getLastSchedule(), "After LIR generation");
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        finally {
            graph.checkCancellation();
        }
    }

    protected NodeLLVMBuilder newNodeLLVMBuilder(StructuredGraph graph, LLVMGenerator generator) {
        return new NodeLLVMBuilder(graph, generator, this.getRuntimeConfiguration());
    }

    private static void generate(NodeLLVMBuilder nodeBuilder, StructuredGraph graph) {
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        for (Block b : schedule.getCFG().getBlocks()) {
            nodeBuilder.doBlock(b, graph, (BlockMap<List<Node>>)schedule.getBlockToNodesMap());
        }
        nodeBuilder.finish();
    }

    private static void dumpDebugInfo(CompilationResult compilationResult, StructuredGraph graph) {
        DebugContext debug = graph.getDebug();
        if (debug.isCountEnabled()) {
            List ldp = compilationResult.getDataPatches();
            JavaKind[] kindValues = JavaKind.values();
            CounterKey[] dms = new CounterKey[kindValues.length];
            for (int i = 0; i < dms.length; ++i) {
                dms[i] = DebugContext.counter((String)"DataPatches-%s", (Object)kindValues[i]);
            }
            for (DataPatch dp : ldp) {
                VMConstant constant;
                JavaKind kind = JavaKind.Illegal;
                if (dp.reference instanceof ConstantReference && (constant = ((ConstantReference)dp.reference).getConstant()) instanceof JavaConstant) {
                    kind = ((JavaConstant)constant).getJavaKind();
                }
                dms[kind.ordinal()].add(debug, 1L);
            }
            DebugContext.counter((CharSequence)"CompilationResults").increment(debug);
            DebugContext.counter((CharSequence)"InfopointsEmitted").add(debug, (long)compilationResult.getInfopoints().size());
            DebugContext.counter((CharSequence)"DataPatches").add(debug, (long)ldp.size());
        }
        debug.dump(1, (Object)compilationResult, "After code generation");
    }
}

