/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointBuiltins;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.llvm.LLVMFeature;
import com.oracle.svm.core.graal.llvm.NodeLLVMBuilder;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicGenerator;
import com.oracle.svm.core.graal.llvm.runtime.LLVMExceptionUnwind;
import com.oracle.svm.core.graal.llvm.util.LLVMIRBuilder;
import com.oracle.svm.core.graal.llvm.util.LLVMOptions;
import com.oracle.svm.core.graal.llvm.util.LLVMTargetSpecific;
import com.oracle.svm.core.graal.llvm.util.LLVMUtils;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMTypeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMValueRef;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.RawPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.util.GuardedAnnotationAccess;

public class LLVMGenerator
implements LIRGeneratorTool,
SubstrateLIRGenerator {
    private static final SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
    private final Providers providers;
    private final CompilationResult compilationResult;
    private final LLVMIRBuilder builder;
    private final ArithmeticLLVMGenerator arithmetic;
    private final LIRKindTool lirKindTool;
    private final DebugInfoPrinter debugInfoPrinter;
    private final String functionName;
    private final boolean isEntryPoint;
    private final boolean canModifySpecialRegisters;
    private final boolean returnsEnum;
    private final boolean returnsCEnum;
    private Block currentBlock;
    private final Map<AbstractBeginNode, LLVMBasicBlockRef> basicBlockMap = new HashMap<AbstractBeginNode, LLVMBasicBlockRef>();
    private final Map<Block, LLVMBasicBlockRef> splitBlockEndMap = new HashMap<Block, LLVMBasicBlockRef>();
    private final Map<Block, LLVMValueRef[]> specialRegValues = new HashMap<Block, LLVMValueRef[]>();
    private final Map<Block, LLVMValueRef[]> initialSpecialRegValues = new HashMap<Block, LLVMValueRef[]>();
    private final Map<Block, LLVMValueRef[]> handlerSpecialRegValues = new HashMap<Block, LLVMValueRef[]>();
    private final LLVMValueRef[] stackSlots = new LLVMValueRef[SpecialRegister.count()];
    private final Map<Constant, String> constants = new HashMap<Constant, String>();
    private long nextConstantId = 0L;
    static final AtomicLong nextPatchpointId = new AtomicLong(0L);
    public static final String JNI_WRAPPER_BASE_NAME = "__llvm_jni_wrapper_";

    LLVMGenerator(Providers providers, CompilationResult result, ResolvedJavaMethod method, int debugLevel) {
        this.providers = providers;
        this.compilationResult = result;
        this.builder = new LLVMIRBuilder(method.format("%H.%n"));
        this.arithmetic = new ArithmeticLLVMGenerator(this.builder);
        this.lirKindTool = new LLVMUtils.LLVMKindTool(this.builder);
        this.debugInfoPrinter = new DebugInfoPrinter(this, debugLevel);
        this.functionName = SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
        this.isEntryPoint = LLVMGenerator.isEntryPoint(method);
        this.canModifySpecialRegisters = this.canModifySpecialRegisters(method);
        ResolvedJavaType returnType = method.getSignature().getReturnType(null).resolve(null);
        this.returnsEnum = returnType.isEnum();
        this.returnsCEnum = LLVMGenerator.isCEnumType(returnType);
        this.addMainFunction(method);
    }

    public CodeGenProviders getProviders() {
        return this.providers;
    }

    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    public CodeCacheProvider getCodeCache() {
        return this.providers.getCodeCache();
    }

    public TargetDescription target() {
        return this.getCodeCache().getTarget();
    }

    public SubstrateRegisterConfig getRegisterConfig() {
        return (SubstrateRegisterConfig)this.getCodeCache().getRegisterConfig();
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public LLVMIRBuilder getBuilder() {
        return this.builder;
    }

    public ArithmeticLIRGeneratorTool getArithmetic() {
        return this.arithmetic;
    }

    DebugInfoPrinter getDebugInfoPrinter() {
        return this.debugInfoPrinter;
    }

    String getFunctionName() {
        return this.functionName;
    }

    boolean isEntryPoint() {
        return this.isEntryPoint;
    }

    private void addMainFunction(ResolvedJavaMethod method) {
        this.builder.setMainFunction(this.functionName, this.getLLVMFunctionType(method, true));
        this.builder.setFunctionLinkage(LLVMIRBuilder.LinkageType.External);
        this.builder.setFunctionAttribute(LLVMIRBuilder.Attribute.NoInline);
        this.builder.setFunctionAttribute(LLVMIRBuilder.Attribute.NoRedZone);
        this.builder.setFunctionAttribute(LLVMIRBuilder.Attribute.NoRealignStack);
        this.builder.setGarbageCollector(LLVMIRBuilder.GCStrategy.CompressedPointers);
        this.builder.setPersonalityFunction(this.getFunction(LLVMExceptionUnwind.getPersonalityStub(this.getMetaAccess())));
        if (this.isEntryPoint) {
            CEntryPointData cEntryPointData;
            this.builder.addAlias(SubstrateUtil.mangleName((String)this.functionName));
            Object entryPointData = ((HostedMethod)method).getWrapped().getEntryPointData();
            if (entryPointData instanceof CEntryPointData && (cEntryPointData = (CEntryPointData)entryPointData).getPublishAs() != CEntryPointOptions.Publish.NotPublished) {
                String entryPointSymbolName = cEntryPointData.getSymbolName();
                assert (!entryPointSymbolName.isEmpty());
                this.builder.addAlias(entryPointSymbolName);
            }
        }
    }

    LLVMValueRef getFunction(ResolvedJavaMethod method) {
        LLVMTypeRef functionType = this.getLLVMFunctionType(method, false);
        return this.builder.getFunction(LLVMGenerator.getFunctionName(method), functionType);
    }

    byte[] getBitcode() {
        assert (this.builder.verifyBitcode());
        byte[] bitcode = this.builder.getBitcode();
        this.builder.close();
        return bitcode;
    }

    private static String getFunctionName(ResolvedJavaMethod method) {
        return SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
    }

    private static boolean isEntryPoint(ResolvedJavaMethod method) {
        return ((HostedMethod)method).isEntryPoint();
    }

    private boolean canModifySpecialRegisters(ResolvedJavaMethod method) {
        CEntryPointOptions entryPointOptions = (CEntryPointOptions)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)method, CEntryPointOptions.class);
        return entryPointOptions != null && entryPointOptions.prologue() == CEntryPointOptions.NoPrologue.class || method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointSnippets.class)) || method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointNativeFunctions.class)) || method.getDeclaringClass().equals(this.getMetaAccess().lookupJavaType(CEntryPointBuiltins.class));
    }

    void appendBasicBlock(Block block) {
        LLVMBasicBlockRef basicBlock = this.builder.appendBasicBlock(block.toString());
        this.basicBlockMap.put(block.getBeginNode(), basicBlock);
    }

    void beginBlock(Block block) {
        this.currentBlock = block;
        this.builder.positionAtEnd(this.getBlock(block));
    }

    void resumeBlock(Block block) {
        this.currentBlock = block;
        this.builder.positionAtEnd(this.getBlockEnd(block));
    }

    void editBlock(Block block) {
        this.currentBlock = block;
        this.builder.positionBeforeTerminator(this.getBlockEnd(block));
    }

    public AbstractBlockBase<?> getCurrentBlock() {
        return this.currentBlock;
    }

    LLVMBasicBlockRef getBlock(Block block) {
        return this.getBlock(block.getBeginNode());
    }

    LLVMBasicBlockRef getBlock(AbstractBeginNode begin) {
        return this.basicBlockMap.get(begin);
    }

    LLVMBasicBlockRef getBlockEnd(Block block) {
        return this.splitBlockEndMap.containsKey(block) ? this.splitBlockEndMap.get(block) : this.getBlock(block);
    }

    public LIRKind getLIRKind(Stamp stamp) {
        return stamp.getLIRKind(this.lirKindTool);
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return this.getLIRKind(StampFactory.forKind((JavaKind)javaKind));
    }

    LLVMTypeRef getLLVMType(Stamp stamp) {
        if (stamp instanceof RawPointerStamp) {
            return this.builder.rawPointerType();
        }
        return this.getLLVMType(this.getTypeKind(stamp.javaType(this.getMetaAccess()), false), stamp instanceof NarrowOopStamp);
    }

    LLVMTypeRef getLLVMStackType(JavaKind kind) {
        return this.getLLVMType(kind.getStackKind(), false);
    }

    JavaKind getTypeKind(ResolvedJavaType type, boolean forMainFunction) {
        if (forMainFunction && this.isEntryPoint && LLVMGenerator.isCEnumType(type)) {
            return JavaKind.Int;
        }
        return ((HostedType)type).getStorageKind();
    }

    private LLVMTypeRef getLLVMType(JavaKind kind, boolean compressedObjects) {
        switch (kind) {
            case Boolean: {
                return this.builder.booleanType();
            }
            case Byte: {
                return this.builder.byteType();
            }
            case Short: {
                return this.builder.shortType();
            }
            case Char: {
                return this.builder.charType();
            }
            case Int: {
                return this.builder.intType();
            }
            case Float: {
                return this.builder.floatType();
            }
            case Long: {
                return this.builder.longType();
            }
            case Double: {
                return this.builder.doubleType();
            }
            case Object: {
                return this.builder.objectType(compressedObjects);
            }
            case Void: {
                return this.builder.voidType();
            }
        }
        throw GraalError.shouldNotReachHere((String)"Illegal type");
    }

    private static JavaKind getJavaKind(LLVMTypeRef type) {
        if (LLVMIRBuilder.isBooleanType(type)) {
            return JavaKind.Boolean;
        }
        if (LLVMIRBuilder.isByteType(type)) {
            return JavaKind.Byte;
        }
        if (LLVMIRBuilder.isShortType(type)) {
            return JavaKind.Short;
        }
        if (LLVMIRBuilder.isCharType(type)) {
            return JavaKind.Char;
        }
        if (LLVMIRBuilder.isIntType(type)) {
            return JavaKind.Int;
        }
        if (LLVMIRBuilder.isLongType(type)) {
            return JavaKind.Long;
        }
        if (LLVMIRBuilder.isFloatType(type)) {
            return JavaKind.Float;
        }
        if (LLVMIRBuilder.isDoubleType(type)) {
            return JavaKind.Double;
        }
        if (LLVMIRBuilder.isObjectType(type)) {
            return JavaKind.Object;
        }
        if (LLVMIRBuilder.isVoidType(type)) {
            return JavaKind.Void;
        }
        throw GraalError.shouldNotReachHere((String)"Unknown LLVM type");
    }

    private LLVMTypeRef getLLVMFunctionType(ResolvedJavaMethod method, boolean forMainFunction) {
        return this.builder.functionType(this.getLLVMFunctionReturnType(method, forMainFunction), this.getLLVMFunctionArgTypes(method, forMainFunction));
    }

    LLVMTypeRef getLLVMFunctionPointerType(ResolvedJavaMethod method) {
        return this.builder.functionPointerType(this.getLLVMFunctionReturnType(method, false), this.getLLVMFunctionArgTypes(method, false));
    }

    LLVMTypeRef getLLVMFunctionReturnType(ResolvedJavaMethod method, boolean forMainFunction) {
        ResolvedJavaType returnType = method.getSignature().getReturnType(null).resolve(null);
        LLVMTypeRef llvmReturnType = this.getLLVMStackType(this.getTypeKind(returnType, forMainFunction));
        if (!(!((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue() || forMainFunction && this.isEntryPoint)) {
            boolean voidReturnType = LLVMIRBuilder.isVoidType(llvmReturnType);
            LLVMTypeRef[] returnTypes = new LLVMTypeRef[SpecialRegister.count() + (voidReturnType ? 0 : 1)];
            for (SpecialRegister reg : SpecialRegister.registers()) {
                returnTypes[((SpecialRegister)reg).index] = this.builder.wordType();
            }
            if (!voidReturnType) {
                returnTypes[SpecialRegister.count()] = llvmReturnType;
            }
            llvmReturnType = this.builder.structType(returnTypes);
        }
        return llvmReturnType;
    }

    boolean isVoidReturnType(LLVMTypeRef returnType) {
        if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            return LLVMIRBuilder.countElementTypes(returnType) == SpecialRegister.count();
        }
        return LLVMIRBuilder.isVoidType(returnType);
    }

    private LLVMTypeRef[] getLLVMFunctionArgTypes(ResolvedJavaMethod method, boolean forMainFunction) {
        LLVMTypeRef[] parameterTypes;
        ResolvedJavaType receiver = method.hasReceiver() ? method.getDeclaringClass() : null;
        JavaType[] javaParameterTypes = method.getSignature().toParameterTypes((JavaType)receiver);
        LLVMTypeRef[] newParameterTypes = parameterTypes = (LLVMTypeRef[])Arrays.stream(javaParameterTypes).map(type -> this.getLLVMStackType(this.getTypeKind(type.resolve(null), forMainFunction))).toArray(LLVMTypeRef[]::new);
        if (!LLVMGenerator.isEntryPoint(method) && SpecialRegister.count() > 0) {
            newParameterTypes = new LLVMTypeRef[SpecialRegister.count() + parameterTypes.length];
            for (SpecialRegister reg : SpecialRegister.registers()) {
                newParameterTypes[((SpecialRegister)reg).index] = (Boolean)LLVMOptions.ReturnSpecialRegs.getValue() == false && this.canModifySpecialRegisters(method) ? this.builder.pointerType(this.builder.wordType()) : this.builder.wordType();
            }
            System.arraycopy(parameterTypes, 0, newParameterTypes, SpecialRegister.count(), parameterTypes.length);
        }
        return newParameterTypes;
    }

    private LLVMTypeRef prependArgumentTypes(LLVMTypeRef functionType, int prefixTypes, LLVMTypeRef ... typesToAdd) {
        LLVMTypeRef returnType = LLVMIRBuilder.getReturnType(functionType);
        boolean varargs = LLVMIRBuilder.isFunctionVarArg(functionType);
        LLVMTypeRef[] oldTypes = LLVMIRBuilder.getParamTypes(functionType);
        LLVMTypeRef[] newTypes = new LLVMTypeRef[oldTypes.length + typesToAdd.length];
        System.arraycopy(oldTypes, 0, newTypes, 0, prefixTypes);
        System.arraycopy(typesToAdd, 0, newTypes, prefixTypes, typesToAdd.length);
        System.arraycopy(oldTypes, prefixTypes, newTypes, prefixTypes + typesToAdd.length, oldTypes.length - prefixTypes);
        return this.builder.functionType(returnType, varargs, newTypes);
    }

    private static boolean isCEnumType(ResolvedJavaType type) {
        return type.isEnum() && GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)type, CEnum.class);
    }

    public Value emitConstant(LIRKind kind, Constant constant) {
        boolean uncompressedObject = LLVMGenerator.isUncompressedObjectKind(kind);
        LLVMTypeRef actualType = uncompressedObject ? this.builder.objectType(true) : ((LLVMUtils.LLVMKind)kind.getPlatformKind()).get();
        LLVMValueRef value = this.emitLLVMConstant(actualType, (JavaConstant)constant);
        LLVMUtils.LLVMConstant val = new LLVMUtils.LLVMConstant(value, constant);
        return uncompressedObject ? this.emitUncompress((Value)val, ReferenceAccess.singleton().getCompressEncoding(), false) : val;
    }

    public Value emitJavaConstant(JavaConstant constant) {
        assert (constant.getJavaKind() != JavaKind.Object);
        LLVMValueRef value = this.emitLLVMConstant(this.getLLVMType(constant.getJavaKind(), false), constant);
        return new LLVMUtils.LLVMConstant(value, (Constant)constant);
    }

    LLVMValueRef emitLLVMConstant(LLVMTypeRef type, JavaConstant constant) {
        switch (LLVMGenerator.getJavaKind(type)) {
            case Boolean: {
                return this.builder.constantBoolean(constant.asBoolean());
            }
            case Byte: {
                return this.builder.constantByte((byte)constant.asInt());
            }
            case Short: {
                return this.builder.constantShort((short)constant.asInt());
            }
            case Char: {
                return this.builder.constantChar((char)constant.asInt());
            }
            case Int: {
                return this.builder.constantInt(constant.asInt());
            }
            case Long: {
                return this.builder.constantLong(constant.asLong());
            }
            case Float: {
                return this.builder.constantFloat(constant.asFloat());
            }
            case Double: {
                return this.builder.constantDouble(constant.asDouble());
            }
            case Object: {
                if (constant.isNull()) {
                    return this.builder.constantNull(this.builder.objectType(LLVMIRBuilder.isCompressedPointerType(type)));
                }
                return this.builder.buildLoad(this.getLLVMPlaceholderForConstant((Constant)constant), this.builder.objectType(LLVMIRBuilder.isCompressedPointerType(type)));
            }
        }
        throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("unsupported constant type", type));
    }

    public AllocatableValue emitLoadConstant(ValueKind<?> kind, Constant constant) {
        LLVMValueRef value = this.builder.buildLoad(this.getLLVMPlaceholderForConstant(constant), ((LLVMUtils.LLVMKind)kind.getPlatformKind()).get());
        LLVMUtils.LLVMVariable rawConstant = new LLVMUtils.LLVMVariable(value);
        if (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue() && ((LIRKind)kind).isReference(0) && !((LIRKind)kind).isCompressedReference(0)) {
            return (AllocatableValue)this.emitUncompress((Value)rawConstant, ReferenceAccess.singleton().getCompressEncoding(), false);
        }
        return rawConstant;
    }

    private LLVMValueRef getLLVMPlaceholderForConstant(Constant constant) {
        String symbolName = this.constants.get(constant);
        boolean uncompressedObject = LLVMGenerator.isUncompressedObjectConstant(constant);
        if (symbolName == null) {
            symbolName = "constant_" + this.functionName + "#" + this.nextConstantId++;
            this.constants.put(constant, symbolName);
            Constant storedConstant = uncompressedObject ? ((SubstrateObjectConstant)constant).compress() : constant;
            DataSectionReference reference = this.compilationResult.getDataSection().insertData(dataBuilder.createDataItem(storedConstant));
            this.compilationResult.recordDataPatchWithNote(0, (Reference)reference, (Object)symbolName);
        }
        return this.builder.getExternalObject(symbolName, LLVMGenerator.isUncompressedObjectConstant(constant));
    }

    private static boolean isUncompressedObjectConstant(Constant constant) {
        return (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && constant instanceof SubstrateObjectConstant && !((SubstrateObjectConstant)constant).isCompressed();
    }

    private static boolean isUncompressedObjectKind(LIRKind kind) {
        return (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && kind.isReference(0) && !kind.isCompressedReference(0);
    }

    public boolean canInlineConstant(Constant constant) {
        return false;
    }

    public boolean mayEmbedConstantLoad(Constant constant) {
        return false;
    }

    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        throw GraalError.unimplemented((String)"only needed when emitting LIR constants");
    }

    public void emitMoveConstant(AllocatableValue dst, Constant src) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't need to move constants");
    }

    public Variable newVariable(ValueKind<?> kind) {
        return new LLVMUtils.LLVMVariable(kind);
    }

    public AllocatableValue asAllocatable(Value value) {
        return (AllocatableValue)value;
    }

    public Variable emitMove(Value input) {
        if (input instanceof LLVMUtils.LLVMVariable) {
            return (LLVMUtils.LLVMVariable)input;
        }
        if (input instanceof LLVMUtils.LLVMValueWrapper) {
            return new LLVMUtils.LLVMVariable(LLVMUtils.getVal(input));
        }
        throw GraalError.shouldNotReachHere((String)"Unknown move input");
    }

    public void emitMove(AllocatableValue dst, Value src) {
        LLVMValueRef source = LLVMUtils.getVal(src);
        LLVMTypeRef sourceType = LLVMIRBuilder.typeOf(source);
        LLVMTypeRef destType = ((LLVMUtils.LLVMKind)dst.getPlatformKind()).get();
        if (LLVMIRBuilder.isObjectType(destType) && LLVMIRBuilder.isWordType(sourceType)) {
            source = this.builder.buildIntToPtr(source, destType);
        } else if (LLVMIRBuilder.isWordType(destType) && LLVMIRBuilder.isObjectType(sourceType)) {
            source = this.builder.buildPtrToInt(source);
        }
        ((LLVMUtils.LLVMVariable)dst).set(source);
    }

    public Variable emitConditionalMove(PlatformKind cmpKind, Value leftVal, Value rightVal, Condition cond, boolean unorderedIsTrue, Value trueVal, Value falseVal) {
        LLVMValueRef condition = this.builder.buildCompare(cond, LLVMUtils.getVal(leftVal), LLVMUtils.getVal(rightVal), unorderedIsTrue);
        LLVMValueRef trueValue = LLVMUtils.getVal(trueVal);
        LLVMValueRef falseValue = LLVMUtils.getVal(falseVal);
        LLVMValueRef select = LLVMFeature.LLVMVersionChecker.useExplicitSelects() && LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(trueValue)) ? this.buildExplicitSelect(condition, trueValue, falseValue) : this.builder.buildSelect(condition, trueValue, falseValue);
        return new LLVMUtils.LLVMVariable(select);
    }

    Variable emitIsNullMove(Value value, Value trueValue, Value falseValue) {
        LLVMValueRef isNull = this.builder.buildIsNull(LLVMUtils.getVal(value));
        LLVMValueRef select = this.builder.buildSelect(isNull, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(select);
    }

    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        LLVMValueRef and = this.builder.buildAnd(LLVMUtils.getVal(left), LLVMUtils.getVal(right));
        LLVMValueRef isNull = this.builder.buildIsNull(and);
        LLVMValueRef select = this.builder.buildSelect(isNull, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(select);
    }

    private LLVMValueRef buildExplicitSelect(LLVMValueRef condition, LLVMValueRef trueVal, LLVMValueRef falseVal) {
        LLVMBasicBlockRef trueBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_true");
        LLVMBasicBlockRef falseBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_false");
        LLVMBasicBlockRef mergeBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_end");
        this.splitBlockEndMap.put(this.currentBlock, mergeBlock);
        assert (LLVMIRBuilder.compatibleTypes(LLVMIRBuilder.typeOf(trueVal), LLVMIRBuilder.typeOf(falseVal)));
        this.builder.buildIf(condition, trueBlock, falseBlock);
        this.builder.positionAtEnd(trueBlock);
        this.builder.buildBranch(mergeBlock);
        this.builder.positionAtEnd(falseBlock);
        this.builder.buildBranch(mergeBlock);
        this.builder.positionAtEnd(mergeBlock);
        LLVMValueRef[] incomingValues = new LLVMValueRef[]{trueVal, falseVal};
        LLVMBasicBlockRef[] incomingBlocks = new LLVMBasicBlockRef[]{trueBlock, falseBlock};
        return this.builder.buildPhi(LLVMIRBuilder.typeOf(trueVal), incomingValues, incomingBlocks);
    }

    public Variable emitByteSwap(Value operand) {
        LLVMValueRef byteSwap = this.builder.buildBswap(LLVMUtils.getVal(operand));
        return new LLVMUtils.LLVMVariable(byteSwap);
    }

    public void emitMembar(int barriers) {
        this.builder.buildFence();
    }

    public Value emitAtomicReadAndWrite(Value address, ValueKind<?> valueKind, Value newValue) {
        LLVMValueRef atomicRMW = this.builder.buildAtomicXchg(LLVMUtils.getVal(address), LLVMUtils.getVal(newValue));
        return new LLVMUtils.LLVMVariable(atomicRMW);
    }

    public Value emitAtomicReadAndAdd(Value address, ValueKind<?> valueKind, Value delta) {
        LLVMValueRef atomicRMW = this.builder.buildAtomicAdd(LLVMUtils.getVal(address), LLVMUtils.getVal(delta));
        return new LLVMUtils.LLVMVariable(atomicRMW);
    }

    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue) {
        LLVMValueRef success = this.buildCmpxchg(LLVMUtils.getVal(address), LLVMUtils.getVal(expectedValue), LLVMUtils.getVal(newValue), false);
        LLVMValueRef result = this.builder.buildSelect(success, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(result);
    }

    public Value emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue) {
        LLVMValueRef result = this.buildCmpxchg(LLVMUtils.getVal(address), LLVMUtils.getVal(expectedValue), LLVMUtils.getVal(newValue), true);
        return new LLVMUtils.LLVMVariable(result);
    }

    private LLVMValueRef buildCmpxchg(LLVMValueRef address, LLVMValueRef expectedValue, LLVMValueRef newValue, boolean returnValue) {
        LLVMTypeRef expectedType = LLVMIRBuilder.typeOf(expectedValue);
        LLVMTypeRef newType = LLVMIRBuilder.typeOf(newValue);
        assert (LLVMIRBuilder.compatibleTypes(expectedType, newType)) : LLVMUtils.dumpValues("invalid cmpxchg arguments", expectedValue, newValue);
        LLVMValueRef castedAddress = this.builder.buildBitcast(address, this.builder.pointerType(expectedType, LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(address)), false));
        return this.builder.buildCmpxchg(castedAddress, expectedValue, newValue, returnValue);
    }

    public Variable emitReadRegister(Register register, ValueKind<?> kind) {
        LLVMValueRef value;
        if (register.equals((Object)this.getRegisterConfig().getThreadRegister())) {
            if (this.isEntryPoint || this.canModifySpecialRegisters) {
                return new LLVMUtils.LLVMPendingSpecialRegisterRead(this, SpecialRegister.ThreadPointer);
            }
            value = this.getSpecialRegister(SpecialRegister.ThreadPointer);
        } else if (register.equals((Object)this.getRegisterConfig().getHeapBaseRegister())) {
            if (this.isEntryPoint || this.canModifySpecialRegisters) {
                return new LLVMUtils.LLVMPendingSpecialRegisterRead(this, SpecialRegister.HeapBase);
            }
            value = this.getSpecialRegister(SpecialRegister.HeapBase);
        } else if (register.equals((Object)this.getRegisterConfig().getFrameRegister())) {
            value = this.builder.buildReadRegister(this.builder.register(this.getRegisterConfig().getFrameRegister().name));
        } else {
            throw VMError.shouldNotReachHere();
        }
        return new LLVMUtils.LLVMVariable(value);
    }

    public void emitWriteRegister(Register dst, Value src, ValueKind<?> kind) {
        if (dst.equals((Object)this.getRegisterConfig().getThreadRegister())) {
            VMError.guarantee((this.isEntryPoint || this.canModifySpecialRegisters ? 1 : 0) != 0, (String)"Can only write to registers in a method where it is expected.");
            if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
                this.setSpecialRegisterValue(SpecialRegister.ThreadPointer, LLVMUtils.getVal(src));
            } else {
                this.builder.buildStore(LLVMUtils.getVal(src), this.getSpecialRegisterPointer(SpecialRegister.ThreadPointer));
            }
            return;
        }
        if (dst.equals((Object)this.getRegisterConfig().getHeapBaseRegister())) {
            VMError.guarantee((this.isEntryPoint || this.canModifySpecialRegisters ? 1 : 0) != 0, (String)"Can only write to registers in a method where it is expected.");
            if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
                this.setSpecialRegisterValue(SpecialRegister.HeapBase, LLVMUtils.getVal(src));
            } else {
                this.builder.buildStore(LLVMUtils.getVal(src), this.getSpecialRegisterPointer(SpecialRegister.HeapBase));
            }
            return;
        }
        throw VMError.shouldNotReachHere();
    }

    public Variable load(Value value) {
        LLVMValueRef load = this.builder.buildPtrToInt(LLVMUtils.getVal(value));
        return new LLVMUtils.LLVMVariable(load);
    }

    public void emitPrefetchAllocate(Value address) {
        this.builder.buildPrefetch(LLVMUtils.getVal(address));
    }

    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LLVMValueRef heapBase = this.getSpecialRegister(SpecialRegister.HeapBase);
        return new LLVMUtils.LLVMVariable(this.builder.buildCompress(LLVMUtils.getVal(pointer), heapBase, nonNull, encoding.getShift()));
    }

    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LLVMValueRef heapBase = this.getSpecialRegister(SpecialRegister.HeapBase);
        return new LLVMUtils.LLVMVariable(this.builder.buildUncompress(LLVMUtils.getVal(pointer), heapBase, nonNull, encoding.getShift()));
    }

    public VirtualStackSlot allocateStackSlots(int slots) {
        this.builder.positionAtStart();
        LLVMValueRef alloca = this.builder.buildArrayAlloca(this.builder.wordType(), slots);
        this.builder.positionAtEnd(this.getBlockEnd(this.currentBlock));
        return new LLVMUtils.LLVMStackSlot(alloca);
    }

    public Variable emitAddress(AllocatableValue stackslot) {
        if (stackslot instanceof LLVMUtils.LLVMStackSlot) {
            return new LLVMUtils.LLVMVariable(this.builder.buildPtrToInt(LLVMUtils.getVal((Value)stackslot)));
        }
        throw GraalError.shouldNotReachHere((String)"Unknown address type");
    }

    void allocateRegisterSlots() {
        if (!this.isEntryPoint) {
            return;
        }
        for (SpecialRegister reg : SpecialRegister.registers()) {
            this.stackSlots[((SpecialRegister)reg).index] = this.builder.buildAlloca(this.builder.wordType());
        }
    }

    public Value emitReadCallerStackPointer(Stamp wordStamp) {
        LLVMValueRef basePointer = this.builder.buildFrameAddress(this.builder.constantInt(0));
        LLVMValueRef callerSP = this.builder.buildAdd(this.builder.buildPtrToInt(basePointer), this.builder.constantLong(16L));
        return new LLVMUtils.LLVMVariable(callerSP);
    }

    public Value emitReadReturnAddress(Stamp wordStamp, int returnAddressSize) {
        LLVMValueRef returnAddress = this.builder.buildReturnAddress(this.builder.constantInt(0));
        return new LLVMUtils.LLVMVariable(this.builder.buildPtrToInt(returnAddress));
    }

    LLVMValueRef buildStatepointCall(LLVMValueRef callee, boolean nativeABI, long statepointId, LLVMValueRef ... args) {
        LLVMValueRef result = this.builder.buildCall(callee, args);
        this.builder.setCallSiteAttribute(result, LLVMIRBuilder.Attribute.StatepointID, Long.toString(statepointId));
        if (!nativeABI && ((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            for (SpecialRegister reg : SpecialRegister.registers()) {
                this.setSpecialRegisterValue(reg, this.builder.buildExtractValue(result, reg.index));
            }
            int numReturnValues = LLVMIRBuilder.countElementTypes(LLVMIRBuilder.typeOf(result));
            return numReturnValues > SpecialRegister.count() ? this.builder.buildExtractValue(result, SpecialRegister.count()) : result;
        }
        return result;
    }

    LLVMValueRef buildStatepointInvoke(LLVMValueRef callee, boolean nativeABI, LLVMBasicBlockRef successor, LLVMBasicBlockRef handler, long statepointId, LLVMValueRef ... args) {
        LLVMBasicBlockRef handlerBlock;
        LLVMBasicBlockRef successorBlock;
        if (!nativeABI && ((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            successorBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_invoke_successor");
            handlerBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_invoke_handler");
            this.splitBlockEndMap.put(this.currentBlock, successorBlock);
        } else {
            successorBlock = successor;
            handlerBlock = handler;
        }
        LLVMValueRef result = this.builder.buildInvoke(callee, successorBlock, handlerBlock, args);
        this.builder.setCallSiteAttribute(result, LLVMIRBuilder.Attribute.StatepointID, Long.toString(statepointId));
        if (!nativeABI && ((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            this.builder.positionAtEnd(handlerBlock);
            this.builder.buildLandingPad();
            for (SpecialRegister reg : SpecialRegister.registers()) {
                this.setHandlerSpecialRegisterValue(reg, this.getSpecialRegisterValue(reg));
            }
            this.builder.buildBranch(handler);
            this.builder.positionAtEnd(successorBlock);
            int numReturnValues = LLVMIRBuilder.countElementTypes(LLVMIRBuilder.typeOf(result));
            for (SpecialRegister reg : SpecialRegister.registers()) {
                assert (reg.index < numReturnValues);
                this.setSpecialRegisterValue(reg, this.builder.buildExtractValue(result, reg.index));
            }
            result = numReturnValues > SpecialRegister.count() ? this.builder.buildExtractValue(result, SpecialRegister.count()) : result;
            this.builder.buildBranch(successor);
        }
        return result;
    }

    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... arguments) {
        return this.emitForeignCall(linkage, state, (LLVMBasicBlockRef)null, (LLVMBasicBlockRef)null, arguments);
    }

    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, LLVMBasicBlockRef successor, LLVMBasicBlockRef handler, Value ... arguments) {
        LLVMValueRef call;
        ResolvedJavaMethod targetMethod = ((SnippetRuntime.SubstrateForeignCallDescriptor)linkage.getDescriptor()).findMethod(this.getMetaAccess());
        state.initDebugInfo(null, false);
        long patchpointId = nextPatchpointId.getAndIncrement();
        this.compilationResult.recordCall(NumUtil.safeToInt((long)patchpointId), 0, (InvokeTarget)targetMethod, state.debugInfo(), true);
        LLVMValueRef callee = this.getFunction(targetMethod);
        LLVMValueRef[] args = (LLVMValueRef[])Arrays.stream(arguments).map(LLVMUtils::getVal).toArray(LLVMValueRef[]::new);
        CallingConvention.Type callType = ((SubstrateCallingConvention)linkage.getOutgoingCallingConvention()).getType();
        LLVMValueRef[] callArguments = this.getCallArguments(args, callType, targetMethod);
        boolean nativeABI = ((SubstrateCallingConventionType)callType).nativeABI;
        if (successor == null && handler == null) {
            call = this.buildStatepointCall(callee, nativeABI, patchpointId, callArguments);
        } else {
            assert (successor != null && handler != null);
            call = this.buildStatepointInvoke(callee, nativeABI, successor, handler, patchpointId, callArguments);
        }
        return this.isVoidReturnType(this.getLLVMFunctionReturnType(targetMethod, false)) ? null : new LLVMUtils.LLVMVariable(call);
    }

    LLVMValueRef[] getCallArguments(LLVMValueRef[] args, CallingConvention.Type callType, ResolvedJavaMethod targetMethod) {
        LLVMValueRef[] newArgs = args;
        if (!((SubstrateCallingConventionType)callType).nativeABI && SpecialRegister.hasRegisters()) {
            newArgs = new LLVMValueRef[SpecialRegister.count() + args.length];
            for (SpecialRegister reg : SpecialRegister.registers()) {
                newArgs[((SpecialRegister)reg).index] = this.getSpecialRegisterArgument(reg, targetMethod);
            }
            System.arraycopy(args, 0, newArgs, SpecialRegister.count(), args.length);
        }
        return newArgs;
    }

    LLVMTypeRef[] getUnknownCallArgumentTypes(LLVMTypeRef[] types, CallingConvention.Type callType) {
        LLVMTypeRef[] newTypes = types;
        if (!((SubstrateCallingConventionType)callType).nativeABI && SpecialRegister.count() > 0) {
            newTypes = new LLVMTypeRef[SpecialRegister.count() + types.length];
            for (SpecialRegister reg : SpecialRegister.registers()) {
                newTypes[((SpecialRegister)reg).index] = this.builder.wordType();
            }
            System.arraycopy(types, 0, newTypes, SpecialRegister.count(), types.length);
        }
        return newTypes;
    }

    LLVMValueRef createJNIWrapper(LLVMValueRef callee, boolean nativeABI, int numArgs, int anchorIPOffset) {
        LLVMTypeRef calleeType = LLVMIRBuilder.getElementType(LLVMIRBuilder.typeOf(callee));
        String wrapperName = JNI_WRAPPER_BASE_NAME + LLVMIRBuilder.intrinsicType(calleeType) + (nativeABI ? "_native" : "");
        LLVMValueRef transitionWrapper = this.builder.getNamedFunction(wrapperName);
        if (transitionWrapper == null) {
            try (LLVMIRBuilder tempBuilder = new LLVMIRBuilder(this.builder);){
                LLVMTypeRef wrapperType = this.prependArgumentTypes(calleeType, nativeABI ? 0 : SpecialRegister.count(), tempBuilder.rawPointerType(), LLVMIRBuilder.typeOf(callee));
                transitionWrapper = tempBuilder.addFunction(wrapperName, wrapperType);
                LLVMIRBuilder.setLinkage(transitionWrapper, LLVMIRBuilder.LinkageType.LinkOnce);
                tempBuilder.setGarbageCollector(transitionWrapper, LLVMIRBuilder.GCStrategy.CompressedPointers);
                tempBuilder.setFunctionAttribute(transitionWrapper, LLVMIRBuilder.Attribute.NoInline);
                LLVMBasicBlockRef block = tempBuilder.appendBasicBlock(transitionWrapper, "main");
                tempBuilder.positionAtEnd(block);
                LLVMValueRef anchor = LLVMIRBuilder.getParam(transitionWrapper, 0 + (nativeABI ? 0 : SpecialRegister.count()));
                LLVMValueRef lastIPAddr = tempBuilder.buildGEP(anchor, tempBuilder.constantInt(anchorIPOffset));
                LLVMValueRef callIP = tempBuilder.buildReturnAddress(tempBuilder.constantInt(0));
                LLVMValueRef castedLastIPAddr = tempBuilder.buildBitcast(lastIPAddr, tempBuilder.pointerType(tempBuilder.rawPointerType()));
                tempBuilder.buildStore(callIP, castedLastIPAddr);
                LLVMValueRef[] args = new LLVMValueRef[numArgs];
                for (int i = 0; i < numArgs; ++i) {
                    args[i] = !nativeABI && i < SpecialRegister.count() ? LLVMIRBuilder.getParam(transitionWrapper, i) : LLVMIRBuilder.getParam(transitionWrapper, i + 2);
                }
                LLVMValueRef target = LLVMIRBuilder.getParam(transitionWrapper, 1 + (nativeABI ? 0 : SpecialRegister.count()));
                LLVMValueRef ret = tempBuilder.buildCall(target, args);
                tempBuilder.setCallSiteAttribute(ret, LLVMIRBuilder.Attribute.GCLeafFunction);
                if (LLVMIRBuilder.isVoidType(LLVMIRBuilder.getReturnType(calleeType))) {
                    tempBuilder.buildRetVoid();
                } else {
                    tempBuilder.buildRet(ret);
                }
            }
        }
        return transitionWrapper;
    }

    void createJNITrampoline(RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        LLVMValueRef jumpAddressAddress;
        this.builder.setFunctionAttribute(LLVMIRBuilder.Attribute.Naked);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock("main");
        this.builder.positionAtEnd(block);
        long startPatchpointId = nextPatchpointId.getAndIncrement();
        this.builder.buildStackmap(this.builder.constantLong(startPatchpointId), new LLVMValueRef[0]);
        this.compilationResult.recordInfopoint(NumUtil.safeToInt((long)startPatchpointId), null, InfopointReason.METHOD_START);
        if (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue()) {
            LLVMValueRef thread = this.buildInlineGetRegister(threadArg.getRegister().name);
            LLVMValueRef heapBaseAddress = this.builder.buildGEP(this.builder.buildIntToPtr(thread, this.builder.rawPointerType()), this.builder.constantInt(threadIsolateOffset));
            LLVMValueRef heapBase = this.builder.buildLoad(heapBaseAddress, this.builder.rawPointerType());
            LLVMValueRef methodId = this.buildInlineGetRegister(methodIdArg.getRegister().name);
            LLVMValueRef methodBase = this.builder.buildGEP(this.builder.buildIntToPtr(heapBase, this.builder.rawPointerType()), this.builder.buildPtrToInt(methodId));
            jumpAddressAddress = this.builder.buildGEP(methodBase, this.builder.constantInt(methodObjEntryPointOffset));
        } else {
            LLVMValueRef methodBase = this.buildInlineGetRegister(methodIdArg.getRegister().name);
            jumpAddressAddress = this.builder.buildGEP(this.builder.buildIntToPtr(methodBase, this.builder.rawPointerType()), this.builder.constantInt(methodObjEntryPointOffset));
        }
        LLVMValueRef jumpAddress = this.builder.buildLoad(jumpAddressAddress, this.builder.rawPointerType());
        this.buildInlineJump(jumpAddress);
        this.builder.buildUnreachable();
    }

    public void emitReturn(JavaKind javaKind, Value input) {
        if (javaKind == JavaKind.Void) {
            this.debugInfoPrinter.printRetVoid();
            if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue() && !this.isEntryPoint) {
                LLVMTypeRef[] retTypes = new LLVMTypeRef[SpecialRegister.count()];
                LLVMValueRef[] retValues = new LLVMValueRef[SpecialRegister.count()];
                for (SpecialRegister reg : SpecialRegister.registers()) {
                    retTypes[((SpecialRegister)reg).index] = this.builder.wordType();
                    retValues[((SpecialRegister)reg).index] = this.getSpecialRegisterValue(reg);
                }
                LLVMValueRef retStruct = this.builder.constantNull(this.builder.structType(retTypes));
                for (int i = 0; i < retValues.length; ++i) {
                    retStruct = this.builder.buildInsertValue(retStruct, i, retValues[i]);
                }
                this.builder.buildRet(retStruct);
            } else {
                this.builder.buildRetVoid();
            }
        } else {
            this.debugInfoPrinter.printRet(javaKind, input);
            LLVMValueRef retVal = LLVMUtils.getVal(input);
            if (javaKind == JavaKind.Int) {
                assert (LLVMIRBuilder.isIntegerType(LLVMIRBuilder.typeOf(retVal)));
                retVal = this.arithmetic.emitIntegerConvert(retVal, this.builder.intType());
            } else if (this.returnsEnum && javaKind == FrameAccess.getWordKind()) {
                LLVMValueRef result = this.returnsCEnum ? this.builder.buildTrunc(retVal, JavaKind.Int.getBitCount()) : this.builder.buildIntToPtr(retVal, this.builder.objectType(false));
                retVal = result;
            }
            if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue() && !this.isEntryPoint) {
                LLVMTypeRef[] retTypes = new LLVMTypeRef[SpecialRegister.count() + 1];
                LLVMValueRef[] retValues = new LLVMValueRef[SpecialRegister.count() + 1];
                for (SpecialRegister reg : SpecialRegister.registers()) {
                    retTypes[((SpecialRegister)reg).index] = this.builder.wordType();
                    retValues[((SpecialRegister)reg).index] = this.getSpecialRegisterValue(reg);
                }
                retTypes[SpecialRegister.count()] = LLVMIRBuilder.typeOf(retVal);
                retValues[SpecialRegister.count()] = retVal;
                LLVMValueRef retStruct = this.builder.constantNull(this.builder.structType(retTypes));
                for (int i = 0; i < retValues.length; ++i) {
                    retStruct = this.builder.buildInsertValue(retStruct, i, retValues[i]);
                }
                retVal = retStruct;
            }
            this.builder.buildRet(retVal);
        }
    }

    public void emitJump(LabelRef label) {
        this.builder.buildBranch(this.getBlock((Block)label.getTargetBlock()));
    }

    public void emitDeadEnd() {
        this.builder.buildUnreachable();
    }

    public void emitBlackhole(Value operand) {
        this.builder.buildStackmap(this.builder.constantLong(2882400000L), LLVMUtils.getVal(operand));
    }

    public void emitPause() {
    }

    private void buildInlineJump(LLVMValueRef address) {
        LLVMTypeRef inlineAsmType = this.builder.functionType(this.builder.voidType(), this.builder.rawPointerType());
        String asmSnippet = LLVMTargetSpecific.get().getJumpInlineAsm();
        LLVMIRBuilder.InlineAssemblyConstraint inputConstraint = new LLVMIRBuilder.InlineAssemblyConstraint(LLVMIRBuilder.InlineAssemblyConstraint.Type.Input, LLVMIRBuilder.InlineAssemblyConstraint.Location.register());
        LLVMValueRef jump = this.builder.buildInlineAsm(inlineAsmType, asmSnippet, true, false, inputConstraint);
        LLVMValueRef call = this.builder.buildCall(jump, address);
        this.builder.setCallSiteAttribute(call, LLVMIRBuilder.Attribute.GCLeafFunction);
    }

    private LLVMValueRef buildInlineGetRegister(String registerName) {
        LLVMTypeRef inlineAsmType = this.builder.functionType(this.builder.rawPointerType(), new LLVMTypeRef[0]);
        String asmSnippet = LLVMTargetSpecific.get().getRegisterInlineAsm(registerName);
        LLVMIRBuilder.InlineAssemblyConstraint outputConstraint = new LLVMIRBuilder.InlineAssemblyConstraint(LLVMIRBuilder.InlineAssemblyConstraint.Type.Output, LLVMIRBuilder.InlineAssemblyConstraint.Location.namedRegister(LLVMTargetSpecific.get().getLLVMRegisterName(registerName)));
        LLVMValueRef getRegister = this.builder.buildInlineAsm(inlineAsmType, asmSnippet, false, false, outputConstraint);
        LLVMValueRef call = this.builder.buildCall(getRegister, new LLVMValueRef[0]);
        this.builder.setCallSiteAttribute(call, LLVMIRBuilder.Attribute.GCLeafFunction);
        return call;
    }

    private void setSpecialRegisterValue(SpecialRegister reg, LLVMValueRef value) {
        assert (this.getInitialSpecialRegisterValue(reg, this.currentBlock) != null);
        this.specialRegValues.computeIfAbsent((Block)this.currentBlock, (Function<Block, LLVMValueRef[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setSpecialRegisterValue$3(org.graalvm.compiler.nodes.cfg.Block ), (Lorg/graalvm/compiler/nodes/cfg/Block;)[Lcom/oracle/svm/shadowed/org/bytedeco/llvm/LLVM/LLVMValueRef;)())[((SpecialRegister)reg).index] = value;
    }

    void setInitialSpecialRegisterValue(SpecialRegister reg, LLVMValueRef value) {
        this.initialSpecialRegValues.computeIfAbsent((Block)this.currentBlock, (Function<Block, LLVMValueRef[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setInitialSpecialRegisterValue$4(org.graalvm.compiler.nodes.cfg.Block ), (Lorg/graalvm/compiler/nodes/cfg/Block;)[Lcom/oracle/svm/shadowed/org/bytedeco/llvm/LLVM/LLVMValueRef;)())[((SpecialRegister)reg).index] = value;
        this.setSpecialRegisterValue(reg, value);
    }

    private void setHandlerSpecialRegisterValue(SpecialRegister reg, LLVMValueRef value) {
        this.handlerSpecialRegValues.computeIfAbsent((Block)this.currentBlock, (Function<Block, LLVMValueRef[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setHandlerSpecialRegisterValue$5(org.graalvm.compiler.nodes.cfg.Block ), (Lorg/graalvm/compiler/nodes/cfg/Block;)[Lcom/oracle/svm/shadowed/org/bytedeco/llvm/LLVM/LLVMValueRef;)())[((SpecialRegister)reg).index] = value;
    }

    public LLVMValueRef getSpecialRegister(SpecialRegister register) {
        LLVMValueRef specialRegister;
        if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            return this.getSpecialRegisterValue(register);
        }
        if (this.isEntryPoint || this.canModifySpecialRegisters) {
            LLVMValueRef specialRegisterPointer = this.getSpecialRegisterPointer(register);
            specialRegister = this.builder.buildLoad(specialRegisterPointer, this.builder.wordType());
        } else {
            specialRegister = this.builder.getFunctionParam(register.index);
        }
        return specialRegister;
    }

    private LLVMValueRef getSpecialRegisterPointer(SpecialRegister register) {
        assert (!((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue());
        if (this.isEntryPoint) {
            return this.stackSlots[register.index];
        }
        if (this.canModifySpecialRegisters) {
            return this.builder.getFunctionParam(register.index);
        }
        throw VMError.shouldNotReachHere();
    }

    private LLVMValueRef getSpecialRegisterArgument(SpecialRegister register, ResolvedJavaMethod targetMethod) {
        LLVMValueRef specialRegisterArg;
        if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            return this.getSpecialRegisterValue(register);
        }
        if (targetMethod != null && this.canModifySpecialRegisters(targetMethod)) {
            if (this.isEntryPoint || this.canModifySpecialRegisters) {
                specialRegisterArg = this.getSpecialRegisterPointer(register);
            } else {
                assert (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)targetMethod, Uninterruptible.class));
                specialRegisterArg = this.builder.constantNull(this.builder.pointerType(this.builder.wordType()));
            }
        } else {
            specialRegisterArg = this.isEntryPoint || this.canModifySpecialRegisters ? this.builder.buildLoad(this.getSpecialRegisterPointer(register), this.builder.wordType()) : this.getSpecialRegister(register);
        }
        return specialRegisterArg;
    }

    LLVMValueRef getSpecialRegisterValue(SpecialRegister reg) {
        return this.getSpecialRegisterValue(reg, this.currentBlock);
    }

    LLVMValueRef getSpecialRegisterValue(SpecialRegister reg, Block block) {
        return this.specialRegValues.get(block)[reg.index];
    }

    LLVMValueRef getInitialSpecialRegisterValue(SpecialRegister reg, Block block) {
        if (!this.initialSpecialRegValues.containsKey(block)) {
            return null;
        }
        return this.initialSpecialRegValues.get(block)[reg.index];
    }

    LLVMValueRef getHandlerSpecialRegisterValue(SpecialRegister reg, Block block) {
        return this.handlerSpecialRegValues.get(block)[reg.index];
    }

    public LIRGenerationResult getResult() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't produce an LIRGenerationResult");
    }

    public LIRGeneratorTool.MoveFactory getMoveFactory() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't use LIR moves");
    }

    public LIRGeneratorTool.MoveFactory getSpillMoveFactory() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't use LIR moves");
    }

    public void emitNullCheck(Value address, LIRFrameState state) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support deoptimization");
    }

    public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support deoptimization");
    }

    public void emitFarReturn(AllocatableValue result, Value sp, Value ip, boolean fromMethodWithCalleeSavedRegisters) {
        throw GraalError.unimplemented((String)"the LLVM backend delegates exception handling to libunwind");
    }

    public void emitUnwind(Value operand) {
        throw GraalError.shouldNotReachHere((String)"handled by lowering");
    }

    public void emitVerificationMarker(Object marker) {
    }

    public void emitInstructionSynchronizationBarrier() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support instruction synchronization");
    }

    public <I extends LIRInstruction> I append(I op) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support LIR instructions");
    }

    public void emitSpeculationFence() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support speculative execution attack mitigation");
    }

    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public StandardOp.ZapRegistersOp createZapRegisters() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    public LIRInstruction zapArgumentSpace() {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support diagnostic operations");
    }

    private static /* synthetic */ LLVMValueRef[] lambda$setHandlerSpecialRegisterValue$5(Block b) {
        return new LLVMValueRef[SpecialRegister.count()];
    }

    private static /* synthetic */ LLVMValueRef[] lambda$setInitialSpecialRegisterValue$4(Block b) {
        return new LLVMValueRef[SpecialRegister.count()];
    }

    private static /* synthetic */ LLVMValueRef[] lambda$setSpecialRegisterValue$3(Block b) {
        return new LLVMValueRef[SpecialRegister.count()];
    }

    static class DebugInfoPrinter {
        private LLVMGenerator gen;
        private LLVMIRBuilder builder;
        private int debugLevel;
        private LLVMValueRef indentCounter;
        private LLVMValueRef spacesVector;

        DebugInfoPrinter(LLVMGenerator gen, int debugLevel) {
            this.gen = gen;
            this.builder = gen.getBuilder();
            this.debugLevel = debugLevel;
            if (debugLevel >= DebugLevel.Function.level) {
                this.indentCounter = this.builder.getUniqueGlobal("__svm_indent_counter", this.builder.intType(), true);
                this.spacesVector = this.builder.getUniqueGlobal("__svm_spaces_vector", this.builder.vectorType(this.builder.rawPointerType(), 100), false);
                StringBuilder strBuilder = new StringBuilder();
                LLVMValueRef[] strings = new LLVMValueRef[100];
                for (int i = 0; i < 100; ++i) {
                    strings[i] = this.builder.getUniqueGlobal("__svm_" + i + "_spaces", this.builder.arrayType(this.builder.byteType(), strBuilder.length() + 1), false);
                    this.builder.setInitializer(strings[i], this.builder.constantString(strBuilder.toString()));
                    strings[i] = this.builder.buildBitcast(strings[i], this.builder.rawPointerType());
                    strBuilder.append(' ');
                }
                this.builder.setInitializer(this.spacesVector, this.builder.constantVector(strings));
            }
        }

        void printFunction(StructuredGraph graph, NodeLLVMBuilder nodeBuilder) {
            if (this.debugLevel >= DebugLevel.Function.level) {
                this.indent();
                ArrayList<JavaKind> printfTypes = new ArrayList<JavaKind>();
                ArrayList<LLVMValueRef> printfArgs = new ArrayList<LLVMValueRef>();
                for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                    printfTypes.add(param.getStackKind());
                    printfArgs.add(LLVMUtils.getVal(nodeBuilder.operand((Node)param)));
                }
                String functionName = this.gen.getFunctionName();
                this.emitPrintf("In " + functionName, printfTypes.toArray(new JavaKind[0]), printfArgs.toArray(new LLVMValueRef[0]));
            }
        }

        void printBlock(Block block) {
            if (this.debugLevel >= DebugLevel.Block.level) {
                this.emitPrintf("In block " + block.toString());
            }
        }

        void printNode(ValueNode valueNode) {
            if (this.debugLevel >= DebugLevel.Node.level) {
                this.emitPrintf(valueNode.toString());
            }
        }

        void printIndirectCall(ResolvedJavaMethod targetMethod, LLVMValueRef callee) {
            if (this.debugLevel >= DebugLevel.Node.level) {
                this.emitPrintf("Indirect call to " + (targetMethod != null ? targetMethod.getName() : "[unknown]"), new JavaKind[]{JavaKind.Object}, new LLVMValueRef[]{callee});
            }
        }

        void printBreakpoint() {
            if (this.debugLevel >= DebugLevel.Function.level) {
                this.emitPrintf("breakpoint");
            }
        }

        void printRetVoid() {
            if (this.debugLevel >= DebugLevel.Function.level) {
                this.emitPrintf("Return");
                this.deindent();
            }
        }

        void printRet(JavaKind kind, Value input) {
            if (this.debugLevel >= DebugLevel.Function.level) {
                this.emitPrintf("Return", new JavaKind[]{kind}, new LLVMValueRef[]{LLVMUtils.getVal(input)});
                this.deindent();
            }
        }

        void setValueName(LLVMUtils.LLVMValueWrapper value, ValueNode node) {
            if (this.debugLevel >= DebugLevel.Node.level && node.getStackKind() != JavaKind.Void) {
                this.builder.setValueName(value.get(), node.toString());
            }
        }

        void indent() {
            LLVMValueRef counter = this.builder.buildLoad(this.indentCounter);
            LLVMValueRef newCounter = this.builder.buildAdd(counter, this.builder.constantInt(1));
            this.builder.buildStore(newCounter, this.indentCounter);
        }

        private void deindent() {
            LLVMValueRef counter = this.builder.buildLoad(this.indentCounter);
            LLVMValueRef newCounter = this.builder.buildSub(counter, this.builder.constantInt(1));
            this.builder.buildStore(newCounter, this.indentCounter);
        }

        private void emitPrintf(String base) {
            this.emitPrintf(base, new JavaKind[0], new LLVMValueRef[0]);
        }

        private void emitPrintf(String base, JavaKind[] types, LLVMValueRef[] values) {
            LLVMValueRef printf = this.builder.getFunction("printf", this.builder.functionType(this.builder.intType(), true, this.builder.rawPointerType()));
            if (this.debugLevel >= DebugLevel.Function.level) {
                LLVMValueRef count = this.builder.buildLoad(this.indentCounter);
                LLVMValueRef vector = this.builder.buildLoad(this.spacesVector);
                LLVMValueRef spaces = this.builder.buildExtractElement(vector, count);
                this.builder.buildCall(printf, spaces);
            }
            StringBuilder introString = new StringBuilder(base);
            ArrayList<LLVMValueRef> printfArgs = new ArrayList<LLVMValueRef>();
            assert (types.length == values.length);
            for (int i = 0; i < types.length; ++i) {
                switch (types[i]) {
                    case Boolean: 
                    case Byte: {
                        introString.append(" %hhd ");
                        break;
                    }
                    case Short: {
                        introString.append(" %hd ");
                        break;
                    }
                    case Char: {
                        introString.append(" %c ");
                        break;
                    }
                    case Int: {
                        introString.append(" %ld ");
                        break;
                    }
                    case Float: 
                    case Double: {
                        introString.append(" %f ");
                        break;
                    }
                    case Long: {
                        introString.append(" %lld ");
                        break;
                    }
                    case Object: {
                        introString.append(" %p ");
                        break;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere();
                    }
                }
                printfArgs.add(values[i]);
            }
            introString.append("\n");
            printfArgs.add(0, this.builder.buildGlobalStringPtr(introString.toString()));
            this.builder.buildCall(printf, printfArgs.toArray(new LLVMValueRef[0]));
        }

        public static enum DebugLevel {
            Function(1),
            Block(2),
            Node(3);

            private int level;

            private DebugLevel(int level) {
                this.level = level;
            }
        }
    }

    public static class ArithmeticLLVMGenerator
    implements ArithmeticLIRGeneratorTool,
    LLVMIntrinsicGenerator {
        private final LLVMIRBuilder builder;

        ArithmeticLLVMGenerator(LLVMIRBuilder builder) {
            this.builder = builder;
        }

        public Value emitNegate(Value input) {
            LLVMValueRef neg = this.builder.buildNeg(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(neg);
        }

        public Value emitAdd(Value a, Value b, boolean setFlags) {
            LLVMValueRef add = this.builder.buildAdd(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(add);
        }

        public Value emitSub(Value a, Value b, boolean setFlags) {
            LLVMValueRef sub = this.builder.buildSub(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(sub);
        }

        public Value emitMul(Value a, Value b, boolean setFlags) {
            LLVMValueRef mul = this.builder.buildMul(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(mul);
        }

        public Value emitMulHigh(Value a, Value b) {
            return this.emitMulHigh(a, b, true);
        }

        public Value emitUMulHigh(Value a, Value b) {
            return this.emitMulHigh(a, b, false);
        }

        private LLVMUtils.LLVMVariable emitMulHigh(Value a, Value b, boolean signed) {
            LLVMValueRef valA = LLVMUtils.getVal(a);
            LLVMValueRef valB = LLVMUtils.getVal(b);
            assert (LLVMIRBuilder.compatibleTypes(LLVMIRBuilder.typeOf(valA), LLVMIRBuilder.typeOf(valB))) : LLVMUtils.dumpValues("invalid mulhigh arguments", valA, valB);
            int baseBits = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(valA));
            int extendedBits = baseBits * 2;
            BiFunction<LLVMValueRef, Integer, LLVMValueRef> extend = signed ? this.builder::buildSExt : this.builder::buildZExt;
            valA = extend.apply(valA, extendedBits);
            valB = extend.apply(valB, extendedBits);
            LLVMValueRef mul = this.builder.buildMul(valA, valB);
            BiFunction<LLVMValueRef, LLVMValueRef, LLVMValueRef> shift = signed ? this.builder::buildShr : this.builder::buildUShr;
            LLVMValueRef shiftedMul = shift.apply(mul, this.builder.constantInteger(baseBits, extendedBits));
            LLVMValueRef truncatedMul = this.builder.buildTrunc(shiftedMul, baseBits);
            return new LLVMUtils.LLVMVariable(truncatedMul);
        }

        public Value emitDiv(Value a, Value b, LIRFrameState state) {
            LLVMValueRef div = this.builder.buildDiv(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(div);
        }

        public Value emitRem(Value a, Value b, LIRFrameState state) {
            LLVMValueRef rem = this.builder.buildRem(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(rem);
        }

        public Value emitUDiv(Value a, Value b, LIRFrameState state) {
            LLVMValueRef uDiv = this.builder.buildUDiv(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(uDiv);
        }

        public Value emitURem(Value a, Value b, LIRFrameState state) {
            LLVMValueRef uRem = this.builder.buildURem(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(uRem);
        }

        public Value emitNot(Value input) {
            LLVMValueRef not = this.builder.buildNot(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(not);
        }

        public Value emitAnd(Value a, Value b) {
            LLVMValueRef and = this.builder.buildAnd(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(and);
        }

        public Value emitOr(Value a, Value b) {
            LLVMValueRef or = this.builder.buildOr(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(or);
        }

        public Value emitXor(Value a, Value b) {
            LLVMValueRef xor = this.builder.buildXor(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(xor);
        }

        public Value emitShl(Value a, Value b) {
            LLVMValueRef valA = LLVMUtils.getVal(a);
            LLVMValueRef shl = this.builder.buildShl(valA, this.emitIntegerConvert(LLVMUtils.getVal(b), LLVMIRBuilder.typeOf(valA)));
            return new LLVMUtils.LLVMVariable(shl);
        }

        public Value emitShr(Value a, Value b) {
            LLVMValueRef valA = LLVMUtils.getVal(a);
            LLVMValueRef shr = this.builder.buildShr(valA, this.emitIntegerConvert(LLVMUtils.getVal(b), LLVMIRBuilder.typeOf(valA)));
            return new LLVMUtils.LLVMVariable(shr);
        }

        public Value emitUShr(Value a, Value b) {
            LLVMValueRef valA = LLVMUtils.getVal(a);
            LLVMValueRef ushr = this.builder.buildUShr(valA, this.emitIntegerConvert(LLVMUtils.getVal(b), LLVMIRBuilder.typeOf(valA)));
            return new LLVMUtils.LLVMVariable(ushr);
        }

        private LLVMValueRef emitIntegerConvert(LLVMValueRef value, LLVMTypeRef type) {
            int toBits;
            int fromBits = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(value));
            if (fromBits < (toBits = LLVMIRBuilder.integerTypeWidth(type))) {
                return fromBits == 1 ? this.builder.buildZExt(value, toBits) : this.builder.buildSExt(value, toBits);
            }
            if (fromBits > toBits) {
                return this.builder.buildTrunc(value, toBits);
            }
            return value;
        }

        public Value emitFloatConvert(FloatConvert op, Value inputVal) {
            LLVMValueRef convert;
            LLVMTypeRef destType;
            switch (op) {
                case F2I: 
                case D2I: {
                    destType = this.builder.intType();
                    break;
                }
                case F2L: 
                case D2L: {
                    destType = this.builder.longType();
                    break;
                }
                case I2F: 
                case L2F: 
                case D2F: {
                    destType = this.builder.floatType();
                    break;
                }
                case I2D: 
                case L2D: 
                case F2D: {
                    destType = this.builder.doubleType();
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere((String)"invalid FloatConvert type");
                }
            }
            switch (op.getCategory()) {
                case FloatingPointToInteger: {
                    convert = this.builder.buildFPToSI(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                case IntegerToFloatingPoint: {
                    convert = this.builder.buildSIToFP(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                case FloatingPointToFloatingPoint: {
                    convert = this.builder.buildFPCast(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere((String)"invalid FloatConvert type");
                }
            }
            return new LLVMUtils.LLVMVariable(convert);
        }

        public Value emitReinterpret(LIRKind to, Value inputVal) {
            LLVMTypeRef type = LLVMUtils.getType(to);
            LLVMValueRef cast = this.builder.buildBitcast(LLVMUtils.getVal(inputVal), type);
            return new LLVMUtils.LLVMVariable(cast);
        }

        public Value emitNarrow(Value inputVal, int bits) {
            LLVMValueRef narrow = this.builder.buildTrunc(LLVMUtils.getVal(inputVal), bits);
            return new LLVMUtils.LLVMVariable(narrow);
        }

        public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
            LLVMValueRef signExtend = this.builder.buildSExt(LLVMUtils.getVal(inputVal), toBits);
            return new LLVMUtils.LLVMVariable(signExtend);
        }

        public Value emitZeroExtend(Value inputVal, int fromBits, int toBits) {
            LLVMValueRef zeroExtend = this.builder.buildZExt(LLVMUtils.getVal(inputVal), toBits);
            return new LLVMUtils.LLVMVariable(zeroExtend);
        }

        public Value emitMathAbs(Value input) {
            LLVMValueRef abs = this.builder.buildAbs(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(abs);
        }

        public Value emitMathSqrt(Value input) {
            LLVMValueRef sqrt = this.builder.buildSqrt(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(sqrt);
        }

        public Value emitMathLog(Value input, boolean base10) {
            LLVMValueRef value = LLVMUtils.getVal(input);
            LLVMValueRef log = base10 ? this.builder.buildLog10(value) : this.builder.buildLog(value);
            return new LLVMUtils.LLVMVariable(log);
        }

        public Value emitMathCos(Value input) {
            LLVMValueRef cos = this.builder.buildCos(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(cos);
        }

        public Value emitMathSin(Value input) {
            LLVMValueRef sin = this.builder.buildSin(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(sin);
        }

        public Value emitMathTan(Value input) {
            LLVMValueRef value = LLVMUtils.getVal(input);
            LLVMValueRef sin = this.builder.buildSin(value);
            LLVMValueRef cos = this.builder.buildCos(value);
            LLVMValueRef tan = this.builder.buildDiv(sin, cos);
            return new LLVMUtils.LLVMVariable(tan);
        }

        public Value emitMathExp(Value input) {
            LLVMValueRef exp = this.builder.buildExp(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(exp);
        }

        public Value emitMathPow(Value x, Value y) {
            LLVMValueRef pow = this.builder.buildPow(LLVMUtils.getVal(x), LLVMUtils.getVal(y));
            return new LLVMUtils.LLVMVariable(pow);
        }

        @Override
        public Value emitMathCeil(Value input) {
            LLVMValueRef ceil = this.builder.buildCeil(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(ceil);
        }

        @Override
        public Value emitMathFloor(Value input) {
            LLVMValueRef floor = this.builder.buildFloor(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(floor);
        }

        @Override
        public Value emitCountLeadingZeros(Value input) {
            LLVMValueRef ctlz = this.builder.buildCtlz(LLVMUtils.getVal(input));
            ctlz = this.emitIntegerConvert(ctlz, this.builder.intType());
            return new LLVMUtils.LLVMVariable(ctlz);
        }

        @Override
        public Value emitCountTrailingZeros(Value input) {
            LLVMValueRef cttz = this.builder.buildCttz(LLVMUtils.getVal(input));
            cttz = this.emitIntegerConvert(cttz, this.builder.intType());
            return new LLVMUtils.LLVMVariable(cttz);
        }

        public Value emitBitCount(Value operand) {
            LLVMValueRef op = LLVMUtils.getVal(operand);
            LLVMValueRef answer = this.builder.buildCtpop(op);
            answer = this.emitIntegerConvert(answer, this.builder.intType());
            return new LLVMUtils.LLVMVariable(answer);
        }

        public Value emitBitScanForward(Value operand) {
            int expectedSize;
            LLVMValueRef op = LLVMUtils.getVal(operand);
            LLVMValueRef trailingZeros = this.builder.buildCttz(op);
            int resultSize = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(trailingZeros));
            if (resultSize < (expectedSize = JavaKind.Int.getBitCount())) {
                trailingZeros = this.builder.buildZExt(trailingZeros, expectedSize);
            } else if (resultSize > expectedSize) {
                trailingZeros = this.builder.buildTrunc(trailingZeros, expectedSize);
            }
            return new LLVMUtils.LLVMVariable(trailingZeros);
        }

        public Value emitBitScanReverse(Value operand) {
            LLVMValueRef op = LLVMUtils.getVal(operand);
            int opSize = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(op));
            int expectedSize = JavaKind.Int.getBitCount();
            LLVMValueRef leadingZeros = this.builder.buildCtlz(op);
            if (opSize < expectedSize) {
                leadingZeros = this.builder.buildZExt(leadingZeros, expectedSize);
            } else if (opSize > expectedSize) {
                leadingZeros = this.builder.buildTrunc(leadingZeros, expectedSize);
            }
            LLVMValueRef result = this.builder.buildSub(this.builder.constantInt(opSize - 1), leadingZeros);
            return new LLVMUtils.LLVMVariable(result);
        }

        public Value emitFusedMultiplyAdd(Value a, Value b, Value c) {
            LLVMValueRef fma = this.builder.buildFma(LLVMUtils.getVal(a), LLVMUtils.getVal(b), LLVMUtils.getVal(c));
            return new LLVMUtils.LLVMVariable(fma);
        }

        @Override
        public Value emitMathMin(Value a, Value b) {
            LLVMValueRef min = this.builder.buildMin(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(min);
        }

        @Override
        public Value emitMathMax(Value a, Value b) {
            LLVMValueRef max = this.builder.buildMax(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(max);
        }

        @Override
        public Value emitMathCopySign(Value a, Value b) {
            LLVMValueRef copySign = this.builder.buildCopysign(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(copySign);
        }

        public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state) {
            LLVMValueRef load = this.builder.buildLoad(LLVMUtils.getVal(address), LLVMUtils.getType(kind));
            return new LLVMUtils.LLVMVariable(load);
        }

        public void emitStore(ValueKind<?> kind, Value addr, Value input, LIRFrameState state) {
            LLVMValueRef address = LLVMUtils.getVal(addr);
            LLVMValueRef value = LLVMUtils.getVal(input);
            LLVMTypeRef addressType = LLVMIRBuilder.typeOf(address);
            LLVMTypeRef valueType = LLVMIRBuilder.typeOf(value);
            LLVMValueRef castedValue = value;
            if (LLVMIRBuilder.isObjectType(valueType) && !LLVMIRBuilder.isObjectType(addressType)) {
                valueType = this.builder.rawPointerType();
                castedValue = this.builder.buildAddrSpaceCast(value, this.builder.rawPointerType());
            }
            LLVMValueRef castedAddress = this.builder.buildBitcast(address, this.builder.pointerType(valueType, LLVMIRBuilder.isObjectType(addressType), false));
            this.builder.buildStore(castedValue, castedAddress);
        }

        public Variable emitVolatileLoad(LIRKind kind, Value address, LIRFrameState state) {
            throw GraalError.shouldNotReachHere();
        }

        public void emitVolatileStore(ValueKind<?> kind, Value address, Value input, LIRFrameState state) {
            throw GraalError.shouldNotReachHere();
        }
    }

    public static enum SpecialRegister {
        ThreadPointer((Boolean)SubstrateOptions.MultiThreaded.getValue()),
        HeapBase((Boolean)SubstrateOptions.SpawnIsolates.getValue());

        private static final int presentCount;
        private static final SpecialRegister[] presentRegisters;
        private boolean isPresent;
        private int index;

        private SpecialRegister(boolean isPresent) {
            this.isPresent = isPresent;
        }

        int getIndex() {
            return this.index;
        }

        static boolean hasRegisters() {
            return presentCount > 0;
        }

        static int count() {
            return presentCount;
        }

        static SpecialRegister[] registers() {
            return (SpecialRegister[])presentRegisters.clone();
        }

        static {
            int index = 0;
            for (SpecialRegister reg : SpecialRegister.values()) {
                if (!reg.isPresent) continue;
                reg.index = index++;
            }
            presentCount = index;
            presentRegisters = new SpecialRegister[presentCount];
            for (SpecialRegister reg : SpecialRegister.values()) {
                if (!reg.isPresent) continue;
                SpecialRegister.presentRegisters[reg.index] = reg;
            }
        }
    }
}

