/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SerializeArgumentLibrary.CharConversion.class)
final class CharConversionGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    private CharConversionGen() {
    }

    static {
        LibraryExport.register(SerializeArgumentLibrary.CharConversion.class, (LibraryExport[])new LibraryExport[]{new SerializeArgumentLibraryExports()});
    }

    @GeneratedBy(value=SerializeArgumentLibrary.CharConversion.class)
    private static final class SerializeArgumentLibraryExports
    extends LibraryExport<SerializeArgumentLibrary> {
        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, Character.class, true);
        }

        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof Character);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof Character);
            return new Cached();
        }

        @GeneratedBy(value=SerializeArgumentLibrary.CharConversion.class)
        private static final class Uncached
        extends SerializeArgumentLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof Character) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Character;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putByte(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putUByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putUByte(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putShort(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putUShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putUShort(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putInt(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putUInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putUInt(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putLong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putLong(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putULong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putULong(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putFloat(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putFloat(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putDouble(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character)arg0Value_;
                SerializeArgumentLibrary.CharConversion.putDouble(arg0Value, arg1Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached((Object)SerializeArgumentLibrary.CharConversion.zero()));
            }
        }

        @GeneratedBy(value=SerializeArgumentLibrary.CharConversion.class)
        private static final class Cached
        extends SerializeArgumentLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private SerializeArgumentLibrary putByteNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putUByteNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putShortNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putUShortNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putIntNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putUIntNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putLongNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putULongNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putFloatNode__serialize_;
            @Node.Child
            private SerializeArgumentLibrary putDoubleNode__serialize_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof Character) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Character;
            }

            @Override
            public void putByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    assert (this.putByteNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putByte(arg0Value, arg1Value, this.putByteNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putByteNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putByteNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putByte(arg0Value, arg1Value, this.putByteNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void putUByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    assert (this.putUByteNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putUByte(arg0Value, arg1Value, this.putUByteNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putUByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putUByteNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putUByteNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putUByte(arg0Value, arg1Value, this.putUByteNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    assert (this.putShortNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putShort(arg0Value, arg1Value, this.putShortNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putShortNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putShortNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putShortNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putShort(arg0Value, arg1Value, this.putShortNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    assert (this.putUShortNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putUShort(arg0Value, arg1Value, this.putUShortNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putUShortNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putUShortNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putUShortNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putUShort(arg0Value, arg1Value, this.putUShortNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    assert (this.putIntNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putInt(arg0Value, arg1Value, this.putIntNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putIntNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putIntNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putIntNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putInt(arg0Value, arg1Value, this.putIntNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    assert (this.putUIntNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putUInt(arg0Value, arg1Value, this.putUIntNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putUIntNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putUIntNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putUIntNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putUInt(arg0Value, arg1Value, this.putUIntNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putLong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    assert (this.putLongNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putLong(arg0Value, arg1Value, this.putLongNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putLongNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putLongNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putLongNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putLong(arg0Value, arg1Value, this.putLongNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putULong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    assert (this.putULongNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putULong(arg0Value, arg1Value, this.putULongNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putULongNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putULongNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putULongNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putULong(arg0Value, arg1Value, this.putULongNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putFloat(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x100) != 0) {
                    assert (this.putFloatNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putFloat(arg0Value, arg1Value, this.putFloatNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putFloatNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putFloatNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putFloat(arg0Value, arg1Value, this.putFloatNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putDouble(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                Character arg0Value = (Character)arg0Value_;
                int state = this.state_;
                if ((state & 0x200) != 0) {
                    assert (this.putDoubleNode__serialize_.accepts(SerializeArgumentLibrary.CharConversion.zero()));
                    SerializeArgumentLibrary.CharConversion.putDouble(arg0Value, arg1Value, this.putDoubleNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void putDoubleNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.putDoubleNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.create((Object)SerializeArgumentLibrary.CharConversion.zero()));
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    SerializeArgumentLibrary.CharConversion.putDouble(arg0Value, arg1Value, this.putDoubleNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

