/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFILibrary;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;

@ExportLibrary(value=InteropLibrary.class)
final class NFISymbol
implements TruffleObject {
    private static final Object NO_SIGNATURE = new Object();
    final Object nativeSymbol;
    final Object signature;

    static NFISymbol createBindable(Object nativeSymbol) {
        return new NFISymbol(nativeSymbol, NO_SIGNATURE);
    }

    static NFISymbol createBound(Object nativeSymbol, Object signature) {
        return new NFISymbol(nativeSymbol, signature);
    }

    private NFISymbol(Object nativeSymbol, Object signature) {
        this.nativeSymbol = nativeSymbol;
        this.signature = signature;
    }

    @ExportMessage
    boolean isExecutable() {
        return this.signature != NO_SIGNATURE;
    }

    @ExportMessage
    Object execute(Object[] args, @CachedLibrary(value="this.nativeSymbol") NativeSymbolLibrary library, @Cached.Exclusive @Cached BranchProfile exception) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (this.isExecutable()) {
            return library.call(this.nativeSymbol, this.signature, args);
        }
        exception.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new NFILibrary.Keys("bind");
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return "bind".equals(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached BindSignatureNode bind, @CachedLibrary(value="this.nativeSymbol") NativeSymbolLibrary symbolLibrary, @Cached ConditionProfile isCallable, @Cached.Exclusive @Cached BranchProfile exception) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        if (!"bind".equals(member)) {
            exception.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        if (args.length != 1) {
            exception.enter();
            throw ArityException.create((int)1, (int)args.length);
        }
        if (isCallable.profile(symbolLibrary.isBindable(this.nativeSymbol))) {
            return bind.execute(this.nativeSymbol, args[0]);
        }
        return this;
    }

    @ExportMessage
    boolean isNull(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        return library.isNull(this.nativeSymbol);
    }

    @ExportMessage
    boolean isPointer(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        return library.isPointer(this.nativeSymbol);
    }

    @ExportMessage
    long asPointer(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) throws UnsupportedMessageException {
        return library.asPointer(this.nativeSymbol);
    }

    @ExportMessage
    void toNative(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        library.toNative(this.nativeSymbol);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return NFILanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return "Native Symbol";
    }
}

