/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=BindSignatureNode.class)
final class BindSignatureNodeGen
extends BindSignatureNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedSignatureData cachedSignature_cache;
    @Node.Child
    private CachedSignatureStringData cachedSignatureString_cache;
    @Node.Child
    private Generic0Data generic0_cache;

    private BindSignatureNodeGen() {
    }

    @Override
    @ExplodeLoop
    Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    if (s1_.symbolLibrary_.accepts(arg0Value) && arg1Value == s1_.cachedSignature_) {
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                while (s2_ != null) {
                    if (s2_.interop_.accepts(arg1Value) && s2_.symbolLibrary_.accepts(arg0Value) && s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value))) {
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.symbolLibrary_, s2_.parsedSignature_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                Generic0Data s3_ = this.generic0_cache;
                while (s3_ != null) {
                    if (s3_.interop_.accepts(arg1Value) && s3_.symbolLibrary_.accepts(arg0Value)) {
                        return BindSignatureNode.doGeneric(arg0Value, arg1Value, s3_.interop_, s3_.symbolLibrary_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                return this.generic1Boundary(state, arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object generic1Boundary(int state, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary generic1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
            NativeSymbolLibrary generic1_symbolLibrary__ = (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value);
            Object object = BindSignatureNode.doGeneric(arg0Value, arg1Value, generic1_interop__, generic1_symbolLibrary__);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Object object;
            Object interop__;
            if ((exclude & 1) == 0) {
                int count1_ = 0;
                CachedSignatureData s1_ = this.cachedSignature_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.interop_.accepts(s1_.cachedSignature_));
                        if (s1_.symbolLibrary_.accepts(arg0Value) && arg1Value == s1_.cachedSignature_) break;
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 5) {
                    s1_ = (CachedSignatureData)super.insert((Node)new CachedSignatureData(this.cachedSignature_cache));
                    s1_.cachedSignature_ = arg1Value;
                    s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(s1_.cachedSignature_));
                    s1_.symbolLibrary_ = (NativeSymbolLibrary)s1_.insertAccessor(NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    s1_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_);
                    this.cachedSignature_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object2 = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    return object2;
                }
            }
            if ((exclude & 2) == 0) {
                String cachedSignature__;
                int count2_ = 0;
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.interop_.accepts(arg1Value) && s2_.symbolLibrary_.accepts(arg0Value) && s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value)))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (cachedSignature__ = BindSignatureNode.asString(interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg1Value)), arg1Value)).equals(BindSignatureNode.asString(interop__, arg1Value)) && count2_ < 5) {
                    s2_ = (CachedSignatureStringData)super.insert((Node)new CachedSignatureStringData(this.cachedSignatureString_cache));
                    s2_.interop_ = s2_.insertAccessor(interop__);
                    s2_.cachedSignature_ = cachedSignature__;
                    s2_.symbolLibrary_ = (NativeSymbolLibrary)s2_.insertAccessor(NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    s2_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, s2_.symbolLibrary_);
                    this.cachedSignatureString_cache = s2_;
                    this.exclude_ = exclude |= 1;
                    this.cachedSignature_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    interop__ = BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.symbolLibrary_, s2_.parsedSignature_);
                    return interop__;
                }
            }
            if ((exclude & 4) == 0) {
                int count3_ = 0;
                Generic0Data s3_ = this.generic0_cache;
                if ((state & 4) != 0) {
                    while (!(s3_ == null || s3_.interop_.accepts(arg1Value) && s3_.symbolLibrary_.accepts(arg0Value))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && count3_ < 3) {
                    s3_ = (Generic0Data)super.insert((Node)new Generic0Data(this.generic0_cache));
                    s3_.interop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                    s3_.symbolLibrary_ = (NativeSymbolLibrary)s3_.insertAccessor(NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    this.generic0_cache = s3_;
                    this.exclude_ = exclude |= 3;
                    this.cachedSignature_cache = null;
                    this.cachedSignatureString_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    interop__ = BindSignatureNode.doGeneric(arg0Value, arg1Value, s3_.interop_, s3_.symbolLibrary_);
                    return interop__;
                }
            }
            NativeSymbolLibrary generic1_symbolLibrary__ = null;
            InteropLibrary generic1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                generic1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                generic1_symbolLibrary__ = (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value);
                this.exclude_ = exclude |= 7;
                this.cachedSignature_cache = null;
                this.cachedSignatureString_cache = null;
                this.generic0_cache = null;
                state &= 0xFFFFFFF8;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                object = BindSignatureNode.doGeneric(arg0Value, arg1Value, generic1_interop__, generic1_symbolLibrary__);
            }
            catch (Throwable throwable) {
                encapsulating_.set(prev_);
                throw throwable;
            }
            encapsulating_.set(prev_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedSignatureData s1_ = this.cachedSignature_cache;
            CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
            Generic0Data s3_ = this.generic0_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Uncached
    extends BindSignatureNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Generic0Data
    extends Node {
        @Node.Child
        Generic0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;

        Generic0Data(Generic0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureStringData
    extends Node {
        @Node.Child
        CachedSignatureStringData next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        String cachedSignature_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignatureStringData(CachedSignatureStringData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureData
    extends Node {
        @Node.Child
        CachedSignatureData next_;
        @CompilerDirectives.CompilationFinal
        Object cachedSignature_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

