/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.SnapshotResultsWindow;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshot;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

final class ProfilerSnapshotNPS
extends ProfilerSnapshot {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotNPS.class.getName());
    private LoadedSnapshot loadedSnapshot;
    private TopComponent srw;

    ProfilerSnapshotNPS() {
    }

    ProfilerSnapshotNPS(File snapshot, DataSource master) {
        super(snapshot, master);
        FileObject fobj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)snapshot));
        this.loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fobj);
    }

    @Override
    public LoadedSnapshot getLoadedSnapshot() {
        return this.loadedSnapshot;
    }

    @Override
    protected void remove() {
        super.remove();
        ResultsManager.getDefault().closeSnapshot(this.loadedSnapshot);
    }

    @Override
    protected Image resolveIcon() {
        try {
            int snapshotType = this.getLoadedSnapshot().getType();
            switch (snapshotType) {
                case 1: {
                    return ImageUtilities.mergeImages((Image)CPU_ICON, (Image)NODE_BADGE, (int)0, (int)0);
                }
                case 32: {
                    return ImageUtilities.mergeImages((Image)JDBC_ICON, (Image)NODE_BADGE, (int)0, (int)0);
                }
                case 4: 
                case 8: 
                case 16: {
                    return ImageUtilities.mergeImages((Image)MEMORY_ICON, (Image)NODE_BADGE, (int)0, (int)0);
                }
            }
            return ImageUtilities.mergeImages((Image)SNAPSHOT_ICON, (Image)NODE_BADGE, (int)0, (int)0);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine profiler snapshot type", e);
            return ImageUtilities.mergeImages((Image)SNAPSHOT_ICON, (Image)NODE_BADGE, (int)0, (int)0);
        }
    }

    @Override
    JComponent getUIComponent() {
        if (this.srw == null) {
            Component c;
            this.srw = SnapshotResultsWindow.get((LoadedSnapshot)this.loadedSnapshot, (int)-1, (boolean)false);
            this.srw.setPreferredSize(new Dimension(1, 1));
            DataSource master = this.getMaster();
            if (master instanceof Application && this.srw.getComponentCount() > 0 && (c = this.srw.getComponent(0)) instanceof JComponent) {
                ((JComponent)c).putClientProperty("profiled_application", master);
            }
        }
        return this.srw;
    }

    @Override
    void closeComponent() {
        if (this.srw != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Method method = ProfilerSnapshotNPS.this.srw.getClass().getDeclaredMethod("componentClosed", new Class[0]);
                        if (method != null) {
                            method.setAccessible(true);
                            method.invoke((Object)ProfilerSnapshotNPS.this.srw, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", securityException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", invocationTargetException);
                    }
                    ProfilerSnapshotNPS.this.srw = null;
                }
            });
        }
    }
}

