/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativeTypeLibrary.class)
final class NativeTypeLibraryGen
extends LibraryFactory<NativeTypeLibrary> {
    private static final Class<NativeTypeLibrary> LIBRARY_CLASS = NativeTypeLibraryGen.lazyLibraryClass();
    private static final Message HAS_NATIVE_TYPE = new MessageImpl("hasNativeType", 0, Boolean.TYPE, Object.class);
    private static final Message GET_NATIVE_TYPE = new MessageImpl("getNativeType", 1, Object.class, Object.class);
    private static final NativeTypeLibraryGen INSTANCE = new NativeTypeLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativeTypeLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(HAS_NATIVE_TYPE, GET_NATIVE_TYPE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NativeTypeLibrary.class;
    }

    protected NativeTypeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NativeTypeLibrary createDelegate(NativeTypeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeTypeLibrary lib = (NativeTypeLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.hasNativeType(receiver);
            }
            case 1: {
                return lib.getNativeType(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NativeTypeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NativeTypeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NativeTypeLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.spi.NativeTypeLibrary", false, NativeTypeLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static abstract class CachedDispatch
    extends NativeTypeLibrary {
        @Node.Child
        NativeTypeLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NativeTypeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean hasNativeType(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeTypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.hasNativeType(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getNativeType(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeTypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getNativeType(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            NativeTypeLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NativeTypeLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NativeTypeLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NativeTypeLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NativeTypeLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NativeTypeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NativeTypeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class UncachedDispatch
    extends NativeTypeLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNativeType(Object receiver_) {
            return ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).hasNativeType(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativeType(Object receiver_) {
            return ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).getNativeType(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NativeTypeLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNativeType(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).hasNativeType(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativeType(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).getNativeType(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Delegate
    extends NativeTypeLibrary {
        @Node.Child
        private NativeTypeLibrary delegateLibrary;

        Delegate(NativeTypeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean hasNativeType(Object receiver_) {
            if (NativeTypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NativeTypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeTypeLibrary)NativeTypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).hasNativeType(delegate);
            }
            return this.delegateLibrary.hasNativeType(receiver_);
        }

        @Override
        public Object getNativeType(Object receiver_) {
            if (NativeTypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NativeTypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeTypeLibrary)NativeTypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getNativeType(delegate);
            }
            return this.delegateLibrary.getNativeType(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Proxy
    extends NativeTypeLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean hasNativeType(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, HAS_NATIVE_TYPE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getNativeType(Object receiver_) {
            try {
                return this.lib.send(receiver_, GET_NATIVE_TYPE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Default
    extends LibraryExport<NativeTypeLibrary> {
        private Default() {
            super(NativeTypeLibrary.class, Object.class, false);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeTypeLibrary.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasNativeType(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativeType(receiver);
            }
        }

        @GeneratedBy(value=NativeTypeLibrary.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasNativeType(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativeType(this.dynamicDispatch_.cast(receiver));
            }
        }
    }
}

