/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ReferenceLibrary.InteropFallback.class)
final class InteropFallbackGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private InteropFallbackGen() {
    }

    static {
        LibraryExport.register(ReferenceLibrary.InteropFallback.class, (LibraryExport[])new LibraryExport[]{new ReferenceLibraryExports()});
    }

    @GeneratedBy(value=ReferenceLibrary.InteropFallback.class)
    private static final class ReferenceLibraryExports
    extends LibraryExport<ReferenceLibrary> {
        private ReferenceLibraryExports() {
            super(ReferenceLibrary.class, Object.class, true);
        }

        protected ReferenceLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ReferenceLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ReferenceLibrary.InteropFallback.class)
        private static final class Uncached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isSame(Object arg0Value, Object arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return ReferenceLibrary.InteropFallback.isSame(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }
        }

        @GeneratedBy(value=ReferenceLibrary.InteropFallback.class)
        private static final class Cached
        extends ReferenceLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private InteropLibrary otherInterop_;

            Cached(Object receiver) {
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != this.dynamicDispatchTarget_) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public boolean isSame(Object arg0Value, Object arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if (state != 0) {
                    InteropLibrary receiverInterop__ = this.receiverInteropLibrary_;
                    return ReferenceLibrary.InteropFallback.isSame(arg0Value, arg1Value, receiverInterop__, this.otherInterop_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(Object arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    InteropLibrary receiverInterop__ = null;
                    receiverInterop__ = this.receiverInteropLibrary_;
                    this.otherInterop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = ReferenceLibrary.InteropFallback.isSame(arg0Value, arg1Value, receiverInterop__, this.otherInterop_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

