/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotStackIntrospection;
import jdk.vm.ci.hotspot.amd64.AMD64HotSpotRegisterConfig;
import jdk.vm.ci.hotspot.amd64.AMD64HotSpotVMConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.runtime.JVMCIBackend;

public class AMD64HotSpotJVMCIBackendFactory
implements HotSpotJVMCIBackendFactory {
    private static EnumSet<AMD64.CPUFeature> computeFeatures(AMD64HotSpotVMConfig config) {
        EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
        if ((config.vmVersionFeatures & config.amd643DNOWPREFETCH) != 0L) {
            features.add(AMD64.CPUFeature.AMD_3DNOW_PREFETCH);
        }
        assert (config.useSSE >= 2) : "minimum config for x64";
        features.add(AMD64.CPUFeature.SSE);
        features.add(AMD64.CPUFeature.SSE2);
        if ((config.vmVersionFeatures & config.amd64SSE3) != 0L) {
            features.add(AMD64.CPUFeature.SSE3);
        }
        if ((config.vmVersionFeatures & config.amd64SSSE3) != 0L) {
            features.add(AMD64.CPUFeature.SSSE3);
        }
        if ((config.vmVersionFeatures & config.amd64SSE4A) != 0L) {
            features.add(AMD64.CPUFeature.SSE4A);
        }
        if ((config.vmVersionFeatures & config.amd64SSE41) != 0L) {
            features.add(AMD64.CPUFeature.SSE4_1);
        }
        if ((config.vmVersionFeatures & config.amd64SSE42) != 0L) {
            features.add(AMD64.CPUFeature.SSE4_2);
        }
        if ((config.vmVersionFeatures & config.amd64POPCNT) != 0L) {
            features.add(AMD64.CPUFeature.POPCNT);
        }
        if ((config.vmVersionFeatures & config.amd64LZCNT) != 0L) {
            features.add(AMD64.CPUFeature.LZCNT);
        }
        if ((config.vmVersionFeatures & config.amd64ERMS) != 0L) {
            features.add(AMD64.CPUFeature.ERMS);
        }
        if ((config.vmVersionFeatures & config.amd64AVX) != 0L) {
            features.add(AMD64.CPUFeature.AVX);
        }
        if ((config.vmVersionFeatures & config.amd64AVX2) != 0L) {
            features.add(AMD64.CPUFeature.AVX2);
        }
        if ((config.vmVersionFeatures & config.amd64AES) != 0L) {
            features.add(AMD64.CPUFeature.AES);
        }
        if ((config.vmVersionFeatures & config.amd643DNOWPREFETCH) != 0L) {
            features.add(AMD64.CPUFeature.AMD_3DNOW_PREFETCH);
        }
        if ((config.vmVersionFeatures & config.amd64BMI1) != 0L) {
            features.add(AMD64.CPUFeature.BMI1);
        }
        if ((config.vmVersionFeatures & config.amd64BMI2) != 0L) {
            features.add(AMD64.CPUFeature.BMI2);
        }
        if ((config.vmVersionFeatures & config.amd64RTM) != 0L) {
            features.add(AMD64.CPUFeature.RTM);
        }
        if ((config.vmVersionFeatures & config.amd64ADX) != 0L) {
            features.add(AMD64.CPUFeature.ADX);
        }
        return features;
    }

    private static EnumSet<AMD64.Flag> computeFlags(AMD64HotSpotVMConfig config) {
        EnumSet<AMD64.Flag> flags = EnumSet.noneOf(AMD64.Flag.class);
        if (config.useCountLeadingZerosInstruction) {
            flags.add(AMD64.Flag.UseCountLeadingZerosInstruction);
        }
        if (config.useCountTrailingZerosInstruction) {
            flags.add(AMD64.Flag.UseCountTrailingZerosInstruction);
        }
        return flags;
    }

    private static TargetDescription createTarget(AMD64HotSpotVMConfig config) {
        int stackFrameAlignment = 16;
        int implicitNullCheckLimit = 4096;
        boolean inlineObjects = true;
        AMD64 arch = new AMD64(AMD64HotSpotJVMCIBackendFactory.computeFeatures(config), AMD64HotSpotJVMCIBackendFactory.computeFlags(config));
        return new TargetDescription((Architecture)arch, true, 16, 4096, true);
    }

    protected HotSpotConstantReflectionProvider createConstantReflection(HotSpotJVMCIRuntime runtime) {
        return new HotSpotConstantReflectionProvider(runtime);
    }

    private static RegisterConfig createRegisterConfig(AMD64HotSpotVMConfig config, TargetDescription target) {
        return new AMD64HotSpotRegisterConfig(target, config.useCompressedOops, config.windowsOs);
    }

    protected HotSpotCodeCacheProvider createCodeCache(HotSpotJVMCIRuntime runtime, TargetDescription target, RegisterConfig regConfig) {
        return new HotSpotCodeCacheProvider(runtime, target, regConfig);
    }

    protected HotSpotMetaAccessProvider createMetaAccess(HotSpotJVMCIRuntime runtime) {
        return new HotSpotMetaAccessProvider(runtime);
    }

    @Override
    public String getArchitecture() {
        return "AMD64";
    }

    public String toString() {
        return "JVMCIBackend:" + this.getArchitecture();
    }

    @Override
    public JVMCIBackend createJVMCIBackend(HotSpotJVMCIRuntime runtime, JVMCIBackend host) {
        HotSpotStackIntrospection stackIntrospection;
        HotSpotConstantReflectionProvider constantReflection;
        HotSpotCodeCacheProvider codeCache;
        HotSpotMetaAccessProvider metaAccess;
        assert (host == null);
        AMD64HotSpotVMConfig config = new AMD64HotSpotVMConfig(runtime.getConfigStore());
        TargetDescription target = AMD64HotSpotJVMCIBackendFactory.createTarget(config);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            RegisterConfig regConfig;
            try (InitTimer rt = InitTimer.timer((String)"create MetaAccess provider");){
                metaAccess = this.createMetaAccess(runtime);
            }
            rt = InitTimer.timer((String)"create RegisterConfig");
            var13_11 = null;
            try {
                regConfig = AMD64HotSpotJVMCIBackendFactory.createRegisterConfig(config, target);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create CodeCache provider");
            var13_11 = null;
            try {
                codeCache = this.createCodeCache(runtime, target, regConfig);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create ConstantReflection provider");
            var13_11 = null;
            try {
                constantReflection = this.createConstantReflection(runtime);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create StackIntrospection provider");
            var13_11 = null;
            try {
                stackIntrospection = new HotSpotStackIntrospection(runtime);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
        }
        var11_6 = null;
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            JVMCIBackend jVMCIBackend = this.createBackend(metaAccess, codeCache, constantReflection, stackIntrospection);
            return jVMCIBackend;
        }
        catch (Throwable throwable) {
            var11_6 = throwable;
            throw throwable;
        }
    }

    protected JVMCIBackend createBackend(HotSpotMetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, StackIntrospection stackIntrospection) {
        return new JVMCIBackend((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, constantReflection, stackIntrospection);
    }
}

