/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.aarch64;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AArch64HotSpotRegisterConfig
implements RegisterConfig {
    private final TargetDescription target;
    private final RegisterArray allocatable;
    private final RegisterArray callerSaved;
    private final boolean allAllocatableAreCallerSaved;
    private final RegisterAttributes[] attributesMap;
    private final RegisterArray javaGeneralParameterRegisters = new RegisterArray(new Register[]{AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7, AArch64.r0});
    private final RegisterArray nativeGeneralParameterRegisters = new RegisterArray(new Register[]{AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7});
    private final RegisterArray simdParameterRegisters = new RegisterArray(new Register[]{AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7});
    public static final Register inlineCacheRegister = AArch64.rscratch2;
    public static final Register metaspaceMethodRegister = AArch64.r12;
    public static final Register heapBaseRegister = AArch64.r27;
    public static final Register threadRegister = AArch64.r28;
    public static final Register fp = AArch64.r29;
    private static final RegisterArray reservedRegisters = new RegisterArray(new Register[]{AArch64.rscratch1, AArch64.rscratch2, heapBaseRegister, threadRegister, fp, AArch64.lr, AArch64.r31, AArch64.zr, AArch64.sp});

    public RegisterArray getAllocatableRegisters() {
        return this.allocatable;
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return new RegisterArray(list);
    }

    public RegisterAttributes[] getAttributesMap() {
        return (RegisterAttributes[])this.attributesMap.clone();
    }

    private static RegisterArray initAllocatable(Architecture arch) {
        RegisterArray allRegisters = arch.getAvailableValueRegisters();
        Register[] registers = new Register[allRegisters.size() - reservedRegisters.size()];
        List reservedRegistersList = reservedRegisters.asList();
        int idx = 0;
        for (Register reg : allRegisters) {
            if (reservedRegistersList.contains(reg)) continue;
            assert (!(reg.equals((Object)heapBaseRegister) || reg.equals((Object)threadRegister) || reg.equals((Object)fp) || reg.equals((Object)AArch64.lr) || reg.equals((Object)AArch64.r31) || reg.equals((Object)AArch64.zr) || reg.equals((Object)AArch64.sp))) : reg;
            registers[idx++] = reg;
        }
        assert (idx == registers.length);
        return new RegisterArray(registers);
    }

    public AArch64HotSpotRegisterConfig(TargetDescription target) {
        this(target, AArch64HotSpotRegisterConfig.initAllocatable(target.arch));
        assert (this.callerSaved.size() >= this.allocatable.size());
    }

    public AArch64HotSpotRegisterConfig(TargetDescription target, RegisterArray allocatable) {
        this.target = target;
        this.allocatable = allocatable;
        HashSet callerSaveSet = new HashSet();
        allocatable.addTo(callerSaveSet);
        this.simdParameterRegisters.addTo(callerSaveSet);
        this.javaGeneralParameterRegisters.addTo(callerSaveSet);
        this.nativeGeneralParameterRegisters.addTo(callerSaveSet);
        this.callerSaved = new RegisterArray(callerSaveSet);
        this.allAllocatableAreCallerSaved = true;
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)AArch64.allRegisters);
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.callerSaved;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return null;
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return this.allAllocatableAreCallerSaved;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type type, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        if (type == HotSpotCallingConventionType.NativeCall) {
            return this.callingConvention(this.nativeGeneralParameterRegisters, returnType, parameterTypes, hotspotType, valueKindFactory);
        }
        return this.callingConvention(this.javaGeneralParameterRegisters, returnType, parameterTypes, hotspotType, valueKindFactory);
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type type, JavaKind kind) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return hotspotType == HotSpotCallingConventionType.NativeCall ? this.nativeGeneralParameterRegisters : this.javaGeneralParameterRegisters;
            }
            case Float: 
            case Double: {
                return this.simdParameterRegisters;
            }
        }
        throw JVMCIError.shouldNotReachHere();
    }

    private CallingConvention callingConvention(RegisterArray generalParameterRegisters, JavaType returnType, JavaType[] parameterTypes, HotSpotCallingConventionType type, ValueKindFactory<?> valueKindFactory) {
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentSIMD = 0;
        int currentStackOffset = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind = parameterTypes[i].getJavaKind().getStackKind();
            switch (kind) {
                case Boolean: 
                case Byte: 
                case Short: 
                case Char: 
                case Int: 
                case Long: 
                case Object: {
                    if (currentGeneral >= generalParameterRegisters.size()) break;
                    Register register = generalParameterRegisters.get(currentGeneral++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                    break;
                }
                case Float: 
                case Double: {
                    if (currentSIMD >= this.simdParameterRegisters.size()) break;
                    Register register = this.simdParameterRegisters.get(currentSIMD++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                    break;
                }
                default: {
                    throw JVMCIError.shouldNotReachHere();
                }
            }
            if (locations[i] != null) continue;
            ValueKind valueKind = valueKindFactory.getValueKind(kind);
            locations[i] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!type.out ? 1 : 0) != 0);
            currentStackOffset += Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : returnType.getJavaKind();
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new CallingConvention(currentStackOffset, returnLocation, locations);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return AArch64.r0;
            }
            case Float: 
            case Double: {
                return AArch64.v0;
            }
            case Void: 
            case Illegal: {
                return null;
            }
        }
        throw new UnsupportedOperationException("no return register for type " + kind);
    }

    public Register getFrameRegister() {
        return AArch64.sp;
    }

    public String toString() {
        return String.format("Allocatable: " + this.getAllocatableRegisters() + "%nCallerSave:  " + this.getCallerSaveRegisters() + "%n", new Object[0]);
    }
}

