/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.Objects;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.VMEntryPoint;

final class TranslatedException
extends Exception {
    private String originalExceptionClassName;

    private TranslatedException(String message, String originalExceptionClassName) {
        super(message);
        this.originalExceptionClassName = originalExceptionClassName;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String toString() {
        String s = this.originalExceptionClassName.equals(TranslatedException.class.getName()) ? this.getClass().getName() : this.getClass().getName() + "[" + this.originalExceptionClassName + "]";
        String message = this.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private static boolean printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
        return true;
    }

    private static Throwable initCause(Throwable throwable, Throwable cause) {
        block3: {
            if (cause != null) {
                try {
                    throwable.initCause(cause);
                }
                catch (IllegalStateException e) {
                    if ($assertionsDisabled || TranslatedException.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
        return throwable;
    }

    private static Throwable create(String className, String message, Throwable cause) {
        try {
            Class<?> cls = Class.forName(className);
            if (cause != null) {
                if (cls == InvocationTargetException.class) {
                    return new InvocationTargetException(cause, message);
                }
                if (cls == ExceptionInInitializerError.class) {
                    return new ExceptionInInitializerError(cause);
                }
            }
            if (message == null) {
                return TranslatedException.initCause((Throwable)cls.getConstructor(new Class[0]).newInstance(new Object[0]), cause);
            }
            return TranslatedException.initCause((Throwable)cls.getDeclaredConstructor(String.class).newInstance(message), cause);
        }
        catch (Throwable translationFailure) {
            return TranslatedException.initCause(new TranslatedException(message, className), cause);
        }
    }

    private static String encodeMessage(String value) {
        return value != null ? ' ' + value : value;
    }

    private static String decodeMessage(String value) {
        if (value.length() == 0) {
            return null;
        }
        return value.substring(1);
    }

    private static String encodedString(String value) {
        return Objects.toString(value, "").replace('|', '_');
    }

    @VMEntryPoint
    static String encodeThrowable(Throwable throwable) throws Throwable {
        try {
            Formatter enc = new Formatter();
            ArrayList<Throwable> throwables = new ArrayList<Throwable>();
            for (Throwable current = throwable; current != null; current = current.getCause()) {
                throwables.add(current);
            }
            Collections.reverse(throwables);
            for (Throwable current : throwables) {
                enc.format("%s|%s|", current.getClass().getName(), TranslatedException.encodedString(TranslatedException.encodeMessage(current.getMessage())));
                StackTraceElement[] stackTrace = current.getStackTrace();
                if (stackTrace == null) {
                    stackTrace = new StackTraceElement[]{};
                }
                enc.format("%d|", stackTrace.length);
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement frame = stackTrace[i];
                    if (frame == null) continue;
                    enc.format("%s|%s|%s|%d|", frame.getClassName(), frame.getMethodName(), TranslatedException.encodedString(frame.getFileName()), frame.getLineNumber());
                }
            }
            return enc.toString();
        }
        catch (Throwable e) {
            assert (TranslatedException.printStackTrace(e));
            try {
                return e.getClass().getName() + "|" + TranslatedException.encodedString(e.getMessage()) + "|0|";
            }
            catch (Throwable e2) {
                assert (TranslatedException.printStackTrace(e2));
                return "java.lang.Throwable|too many errors during encoding|0|";
            }
        }
    }

    private static StackTraceElement[] getStackTraceSuffix() {
        StackTraceElement[] stack = new Exception().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement e = stack[i];
            if (!e.getClassName().equals(CompilerToVM.class.getName())) continue;
            return Arrays.copyOfRange(stack, i, stack.length);
        }
        return new StackTraceElement[0];
    }

    @VMEntryPoint
    static Throwable decodeThrowable(String encodedThrowable) {
        try {
            int i = 0;
            String[] parts = encodedThrowable.split("\\|");
            Throwable cause = null;
            Throwable throwable = null;
            while (i != parts.length) {
                String exceptionClassName = parts[i++];
                String exceptionMessage = TranslatedException.decodeMessage(parts[i++]);
                throwable = TranslatedException.create(exceptionClassName, exceptionMessage, cause);
                int stackTraceDepth = Integer.parseInt(parts[i++]);
                StackTraceElement[] suffix = TranslatedException.getStackTraceSuffix();
                StackTraceElement[] stackTrace = new StackTraceElement[stackTraceDepth + suffix.length];
                for (int j = 0; j < stackTraceDepth; ++j) {
                    String className = parts[i++];
                    String methodName = parts[i++];
                    String fileName = parts[i++];
                    int lineNumber = Integer.parseInt(parts[i++]);
                    if (fileName.isEmpty()) {
                        fileName = null;
                    }
                    stackTrace[j] = new StackTraceElement(className, methodName, fileName, lineNumber);
                }
                System.arraycopy(suffix, 0, stackTrace, stackTraceDepth, suffix.length);
                throwable.setStackTrace(stackTrace);
                cause = throwable;
            }
            return throwable;
        }
        catch (Throwable translationFailure) {
            assert (TranslatedException.printStackTrace(translationFailure));
            return new TranslatedException("Error decoding exception: " + encodedThrowable, translationFailure.getClass().getName());
        }
    }
}

