/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import jdk.vm.ci.hotspot.DirectHotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotJVMCIReflection;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotJVMCIUnsupportedOperationError;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedPrimitiveType;
import jdk.vm.ci.hotspot.IndirectHotSpotObjectConstantImpl;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

class SharedLibraryJVMCIReflection
extends HotSpotJVMCIReflection {
    SharedLibraryJVMCIReflection() {
    }

    @Override
    Object resolveObject(HotSpotObjectConstantImpl objectHandle) {
        throw new HotSpotJVMCIUnsupportedOperationError("cannot resolve handle in a JVMCI shared library to a raw object: " + objectHandle);
    }

    @Override
    boolean isInstance(HotSpotResolvedObjectTypeImpl holder, HotSpotObjectConstantImpl obj) {
        if (obj instanceof DirectHotSpotObjectConstantImpl) {
            HotSpotResolvedObjectTypeImpl type = this.getType(obj);
            return holder.isAssignableFrom(type);
        }
        return HotSpotJVMCIRuntime.runtime().compilerToVm.isInstance(holder, obj);
    }

    @Override
    boolean isAssignableFrom(HotSpotResolvedObjectTypeImpl holder, HotSpotResolvedObjectTypeImpl otherType) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.isAssignableFrom(holder, otherType);
    }

    @Override
    boolean isLocalClass(HotSpotResolvedObjectTypeImpl holder) {
        throw new HotSpotJVMCIUnsupportedOperationError("requires a call Class.isLocalClass()");
    }

    @Override
    boolean isMemberClass(HotSpotResolvedObjectTypeImpl holder) {
        throw new HotSpotJVMCIUnsupportedOperationError("requires a call Class.isMemberClass()");
    }

    @Override
    HotSpotResolvedObjectType getEnclosingClass(HotSpotResolvedObjectTypeImpl holder) {
        throw new HotSpotJVMCIUnsupportedOperationError("requires a call Class.getEnclosingClass()");
    }

    @Override
    JavaConstant readFieldValue(HotSpotResolvedObjectTypeImpl holder, HotSpotResolvedJavaField field, boolean isVolatile) {
        JavaConstant javaConstant = HotSpotJVMCIRuntime.runtime().compilerToVm.readFieldValue(holder, field, isVolatile);
        if (javaConstant == null) {
            return JavaConstant.NULL_POINTER;
        }
        return javaConstant;
    }

    @Override
    JavaConstant readFieldValue(HotSpotObjectConstantImpl object, HotSpotResolvedJavaField field, boolean isVolatile) {
        if (object instanceof DirectHotSpotObjectConstantImpl) {
            return null;
        }
        JavaConstant javaConstant = HotSpotJVMCIRuntime.runtime().compilerToVm.readFieldValue(object, field, isVolatile);
        if (javaConstant == null) {
            return JavaConstant.NULL_POINTER;
        }
        return javaConstant;
    }

    @Override
    boolean equals(HotSpotObjectConstantImpl x, HotSpotObjectConstantImpl y) {
        if (x == y) {
            return true;
        }
        if (x.compressed != y.compressed) {
            return false;
        }
        if (x instanceof DirectHotSpotObjectConstantImpl && y instanceof DirectHotSpotObjectConstantImpl) {
            DirectHotSpotObjectConstantImpl xd = (DirectHotSpotObjectConstantImpl)x;
            DirectHotSpotObjectConstantImpl yd = (DirectHotSpotObjectConstantImpl)y;
            return xd.object == yd.object;
        }
        if (x instanceof DirectHotSpotObjectConstantImpl || y instanceof DirectHotSpotObjectConstantImpl) {
            return false;
        }
        IndirectHotSpotObjectConstantImpl indirectX = (IndirectHotSpotObjectConstantImpl)x;
        IndirectHotSpotObjectConstantImpl indirectY = (IndirectHotSpotObjectConstantImpl)y;
        return HotSpotJVMCIRuntime.runtime().compilerToVm.equals(x, indirectX.getHandle(), y, indirectY.getHandle());
    }

    @Override
    JavaConstant getJavaMirror(HotSpotResolvedPrimitiveType hotSpotResolvedPrimitiveType) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getJavaMirror(hotSpotResolvedPrimitiveType);
    }

    @Override
    ResolvedJavaMethod.Parameter[] getParameters(HotSpotResolvedJavaMethodImpl javaMethod) {
        return null;
    }

    static Annotation[] getClassAnnotations(String className) {
        throw new InternalError("missing substitution: " + className);
    }

    static Annotation[][] getParameterAnnotations(String className, String methodName) {
        throw new InternalError("missing substitution: " + className + " " + methodName);
    }

    @Override
    Annotation[] getAnnotations(HotSpotResolvedObjectTypeImpl holder) {
        Annotation[] annotations = SharedLibraryJVMCIReflection.getClassAnnotations(holder.getName());
        return annotations == null ? new Annotation[]{} : annotations;
    }

    @Override
    Annotation[] getDeclaredAnnotations(HotSpotResolvedObjectTypeImpl holder) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    <T extends Annotation> T getAnnotation(HotSpotResolvedObjectTypeImpl holder, Class<T> annotationClass) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    Annotation[][] getParameterAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        Annotation[][] annotations = SharedLibraryJVMCIReflection.getParameterAnnotations(javaMethod.getDeclaringClass().getName(), javaMethod.getName());
        if (annotations == null) {
            return new Annotation[javaMethod.signature.getParameterCount(false)][0];
        }
        return annotations;
    }

    @Override
    Type[] getGenericParameterTypes(HotSpotResolvedJavaMethodImpl javaMethod) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    Annotation[] getFieldAnnotations(HotSpotResolvedJavaFieldImpl javaField) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    Annotation[] getMethodAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        Annotation[] annotations = SharedLibraryJVMCIReflection.getMethodAnnotationsInternal(javaMethod);
        return annotations == null ? new Annotation[]{} : annotations;
    }

    @Override
    <T extends Annotation> T getMethodAnnotation(HotSpotResolvedJavaMethodImpl javaMethod, Class<T> annotationClass) {
        Annotation[] methodAnnotations = this.getMethodAnnotations(javaMethod);
        if (methodAnnotations != null) {
            for (Annotation ann : methodAnnotations) {
                if (!annotationClass.isInstance(ann)) continue;
                return (T)((Annotation)annotationClass.cast(ann));
            }
        }
        return null;
    }

    private static Annotation[] getMethodAnnotationsInternal(ResolvedJavaMethod javaMethod) {
        throw new InternalError("missing substitution");
    }

    @Override
    Annotation[] getMethodDeclaredAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    Annotation[] getFieldDeclaredAnnotations(HotSpotResolvedJavaFieldImpl javaMethod) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    <T extends Annotation> T getFieldAnnotation(HotSpotResolvedJavaFieldImpl javaField, Class<T> annotationClass) {
        throw new HotSpotJVMCIUnsupportedOperationError("unimplemented");
    }

    @Override
    HotSpotResolvedObjectTypeImpl getType(HotSpotObjectConstantImpl object) {
        if (object instanceof DirectHotSpotObjectConstantImpl) {
            Class<?> theClass = ((DirectHotSpotObjectConstantImpl)object).object.getClass();
            try {
                String name = theClass.getName().replace('.', '/');
                HotSpotResolvedObjectTypeImpl type = (HotSpotResolvedObjectTypeImpl)HotSpotJVMCIRuntime.runtime().compilerToVm.lookupType(name, null, true);
                if (type == null) {
                    throw new InternalError(name);
                }
                return type;
            }
            catch (ClassNotFoundException e) {
                throw new InternalError(e);
            }
        }
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getResolvedJavaType(object, (long)HotSpotJVMCIRuntime.runtime().getConfig().hubOffset, false);
    }

    @Override
    String asString(HotSpotObjectConstantImpl object) {
        if (object instanceof IndirectHotSpotObjectConstantImpl) {
            return HotSpotJVMCIRuntime.runtime().compilerToVm.asString(object);
        }
        Object value = ((DirectHotSpotObjectConstantImpl)object).object;
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    ResolvedJavaType asJavaType(HotSpotObjectConstantImpl object) {
        if (object instanceof DirectHotSpotObjectConstantImpl) {
            DirectHotSpotObjectConstantImpl direct = (DirectHotSpotObjectConstantImpl)object;
            if (direct.object instanceof Class) {
                Class javaClass = (Class)direct.object;
                return HotSpotJVMCIRuntime.runtime().fromClass(javaClass);
            }
            if (direct.object instanceof ResolvedJavaType) {
                return (ResolvedJavaType)SharedLibraryJVMCIReflection.convertUnknownValue(direct.object);
            }
            return null;
        }
        return HotSpotJVMCIRuntime.runtime().compilerToVm.asJavaType(object);
    }

    static Object convertUnknownValue(Object object) {
        return object;
    }

    @Override
    <T> T asObject(HotSpotObjectConstantImpl object, Class<T> type) {
        Object theObject;
        if (object instanceof DirectHotSpotObjectConstantImpl && type.isInstance(theObject = ((DirectHotSpotObjectConstantImpl)object).object)) {
            return (T)SharedLibraryJVMCIReflection.convertUnknownValue(type.cast(theObject));
        }
        return null;
    }

    @Override
    Object asObject(HotSpotObjectConstantImpl object, HotSpotResolvedJavaType type) {
        throw new HotSpotJVMCIUnsupportedOperationError("cannot resolve a shared library JVMCI object handle to a raw object as it may be in another runtime");
    }

    @Override
    String formatString(HotSpotObjectConstantImpl object) {
        if (object instanceof DirectHotSpotObjectConstantImpl) {
            DirectHotSpotObjectConstantImpl direct = (DirectHotSpotObjectConstantImpl)object;
            return "CompilerObject<" + direct.object.getClass().getName() + ">";
        }
        IndirectHotSpotObjectConstantImpl indirect = (IndirectHotSpotObjectConstantImpl)object;
        if (!indirect.isValid()) {
            return "Instance<null>";
        }
        return "Instance<" + object.getType().toJavaName() + ">";
    }

    @Override
    Integer getLength(HotSpotObjectConstantImpl object) {
        if (object instanceof DirectHotSpotObjectConstantImpl) {
            DirectHotSpotObjectConstantImpl direct = (DirectHotSpotObjectConstantImpl)object;
            if (direct.object.getClass().isArray()) {
                return Array.getLength(direct.object);
            }
            return null;
        }
        int length = HotSpotJVMCIRuntime.runtime().compilerToVm.getArrayLength(object);
        if (length >= 0) {
            return length;
        }
        return null;
    }

    @Override
    JavaConstant readArrayElement(HotSpotObjectConstantImpl arrayObject, int index) {
        Object result = HotSpotJVMCIRuntime.runtime().compilerToVm.readArrayElement(arrayObject, index);
        if (result == null) {
            return null;
        }
        if (result instanceof JavaConstant) {
            return (JavaConstant)result;
        }
        PrimitiveConstant constant = JavaConstant.forBoxedPrimitive((Object)result);
        if (constant == null) {
            throw new InternalError("Unexpected value " + result);
        }
        return constant;
    }

    @Override
    JavaConstant forObject(Object value) {
        return DirectHotSpotObjectConstantImpl.forObject(value, false);
    }

    @Override
    JavaConstant unboxPrimitive(HotSpotObjectConstantImpl source) {
        Object box = HotSpotJVMCIRuntime.runtime().compilerToVm.unboxPrimitive(source);
        return JavaConstant.forBoxedPrimitive((Object)box);
    }

    @Override
    JavaConstant boxPrimitive(JavaConstant source) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.boxPrimitive(source.asBoxedPrimitive());
    }

    @Override
    int getInt(HotSpotObjectConstantImpl object, long displacement) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getInt(object, displacement);
    }

    @Override
    byte getByte(HotSpotObjectConstantImpl object, long displacement) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getByte(object, displacement);
    }

    @Override
    short getShort(HotSpotObjectConstantImpl object, long displacement) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getShort(object, displacement);
    }

    @Override
    long getLong(HotSpotObjectConstantImpl object, long displacement) {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getLong(object, displacement);
    }

    @Override
    void checkRead(HotSpotObjectConstantImpl constant, JavaKind kind, long displacement, HotSpotResolvedObjectType type) {
    }
}

