/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Arrays;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class HotSpotStackFrameReference
implements InspectedFrame {
    private CompilerToVM compilerToVM;
    private boolean objectsMaterialized;
    private long stackPointer;
    private int frameNumber;
    private int bci;
    private HotSpotResolvedJavaMethod method;
    private Object[] locals;
    private boolean[] localIsVirtual;

    public long getStackPointer() {
        return this.stackPointer;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Object getLocal(int index) {
        return this.locals[index];
    }

    public boolean isVirtual(int index) {
        return this.localIsVirtual == null ? false : this.localIsVirtual[index];
    }

    public void materializeVirtualObjects(boolean invalidateCode) {
        this.compilerToVM.materializeVirtualObjects(this, invalidateCode);
    }

    public int getBytecodeIndex() {
        return this.bci;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public boolean isMethod(ResolvedJavaMethod otherMethod) {
        return this.method.equals(otherMethod);
    }

    public boolean hasVirtualObjects() {
        return this.localIsVirtual != null;
    }

    public String toString() {
        return "HotSpotStackFrameReference [stackPointer=" + this.stackPointer + ", frameNumber=" + this.frameNumber + ", bci=" + this.bci + ", method=" + this.getMethod() + ", locals=" + Arrays.toString(this.locals) + ", localIsVirtual=" + Arrays.toString(this.localIsVirtual) + "]";
    }
}

