/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;

final class HotSpotSpeculationEncoding
extends ByteArrayOutputStream
implements SpeculationLog.SpeculationReasonEncoding {
    private DataOutputStream dos = new DataOutputStream(this);
    private byte[] result;
    private static final int NULL_METHOD = -1;
    private static final int NULL_TYPE = -2;
    private static final int NULL_STRING = -3;
    private static final MessageDigest SHA1;
    private static final boolean SHA1_IS_CLONEABLE;
    private static final int SHA1_LENGTH;

    HotSpotSpeculationEncoding() {
        super(SHA1_LENGTH);
    }

    private void checkOpen() {
        if (this.result != null) {
            throw new IllegalArgumentException("Cannot update closed speculation encoding");
        }
    }

    public void addByte(int value) {
        this.checkOpen();
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addShort(int value) {
        this.checkOpen();
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addMethod(ResolvedJavaMethod method) {
        if (!this.addNull(method, -1)) {
            this.checkOpen();
            if (method instanceof HotSpotResolvedJavaMethodImpl) {
                try {
                    this.dos.writeLong(((HotSpotResolvedJavaMethodImpl)method).getMetaspaceMethod());
                }
                catch (IOException e) {
                    throw new InternalError(e);
                }
            } else {
                throw new IllegalArgumentException("Cannot encode unsupported type " + method.getClass().getName() + ": " + method.format("%H.%n(%p)"));
            }
        }
    }

    public void addType(ResolvedJavaType type) {
        if (!this.addNull(type, -2)) {
            this.checkOpen();
            if (type instanceof HotSpotResolvedObjectTypeImpl) {
                try {
                    this.dos.writeLong(((HotSpotResolvedObjectTypeImpl)type).getMetaspaceKlass());
                }
                catch (IOException e) {
                    throw new InternalError(e);
                }
            } else {
                throw new IllegalArgumentException("Cannot encode unsupported type " + type.getClass().getName() + ": " + type.toClassName());
            }
        }
    }

    public void addString(String value) {
        if (!this.addNull(value, -3)) {
            this.checkOpen();
            try {
                this.dos.writeChars(value);
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    public void addInt(int value) {
        this.checkOpen();
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addLong(long value) {
        this.checkOpen();
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private boolean addNull(Object o, int nullValue) {
        if (o == null) {
            this.addInt(nullValue);
            return true;
        }
        return false;
    }

    byte[] getByteArray() {
        if (this.result == null) {
            if (SHA1 != null && this.count > SHA1_LENGTH) {
                try {
                    MessageDigest md = SHA1_IS_CLONEABLE ? (MessageDigest)SHA1.clone() : MessageDigest.getInstance("SHA-1");
                    md.update(this.buf, 0, this.count);
                    this.result = md.digest();
                }
                catch (CloneNotSupportedException | NoSuchAlgorithmException e) {
                    throw new InternalError(e);
                }
            } else {
                if (this.buf.length == this.count) {
                    return this.buf;
                }
                this.result = Arrays.copyOf(this.buf, this.count);
            }
            this.dos = null;
        }
        return this.result;
    }

    static {
        MessageDigest sha1 = null;
        boolean sha1IsCloneable = false;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
            sha1.clone();
            sha1IsCloneable = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        SHA1 = sha1;
        SHA1_IS_CLONEABLE = sha1IsCloneable;
        SHA1_LENGTH = SHA1 == null ? 20 : SHA1.getDigestLength();
    }
}

