/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HandleCleaner;
import jdk.vm.ci.hotspot.HotSpotConstantPool;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstantImpl;
import jdk.vm.ci.hotspot.HotSpotMethod;
import jdk.vm.ci.hotspot.HotSpotMethodData;
import jdk.vm.ci.hotspot.HotSpotModifiers;
import jdk.vm.ci.hotspot.HotSpotProfilingInfo;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.MetaspaceHandleObject;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;

final class HotSpotResolvedJavaMethodImpl
extends HotSpotMethod
implements HotSpotResolvedJavaMethod,
MetaspaceHandleObject {
    private final long metadataHandle;
    private final HotSpotResolvedObjectTypeImpl holder;
    private final HotSpotConstantPool constantPool;
    final HotSpotSignature signature;
    private HotSpotMethodData methodData;
    private byte[] code;
    volatile Executable toJavaCache;
    private String nameCache;

    private static HotSpotResolvedObjectTypeImpl getHolder(long metaspaceHandle) {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        long metaspaceMethod = UnsafeAccess.UNSAFE.getLong(metaspaceHandle);
        assert (metaspaceMethod != 0L) : metaspaceHandle;
        long metaspaceConstMethod = UnsafeAccess.UNSAFE.getAddress(metaspaceMethod + (long)config.methodConstMethodOffset);
        long metaspaceConstantPool = UnsafeAccess.UNSAFE.getAddress(metaspaceConstMethod + (long)config.constMethodConstantsOffset);
        HotSpotResolvedObjectTypeImpl result = CompilerToVM.compilerToVM().getResolvedJavaType(metaspaceConstantPool + (long)config.constantPoolHolderOffset, false);
        assert (result != null);
        return result;
    }

    @VMEntryPoint
    private static HotSpotResolvedJavaMethod fromMetaspace(long metaspaceHandle) {
        HotSpotResolvedObjectTypeImpl holder = HotSpotResolvedJavaMethodImpl.getHolder(metaspaceHandle);
        return holder.createMethod(metaspaceHandle);
    }

    HotSpotResolvedJavaMethodImpl(HotSpotResolvedObjectTypeImpl holder, long metaspaceHandle) {
        this.metadataHandle = metaspaceHandle;
        this.holder = holder;
        HotSpotVMConfig config = HotSpotVMConfig.config();
        long constMethod = this.getConstMethod();
        long metaspaceConstantPool = UnsafeAccess.UNSAFE.getAddress(constMethod + (long)config.constMethodConstantsOffset);
        this.constantPool = metaspaceConstantPool == holder.getConstantPool().getMetaspaceConstantPool() ? holder.getConstantPool() : CompilerToVM.compilerToVM().getConstantPool(this);
        char signatureIndex = UnsafeAccess.UNSAFE.getChar(constMethod + (long)config.constMethodSignatureIndexOffset);
        this.signature = (HotSpotSignature)this.constantPool.lookupSignature(signatureIndex);
        HandleCleaner.create(this, metaspaceHandle);
    }

    private long getConstMethod() {
        return UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceMethod() + (long)HotSpotVMConfig.config().methodConstMethodOffset);
    }

    public String getName() {
        if (this.nameCache == null) {
            char nameIndex = UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodNameIndexOffset);
            this.nameCache = this.constantPool.lookupUtf8(nameIndex);
        }
        return this.nameCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HotSpotResolvedJavaMethodImpl) {
            HotSpotResolvedJavaMethodImpl that = (HotSpotResolvedJavaMethodImpl)obj;
            return that.getMetaspaceMethod() == this.getMetaspaceMethod();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getMetaspaceMethod();
    }

    private int getFlags() {
        return UnsafeAccess.UNSAFE.getByte(this.getMetaspaceMethod() + (long)HotSpotVMConfig.config().methodFlagsOffset);
    }

    private int getConstMethodFlags() {
        return UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodFlagsOffset);
    }

    @Override
    public HotSpotResolvedObjectTypeImpl getDeclaringClass() {
        return this.holder;
    }

    public Constant getMetaspaceMethodConstant() {
        return HotSpotMetaspaceConstantImpl.forMetaspaceObject(this, false);
    }

    long getMetaspaceMethod() {
        long metaspacePointer = this.getMetaspacePointer();
        if (metaspacePointer == 0L) {
            throw new NullPointerException("Method* is null");
        }
        return metaspacePointer;
    }

    @Override
    public long getMetadataHandle() {
        return this.metadataHandle;
    }

    public Constant getEncoding() {
        return this.getMetaspaceMethodConstant();
    }

    public int getAllModifiers() {
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceMethod() + (long)HotSpotVMConfig.config().methodAccessFlagsOffset);
    }

    public int getModifiers() {
        return this.getAllModifiers() & HotSpotModifiers.jvmMethodModifiers();
    }

    public boolean canBeStaticallyBound() {
        return (this.isFinal() || this.isPrivate() || this.isStatic() || this.holder.isLeaf()) && this.isConcrete();
    }

    public byte[] getCode() {
        if (this.getCodeSize() == 0) {
            return null;
        }
        if (this.code == null && this.holder.isLinked()) {
            this.code = CompilerToVM.compilerToVM().getBytecode(this);
            assert (this.code.length == this.getCodeSize()) : "expected: " + this.getCodeSize() + ", actual: " + this.code.length;
        }
        return this.code;
    }

    public int getCodeSize() {
        return UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodCodeSizeOffset);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        boolean hasExceptionTable;
        boolean bl = hasExceptionTable = (this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasExceptionTable) != 0;
        if (!hasExceptionTable) {
            return new ExceptionHandler[0];
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        int exceptionTableLength = CompilerToVM.compilerToVM().getExceptionTableLength(this);
        ExceptionHandler[] handlers = new ExceptionHandler[exceptionTableLength];
        long exceptionTableElement = CompilerToVM.compilerToVM().getExceptionTableStart(this);
        for (int i = 0; i < exceptionTableLength; ++i) {
            JavaType catchType;
            char startPc = UnsafeAccess.UNSAFE.getChar(exceptionTableElement + (long)config.exceptionTableElementStartPcOffset);
            char endPc = UnsafeAccess.UNSAFE.getChar(exceptionTableElement + (long)config.exceptionTableElementEndPcOffset);
            char handlerPc = UnsafeAccess.UNSAFE.getChar(exceptionTableElement + (long)config.exceptionTableElementHandlerPcOffset);
            char catchTypeIndex = UnsafeAccess.UNSAFE.getChar(exceptionTableElement + (long)config.exceptionTableElementCatchTypeIndexOffset);
            if (catchTypeIndex == '\u0000') {
                catchType = null;
            } else {
                HotSpotResolvedObjectTypeImpl resolvedType;
                int opcode = -1;
                catchType = this.constantPool.lookupType(catchTypeIndex, -1);
                if (catchType instanceof HotSpotResolvedObjectTypeImpl && (resolvedType = (HotSpotResolvedObjectTypeImpl)catchType).equals(HotSpotJVMCIRuntime.runtime().getJavaLangThrowable())) {
                    catchTypeIndex = '\u0000';
                    catchType = null;
                }
            }
            handlers[i] = new ExceptionHandler((int)startPc, (int)endPc, (int)handlerPc, (int)catchTypeIndex, catchType);
            exceptionTableElement += (long)config.exceptionTableElementSize;
        }
        return handlers;
    }

    @Override
    public boolean isCallerSensitive() {
        return (this.getFlags() & HotSpotVMConfig.config().methodFlagsCallerSensitive) != 0;
    }

    @Override
    public boolean isForceInline() {
        return (this.getFlags() & HotSpotVMConfig.config().methodFlagsForceInline) != 0;
    }

    @Override
    public boolean hasReservedStackAccess() {
        return false;
    }

    @Override
    public void setNotInlinableOrCompilable() {
        CompilerToVM.compilerToVM().setNotInlinableOrCompilable(this);
    }

    @Override
    public boolean ignoredBySecurityStackWalk() {
        return CompilerToVM.compilerToVM().methodIsIgnoredBySecurityStackWalk(this);
    }

    public boolean isClassInitializer() {
        if (this.isStatic()) {
            long clinitSymbol;
            char nameIndex = UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodNameIndexOffset);
            long nameSymbol = this.constantPool.getEntryAt(nameIndex);
            return nameSymbol == (clinitSymbol = HotSpotVMConfig.config().symbolClinit);
        }
        return false;
    }

    public boolean isConstructor() {
        if (!this.isStatic()) {
            long initSymbol;
            char nameIndex = UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodNameIndexOffset);
            long nameSymbol = this.constantPool.getEntryAt(nameIndex);
            return nameSymbol == (initSymbol = HotSpotVMConfig.config().symbolInit);
        }
        return false;
    }

    public int getMaxLocals() {
        if (this.isAbstract() || this.isNative()) {
            return 0;
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)config.methodMaxLocalsOffset);
    }

    public int getMaxStackSize() {
        if (this.isAbstract() || this.isNative()) {
            return 0;
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return config.extraStackEntries + UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)config.constMethodMaxStackOffset);
    }

    public StackTraceElement asStackTraceElement(int bci) {
        if (bci < 0 || bci >= this.getCodeSize()) {
            StackTraceElement ste = CompilerToVM.compilerToVM().getStackTraceElement(this, 0);
            return new StackTraceElement(ste.getClassName(), ste.getMethodName(), ste.getFileName(), -1);
        }
        return CompilerToVM.compilerToVM().getStackTraceElement(this, bci);
    }

    @Override
    public ResolvedJavaMethod uniqueConcreteMethod(HotSpotResolvedObjectType receiver) {
        if (receiver.isInterface()) {
            return null;
        }
        if (this.isDefault()) {
            return null;
        }
        return CompilerToVM.compilerToVM().findUniqueConcreteMethod((HotSpotResolvedObjectTypeImpl)receiver, this);
    }

    public HotSpotSignature getSignature() {
        return this.signature;
    }

    private long getCompiledCode() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceMethod() + (long)config.methodCodeOffset);
    }

    @Override
    public boolean hasCompiledCode() {
        return this.getCompiledCode() != 0L;
    }

    @Override
    public boolean hasCompiledCodeAtLevel(int level) {
        long compiledCode = this.getCompiledCode();
        if (compiledCode != 0L) {
            return UnsafeAccess.UNSAFE.getInt(compiledCode + (long)HotSpotVMConfig.config().nmethodCompLevelOffset) == level;
        }
        return false;
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        long metaspaceMethodData;
        if (HotSpotJVMCIRuntime.Option.UseProfilingInformation.getBoolean() && this.methodData == null && (metaspaceMethodData = UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceMethod() + (long)HotSpotVMConfig.config().methodDataOffset)) != 0L) {
            this.methodData = new HotSpotMethodData(metaspaceMethodData, this);
            String methodDataFilter = HotSpotJVMCIRuntime.Option.TraceMethodDataFilter.getString();
            if (methodDataFilter != null && this.format("%H.%n").contains(methodDataFilter)) {
                String line = this.methodData.toString() + System.lineSeparator();
                byte[] lineBytes = line.getBytes();
                CompilerToVM.compilerToVM().writeDebugOutput(lineBytes, 0, lineBytes.length, true, true);
            }
        }
        Object info = this.methodData == null || !this.methodData.hasNormalData() && !this.methodData.hasExtraData() ? DefaultProfilingInfo.get((TriState)TriState.FALSE) : new HotSpotProfilingInfo(this.methodData, this, includeNormal, includeOSR);
        return info;
    }

    public void reprofile() {
        CompilerToVM.compilerToVM().reprofile(this);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        if (this.signature.getParameterCount(false) == 0) {
            return new ResolvedJavaMethod.Parameter[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getParameters(this);
    }

    public Annotation[][] getParameterAnnotations() {
        if ((this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasParameterAnnotations) == 0 || this.isClassInitializer()) {
            return new Annotation[this.signature.getParameterCount(false)][0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getParameterAnnotations(this);
    }

    public Annotation[] getAnnotations() {
        if ((this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasMethodAnnotations) == 0 || this.isClassInitializer()) {
            return new Annotation[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getMethodAnnotations(this);
    }

    public Annotation[] getDeclaredAnnotations() {
        if ((this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasMethodAnnotations) == 0 || this.isClassInitializer()) {
            return new Annotation[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getMethodDeclaredAnnotations(this);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if ((this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasMethodAnnotations) == 0 || this.isClassInitializer()) {
            return null;
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getMethodAnnotation(this, annotationClass);
    }

    public boolean isBridge() {
        return (HotSpotModifiers.BRIDGE & this.getModifiers()) != 0;
    }

    public boolean isSynthetic() {
        return (HotSpotModifiers.SYNTHETIC & this.getModifiers()) != 0;
    }

    public boolean isVarArgs() {
        return (HotSpotModifiers.VARARGS & this.getModifiers()) != 0;
    }

    @Override
    public boolean isDefault() {
        int mask = 1033;
        return (this.getModifiers() & mask) == 1 && this.getDeclaringClass().isInterface();
    }

    public Type[] getGenericParameterTypes() {
        if (this.isClassInitializer()) {
            return new Type[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getGenericParameterTypes(this);
    }

    public HotSpotResolvedJavaType[] signatureToTypes() {
        HotSpotSignature sig = this.getSignature();
        int count = sig.getParameterCount(false);
        HotSpotResolvedJavaType[] result = new HotSpotResolvedJavaType[count];
        for (int i = 0; i < result.length; ++i) {
            JavaType parameterType = sig.getParameterType(i, this.holder);
            HotSpotResolvedJavaType resolvedParameterType = (HotSpotResolvedJavaType)parameterType.resolve((ResolvedJavaType)this.holder);
            assert (resolvedParameterType != null);
            result[i] = resolvedParameterType;
        }
        return result;
    }

    public boolean canBeInlined() {
        if (this.hasNeverInlineDirective()) {
            return false;
        }
        return CompilerToVM.compilerToVM().isCompilable(this);
    }

    public boolean hasNeverInlineDirective() {
        return CompilerToVM.compilerToVM().hasNeverInlineDirective(this);
    }

    public boolean shouldBeInlined() {
        if (this.isForceInline()) {
            return true;
        }
        return CompilerToVM.compilerToVM().shouldInlineMethod(this);
    }

    public LineNumberTable getLineNumberTable() {
        boolean hasLineNumberTable;
        boolean bl = hasLineNumberTable = (this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasLineNumberTable) != 0;
        if (!hasLineNumberTable) {
            return null;
        }
        long[] values = CompilerToVM.compilerToVM().getLineNumberTable(this);
        if (values == null || values.length == 0) {
            return null;
        }
        assert (values.length % 2 == 0);
        int[] bci = new int[values.length / 2];
        int[] line = new int[values.length / 2];
        for (int i = 0; i < values.length / 2; ++i) {
            bci[i] = (int)values[i * 2];
            line[i] = (int)values[i * 2 + 1];
        }
        return new LineNumberTable(line, bci);
    }

    public LocalVariableTable getLocalVariableTable() {
        boolean hasLocalVariableTable;
        boolean bl = hasLocalVariableTable = (this.getConstMethodFlags() & HotSpotVMConfig.config().constMethodHasLocalVariableTable) != 0;
        if (!hasLocalVariableTable) {
            return null;
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        long localVariableTableElement = CompilerToVM.compilerToVM().getLocalVariableTableStart(this);
        int localVariableTableLength = CompilerToVM.compilerToVM().getLocalVariableTableLength(this);
        Local[] locals = new Local[localVariableTableLength];
        for (int i = 0; i < localVariableTableLength; ++i) {
            char startBci = UnsafeAccess.UNSAFE.getChar(localVariableTableElement + (long)config.localVariableTableElementStartBciOffset);
            int endBci = startBci + UnsafeAccess.UNSAFE.getChar(localVariableTableElement + (long)config.localVariableTableElementLengthOffset);
            char nameCpIndex = UnsafeAccess.UNSAFE.getChar(localVariableTableElement + (long)config.localVariableTableElementNameCpIndexOffset);
            char typeCpIndex = UnsafeAccess.UNSAFE.getChar(localVariableTableElement + (long)config.localVariableTableElementDescriptorCpIndexOffset);
            char slot = UnsafeAccess.UNSAFE.getChar(localVariableTableElement + (long)config.localVariableTableElementSlotOffset);
            String localName = this.getConstantPool().lookupUtf8((int)nameCpIndex);
            String localType = this.getConstantPool().lookupUtf8((int)typeCpIndex);
            locals[i] = new Local(localName, HotSpotJVMCIRuntime.runtime().lookupType(localType, this.holder, false), (int)startBci, endBci, (int)slot);
            localVariableTableElement += (long)config.localVariableTableElementSize;
        }
        return new LocalVariableTable(locals);
    }

    @Override
    public int vtableEntryOffset(ResolvedJavaType resolved) {
        if (!this.isInVirtualMethodTable(resolved)) {
            throw new JVMCIError("%s does not have a vtable entry in type %s", new Object[]{this, resolved});
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        int vtableIndex = this.getVtableIndex((HotSpotResolvedObjectTypeImpl)resolved);
        return config.klassVtableStartOffset + vtableIndex * config.vtableEntrySize + config.vtableEntryMethodOffset;
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        if (resolved instanceof HotSpotResolvedObjectTypeImpl) {
            HotSpotResolvedObjectTypeImpl hotspotResolved = (HotSpotResolvedObjectTypeImpl)resolved;
            int vtableIndex = this.getVtableIndex(hotspotResolved);
            return vtableIndex >= 0 && vtableIndex < hotspotResolved.getVtableLength();
        }
        return false;
    }

    private int getVtableIndex(HotSpotResolvedObjectTypeImpl resolved) {
        if (!this.holder.isLinked()) {
            return HotSpotVMConfig.config().invalidVtableIndex;
        }
        if (this.holder.isInterface()) {
            if (resolved.isInterface() || !resolved.isLinked()) {
                return HotSpotVMConfig.config().invalidVtableIndex;
            }
            return this.getVtableIndexForInterfaceMethod(resolved);
        }
        return this.getVtableIndex();
    }

    private int getVtableIndex() {
        assert (!this.holder.isInterface());
        HotSpotVMConfig config = HotSpotVMConfig.config();
        int result = UnsafeAccess.UNSAFE.getInt(this.getMetaspaceMethod() + (long)config.methodVtableIndexOffset);
        assert (result >= config.nonvirtualVtableIndex) : "must be linked";
        return result;
    }

    private int getVtableIndexForInterfaceMethod(ResolvedJavaType resolved) {
        HotSpotResolvedObjectTypeImpl hotspotType = (HotSpotResolvedObjectTypeImpl)resolved;
        return CompilerToVM.compilerToVM().getVtableIndexForInterfaceMethod(hotspotType, this);
    }

    public SpeculationLog getSpeculationLog() {
        long address = CompilerToVM.compilerToVM().getFailedSpeculationsAddress(this);
        return new HotSpotSpeculationLog(address);
    }

    @Override
    public int intrinsicId() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return UnsafeAccess.UNSAFE.getByte(this.getMetaspaceMethod() + (long)config.methodIntrinsicIdOffset) & 0xFF;
    }

    @Override
    public boolean isIntrinsicCandidate() {
        return true;
    }

    @Override
    public int allocateCompileId(int entryBCI) {
        return CompilerToVM.compilerToVM().allocateCompileId(this, entryBCI);
    }

    @Override
    public boolean hasCodeAtLevel(int entryBCI, int level) {
        if (entryBCI == HotSpotVMConfig.config().invocationEntryBci) {
            return this.hasCompiledCodeAtLevel(level);
        }
        return CompilerToVM.compilerToVM().hasCompiledCodeForOSR(this, entryBCI, level);
    }

    @Override
    public int methodIdnum() {
        return UnsafeAccess.UNSAFE.getChar(this.getConstMethod() + (long)HotSpotVMConfig.config().constMethodMethodIdnumOffset);
    }
}

