/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.code.InvalidInstalledCodeException;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIUnsupportedOperationError;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;

public class HotSpotNmethod
extends HotSpotInstalledCode {
    private final HotSpotResolvedJavaMethodImpl method;
    private final boolean isDefault;
    private final long compileIdSnapshot;

    boolean inOopsTable() {
        return this.compileIdSnapshot != 0L;
    }

    HotSpotNmethod(HotSpotResolvedJavaMethodImpl method, String name, boolean isDefault, long compileId) {
        super(name);
        this.method = method;
        this.isDefault = isDefault;
        boolean inOopsTable = !Services.IS_IN_NATIVE_IMAGE && !isDefault;
        long l = this.compileIdSnapshot = inOopsTable ? 0L : compileId;
        assert (inOopsTable || compileId != 0L) : this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isValid() {
        if (this.compileIdSnapshot != 0L) {
            CompilerToVM.compilerToVM().updateHotSpotNmethod(this);
        }
        return super.isValid();
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public void invalidate() {
        CompilerToVM.compilerToVM().invalidateHotSpotNmethod(this);
    }

    public long getAddress() {
        if (this.compileIdSnapshot != 0L) {
            CompilerToVM.compilerToVM().updateHotSpotNmethod(this);
        }
        return super.getAddress();
    }

    public long getEntryPoint() {
        if (this.compileIdSnapshot != 0L) {
            return 0L;
        }
        return super.getEntryPoint();
    }

    @Override
    public String toString() {
        return String.format("HotSpotNmethod[method=%s, codeBlob=0x%x, isDefault=%b, name=%s, inOopsTable=%s]", this.method, this.getAddress(), this.isDefault, this.name, this.inOopsTable());
    }

    private boolean checkArgs(Object ... args) {
        JavaType[] sig = this.method.toParameterTypes();
        assert (args.length == sig.length) : this.method.format("%H.%n(%p): expected ") + sig.length + " args, got " + args.length;
        for (int i = 0; i < sig.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                assert (sig[i].getJavaKind() == JavaKind.Object) : this.method.format("%H.%n(%p): expected arg ") + i + " to be Object, not " + sig[i];
                continue;
            }
            if (sig[i].getJavaKind() != JavaKind.Object) assert (sig[i].getJavaKind().toBoxedJavaClass() == arg.getClass()) : this.method.format("%H.%n(%p): expected arg ") + i + " to be " + sig[i] + ", not " + arg.getClass();
        }
        return true;
    }

    public Object executeVarargs(Object ... args) throws InvalidInstalledCodeException {
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new HotSpotJVMCIUnsupportedOperationError("Cannot execute nmethod via mirror in native image");
        }
        assert (this.checkArgs(args));
        return CompilerToVM.compilerToVM().executeHotSpotNmethod(args, this);
    }

    @Override
    public long getStart() {
        return this.isValid() ? super.getStart() : 0L;
    }
}

