/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMethodData;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HotSpotMethodHandleAccessProvider
implements MethodHandleAccessProvider {
    private final ConstantReflectionProvider constantReflection;

    public HotSpotMethodHandleAccessProvider(ConstantReflectionProvider constantReflection) {
        this.constantReflection = constantReflection;
    }

    public MethodHandleAccessProvider.IntrinsicMethod lookupMethodHandleIntrinsic(ResolvedJavaMethod method) {
        int intrinsicId = ((HotSpotResolvedJavaMethodImpl)method).intrinsicId();
        if (intrinsicId != 0) {
            return HotSpotMethodHandleAccessProvider.getMethodHandleIntrinsic(intrinsicId);
        }
        return null;
    }

    public static MethodHandleAccessProvider.IntrinsicMethod getMethodHandleIntrinsic(int intrinsicId) {
        HotSpotVMConfig config = HotSpotJVMCIRuntime.runtime().getConfig();
        if (intrinsicId == config.vmIntrinsicInvokeBasic) {
            return MethodHandleAccessProvider.IntrinsicMethod.INVOKE_BASIC;
        }
        if (intrinsicId == config.vmIntrinsicLinkToInterface) {
            return MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_INTERFACE;
        }
        if (intrinsicId == config.vmIntrinsicLinkToSpecial) {
            return MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_SPECIAL;
        }
        if (intrinsicId == config.vmIntrinsicLinkToStatic) {
            return MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_STATIC;
        }
        if (intrinsicId == config.vmIntrinsicLinkToVirtual) {
            return MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_VIRTUAL;
        }
        return null;
    }

    public ResolvedJavaMethod resolveInvokeBasicTarget(JavaConstant methodHandle, boolean forceBytecodeGeneration) {
        if (methodHandle.isNull()) {
            return null;
        }
        Internals internals = Internals.instance();
        JavaConstant lambdaForm = this.constantReflection.readFieldValue(internals.methodHandleFormField, methodHandle);
        if (lambdaForm == null || lambdaForm.isNull()) {
            return null;
        }
        JavaConstant memberName = this.constantReflection.readFieldValue(internals.lambdaFormVmentryField, lambdaForm);
        if (memberName.isNull() && forceBytecodeGeneration) {
            CompilerToVM.compilerToVM().compileToBytecode((HotSpotObjectConstantImpl)lambdaForm);
            memberName = this.constantReflection.readFieldValue(internals.lambdaFormVmentryField, lambdaForm);
            assert (memberName.isNonNull());
        }
        return HotSpotMethodHandleAccessProvider.getTargetMethod(memberName);
    }

    public ResolvedJavaMethod resolveLinkToTarget(JavaConstant memberName) {
        return HotSpotMethodHandleAccessProvider.getTargetMethod(memberName);
    }

    private static ResolvedJavaMethod getTargetMethod(JavaConstant memberName) {
        if (memberName.isNull()) {
            return null;
        }
        return CompilerToVM.compilerToVM().getResolvedJavaMethod((HotSpotObjectConstantImpl)memberName, Internals.instance().memberNameVmtargetField.getOffset());
    }

    static final class Internals {
        final ResolvedJavaType lambdaFormType;
        final ResolvedJavaField methodHandleFormField;
        final ResolvedJavaField lambdaFormVmentryField;
        final HotSpotResolvedJavaField memberNameVmtargetField;
        final HotSpotResolvedJavaField callSiteTargetField;
        final HotSpotResolvedJavaField constantCallSiteFrozenField;
        @NativeImageReinitialize
        private static volatile Internals instance;

        private static ResolvedJavaField findFieldInClass(ResolvedJavaType declaringType, String fieldName, ResolvedJavaType fieldType) {
            ResolvedJavaField[] fields;
            for (ResolvedJavaField field : fields = declaringType.getInstanceFields(false)) {
                if (!field.getName().equals(fieldName) || !field.getType().equals(fieldType)) continue;
                return field;
            }
            throw new NoSuchFieldError(declaringType + "." + fieldName);
        }

        private static ResolvedJavaType resolveType(String className) {
            return (ResolvedJavaType)HotSpotJVMCIRuntime.runtime().lookupTypeInternal(className, null, true);
        }

        private Internals() {
            try {
                ResolvedJavaType methodHandleType = Internals.resolveType("Ljava/lang/invoke/MethodHandle;");
                ResolvedJavaType memberNameType = Internals.resolveType("Ljava/lang/invoke/MemberName;");
                this.lambdaFormType = Internals.resolveType("Ljava/lang/invoke/LambdaForm;");
                this.methodHandleFormField = Internals.findFieldInClass(methodHandleType, "form", this.lambdaFormType);
                this.lambdaFormVmentryField = Internals.findFieldInClass(this.lambdaFormType, "vmentry", memberNameType);
                this.memberNameVmtargetField = (HotSpotResolvedJavaField)Internals.findFieldInClass(memberNameType, "vmtarget", Internals.resolveType("J"));
                ResolvedJavaType callSiteType = Internals.resolveType("Ljava/lang/invoke/CallSite;");
                this.callSiteTargetField = (HotSpotResolvedJavaField)Internals.findFieldInClass(callSiteType, "target", methodHandleType);
                ResolvedJavaType constantCallSiteType = Internals.resolveType("Ljava/lang/invoke/ConstantCallSite;");
                ResolvedJavaType booleanType = Internals.resolveType("Z");
                this.constantCallSiteFrozenField = (HotSpotResolvedJavaField)Internals.findFieldInClass(constantCallSiteType, "isFrozen", booleanType);
            }
            catch (Throwable ex) {
                throw new JVMCIError(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Internals instance() {
            Internals result = instance;
            if (result != null) return result;
            Class<HotSpotMethodData.VMState> clazz = HotSpotMethodData.VMState.class;
            synchronized (HotSpotMethodData.VMState.class) {
                result = instance;
                if (result != null) return result;
                instance = result = new Internals();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }
    }
}

