/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMemoryAccessProvider;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstantImpl;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.MetaspaceObject;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

class HotSpotMemoryAccessProviderImpl
implements HotSpotMemoryAccessProvider {
    protected final HotSpotJVMCIRuntime runtime;

    HotSpotMemoryAccessProviderImpl(HotSpotJVMCIRuntime runtime) {
        this.runtime = runtime;
    }

    private static HotSpotObjectConstantImpl asObject(Constant base, JavaKind kind, long displacement) {
        if (base instanceof HotSpotObjectConstantImpl) {
            HotSpotObjectConstantImpl constant = (HotSpotObjectConstantImpl)base;
            HotSpotResolvedObjectType type = constant.getType();
            HotSpotJVMCIRuntime.runtime().reflection.checkRead(constant, kind, displacement, type);
            return constant;
        }
        return null;
    }

    private boolean isValidObjectFieldDisplacement(Constant base, long displacement) {
        if (base instanceof HotSpotMetaspaceConstant) {
            MetaspaceObject metaspaceObject = HotSpotMetaspaceConstantImpl.getMetaspaceObject(base);
            if (metaspaceObject instanceof HotSpotResolvedObjectTypeImpl) {
                if (displacement == (long)this.runtime.getConfig().javaMirrorOffset) {
                    return true;
                }
                if (displacement == (long)this.runtime.getConfig().arrayKlassComponentMirrorOffset) {
                    return ((HotSpotResolvedObjectTypeImpl)metaspaceObject).isArray();
                }
            } else {
                throw new IllegalArgumentException(String.valueOf(metaspaceObject));
            }
        }
        return false;
    }

    private static long asRawPointer(Constant base) {
        PrimitiveConstant prim;
        if (base instanceof HotSpotMetaspaceConstantImpl) {
            MetaspaceObject meta = HotSpotMetaspaceConstantImpl.getMetaspaceObject(base);
            return meta.getMetaspacePointer();
        }
        if (base instanceof PrimitiveConstant && (prim = (PrimitiveConstant)base).getJavaKind().isNumericInteger()) {
            return prim.asLong();
        }
        throw new IllegalArgumentException(String.valueOf(base));
    }

    private static long readRawValue(Constant baseConstant, long displacement, JavaKind kind, int bits) {
        HotSpotObjectConstantImpl base = HotSpotMemoryAccessProviderImpl.asObject(baseConstant, kind, displacement);
        if (base != null) {
            switch (bits) {
                case 8: {
                    return HotSpotJVMCIRuntime.runtime().reflection.getByte(base, displacement);
                }
                case 16: {
                    return HotSpotJVMCIRuntime.runtime().reflection.getShort(base, displacement);
                }
                case 32: {
                    return HotSpotJVMCIRuntime.runtime().reflection.getInt(base, displacement);
                }
                case 64: {
                    return HotSpotJVMCIRuntime.runtime().reflection.getLong(base, displacement);
                }
            }
            throw new IllegalArgumentException(String.valueOf(bits));
        }
        long pointer = HotSpotMemoryAccessProviderImpl.asRawPointer(baseConstant);
        switch (bits) {
            case 8: {
                return UnsafeAccess.UNSAFE.getByte(pointer + displacement);
            }
            case 16: {
                return UnsafeAccess.UNSAFE.getShort(pointer + displacement);
            }
            case 32: {
                return UnsafeAccess.UNSAFE.getInt(pointer + displacement);
            }
            case 64: {
                return UnsafeAccess.UNSAFE.getLong(pointer + displacement);
            }
        }
        throw new IllegalArgumentException(String.valueOf(bits));
    }

    private boolean verifyReadRawObject(JavaConstant expected, Constant base, long displacement) {
        MetaspaceObject metaspaceObject;
        if (base instanceof HotSpotMetaspaceConstant && (metaspaceObject = HotSpotMetaspaceConstantImpl.getMetaspaceObject(base)) instanceof HotSpotResolvedObjectTypeImpl && displacement == (long)this.runtime.getConfig().javaMirrorOffset) {
            HotSpotResolvedObjectTypeImpl type = (HotSpotResolvedObjectTypeImpl)metaspaceObject;
            assert (expected.equals(type.getJavaMirror()));
        }
        return true;
    }

    private JavaConstant readRawObject(Constant baseConstant, long initialDisplacement, boolean compressed) {
        HotSpotObjectConstantImpl ret;
        long displacement = initialDisplacement;
        HotSpotObjectConstantImpl base = HotSpotMemoryAccessProviderImpl.asObject(baseConstant, JavaKind.Object, displacement);
        if (base == null) {
            assert (!compressed);
            ret = this.runtime.getCompilerToVM().readUncompressedOop(displacement += HotSpotMemoryAccessProviderImpl.asRawPointer(baseConstant));
            assert (this.verifyReadRawObject(ret, baseConstant, initialDisplacement));
        } else {
            assert (this.runtime.getConfig().useCompressedOops == compressed);
            ret = this.runtime.getCompilerToVM().getObject(base, displacement);
        }
        return ret == null ? JavaConstant.NULL_POINTER : ret;
    }

    public JavaConstant readPrimitiveConstant(JavaKind kind, Constant baseConstant, long initialDisplacement, int bits) {
        try {
            long rawValue = HotSpotMemoryAccessProviderImpl.readRawValue(baseConstant, initialDisplacement, kind, bits);
            switch (kind) {
                case Boolean: {
                    return JavaConstant.forBoolean((rawValue != 0L ? 1 : 0) != 0);
                }
                case Byte: {
                    return JavaConstant.forByte((byte)((byte)rawValue));
                }
                case Char: {
                    return JavaConstant.forChar((char)((char)rawValue));
                }
                case Short: {
                    return JavaConstant.forShort((short)((short)rawValue));
                }
                case Int: {
                    return JavaConstant.forInt((int)((int)rawValue));
                }
                case Long: {
                    return JavaConstant.forLong((long)rawValue);
                }
                case Float: {
                    return JavaConstant.forFloat((float)Float.intBitsToFloat((int)rawValue));
                }
                case Double: {
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(rawValue));
                }
            }
            throw new IllegalArgumentException("Unsupported kind: " + kind);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public JavaConstant readObjectConstant(Constant base, long displacement) {
        if (base instanceof HotSpotObjectConstantImpl) {
            return this.readRawObject(base, displacement, this.runtime.getConfig().useCompressedOops);
        }
        if (!this.isValidObjectFieldDisplacement(base, displacement)) {
            return null;
        }
        return this.readRawObject(base, displacement, false);
    }

    @Override
    public JavaConstant readNarrowOopConstant(Constant base, long displacement) {
        JavaConstant res = this.readRawObject(base, displacement, true);
        return JavaConstant.NULL_POINTER.equals(res) ? HotSpotCompressedNullConstant.COMPRESSED_NULL : ((HotSpotObjectConstant)res).compress();
    }

    private HotSpotResolvedObjectTypeImpl readKlass(Constant base, long displacement, boolean compressed) {
        assert (base instanceof HotSpotMetaspaceConstantImpl || base instanceof HotSpotObjectConstantImpl) : base.getClass();
        if (base instanceof HotSpotMetaspaceConstantImpl) {
            return this.runtime.getCompilerToVM().getResolvedJavaType((HotSpotResolvedObjectTypeImpl)((HotSpotMetaspaceConstantImpl)base).asResolvedJavaType(), displacement, compressed);
        }
        return this.runtime.getCompilerToVM().getResolvedJavaType((HotSpotObjectConstantImpl)base, displacement, compressed);
    }

    @Override
    public Constant readKlassPointerConstant(Constant base, long displacement) {
        HotSpotResolvedObjectTypeImpl klass = this.readKlass(base, displacement, false);
        if (klass == null) {
            return JavaConstant.NULL_POINTER;
        }
        return HotSpotMetaspaceConstantImpl.forMetaspaceObject(klass, false);
    }

    @Override
    public Constant readNarrowKlassPointerConstant(Constant base, long displacement) {
        HotSpotResolvedObjectTypeImpl klass = this.readKlass(base, displacement, true);
        if (klass == null) {
            return HotSpotCompressedNullConstant.COMPRESSED_NULL;
        }
        return HotSpotMetaspaceConstantImpl.forMetaspaceObject(klass, true);
    }

    @Override
    public Constant readMethodPointerConstant(Constant base, long displacement) {
        assert (base instanceof HotSpotObjectConstantImpl);
        HotSpotResolvedJavaMethodImpl method = this.runtime.getCompilerToVM().getResolvedJavaMethod((HotSpotObjectConstantImpl)base, displacement);
        return HotSpotMetaspaceConstantImpl.forMetaspaceObject(method, false);
    }
}

