/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompilationRequestResult;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.Cleaner;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotJDKReflection;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCICompilerConfig;
import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIReflection;
import jdk.vm.ci.hotspot.HotSpotJVMCIUnsupportedOperationError;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedPrimitiveType;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;
import jdk.vm.ci.hotspot.SharedLibraryJVMCIReflection;
import jdk.vm.ci.hotspot.SuppressFBWarnings;
import jdk.vm.ci.hotspot.TranslatedException;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.runtime.JVMCICompiler;
import jdk.vm.ci.runtime.JVMCICompilerFactory;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.JVMCIServiceLocator;
import jdk.vm.ci.services.Services;

public final class HotSpotJVMCIRuntime
implements JVMCIRuntime {
    @NativeImageReinitialize
    private static volatile HotSpotJVMCIRuntime instance;
    private HotSpotResolvedObjectTypeImpl javaLangObject;
    private HotSpotResolvedObjectTypeImpl javaLangInvokeMethodHandle;
    private HotSpotResolvedObjectTypeImpl constantCallSiteType;
    private HotSpotResolvedObjectTypeImpl callSiteType;
    private HotSpotResolvedObjectTypeImpl javaLangString;
    private HotSpotResolvedObjectTypeImpl javaLangClass;
    private HotSpotResolvedObjectTypeImpl throwableType;
    private HotSpotResolvedObjectTypeImpl serializableType;
    private HotSpotResolvedObjectTypeImpl cloneableType;
    private HotSpotResolvedObjectTypeImpl enumType;
    static final Map<String, Object> options;
    private static volatile List<HotSpotJVMCIBackendFactory> cachedHotSpotJVMCIBackendFactories;
    final CompilerToVM compilerToVm;
    protected final HotSpotVMConfigStore configStore;
    private final HotSpotVMConfig config;
    private final JVMCIBackend hostBackend;
    private final JVMCICompilerFactory compilerFactory;
    private final HotSpotJVMCICompilerFactory hsCompilerFactory;
    private volatile JVMCICompiler compiler;
    protected final HotSpotJVMCIReflection reflection;
    @NativeImageReinitialize
    private volatile boolean creatingCompiler;
    @NativeImageReinitialize
    private volatile ClassValue<WeakReference<HotSpotResolvedJavaType>> resolvedJavaType;
    @NativeImageReinitialize
    private HashMap<Long, WeakReference<ResolvedJavaType>> resolvedJavaTypes;
    @NativeImageReinitialize
    private ClassLoader[] excludeFromJVMCICompilation;
    private final Map<Class<? extends Architecture>, JVMCIBackend> backends = new HashMap<Class<? extends Architecture>, JVMCIBackend>();
    private volatile List<HotSpotVMEventListener> vmEventListeners;
    private boolean isShutdown;

    HotSpotResolvedObjectTypeImpl getJavaLangObject() {
        if (this.javaLangObject == null) {
            this.javaLangObject = (HotSpotResolvedObjectTypeImpl)this.fromClass(Object.class);
        }
        return this.javaLangObject;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangString() {
        if (this.javaLangString == null) {
            this.javaLangString = (HotSpotResolvedObjectTypeImpl)this.fromClass(String.class);
        }
        return this.javaLangString;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangClass() {
        if (this.javaLangClass == null) {
            this.javaLangClass = (HotSpotResolvedObjectTypeImpl)this.fromClass(Class.class);
        }
        return this.javaLangClass;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangCloneable() {
        if (this.cloneableType == null) {
            this.cloneableType = (HotSpotResolvedObjectTypeImpl)this.fromClass(Cloneable.class);
        }
        return this.cloneableType;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangSerializable() {
        if (this.serializableType == null) {
            this.serializableType = (HotSpotResolvedObjectTypeImpl)this.fromClass(Serializable.class);
        }
        return this.serializableType;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangThrowable() {
        if (this.throwableType == null) {
            this.throwableType = (HotSpotResolvedObjectTypeImpl)this.fromClass(Throwable.class);
        }
        return this.throwableType;
    }

    HotSpotResolvedObjectTypeImpl getJavaLangEnum() {
        if (this.enumType == null) {
            this.enumType = (HotSpotResolvedObjectTypeImpl)this.fromClass(Enum.class);
        }
        return this.enumType;
    }

    HotSpotResolvedObjectTypeImpl getConstantCallSite() {
        if (this.constantCallSiteType == null) {
            this.constantCallSiteType = (HotSpotResolvedObjectTypeImpl)this.fromClass(ConstantCallSite.class);
        }
        return this.constantCallSiteType;
    }

    HotSpotResolvedObjectTypeImpl getCallSite() {
        if (this.callSiteType == null) {
            this.callSiteType = (HotSpotResolvedObjectTypeImpl)this.fromClass(CallSite.class);
        }
        return this.callSiteType;
    }

    HotSpotResolvedObjectType getMethodHandleClass() {
        if (this.javaLangInvokeMethodHandle == null) {
            this.javaLangInvokeMethodHandle = (HotSpotResolvedObjectTypeImpl)this.fromClass(MethodHandle.class);
        }
        return this.javaLangInvokeMethodHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VMEntryPoint
    public static HotSpotJVMCIRuntime runtime() {
        HotSpotJVMCIRuntime result = instance;
        if (result != null) return result;
        Class<JVMCI> clazz = JVMCI.class;
        synchronized (JVMCI.class) {
            result = instance;
            if (result != null) return result;
            try (InitTimer t = InitTimer.timer((String)"HotSpotJVMCIRuntime.<init>");){
                instance = result = new HotSpotJVMCIRuntime();
                if (result.config.getFlag("EagerJVMCI", Boolean.class).booleanValue()) {
                    result.getCompiler();
                }
            }
            JVMCI.getRuntime();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    @VMEntryPoint
    static Throwable decodeThrowable(String encodedThrowable) throws Throwable {
        return TranslatedException.decodeThrowable(encodedThrowable);
    }

    @VMEntryPoint
    static String encodeThrowable(Throwable throwable) throws Throwable {
        return TranslatedException.encodeThrowable(throwable);
    }

    @VMEntryPoint
    static String callToString(Object o) {
        return o.toString();
    }

    private static HotSpotJVMCIBackendFactory findFactory(String architecture) {
        Iterable<HotSpotJVMCIBackendFactory> factories = HotSpotJVMCIRuntime.getHotSpotJVMCIBackendFactories();
        for (HotSpotJVMCIBackendFactory factory : factories) {
            if (!factory.getArchitecture().equalsIgnoreCase(architecture)) continue;
            return factory;
        }
        throw new JVMCIError("No JVMCI runtime available for the %s architecture", new Object[]{architecture});
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_UPDATE_STATIC"}, justification="not sure about this")
    private static Iterable<HotSpotJVMCIBackendFactory> getHotSpotJVMCIBackendFactories() {
        if (Services.IS_IN_NATIVE_IMAGE || cachedHotSpotJVMCIBackendFactories != null) {
            return cachedHotSpotJVMCIBackendFactories;
        }
        Iterable result = Services.load(HotSpotJVMCIBackendFactory.class);
        if (Services.IS_BUILDING_NATIVE_IMAGE) {
            cachedHotSpotJVMCIBackendFactories = new ArrayList<HotSpotJVMCIBackendFactory>();
            for (HotSpotJVMCIBackendFactory factory : result) {
                cachedHotSpotJVMCIBackendFactories.add(factory);
            }
        }
        return result;
    }

    public static JavaKind getHostWordKind() {
        return HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getCodeCache().getTarget().wordJavaKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<HotSpotVMEventListener> getVmEventListeners() {
        if (this.vmEventListeners == null) {
            HotSpotJVMCIRuntime hotSpotJVMCIRuntime = this;
            synchronized (hotSpotJVMCIRuntime) {
                if (this.vmEventListeners == null) {
                    this.vmEventListeners = JVMCIServiceLocator.getProviders(HotSpotVMEventListener.class);
                }
            }
        }
        return this.vmEventListeners;
    }

    private HotSpotJVMCIRuntime() {
        HotSpotJVMCIBackendFactory factory;
        this.compilerToVm = new CompilerToVM();
        try (InitTimer t = InitTimer.timer((String)"HotSpotVMConfig<init>");){
            this.configStore = new HotSpotVMConfigStore(this.compilerToVm);
            this.config = new HotSpotVMConfig(this.configStore);
        }
        this.reflection = Services.IS_IN_NATIVE_IMAGE ? new SharedLibraryJVMCIReflection() : new HotSpotJDKReflection();
        PrintStream vmLogStream = null;
        if (Services.IS_IN_NATIVE_IMAGE) {
            vmLogStream = new PrintStream(this.getLogStream());
            System.setOut(vmLogStream);
            System.setErr(vmLogStream);
        }
        Option.parse();
        String hostArchitecture = this.config.getHostArchitectureName();
        try (InitTimer t = InitTimer.timer((String)"find factory:", (Object)hostArchitecture);){
            factory = HotSpotJVMCIRuntime.findFactory(hostArchitecture);
        }
        t = InitTimer.timer((String)"create JVMCI backend:", (Object)hostArchitecture);
        var5_9 = null;
        try {
            this.hostBackend = this.registerBackend(factory.createJVMCIBackend(this, null));
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var5_9 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var5_9.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
        this.compilerFactory = HotSpotJVMCICompilerConfig.getCompilerFactory();
        if (this.compilerFactory instanceof HotSpotJVMCICompilerFactory) {
            this.hsCompilerFactory = (HotSpotJVMCICompilerFactory)this.compilerFactory;
            if (this.hsCompilerFactory.getCompilationLevelAdjustment() != HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None) {
                String name = HotSpotJVMCICompilerFactory.class.getName();
                String msg = String.format("%s.getCompilationLevelAdjustment() is no longer supported. Use %s.excludeFromJVMCICompilation() instead.", name, name);
                throw new HotSpotJVMCIUnsupportedOperationError(msg);
            }
        } else {
            this.hsCompilerFactory = null;
        }
        if (this.config.getFlag("JVMCIPrintProperties", Boolean.class).booleanValue()) {
            if (vmLogStream == null) {
                vmLogStream = new PrintStream(this.getLogStream());
            }
            Option.printProperties(vmLogStream);
            this.compilerFactory.printProperties(vmLogStream);
            System.exit(0);
        }
        if (Option.PrintConfig.getBoolean()) {
            this.configStore.printConfig();
        }
    }

    HotSpotResolvedJavaType createClass(Class<?> javaClass) {
        if (javaClass.isPrimitive()) {
            return HotSpotResolvedPrimitiveType.forKind(JavaKind.fromJavaClass(javaClass));
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            try {
                return this.compilerToVm.lookupType(javaClass.getName().replace('.', '/'), null, true);
            }
            catch (ClassNotFoundException e) {
                throw new JVMCIError((Throwable)e);
            }
        }
        return this.compilerToVm.lookupClass(javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HotSpotResolvedJavaType fromClass0(Class<?> javaClass) {
        if (this.resolvedJavaType == null) {
            HotSpotJVMCIRuntime hotSpotJVMCIRuntime = this;
            synchronized (hotSpotJVMCIRuntime) {
                if (this.resolvedJavaType == null) {
                    this.resolvedJavaType = new ClassValue<WeakReference<HotSpotResolvedJavaType>>(){

                        @Override
                        protected WeakReference<HotSpotResolvedJavaType> computeValue(Class<?> type) {
                            return new WeakReference<HotSpotResolvedJavaType>(HotSpotJVMCIRuntime.this.createClass(type));
                        }
                    };
                }
            }
        }
        HotSpotResolvedJavaType javaType = null;
        while (javaType == null) {
            WeakReference<HotSpotResolvedJavaType> type = this.resolvedJavaType.get(javaClass);
            javaType = (HotSpotResolvedJavaType)type.get();
            if (javaType != null) continue;
            this.resolvedJavaType.remove(javaClass);
        }
        return javaType;
    }

    HotSpotResolvedJavaType fromClass(Class<?> javaClass) {
        if (javaClass == null) {
            return null;
        }
        return this.fromClass0(javaClass);
    }

    synchronized HotSpotResolvedObjectTypeImpl fromMetaspace(long klassPointer, String signature) {
        if (this.resolvedJavaTypes == null) {
            this.resolvedJavaTypes = new HashMap();
        }
        assert (klassPointer != 0L);
        WeakReference<ResolvedJavaType> klassReference = this.resolvedJavaTypes.get(klassPointer);
        HotSpotResolvedObjectTypeImpl javaType = null;
        if (klassReference != null) {
            javaType = (HotSpotResolvedObjectTypeImpl)klassReference.get();
        }
        if (javaType == null) {
            javaType = new HotSpotResolvedObjectTypeImpl(klassPointer, signature);
            this.resolvedJavaTypes.put(klassPointer, new WeakReference<HotSpotResolvedObjectTypeImpl>(javaType));
        }
        return javaType;
    }

    private JVMCIBackend registerBackend(JVMCIBackend backend) {
        Class<?> arch = backend.getCodeCache().getTarget().arch.getClass();
        JVMCIBackend oldValue = this.backends.put(arch, backend);
        assert (oldValue == null) : "cannot overwrite existing backend for architecture " + arch.getSimpleName();
        return backend;
    }

    public HotSpotVMConfigStore getConfigStore() {
        return this.configStore;
    }

    HotSpotVMConfig getConfig() {
        return this.config;
    }

    CompilerToVM getCompilerToVM() {
        return this.compilerToVm;
    }

    HotSpotJVMCIReflection getReflection() {
        return this.reflection;
    }

    public Predicate<ResolvedJavaType> getIntrinsificationTrustPredicate(Class<?> ... compilerLeafClasses) {
        return new Predicate<ResolvedJavaType>(){

            @Override
            public boolean test(ResolvedJavaType type) {
                if (type instanceof HotSpotResolvedObjectTypeImpl) {
                    HotSpotResolvedObjectTypeImpl hsType = (HotSpotResolvedObjectTypeImpl)type;
                    return HotSpotJVMCIRuntime.this.compilerToVm.isTrustedForIntrinsics(hsType);
                }
                return false;
            }
        };
    }

    public Class<?> getMirror(ResolvedJavaType type) {
        if (type instanceof HotSpotResolvedJavaType && this.reflection instanceof HotSpotJDKReflection) {
            return ((HotSpotJDKReflection)this.reflection).getMirror((HotSpotResolvedJavaType)type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JVMCICompiler getCompiler() {
        if (this.compiler == null) {
            HotSpotJVMCIRuntime hotSpotJVMCIRuntime = this;
            synchronized (hotSpotJVMCIRuntime) {
                if (this.compiler == null) {
                    assert (!this.creatingCompiler) : "recursive compiler creation";
                    this.creatingCompiler = true;
                    this.compiler = this.compilerFactory.createCompiler((JVMCIRuntime)this);
                    this.creatingCompiler = false;
                }
            }
        }
        return this.compiler;
    }

    public JavaType lookupType(String name, HotSpotResolvedObjectType accessingType, boolean resolve) {
        Objects.requireNonNull(accessingType, "cannot resolve type without an accessing class");
        return this.lookupTypeInternal(name, accessingType, resolve);
    }

    JavaType lookupTypeInternal(String name, HotSpotResolvedObjectType accessingType, boolean resolve) {
        if (name.length() == 1) {
            JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)name.charAt(0));
            return HotSpotResolvedPrimitiveType.forKind(kind);
        }
        HotSpotResolvedObjectTypeImpl hsAccessingType = (HotSpotResolvedObjectTypeImpl)accessingType;
        try {
            HotSpotResolvedJavaType klass = this.compilerToVm.lookupType(name, hsAccessingType, resolve);
            if (klass == null) {
                assert (!resolve) : name;
                return UnresolvedJavaType.create((String)name);
            }
            return klass;
        }
        catch (ClassNotFoundException e) {
            throw (NoClassDefFoundError)new NoClassDefFoundError().initCause(e);
        }
    }

    public JVMCIBackend getHostJVMCIBackend() {
        return this.hostBackend;
    }

    public <T extends Architecture> JVMCIBackend getJVMCIBackend(Class<T> arch) {
        assert (arch != Architecture.class);
        return this.backends.get(arch);
    }

    public Map<Class<? extends Architecture>, JVMCIBackend> getJVMCIBackends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @VMEntryPoint
    private HotSpotCompilationRequestResult compileMethod(HotSpotResolvedJavaMethod method, int entryBCI, long compileState, int id) {
        HotSpotCompilationRequestResult hsResult;
        Thread.currentThread().setContextClassLoader(HotSpotJVMCIRuntime.class.getClassLoader());
        HotSpotCompilationRequest request = new HotSpotCompilationRequest(method, entryBCI, compileState, id);
        CompilationRequestResult result = this.getCompiler().compileMethod((CompilationRequest)request);
        assert (result != null) : "compileMethod must always return something";
        if (result instanceof HotSpotCompilationRequestResult) {
            hsResult = (HotSpotCompilationRequestResult)result;
        } else {
            Object failure = result.getFailure();
            if (failure != null) {
                boolean retry = false;
                hsResult = HotSpotCompilationRequestResult.failure(failure.toString(), retry);
            } else {
                int inlinedBytecodes = -1;
                hsResult = HotSpotCompilationRequestResult.success(inlinedBytecodes);
            }
        }
        return hsResult;
    }

    @VMEntryPoint
    private synchronized void shutdown() throws Exception {
        if (!this.isShutdown) {
            this.isShutdown = true;
            Cleaner.clean();
            for (HotSpotVMEventListener vmEventListener : this.getVmEventListeners()) {
                vmEventListener.notifyShutdown();
            }
        }
    }

    @VMEntryPoint
    private void bootstrapFinished() throws Exception {
        for (HotSpotVMEventListener vmEventListener : this.getVmEventListeners()) {
            vmEventListener.notifyBootstrapFinished();
        }
    }

    void notifyInstall(HotSpotCodeCacheProvider hotSpotCodeCacheProvider, InstalledCode installedCode, CompiledCode compiledCode) {
        for (HotSpotVMEventListener vmEventListener : this.getVmEventListeners()) {
            vmEventListener.notifyInstall(hotSpotCodeCacheProvider, installedCode, compiledCode);
        }
    }

    public int writeDebugOutput(byte[] bytes, int offset, int length, boolean flush, boolean canThrow) {
        return this.compilerToVm.writeDebugOutput(bytes, offset, length, flush, canThrow);
    }

    public OutputStream getLogStream() {
        return new OutputStream(){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                HotSpotJVMCIRuntime.this.compilerToVm.writeDebugOutput(b, off, len, false, true);
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void flush() throws IOException {
                HotSpotJVMCIRuntime.this.compilerToVm.flushDebugOutput();
            }
        };
    }

    public OutputStream getCompileLogStream() {
        try {
            this.compilerToVm.writeCompileLogOutput(new byte[0], 0, 0);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return new CompileLogStream();
    }

    public long[] collectCounters() {
        return this.compilerToVm.collectCounters();
    }

    public int getCountersSize() {
        return this.compilerToVm.getCountersSize();
    }

    public boolean setCountersSize(int newSize) {
        return this.compilerToVm.setCountersSize(newSize);
    }

    public int getArrayBaseOffset(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return this.compilerToVm.ARRAY_BOOLEAN_BASE_OFFSET;
            }
            case Byte: {
                return this.compilerToVm.ARRAY_BYTE_BASE_OFFSET;
            }
            case Char: {
                return this.compilerToVm.ARRAY_CHAR_BASE_OFFSET;
            }
            case Short: {
                return this.compilerToVm.ARRAY_SHORT_BASE_OFFSET;
            }
            case Int: {
                return this.compilerToVm.ARRAY_INT_BASE_OFFSET;
            }
            case Long: {
                return this.compilerToVm.ARRAY_LONG_BASE_OFFSET;
            }
            case Float: {
                return this.compilerToVm.ARRAY_FLOAT_BASE_OFFSET;
            }
            case Double: {
                return this.compilerToVm.ARRAY_DOUBLE_BASE_OFFSET;
            }
            case Object: {
                return this.compilerToVm.ARRAY_OBJECT_BASE_OFFSET;
            }
        }
        throw new JVMCIError("%s", new Object[]{kind});
    }

    public int getArrayIndexScale(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return this.compilerToVm.ARRAY_BOOLEAN_INDEX_SCALE;
            }
            case Byte: {
                return this.compilerToVm.ARRAY_BYTE_INDEX_SCALE;
            }
            case Char: {
                return this.compilerToVm.ARRAY_CHAR_INDEX_SCALE;
            }
            case Short: {
                return this.compilerToVm.ARRAY_SHORT_INDEX_SCALE;
            }
            case Int: {
                return this.compilerToVm.ARRAY_INT_INDEX_SCALE;
            }
            case Long: {
                return this.compilerToVm.ARRAY_LONG_INDEX_SCALE;
            }
            case Float: {
                return this.compilerToVm.ARRAY_FLOAT_INDEX_SCALE;
            }
            case Double: {
                return this.compilerToVm.ARRAY_DOUBLE_INDEX_SCALE;
            }
            case Object: {
                return this.compilerToVm.ARRAY_OBJECT_INDEX_SCALE;
            }
        }
        throw new JVMCIError("%s", new Object[]{kind});
    }

    public long[] registerNativeMethods(Class<?> clazz) {
        return this.compilerToVm.registerNativeMethods(clazz);
    }

    public long translate(Object obj) {
        return this.compilerToVm.translate(obj);
    }

    public <T> T unhand(Class<T> type, long handle) {
        return type.cast(this.compilerToVm.unhand(handle));
    }

    public boolean isCurrentThreadAttached() {
        return this.compilerToVm.isCurrentThreadAttached();
    }

    public long getCurrentJavaThread() {
        return this.compilerToVm.getCurrentJavaThread();
    }

    public boolean attachCurrentThread(boolean asDaemon) {
        return this.compilerToVm.attachCurrentThread(asDaemon);
    }

    public void detachCurrentThread() {
        this.compilerToVm.detachCurrentThread();
    }

    public void excludeFromJVMCICompilation(ClassLoader ... loaders) {
        this.excludeFromJVMCICompilation = (ClassLoader[])loaders.clone();
    }

    public void exitHotSpot(int status) {
        if (!Services.IS_IN_NATIVE_IMAGE) {
            System.exit(status);
        }
        this.compilerToVm.callSystemExit(status);
    }

    static {
        options = new HashMap<String, Object>();
        options.put("jvmci.class.path.append", options);
    }

    private class CompileLogStream
    extends OutputStream {
        CompileLogStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            HotSpotJVMCIRuntime.this.compilerToVm.writeCompileLogOutput(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void flush() throws IOException {
            HotSpotJVMCIRuntime.this.compilerToVm.flushCompileLogOutput();
        }
    }

    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option Compiler = new Option(String.class, null, "Selects the system compiler. This must match the getCompilerName() value returned by a jdk.vm.ci.runtime.JVMCICompilerFactory provider. An empty string or the value \"null\" selects a compiler that will raise an exception upon receiving a compilation request. This property can also be defined by the contents of <java.home>/lib/jvmci/compiler-name.");
        public static final /* enum */ Option InitTimer = new Option(Boolean.class, false, "Specifies if initialization timing is enabled.");
        public static final /* enum */ Option PrintConfig = new Option(Boolean.class, false, "Prints VM configuration available via JVMCI.");
        public static final /* enum */ Option AuditHandles = new Option(Boolean.class, false, "Record stack trace along with scoped foreign object reference wrappers to debug issue with a wrapper being used after its scope has closed.");
        public static final /* enum */ Option TraceMethodDataFilter = new Option(String.class, null, "Enables tracing of profiling info when read by JVMCI.", "Empty value: trace all methods", "Non-empty value: trace methods whose fully qualified name contains the value.");
        public static final /* enum */ Option UseProfilingInformation = new Option(Boolean.class, true, "");
        private static final String JVMCI_OPTION_PROPERTY_PREFIX = "jvmci.";
        private static final String NULL_VALUE = "NULL";
        private final Class<?> type;
        @NativeImageReinitialize
        private Object value;
        private final Object defaultValue;
        private boolean isDefault = true;
        private final String[] helpLines;
        private static final int PROPERTY_LINE_WIDTH = 80;
        private static final int PROPERTY_HELP_INDENT = 10;
        private static final float FUZZY_MATCH_THRESHOLD = 0.7f;
        private static final /* synthetic */ Option[] $VALUES;

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String name) {
            return Enum.valueOf(Option.class, name);
        }

        private Option(Class<?> type, Object defaultValue, String ... helpLines) {
            assert (Character.isUpperCase(this.name().charAt(0))) : "Option name must start with upper-case letter: " + this.name();
            this.type = type;
            this.defaultValue = defaultValue;
            this.helpLines = helpLines;
            Object existing = options.put(this.getPropertyName(), (Object)this);
            assert (existing == null) : this.getPropertyName();
        }

        private void init(String propertyValue) {
            assert (this.value == null) : "cannot re-initialize " + this.name();
            if (propertyValue == null) {
                this.value = this.defaultValue == null ? NULL_VALUE : this.defaultValue;
                this.isDefault = true;
            } else {
                if (this.type == Boolean.class) {
                    this.value = Boolean.parseBoolean(propertyValue);
                } else if (this.type == String.class) {
                    this.value = propertyValue;
                } else {
                    throw new JVMCIError("Unexpected option type " + this.type);
                }
                this.isDefault = false;
            }
        }

        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="sentinel must be String since it's a static final in an enum")
        private Object getValue() {
            if (this.value == NULL_VALUE) {
                return null;
            }
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        public String getPropertyName() {
            return JVMCI_OPTION_PROPERTY_PREFIX + this.name();
        }

        public boolean getBoolean() {
            return (Boolean)this.getValue();
        }

        public String getString() {
            return (String)this.getValue();
        }

        public static void printProperties(PrintStream out) {
            Option[] values;
            out.println("[JVMCI properties]");
            for (Option option : values = Option.values()) {
                Object value = option.getValue();
                if (value instanceof String) {
                    value = '\"' + String.valueOf(value) + '\"';
                }
                String name = option.getPropertyName();
                String assign = option.isDefault ? "=" : ":=";
                String typeName = option.type.getSimpleName();
                String linePrefix = String.format("%s %s %s ", name, assign, value);
                int typeStartPos = 80 - typeName.length();
                int linePad = typeStartPos - linePrefix.length();
                if (linePad > 0) {
                    out.printf("%s%-" + linePad + "s[%s]%n", linePrefix, "", typeName);
                } else {
                    out.printf("%s[%s]%n", linePrefix, typeName);
                }
                for (String line : option.helpLines) {
                    out.printf("%10s%s%n", "", line);
                }
            }
        }

        static float stringSimiliarity(String str1, String str2) {
            int hit = 0;
            block0: for (int i = 0; i < str1.length() - 1; ++i) {
                for (int j = 0; j < str2.length() - 1; ++j) {
                    if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                    ++hit;
                    continue block0;
                }
            }
            return 2.0f * (float)hit / (float)(str1.length() + str2.length());
        }

        static void parse() {
            Map savedProps = Services.getSavedProperties();
            for (Map.Entry e : savedProps.entrySet()) {
                String name = (String)e.getKey();
                if (!name.startsWith(JVMCI_OPTION_PROPERTY_PREFIX)) continue;
                Object value = options.get(name);
                if (value == null) {
                    ArrayList<String> matches = new ArrayList<String>();
                    for (String pn : options.keySet()) {
                        float score = Option.stringSimiliarity(pn, name);
                        if (!(score >= 0.7f)) continue;
                        matches.add(pn);
                    }
                    Formatter msg = new Formatter();
                    msg.format("Could not find option %s", name);
                    if (!matches.isEmpty()) {
                        msg.format("%nDid you mean one of the following?", new Object[0]);
                        for (String match : matches) {
                            msg.format("%n    %s=<value>", match);
                        }
                    }
                    throw new IllegalArgumentException(msg.toString());
                }
                if (!(value instanceof Option)) continue;
                Option option = (Option)((Object)value);
                option.init((String)e.getValue());
            }
        }

        static {
            $VALUES = new Option[]{Compiler, InitTimer, PrintConfig, AuditHandles, TraceMethodDataFilter, UseProfilingInformation};
        }
    }
}

