/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.hotspot.SuppressFBWarnings;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class HotSpotCompiledCode
implements CompiledCode {
    protected final String name;
    protected final byte[] targetCode;
    protected final int targetCodeSize;
    protected final Site[] sites;
    protected final Assumptions.Assumption[] assumptions;
    protected final ResolvedJavaMethod[] methods;
    protected final Comment[] comments;
    protected final byte[] dataSection;
    protected final int dataSectionAlignment;
    protected final DataPatch[] dataSectionPatches;
    protected final boolean isImmutablePIC;
    protected final int totalFrameSize;
    protected final StackSlot deoptRescueSlot;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `sites`, `targetCode`, `comments`, `methods`, `dataSection`, `dataSectionPatches` and `assumptions`")
    public HotSpotCompiledCode(String name, byte[] targetCode, int targetCodeSize, Site[] sites, Assumptions.Assumption[] assumptions, ResolvedJavaMethod[] methods, Comment[] comments, byte[] dataSection, int dataSectionAlignment, DataPatch[] dataSectionPatches, boolean isImmutablePIC, int totalFrameSize, StackSlot deoptRescueSlot) {
        this.name = name;
        this.targetCode = targetCode;
        this.targetCodeSize = targetCodeSize;
        this.sites = sites;
        this.assumptions = assumptions;
        this.methods = methods;
        this.comments = comments;
        this.dataSection = dataSection;
        this.dataSectionAlignment = dataSectionAlignment;
        this.dataSectionPatches = dataSectionPatches;
        this.isImmutablePIC = isImmutablePIC;
        this.totalFrameSize = totalFrameSize;
        this.deoptRescueSlot = deoptRescueSlot;
        assert (this.validateFrames());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    private boolean validateFrames() {
        for (Site site : this.sites) {
            if (!(site instanceof Infopoint)) continue;
            Infopoint info = (Infopoint)site;
            if (info.debugInfo == null) continue;
            BytecodeFrame frame = info.debugInfo.frame();
            assert (frame == null || frame.validateFormat());
            if (info.debugInfo.getVirtualObjectMapping() == null) continue;
            for (VirtualObject v : info.debugInfo.getVirtualObjectMapping()) {
                HotSpotCompiledCode.verifyVirtualObject(v);
            }
        }
        return true;
    }

    public static void verifyVirtualObject(VirtualObject v) {
        v.verifyLayout(new VirtualObject.LayoutVerifier(){

            public int getOffset(ResolvedJavaField field) {
                return field.getOffset();
            }
        });
    }

    public static class Comment {
        public final String text;
        public final int pcOffset;

        public Comment(int pcOffset, String text) {
            this.text = text;
            this.pcOffset = pcOffset;
        }
    }
}

