/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import jdk.vm.ci.common.NativeImageReinitialize;

abstract class Cleaner
extends WeakReference<Object> {
    @NativeImageReinitialize
    private static Cleaner first;
    private Cleaner next = null;
    private Cleaner prev = null;
    private static final ReferenceQueue<Object> queue;

    Cleaner(Object referent) {
        super(referent, queue);
        Cleaner.add(this);
    }

    private static synchronized Cleaner add(Cleaner cl) {
        if (first != null) {
            Cleaner.clean();
        }
        if (first != null) {
            cl.next = first;
            Cleaner.first.prev = cl;
        }
        first = cl;
        return cl;
    }

    private static synchronized void remove(Cleaner cl) {
        if (cl.next == cl) {
            return;
        }
        if (first == cl) {
            first = cl.next != null ? cl.next : cl.prev;
        }
        if (cl.next != null) {
            cl.next.prev = cl.prev;
        }
        if (cl.prev != null) {
            cl.prev.next = cl.next;
        }
        cl.next = cl;
        cl.prev = cl;
    }

    abstract void doCleanup();

    static void clean() {
        Cleaner c = (Cleaner)queue.poll();
        while (c != null) {
            Cleaner.remove(c);
            c.doCleanup();
            c = (Cleaner)queue.poll();
        }
    }

    static {
        queue = new ReferenceQueue();
    }
}

