/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ModifiersProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaType;

public interface ResolvedJavaType
extends JavaType,
ModifiersProvider,
AnnotatedElement {
    public boolean hasFinalizer();

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass();

    @Override
    public boolean isInterface();

    public boolean isInstanceClass();

    public boolean isPrimitive();

    default public boolean isLeaf() {
        return this.getElementalType().isFinalFlagSet();
    }

    public boolean isEnum();

    public boolean isInitialized();

    public void initialize();

    public boolean isLinked();

    default public void link() {
        throw new UnsupportedOperationException("link is unsupported");
    }

    default public boolean hasDefaultMethods() {
        throw new UnsupportedOperationException("hasDefaultMethods is unsupported");
    }

    default public boolean declaresDefaultMethods() {
        throw new UnsupportedOperationException("declaresDefaultMethods is unsupported");
    }

    public boolean isAssignableFrom(ResolvedJavaType var1);

    public ResolvedJavaType getHostClass();

    default public boolean isJavaLangObject() {
        return this.getSuperclass() == null && !this.isInterface() && this.getJavaKind() == JavaKind.Object;
    }

    public boolean isInstance(JavaConstant var1);

    public ResolvedJavaType getSuperclass();

    public ResolvedJavaType[] getInterfaces();

    public ResolvedJavaType getSingleImplementor();

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType var1);

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype();

    @Override
    public ResolvedJavaType getComponentType();

    @Override
    default public ResolvedJavaType getElementalType() {
        ResolvedJavaType t = this;
        while (t.isArray()) {
            t = t.getComponentType();
        }
        return t;
    }

    @Override
    public ResolvedJavaType getArrayClass();

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod var1, ResolvedJavaType var2);

    default public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        ResolvedJavaMethod resolvedMethod = this.resolveMethod(method, callerType);
        if (resolvedMethod == null || resolvedMethod.isAbstract()) {
            return null;
        }
        return resolvedMethod;
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod var1);

    public ResolvedJavaField[] getInstanceFields(boolean var1);

    public ResolvedJavaField[] getStaticFields();

    public ResolvedJavaField findInstanceFieldWithOffset(long var1, JavaKind var3);

    public String getSourceFileName();

    public boolean isLocal();

    public boolean isMember();

    public ResolvedJavaType getEnclosingType();

    public ResolvedJavaMethod[] getDeclaredConstructors();

    public ResolvedJavaMethod[] getDeclaredMethods();

    public ResolvedJavaMethod getClassInitializer();

    default public ResolvedJavaMethod findMethod(String name, Signature signature) {
        for (ResolvedJavaMethod method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public boolean isCloneableWithAllocation();

    default public ResolvedJavaType lookupType(UnresolvedJavaType unresolvedJavaType, boolean resolve) {
        return null;
    }

    default public ResolvedJavaField resolveField(UnresolvedJavaField unresolvedJavaField, ResolvedJavaType accessingClass) {
        return null;
    }
}

