/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.SuppressFBWarnings;

public class LineNumberTable {
    private final int[] lineNumbers;
    private final int[] bcis;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `lineNumbers` and `bcis`")
    public LineNumberTable(int[] lineNumbers, int[] bcis) {
        assert (bcis.length == lineNumbers.length);
        this.lineNumbers = lineNumbers;
        this.bcis = bcis;
    }

    public int getLineNumber(int atBci) {
        for (int i = 0; i < this.bcis.length - 1; ++i) {
            if (this.bcis[i] > atBci || atBci >= this.bcis[i + 1]) continue;
            return this.lineNumbers[i];
        }
        return this.lineNumbers[this.lineNumbers.length - 1];
    }

    public int[] getLineNumbers() {
        return (int[])this.lineNumbers.clone();
    }

    public int[] getBcis() {
        return (int[])this.bcis.clone();
    }
}

