/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface JavaType {
    public String getName();

    default public String getUnqualifiedName() {
        String name = this.getName();
        if (name.indexOf(47) != -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        if (name.endsWith(";")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    default public boolean isArray() {
        return this.getComponentType() != null;
    }

    public JavaType getComponentType();

    default public JavaType getElementalType() {
        JavaType t = this;
        while (t.getComponentType() != null) {
            t = t.getComponentType();
        }
        return t;
    }

    public JavaType getArrayClass();

    public JavaKind getJavaKind();

    public ResolvedJavaType resolve(ResolvedJavaType var1);

    default public String toJavaName() {
        return MetaUtil.internalNameToJava(this.getName(), true, false);
    }

    default public String toJavaName(boolean qualified) {
        JavaKind kind = this.getJavaKind();
        if (kind == JavaKind.Object) {
            return MetaUtil.internalNameToJava(this.getName(), qualified, false);
        }
        return this.getJavaKind().getJavaName();
    }

    default public String toClassName() {
        return MetaUtil.internalNameToJava(this.getName(), true, true);
    }
}

