/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;

public interface JavaField {
    public String getName();

    public JavaType getType();

    default public JavaKind getJavaKind() {
        return this.getType().getJavaKind();
    }

    public JavaType getDeclaringClass();

    default public String format(String format) throws IllegalFormatException {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        JavaType type = this.getType();
        while (index < format.length()) {
            char ch;
            if ((ch = format.charAt(index++)) == '%') {
                if (index >= format.length()) {
                    throw new UnknownFormatConversionException("An unquoted '%' character cannot terminate a field format specification");
                }
                char specifier = format.charAt(index++);
                switch (specifier) {
                    case 'T': 
                    case 't': {
                        sb.append(type.toJavaName(specifier == 'T'));
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        sb.append(this.getDeclaringClass().toJavaName(specifier == 'H'));
                        break;
                    }
                    case 'n': {
                        sb.append(this.getName());
                        break;
                    }
                    case 'f': {
                        sb.append(!(this instanceof ResolvedJavaField) ? "unresolved" : (((ResolvedJavaField)this).isStatic() ? "static" : "instance"));
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    default: {
                        throw new UnknownFormatConversionException(String.valueOf(specifier));
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

