/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code.site;

import java.util.Map;
import java.util.Objects;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.meta.MetaUtil;

public class Infopoint
extends Site
implements Comparable<Infopoint> {
    public final DebugInfo debugInfo;
    public final InfopointReason reason;

    public Infopoint(int pcOffset, DebugInfo debugInfo, InfopointReason reason) {
        super(pcOffset);
        this.debugInfo = debugInfo;
        this.reason = reason;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pcOffset);
        sb.append("[<infopoint>]");
        Infopoint.appendDebugInfo(sb, this.debugInfo);
        return sb.toString();
    }

    @Override
    public int compareTo(Infopoint o) {
        if (this.pcOffset < o.pcOffset) {
            return -1;
        }
        if (this.pcOffset > o.pcOffset) {
            return 1;
        }
        return this.reason.compareTo(o.reason);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Infopoint that = (Infopoint)obj;
            if (this.pcOffset == that.pcOffset && Objects.equals(this.debugInfo, that.debugInfo) && Objects.equals((Object)this.reason, (Object)that.reason)) {
                return true;
            }
        }
        return false;
    }

    protected static void appendDebugInfo(StringBuilder sb, DebugInfo info) {
        if (info != null) {
            BytecodePosition codePos;
            RegisterSaveLayout calleeSaveInfo;
            ReferenceMap refMap = info.getReferenceMap();
            if (refMap != null) {
                sb.append(refMap.toString());
                sb.append(']');
            }
            if ((calleeSaveInfo = info.getCalleeSaveInfo()) != null) {
                sb.append(" callee-save-info[");
                String sep = "";
                for (Map.Entry<Register, Integer> e : calleeSaveInfo.registersToSlots(true).entrySet()) {
                    sb.append(sep).append(e.getKey()).append("->").append(e.getValue());
                    sep = ", ";
                }
                sb.append(']');
            }
            if ((codePos = info.getBytecodePosition()) != null) {
                MetaUtil.appendLocation(sb.append(" "), codePos.getMethod(), codePos.getBCI());
                if (info.hasFrame()) {
                    sb.append(" #locals=").append(info.frame().numLocals).append(" #expr=").append(info.frame().numStack);
                    if (info.frame().numLocks > 0) {
                        sb.append(" #locks=").append(info.frame().numLocks);
                    }
                }
            }
        }
    }
}

