/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.SuppressFBWarnings;

public final class RegisterSaveLayout {
    private final Register[] registers;
    private final int[] slots;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `registers` and `slots`")
    public RegisterSaveLayout(Register[] registers, int[] slots) {
        assert (registers.length == slots.length);
        this.registers = registers;
        this.slots = slots;
        assert (this.registersToSlots(false).size() == registers.length) : "non-unique registers";
        assert (new HashSet<Integer>(this.registersToSlots(false).values()).size() == slots.length) : "non-unqiue slots";
    }

    public int registerToSlot(Register register) {
        for (int i = 0; i < this.registers.length; ++i) {
            if (!register.equals(this.registers[i])) continue;
            return this.slots[i];
        }
        throw new IllegalArgumentException(register + " not saved by this layout: " + this);
    }

    public Map<Register, Integer> registersToSlots(boolean sorted) {
        AbstractMap result = sorted ? new TreeMap() : new HashMap();
        for (int i = 0; i < this.registers.length; ++i) {
            result.put((Register)this.registers[i], this.slots[i]);
        }
        return result;
    }

    public Map<Integer, Register> slotsToRegisters(boolean sorted) {
        AbstractMap result = sorted ? new TreeMap() : new HashMap();
        for (int i = 0; i < this.registers.length; ++i) {
            result.put(this.slots[i], (Register)this.registers[i]);
        }
        return result;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegisterSaveLayout) {
            RegisterSaveLayout that = (RegisterSaveLayout)obj;
            if (Arrays.equals(this.registers, that.registers) && Arrays.equals(this.slots, that.slots)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.registersToSlots(true).toString();
    }
}

