/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.code.Register;

public final class RegisterArray
implements Iterable<Register> {
    private final Register[] registers;
    private int hash;

    public RegisterArray(Register ... registers) {
        this.registers = registers;
    }

    public RegisterArray(Collection<Register> registers) {
        this.registers = registers.toArray(new Register[registers.size()]);
    }

    public int size() {
        return this.registers.length;
    }

    public Register get(int index) {
        return this.registers[index];
    }

    public void addTo(Collection<Register> collection) {
        collection.addAll(Arrays.asList(this.registers));
    }

    public List<Register> asList() {
        return Collections.unmodifiableList(Arrays.asList(this.registers));
    }

    public Register[] toArray() {
        return (Register[])this.registers.clone();
    }

    @Override
    public Iterator<Register> iterator() {
        return Arrays.asList(this.registers).iterator();
    }

    public int hashCode() {
        if (this.hash == 0 && this.registers.length > 0) {
            this.hash = Arrays.hashCode(this.registers);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegisterArray) {
            return Arrays.equals(this.registers, ((RegisterArray)obj).registers);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.registers);
    }
}

