/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Objects;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.SuppressFBWarnings;
import jdk.vm.ci.code.VirtualObject;

public final class DebugInfo {
    private final BytecodePosition bytecodePosition;
    private ReferenceMap referenceMap;
    private final VirtualObject[] virtualObjectMapping;
    private RegisterSaveLayout calleeSaveInfo;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `virtualObjectMapping`")
    public DebugInfo(BytecodePosition codePos, VirtualObject[] virtualObjectMapping) {
        this.bytecodePosition = codePos;
        this.virtualObjectMapping = virtualObjectMapping;
    }

    public DebugInfo(BytecodePosition codePos) {
        this(codePos, null);
    }

    public void setReferenceMap(ReferenceMap referenceMap) {
        this.referenceMap = referenceMap;
    }

    public boolean hasFrame() {
        return this.getBytecodePosition() instanceof BytecodeFrame;
    }

    public BytecodeFrame frame() {
        if (this.hasFrame()) {
            return (BytecodeFrame)this.getBytecodePosition();
        }
        return null;
    }

    public String toString() {
        return CodeUtil.append(new StringBuilder(100), this, null).toString();
    }

    public BytecodePosition getBytecodePosition() {
        return this.bytecodePosition;
    }

    public ReferenceMap getReferenceMap() {
        return this.referenceMap;
    }

    public VirtualObject[] getVirtualObjectMapping() {
        return this.virtualObjectMapping;
    }

    public void setCalleeSaveInfo(RegisterSaveLayout calleeSaveInfo) {
        this.calleeSaveInfo = calleeSaveInfo;
    }

    public RegisterSaveLayout getCalleeSaveInfo() {
        return this.calleeSaveInfo;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DebugInfo) {
            DebugInfo that = (DebugInfo)obj;
            if (Objects.equals(this.bytecodePosition, that.bytecodePosition) && Objects.equals(this.calleeSaveInfo, that.calleeSaveInfo) && Objects.equals(this.referenceMap, that.referenceMap)) {
                return true;
            }
        }
        return false;
    }
}

