/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import jdk.vm.ci.code.SuppressFBWarnings;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class CallingConvention {
    private final int stackSize;
    private final AllocatableValue returnLocation;
    private final AllocatableValue[] argumentLocations;

    public CallingConvention(int stackSize, AllocatableValue returnLocation, AllocatableValue ... argumentLocations) {
        assert (argumentLocations != null);
        assert (returnLocation != null);
        this.argumentLocations = argumentLocations;
        this.stackSize = stackSize;
        this.returnLocation = returnLocation;
        assert (this.verify());
    }

    public AllocatableValue getReturn() {
        return this.returnLocation;
    }

    public AllocatableValue getArgument(int index) {
        return this.argumentLocations[index];
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public int getArgumentCount() {
        return this.argumentLocations.length;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="FB false positive")
    public AllocatableValue[] getArguments() {
        if (this.argumentLocations.length == 0) {
            return this.argumentLocations;
        }
        return (AllocatableValue[])this.argumentLocations.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CallingConvention[");
        String sep = "";
        for (AllocatableValue op : this.argumentLocations) {
            sb.append(sep).append(op);
            sep = ", ";
        }
        if (!this.returnLocation.equals(Value.ILLEGAL)) {
            sb.append(" -> ").append(this.returnLocation);
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean verify() {
        for (int i = 0; i < this.argumentLocations.length; ++i) {
            AllocatableValue location = this.argumentLocations[i];
            assert (ValueUtil.isStackSlot(location) || ValueUtil.isAllocatableValue(location));
        }
        return true;
    }

    public static interface Type {
    }
}

