/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Objects;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class BytecodePosition {
    private final BytecodePosition caller;
    private final ResolvedJavaMethod method;
    private final int bci;

    public BytecodePosition(BytecodePosition caller, ResolvedJavaMethod method, int bci) {
        assert (method != null);
        this.caller = caller;
        this.method = method;
        this.bci = bci;
        int codeSize = method.getCodeSize();
        if (codeSize != 0 && bci >= codeSize) {
            throw new IllegalArgumentException(String.format("bci %d is out of range for %s %d bytes", bci, method.format("%H.%n(%p)"), codeSize));
        }
    }

    public String toString() {
        return CodeUtil.append(new StringBuilder(100), this).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            BytecodePosition that = (BytecodePosition)obj;
            if (this.bci == that.bci && Objects.equals(this.getMethod(), that.getMethod()) && Objects.equals(this.caller, that.caller)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = this.method.hashCode() * 31 + this.bci;
        if (this.caller != null) {
            hc = hc * 31 + this.caller.hashCode();
        }
        return hc;
    }

    public int getBCI() {
        return this.bci;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public BytecodePosition getCaller() {
        return this.caller;
    }

    public BytecodePosition addCaller(BytecodePosition link) {
        if (this.getCaller() == null) {
            return new BytecodePosition(link, this.getMethod(), this.getBCI());
        }
        return new BytecodePosition(this.getCaller().addCaller(link), this.getMethod(), this.getBCI());
    }
}

