/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.openide.util.WeakListeners;

public class ApplicationDescriptor
extends DataSourceDescriptor<Application>
implements PropertyChangeListener {
    private static final String DISPLAY_NAME_PROPERTY = "-Dvisualvm.display.name=";
    private static final String pid_PARAM = "%pid";
    private static final String PID_PARAM = "%PID";
    private String name = super.getName();
    private ApplicationType type;

    protected ApplicationDescriptor(Application application) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), 0x7FFFFFFE);
    }

    protected ApplicationDescriptor(Application application, int preferredPosition) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), preferredPosition);
    }

    protected ApplicationDescriptor(Application application, ApplicationType type, int preferredPosition) {
        super((DataSource)application, ApplicationDescriptor.resolveApplicationName(application, type), ApplicationDescriptor.resolveApplicationDescription(application, type), ApplicationDescriptor.resolveApplicationIcon(application, type), preferredPosition, 2);
        this.setApplicationType(type);
    }

    public String getName() {
        if (this.supportsRename()) {
            return super.getName();
        }
        return this.name;
    }

    public boolean providesProperties() {
        return true;
    }

    protected void setApplicationType(ApplicationType type) {
        this.type = type;
        this.type.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)this.type)));
    }

    protected ApplicationType getApplicationType() {
        return this.type;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("name".equals(propertyName)) {
            Application application = (Application)this.getDataSource();
            if (ApplicationDescriptor.resolveName((DataSource)application, null) != null) {
                return;
            }
            if (this.supportsRename()) {
                this.setName((String)evt.getNewValue());
                this.name = ApplicationDescriptor.super.getName();
            } else {
                String oldName = this.name;
                this.name = this.formatName(ApplicationDescriptor.createGenericName(application, this.type.getName()));
                PropertyChangeSupport pcs = this.getChangeSupport();
                pcs.firePropertyChange("prop_name", oldName, this.name);
            }
        } else if ("icon".equals(propertyName)) {
            this.setIcon((Image)evt.getNewValue());
        } else if ("description".equals(propertyName)) {
            this.setDescription((String)evt.getNewValue());
        } else if ("version".equals(propertyName)) {
            // empty if block
        }
    }

    protected static String resolveApplicationName(Application application, ApplicationType type) {
        String persistedName = ApplicationDescriptor.resolveName((DataSource)application, null);
        if (persistedName != null) {
            return persistedName;
        }
        String customName = ApplicationDescriptor.resolveCustomName(application);
        if (customName != null) {
            return customName;
        }
        return ApplicationDescriptor.createGenericName(application, type.getName());
    }

    protected static String resolveCustomName(Application application) {
        String args;
        int propIndex;
        Jvm jvm;
        Jvm jvm2 = jvm = application.getState() == 1 ? JvmFactory.getJVMFor(application) : null;
        if (jvm != null && jvm.isBasicInfoSupported() && (propIndex = (args = jvm.getJvmArgs()).indexOf(DISPLAY_NAME_PROPERTY)) != -1) {
            int endIndex = args.indexOf(" ", propIndex += DISPLAY_NAME_PROPERTY.length());
            if (endIndex == -1) {
                return args.substring(propIndex);
            }
            return args.substring(propIndex, endIndex);
        }
        return null;
    }

    protected String formatName(String namePattern) {
        Integer pid;
        if (namePattern == null) {
            return null;
        }
        String formatted = namePattern;
        Integer n = pid = namePattern.contains(pid_PARAM) || namePattern.contains(PID_PARAM) ? Integer.valueOf(((Application)this.getDataSource()).getPid()) : null;
        if (pid != null) {
            boolean unknownPid = -1 == pid;
            formatted = formatted.replace(pid_PARAM, unknownPid ? "unknown" : pid.toString());
            formatted = formatted.replace(PID_PARAM, unknownPid ? " (unknown pid) " : " (pid " + pid.toString() + ") ").trim();
        }
        return formatted;
    }

    protected static String createGenericName(Application application, String nameBase) {
        int pid = application.getPid();
        String id = Application.CURRENT_APPLICATION.getPid() == pid || pid == -1 ? "" : PID_PARAM;
        return nameBase + id;
    }

    protected static String resolveApplicationDescription(Application application, ApplicationType type) {
        String persistedDescription = application.getStorage().getCustomProperty("prop_description");
        if (persistedDescription != null) {
            return persistedDescription;
        }
        return type.getDescription();
    }

    protected static Image resolveApplicationIcon(Application application, ApplicationType type) {
        Image persistedIcon;
        String persistedIconString = application.getStorage().getCustomProperty("prop_icon");
        if (persistedIconString != null && (persistedIcon = Utils.stringToImage((String)persistedIconString)) != null) {
            return persistedIcon;
        }
        return type.getIcon();
    }
}

