/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import jdk.vm.ci.services.JVMCIPermission;
import jdk.vm.ci.services.VMEntryPoint;
import sun.misc.VM;
import sun.reflect.Reflection;

public final class Services {
    public static final boolean IS_BUILDING_NATIVE_IMAGE = Boolean.parseBoolean(VM.getSavedProperty((String)"jdk.vm.ci.services.aot"));
    public static final boolean IS_IN_NATIVE_IMAGE = false;
    private static volatile Map<String, String> savedProperties;
    private static boolean jvmciEnabled;
    private static final Map<Class<?>, List<?>> servicesCache;
    private static final int MAX_UNICODE_IN_UTF8_LENGTH = 3;
    private static final int MAX_UTF8_PROPERTY_STRING_LENGTH = 21845;

    private Services() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getSavedProperties() {
        if (IS_IN_NATIVE_IMAGE) {
            if (savedProperties != null) return savedProperties;
            throw new InternalError("Saved properties not initialized");
        }
        if (savedProperties != null) return savedProperties;
        Class<Services> clazz = Services.class;
        synchronized (Services.class) {
            if (savedProperties != null) return savedProperties;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new JVMCIPermission());
            }
            try {
                Field savedPropsField = VM.class.getDeclaredField("savedProps");
                savedPropsField.setAccessible(true);
                Properties props = (Properties)savedPropsField.get(null);
                HashMap<String, String> res = new HashMap<String, String>(props.size());
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    res.put((String)e.getKey(), (String)e.getValue());
                }
                savedProperties = Collections.unmodifiableMap(res);
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
            return savedProperties;
        }
    }

    public static String getSavedProperty(String name, String def) {
        return Services.getSavedProperties().getOrDefault(name, def);
    }

    public static String getSavedProperty(String name) {
        return Services.getSavedProperties().get(name);
    }

    public static void initializeJVMCI() {
        try {
            Class.forName("jdk.vm.ci.runtime.JVMCI", true, Services.getJVMCIClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    private static ClassLoader findBootClassLoaderChild(ClassLoader start) {
        ClassLoader cl = start;
        while (cl.getParent() != null) {
            cl = cl.getParent();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> Iterable<S> load0(Class<S> service) {
        if (IS_IN_NATIVE_IMAGE || IS_BUILDING_NATIVE_IMAGE) {
            List<?> list = servicesCache.get(service);
            if (list != null) {
                return list;
            }
            if (IS_IN_NATIVE_IMAGE) {
                throw new InternalError(String.format("No %s providers found when building native image", service.getName()));
            }
        }
        Iterable<Object> providers = Collections.emptyList();
        if (jvmciEnabled) {
            ClassLoader cl = null;
            try {
                cl = Services.getJVMCIClassLoader();
                if (cl == null) {
                    cl = LazyBootClassPath.bootClassPath;
                    cl = Services.findBootClassLoaderChild(ClassLoader.getSystemClassLoader());
                }
                providers = ServiceLoader.load(service, cl);
            }
            catch (UnsatisfiedLinkError e) {
                jvmciEnabled = false;
            }
            catch (InternalError e) {
                if (e.getMessage().equals("JVMCI is not enabled")) {
                    jvmciEnabled = false;
                }
                throw e;
            }
        }
        if (IS_BUILDING_NATIVE_IMAGE) {
            Map<Class<?>, List<?>> map = servicesCache;
            synchronized (map) {
                ArrayList<Object> providersList = new ArrayList<Object>();
                for (Object provider : providers) {
                    providersList.add(provider);
                }
                servicesCache.put(service, providersList);
                providers = providersList;
            }
        }
        return providers;
    }

    public static void exportJVMCITo(Class<?> requestor) {
    }

    public static <S> Iterable<S> load(Class<S> service) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JVMCIPermission());
        }
        return Services.load0(service);
    }

    public static <S> S loadSingle(Class<S> service, boolean required) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JVMCIPermission());
        }
        Iterable<S> providers = Services.load0(service);
        Object singleProvider = null;
        for (S provider : providers) {
            if (singleProvider != null) {
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", service.getName(), singleProvider.getClass().getName(), provider.getClass().getName()));
            }
            singleProvider = provider;
        }
        if (singleProvider == null && required) {
            String javaHome = Services.getSavedProperty("java.home");
            String vmName = Services.getSavedProperty("java.vm.name");
            Formatter errorMessage = new Formatter();
            errorMessage.format("The VM does not expose required service %s.%n", service.getName());
            errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
            errorMessage.format("Currently used VM configuration is: %s", vmName);
            throw new UnsupportedOperationException(errorMessage.toString());
        }
        return (S)singleProvider;
    }

    private static ClassLoader getJVMCIClassLoader() {
        if (IS_IN_NATIVE_IMAGE) {
            return null;
        }
        return Services.getJVMCIClassLoader0();
    }

    private static native ClassLoader getJVMCIClassLoader0();

    @VMEntryPoint
    private static byte[] serializeSavedProperties() throws IOException {
        if (IS_IN_NATIVE_IMAGE) {
            throw new InternalError("Can only serialize saved properties in HotSpot runtime");
        }
        return Services.serializeProperties(Services.getSavedProperties());
    }

    private static byte[] serializeProperties(Map<String, String> props) throws IOException {
        String value;
        String name;
        int estimate = 8;
        int nonUtf8Props = 0;
        for (Map.Entry<String, String> e : props.entrySet()) {
            String name2 = e.getKey();
            String value2 = e.getValue();
            estimate += 2 + name2.length() + (2 + value2.length());
            if (name2.length() <= 21845 && value2.length() <= 21845) continue;
            ++nonUtf8Props;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(estimate);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(props.size() - nonUtf8Props);
        out.writeInt(nonUtf8Props);
        for (Map.Entry<String, String> e : props.entrySet()) {
            name = e.getKey();
            value = e.getValue();
            if (name.length() > 21845 || value.length() > 21845) continue;
            out.writeUTF(name);
            out.writeUTF(value);
        }
        if (nonUtf8Props != 0) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                name = e.getKey();
                value = e.getValue();
                if (name.length() <= 21845 && value.length() <= 21845) continue;
                byte[] utf8Name = name.getBytes("UTF-8");
                byte[] utf8Value = value.getBytes("UTF-8");
                out.writeInt(utf8Name.length);
                out.write(utf8Name);
                out.writeInt(utf8Value.length);
                out.write(utf8Value);
            }
        }
        return baos.toByteArray();
    }

    @VMEntryPoint
    private static void initializeSavedProperties(byte[] serializedProperties) throws IOException {
        if (!IS_IN_NATIVE_IMAGE) {
            throw new InternalError("Can only initialize saved properties in JVMCI shared library runtime");
        }
        savedProperties = Collections.unmodifiableMap(Services.deserializeProperties(serializedProperties));
    }

    private static Map<String, String> deserializeProperties(byte[] serializedProperties) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(serializedProperties));
        int utf8Props = in.readInt();
        int nonUtf8Props = in.readInt();
        HashMap<String, String> props = new HashMap<String, String>(utf8Props + nonUtf8Props);
        int index = 0;
        while (in.available() != 0) {
            if (index < utf8Props) {
                String name = in.readUTF();
                String value = in.readUTF();
                props.put(name, value);
            } else {
                int nameLen = in.readInt();
                byte[] nameBytes = new byte[nameLen];
                in.read(nameBytes);
                int valueLen = in.readInt();
                byte[] valueBytes = new byte[valueLen];
                in.read(valueBytes);
                String name = new String(nameBytes, "UTF-8");
                String value = new String(valueBytes, "UTF-8");
                props.put(name, value);
            }
            ++index;
        }
        return props;
    }

    static {
        jvmciEnabled = true;
        servicesCache = IS_BUILDING_NATIVE_IMAGE ? new HashMap() : null;
        Reflection.registerMethodsToFilter(Services.class, (String[])new String[]{"getJVMCIClassLoader"});
    }

    static class LazyBootClassPath {
        static final ClassLoader bootClassPath = new ClassLoader(null){};

        LazyBootClassPath() {
        }
    }
}

