/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.tools.lsp.server.types.TextDocumentContentChangeEvent;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.SourceSectionReference;
import org.graalvm.tools.lsp.server.utils.SourceWrapper;

public final class TextDocumentSurrogate {
    private final TruffleFile truffleFile;
    private final List<TextDocumentContentChangeEvent> changeEventsSinceLastSuccessfulParsing;
    private final Map<SourceSectionReference, List<CoverageData>> section2coverageData;
    private String editorText;
    private Boolean coverageAnalysisDone = Boolean.FALSE;
    private SourceWrapper sourceWrapper;
    private TextDocumentContentChangeEvent lastChange = null;
    private final LanguageInfo languageInfo;

    private TextDocumentSurrogate(TextDocumentSurrogate blueprint) {
        this.truffleFile = blueprint.truffleFile;
        this.section2coverageData = blueprint.section2coverageData;
        this.changeEventsSinceLastSuccessfulParsing = blueprint.changeEventsSinceLastSuccessfulParsing;
        this.editorText = blueprint.editorText;
        this.sourceWrapper = blueprint.sourceWrapper;
        this.lastChange = blueprint.lastChange;
        this.languageInfo = blueprint.languageInfo;
    }

    public TextDocumentSurrogate(TruffleFile truffleFile, LanguageInfo languageInfo) {
        this.truffleFile = truffleFile;
        this.section2coverageData = new HashMap<SourceSectionReference, List<CoverageData>>();
        this.changeEventsSinceLastSuccessfulParsing = new ArrayList<TextDocumentContentChangeEvent>();
        this.languageInfo = languageInfo;
    }

    public URI getUri() {
        return this.truffleFile.toUri();
    }

    public String getLanguageId() {
        return this.languageInfo.getId();
    }

    public String getEditorText() {
        if (this.editorText != null) {
            return this.editorText;
        }
        Source source = this.getSource();
        return source == null ? null : (this.editorText = source.getCharacters().toString());
    }

    public void setEditorText(String editorText) {
        this.editorText = editorText;
    }

    public Boolean getTypeHarvestingDone() {
        return this.coverageAnalysisDone;
    }

    public void setCoverageAnalysisDone(Boolean coverageAnalysisDone) {
        this.coverageAnalysisDone = coverageAnalysisDone;
    }

    public SourceWrapper getSourceWrapper() {
        return this.sourceWrapper;
    }

    public LanguageInfo getLanguageInfo() {
        return this.languageInfo;
    }

    public int hashCode() {
        return this.truffleFile.hashCode();
    }

    public TextDocumentContentChangeEvent getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(TextDocumentContentChangeEvent lastChange) {
        this.lastChange = lastChange;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextDocumentSurrogate) {
            return this.truffleFile.equals((Object)((TextDocumentSurrogate)obj).truffleFile);
        }
        return false;
    }

    public List<TextDocumentContentChangeEvent> getChangeEventsSinceLastSuccessfulParsing() {
        return this.changeEventsSinceLastSuccessfulParsing;
    }

    public List<CoverageData> getCoverageData(SourceSection section) {
        return this.section2coverageData.get(SourceSectionReference.from(section));
    }

    public List<CoverageData> getCoverageData(SourceSectionReference section) {
        return this.section2coverageData.get(section);
    }

    public Set<URI> getCoverageUris(SourceSection section) {
        List<CoverageData> coverageDataObjects = this.section2coverageData.get(SourceSectionReference.from(section));
        return coverageDataObjects == null ? null : coverageDataObjects.stream().map(coverageData -> coverageData.getCovarageUri()).collect(Collectors.toSet());
    }

    public void addLocationCoverage(SourceSectionReference section, CoverageData coverageData) {
        if (!this.section2coverageData.containsKey(section)) {
            this.section2coverageData.put(section, new ArrayList());
        }
        this.section2coverageData.get(section).add(coverageData);
    }

    public boolean isLocationCovered(SourceSectionReference section) {
        return this.section2coverageData.containsKey(section);
    }

    public boolean hasCoverageData() {
        return !this.section2coverageData.isEmpty();
    }

    public void clearCoverage() {
        this.section2coverageData.clear();
    }

    public void clearCoverage(URI runScriptUri) {
        Iterator<Map.Entry<SourceSectionReference, List<CoverageData>>> iterator = this.section2coverageData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SourceSectionReference, List<CoverageData>> entry = iterator.next();
            Iterator<CoverageData> iteratorData = entry.getValue().iterator();
            while (iteratorData.hasNext()) {
                CoverageData coverageData = iteratorData.next();
                if (!coverageData.getCovarageUri().equals(runScriptUri)) continue;
                iteratorData.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }

    public List<SourceSectionReference> getCoverageLocations() {
        return new ArrayList<SourceSectionReference>(this.section2coverageData.keySet());
    }

    public void replace(SourceSectionReference oldSection, SourceSectionReference newSection) {
        List<CoverageData> removedCoverageData = this.section2coverageData.remove(oldSection);
        assert (removedCoverageData != null);
        this.section2coverageData.put(newSection, removedCoverageData);
    }

    public Source buildSource() {
        Source.SourceBuilder builder = Source.newBuilder((String)this.languageInfo.getId(), (TruffleFile)this.truffleFile).cached(false);
        if (this.editorText != null) {
            return builder.content((CharSequence)this.editorText).build();
        }
        try {
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SourceWrapper prepareParsing() {
        Source source = this.buildSource();
        this.sourceWrapper = new SourceWrapper(source);
        return this.sourceWrapper;
    }

    public void notifyParsingDone(CallTarget callTarget) {
        boolean successful;
        boolean bl = successful = callTarget != null;
        if (successful) {
            this.sourceWrapper.setParsingSuccessful(true);
            this.sourceWrapper.setCallTarget(callTarget);
            this.changeEventsSinceLastSuccessfulParsing.clear();
        }
    }

    public boolean isSourceCodeReadyForCodeCompletion() {
        return this.sourceWrapper.isParsingSuccessful();
    }

    public Source getSource() {
        return this.sourceWrapper != null ? this.sourceWrapper.getSource() : null;
    }

    public TextDocumentSurrogate copy() {
        return new TextDocumentSurrogate(this);
    }
}

