/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentSaveReason;

public class WillSaveTextDocumentParams
extends JSONBase {
    WillSaveTextDocumentParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public WillSaveTextDocumentParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public TextDocumentSaveReason getReason() {
        return TextDocumentSaveReason.get(this.jsonData.getInt("reason"));
    }

    public WillSaveTextDocumentParams setReason(TextDocumentSaveReason reason) {
        this.jsonData.put("reason", reason.getIntValue());
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WillSaveTextDocumentParams other = (WillSaveTextDocumentParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return this.getReason() == other.getReason();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getTextDocument());
        hash = 89 * hash + Objects.hashCode((Object)this.getReason());
        return hash;
    }

    public static WillSaveTextDocumentParams create(TextDocumentIdentifier textDocument, TextDocumentSaveReason reason) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("reason", reason.getIntValue());
        return new WillSaveTextDocumentParams(json);
    }
}

